/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opends.messages.Message;
import org.opends.messages.PluginMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.PluginCfgDefn;
import org.opends.server.admin.std.server.ChangeNumberControlPluginCfg;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Control;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.types.operation.PostOperationDeleteOperation;
import org.opends.server.types.operation.PostOperationModifyDNOperation;
import org.opends.server.types.operation.PostOperationModifyOperation;
import org.opends.server.types.operation.PostOperationOperation;

public final class ChangeNumberControlPlugin
extends DirectoryServerPlugin<ChangeNumberControlPluginCfg>
implements ConfigurationChangeListener<ChangeNumberControlPluginCfg> {
    private ChangeNumberControlPluginCfg currentConfig;

    @Override
    public final void initializePlugin(Set<PluginType> pluginTypes, ChangeNumberControlPluginCfg configuration) throws ConfigException {
        this.currentConfig = configuration;
        configuration.addChangeNumberControlChangeListener(this);
        TreeSet<PluginType> types = new TreeSet<PluginType>();
        block3: for (PluginType t : pluginTypes) {
            switch (t) {
                case POST_OPERATION_ADD: 
                case POST_OPERATION_DELETE: 
                case POST_OPERATION_MODIFY: 
                case POST_OPERATION_MODIFY_DN: {
                    types.add(t);
                    continue block3;
                }
            }
            Message message = PluginMessages.ERR_PLUGIN_CHANGE_NUMBER_INVALID_PLUGIN_TYPE.get(t.toString());
            throw new ConfigException(message);
        }
        if (types.size() != 4) {
            StringBuilder expected = new StringBuilder();
            expected.append(PluginType.POST_OPERATION_ADD.toString());
            expected.append(", ");
            expected.append(PluginType.POST_OPERATION_DELETE.toString());
            expected.append(", ");
            expected.append(PluginType.POST_OPERATION_MODIFY.toString());
            expected.append(", ");
            expected.append(PluginType.POST_OPERATION_MODIFY_DN.toString());
            StringBuilder found = new StringBuilder();
            boolean first = true;
            for (PluginType t : types) {
                if (first) {
                    first = false;
                } else {
                    found.append(", ");
                }
                found.append(t.toString());
            }
            Message message = PluginMessages.ERR_PLUGIN_CHANGE_NUMBER_INVALID_PLUGIN_TYPE_LIST.get(found.toString(), expected.toString());
            throw new ConfigException(message);
        }
    }

    @Override
    public final void finalizePlugin() {
        this.currentConfig.removeChangeNumberControlChangeListener(this);
    }

    @Override
    public final PluginResult.PostOperation doPostOperation(PostOperationAddOperation addOperation) {
        this.processCsnControl(addOperation);
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public final PluginResult.PostOperation doPostOperation(PostOperationDeleteOperation deleteOperation) {
        this.processCsnControl(deleteOperation);
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public final PluginResult.PostOperation doPostOperation(PostOperationModifyOperation modifyOperation) {
        this.processCsnControl(modifyOperation);
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public final PluginResult.PostOperation doPostOperation(PostOperationModifyDNOperation modifyDNOperation) {
        this.processCsnControl(modifyDNOperation);
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public boolean isConfigurationAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        ChangeNumberControlPluginCfg cfg = (ChangeNumberControlPluginCfg)configuration;
        return this.isConfigurationChangeAcceptable(cfg, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ChangeNumberControlPluginCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        block3: for (PluginCfgDefn.PluginType pluginType : configuration.getPluginType()) {
            switch (pluginType) {
                case POSTOPERATIONADD: 
                case POSTOPERATIONDELETE: 
                case POSTOPERATIONMODIFY: 
                case POSTOPERATIONMODIFYDN: {
                    continue block3;
                }
            }
            Message message = PluginMessages.ERR_PLUGIN_CHANGE_NUMBER_INVALID_PLUGIN_TYPE.get(pluginType.toString());
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ChangeNumberControlPluginCfg configuration) {
        this.currentConfig = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    private void processCsnControl(PostOperationOperation operation) {
        List<Control> requestControls = operation.getRequestControls();
        if (requestControls != null && !requestControls.isEmpty()) {
            for (Control c : requestControls) {
                ChangeNumber cn;
                if (!c.getOID().equals("1.3.6.1.4.1.42.2.27.9.5.9")) continue;
                OperationContext ctx = (OperationContext)operation.getAttachment("replicationContext");
                if (ctx == null || (cn = ctx.getChangeNumber()) == null) break;
                ChangeNumberControl responseControl = new ChangeNumberControl(c.isCritical(), cn);
                operation.getResponseControls().add(responseControl);
                break;
            }
        }
    }

    public static class ChangeNumberControl
    extends Control {
        private ChangeNumber cn;

        public ChangeNumberControl(boolean isCritical, ChangeNumber cn) {
            super("1.3.6.1.4.1.42.2.27.9.5.9", isCritical);
            this.cn = cn;
        }

        @Override
        protected void writeValue(ASN1Writer writer) throws IOException {
            writer.writeOctetString(this.cn.toString());
        }

        public ChangeNumber getChangeNumber() {
            return this.cn;
        }
    }
}

