/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import java.io.IOException;
import java.util.LinkedList;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;

final class ASN1ByteSequenceReader
implements ASN1Reader {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private int state = 0;
    private byte peekType = 0;
    private int peekLength = -1;
    private final int maxElementSize;
    private ByteSequenceReader reader;
    private final LinkedList<ByteSequenceReader> readerStack;

    ASN1ByteSequenceReader(ByteSequenceReader reader, int maxElementSize) {
        this.reader = reader;
        this.readerStack = new LinkedList();
        this.maxElementSize = maxElementSize;
    }

    @Override
    public byte peekType() throws ASN1Exception {
        if (this.state == 0) {
            if (this.reader.remaining() <= 0) {
                Message message = ProtocolMessages.ERR_ASN1_TRUCATED_TYPE_BYTE.get();
                throw new ASN1Exception(message);
            }
            byte type = this.reader.get();
            this.peekType = type;
            this.state = 1;
        }
        return this.peekType;
    }

    @Override
    public int peekLength() throws ASN1Exception {
        this.peekType();
        if (this.state == 1) {
            this.needFirstLengthByteState(true);
        }
        return this.peekLength;
    }

    @Override
    public boolean elementAvailable() throws ASN1Exception {
        if (this.state == 0 && !this.needTypeState(false)) {
            return false;
        }
        if (this.state == 1 && !this.needFirstLengthByteState(false)) {
            return false;
        }
        return this.peekLength <= this.reader.remaining();
    }

    @Override
    public boolean hasNextElement() throws ASN1Exception {
        return this.state != 0 || this.needTypeState(false);
    }

    private boolean needTypeState(boolean throwEofException) throws ASN1Exception {
        if (this.reader.remaining() <= 0) {
            if (throwEofException) {
                Message message = ProtocolMessages.ERR_ASN1_TRUCATED_TYPE_BYTE.get();
                throw new ASN1Exception(message);
            }
            return false;
        }
        byte type = this.reader.get();
        this.peekType = type;
        this.state = 1;
        return true;
    }

    private boolean needFirstLengthByteState(boolean throwEofException) throws ASN1Exception {
        if (this.reader.remaining() <= 0) {
            if (throwEofException) {
                Message message = ProtocolMessages.ERR_ASN1_TRUNCATED_LENGTH_BYTE.get();
                throw new ASN1Exception(message);
            }
            return false;
        }
        byte readByte = this.reader.get();
        this.peekLength = readByte & 0x7F;
        if (this.peekLength != readByte) {
            int lengthBytesNeeded = this.peekLength;
            if (lengthBytesNeeded > 4) {
                Message message = ProtocolMessages.ERR_ASN1_INVALID_NUM_LENGTH_BYTES.get(lengthBytesNeeded);
                throw new ASN1Exception(message);
            }
            this.peekLength = 0;
            if (this.reader.remaining() < lengthBytesNeeded) {
                if (throwEofException) {
                    Message message = ProtocolMessages.ERR_ASN1_TRUNCATED_LENGTH_BYTES.get(lengthBytesNeeded);
                    throw new ASN1Exception(message);
                }
                return false;
            }
            while (lengthBytesNeeded > 0) {
                readByte = this.reader.get();
                this.peekLength = this.peekLength << 8 | readByte & 0xFF;
                --lengthBytesNeeded;
            }
        }
        if (this.maxElementSize > 0 && this.peekLength > this.maxElementSize) {
            Message m = ProtocolMessages.ERR_LDAP_CLIENT_DECODE_MAX_REQUEST_SIZE_EXCEEDED.get(this.peekLength, this.maxElementSize);
            throw new ASN1Exception(m);
        }
        this.state = 3;
        return true;
    }

    @Override
    public boolean readBoolean() throws ASN1Exception {
        this.peekLength();
        if (this.peekLength != 1) {
            Message message = ProtocolMessages.ERR_ASN1_BOOLEAN_INVALID_LENGTH.get(this.peekLength);
            throw new ASN1Exception(message);
        }
        if (this.reader.remaining() < this.peekLength) {
            Message message = ProtocolMessages.ERR_ASN1_BOOLEAN_TRUNCATED_VALUE.get(this.peekLength);
            throw new ASN1Exception(message);
        }
        byte readByte = this.reader.get();
        this.state = 0;
        return readByte != 0;
    }

    @Override
    public int readEnumerated() throws ASN1Exception {
        this.peekLength();
        if (this.peekLength < 1 || this.peekLength > 4) {
            Message message = ProtocolMessages.ERR_ASN1_INTEGER_INVALID_LENGTH.get(this.peekLength);
            throw new ASN1Exception(message);
        }
        return (int)this.readInteger();
    }

    @Override
    public long readInteger() throws ASN1Exception {
        this.peekLength();
        if (this.peekLength < 1 || this.peekLength > 8) {
            Message message = ProtocolMessages.ERR_ASN1_INTEGER_INVALID_LENGTH.get(this.peekLength);
            throw new ASN1Exception(message);
        }
        if (this.reader.remaining() < this.peekLength) {
            Message message = ProtocolMessages.ERR_ASN1_INTEGER_TRUNCATED_VALUE.get(this.peekLength);
            throw new ASN1Exception(message);
        }
        if (this.peekLength > 4) {
            long longValue = 0L;
            for (int i = 0; i < this.peekLength; ++i) {
                byte readByte = this.reader.get();
                if (i == 0 && readByte < 0) {
                    longValue = -1L;
                }
                longValue = longValue << 8 | (long)(readByte & 0xFF);
            }
            this.state = 0;
            return longValue;
        }
        int intValue = 0;
        for (int i = 0; i < this.peekLength; ++i) {
            byte readByte = this.reader.get();
            if (i == 0 && readByte < 0) {
                intValue = -1;
            }
            intValue = intValue << 8 | readByte & 0xFF;
        }
        this.state = 0;
        return intValue;
    }

    @Override
    public void readNull() throws ASN1Exception {
        this.peekLength();
        if (this.peekLength != 0) {
            Message message = ProtocolMessages.ERR_ASN1_NULL_INVALID_LENGTH.get(this.peekLength);
            throw new ASN1Exception(message);
        }
        this.state = 0;
    }

    @Override
    public ByteString readOctetString() throws ASN1Exception {
        this.peekLength();
        if (this.reader.remaining() < this.peekLength) {
            Message message = ProtocolMessages.ERR_ASN1_OCTET_STRING_TRUNCATED_VALUE.get(this.peekLength);
            throw new ASN1Exception(message);
        }
        this.state = 0;
        return this.reader.getByteString(this.peekLength);
    }

    @Override
    public String readOctetStringAsString() throws ASN1Exception {
        return this.readOctetStringAsString("UTF-8");
    }

    @Override
    public String readOctetStringAsString(String charSet) throws ASN1Exception {
        this.peekLength();
        if (this.reader.remaining() < this.peekLength) {
            Message message = ProtocolMessages.ERR_ASN1_OCTET_STRING_TRUNCATED_VALUE.get(this.peekLength);
            throw new ASN1Exception(message);
        }
        this.state = 0;
        return this.reader.getString(this.peekLength);
    }

    @Override
    public void readOctetString(ByteStringBuilder buffer) throws ASN1Exception {
        this.peekLength();
        if (this.reader.remaining() < this.peekLength) {
            Message message = ProtocolMessages.ERR_ASN1_OCTET_STRING_TRUNCATED_VALUE.get(this.peekLength);
            throw new ASN1Exception(message);
        }
        buffer.append(this.reader, this.peekLength);
        this.state = 0;
    }

    @Override
    public void readStartSequence() throws ASN1Exception {
        this.peekLength();
        if (this.reader.remaining() < this.peekLength) {
            Message message = ProtocolMessages.ERR_ASN1_SEQUENCE_SET_TRUNCATED_VALUE.get(this.peekLength);
            throw new ASN1Exception(message);
        }
        ByteSequenceReader subByteString = this.reader.getByteSequence(this.peekLength).asReader();
        this.readerStack.addFirst(this.reader);
        this.reader = subByteString;
        this.state = 0;
    }

    @Override
    public void readStartExplicitTag() throws ASN1Exception {
        this.readStartSequence();
    }

    @Override
    public void readStartSet() throws ASN1Exception {
        this.readStartSequence();
    }

    @Override
    public void readEndSequence() throws ASN1Exception {
        if (this.readerStack.isEmpty()) {
            Message message = ProtocolMessages.ERR_ASN1_SEQUENCE_READ_NOT_STARTED.get();
            throw new ASN1Exception(message);
        }
        if (this.reader.remaining() > 0 && DebugLogger.debugEnabled()) {
            TRACER.debugWarning("Ignoring %d unused trailing bytes in ASN.1 SEQUENCE", this.reader.remaining());
        }
        this.reader = this.readerStack.removeFirst();
        this.state = 0;
    }

    @Override
    public void readEndExplicitTag() throws ASN1Exception {
        this.readEndSequence();
    }

    @Override
    public void readEndSet() throws ASN1Exception {
        this.readEndSequence();
    }

    @Override
    public void skipElement() throws ASN1Exception {
        this.peekLength();
        if (this.reader.remaining() < this.peekLength) {
            Message message = ProtocolMessages.ERR_ASN1_SKIP_TRUNCATED_VALUE.get(this.peekLength);
            throw new ASN1Exception(message);
        }
        this.state = 0;
        this.reader.skip(this.peekLength);
    }

    @Override
    public void close() throws IOException {
        this.readerStack.clear();
    }
}

