/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.http;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.ConnectionFactory;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.Router;
import org.forgerock.json.resource.servlet.HttpServlet;
import org.forgerock.json.resource.servlet.HttpServletContextFactory;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.rest2ldap.AuthorizationPolicy;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.forgerock.opendj.rest2ldap.servlet.Rest2LDAPContextFactory;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.http.HttpProbe;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.HttpServerMonitoringConfig;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.monitoring.MonitoringConfig;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.utils.Charsets;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.ConnectionHandlerCfg;
import org.opends.server.admin.std.server.HTTPConnectionHandlerCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.api.TrustManagerProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.NullKeyManagerProvider;
import org.opends.server.extensions.NullTrustManagerProvider;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.HTTPAccessLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.monitors.ClientConnectionMonitorProvider;
import org.opends.server.protocols.http.CollectClientConnectionsFilter;
import org.opends.server.protocols.http.HTTPAuthenticationConfig;
import org.opends.server.protocols.http.HTTPStatistics;
import org.opends.server.protocols.http.HTTPStatsProbe;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.HostPort;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.SelectableCertificateKeyManager;
import org.opends.server.util.StaticUtils;

public class HTTPConnectionHandler
extends ConnectionHandler<HTTPConnectionHandlerCfg>
implements ConfigurationChangeListener<HTTPConnectionHandlerCfg>,
ServerShutdownListener,
AlertGenerator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String DEFAULT_FRIENDLY_NAME = "HTTP Connection Handler";
    private static final String SSL_CONTEXT_INSTANCE_NAME = "TLS";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    private HTTPConnectionHandlerCfg initConfig;
    private HTTPConnectionHandlerCfg currentConfig;
    private volatile boolean shutdownRequested;
    private boolean enabled;
    private List<HostPort> listeners = new LinkedList<HostPort>();
    private HttpServer httpServer;
    private HTTPStatsProbe httpProbe;
    private Map<ClientConnection, ClientConnection> clientConnections = new ConcurrentHashMap<ClientConnection, ClientConnection>();
    private HTTPStatistics statTracker;
    private ClientConnectionMonitorProvider connMonitor;
    private String handlerName;
    private String protocol;
    private final Object waitListen = new Object();
    private String friendlyName;
    private SSLEngineConfigurator sslEngineConfigurator;

    public HTTPConnectionHandler() {
        super(DEFAULT_FRIENDLY_NAME);
    }

    public boolean acceptUnauthenticatedRequests() {
        return !DirectoryServer.rejectUnauthenticatedRequests() && !this.currentConfig.isAuthenticationRequired();
    }

    void addClientConnection(ClientConnection clientConnection) {
        this.clientConnections.put(clientConnection, clientConnection);
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(HTTPConnectionHandlerCfg config) {
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        if (this.anyChangeRequiresRestart(config)) {
            adminActionRequired = true;
            messages.add(ProtocolMessages.ERR_CONNHANDLER_CONFIG_CHANGES_REQUIRE_RESTART.get("HTTP"));
        }
        try {
            this.configureSSL(config);
        }
        catch (DirectoryException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            messages.add(e.getMessageObject());
            return new ConfigChangeResult(e.getResultCode(), adminActionRequired, messages);
        }
        if (config.isEnabled() && this.currentConfig.isEnabled() && this.isListening()) {
            if (!this.currentConfig.isKeepStats() && config.isKeepStats()) {
                this.setHttpStatsProbe(this.httpServer);
            } else if (this.currentConfig.isKeepStats() && !config.isKeepStats() && this.httpProbe != null) {
                this.getHttpConfig(this.httpServer).removeProbes((Object[])new HttpProbe[]{this.httpProbe});
                this.httpProbe = null;
            }
        }
        this.initConfig = config;
        this.currentConfig = config;
        this.enabled = this.currentConfig.isEnabled();
        return new ConfigChangeResult(ResultCode.SUCCESS, adminActionRequired, messages);
    }

    private boolean anyChangeRequiresRestart(HTTPConnectionHandlerCfg newCfg) {
        return !this.equals(newCfg.getListenPort(), this.initConfig.getListenPort()) || !this.equals(newCfg.getListenAddress(), this.initConfig.getListenAddress()) || !this.equals(newCfg.getMaxRequestSize(), this.currentConfig.getMaxRequestSize()) || !this.equals(newCfg.isAllowTCPReuseAddress(), this.currentConfig.isAllowTCPReuseAddress()) || !this.equals(newCfg.isUseTCPKeepAlive(), this.currentConfig.isUseTCPKeepAlive()) || !this.equals(newCfg.isUseTCPNoDelay(), this.currentConfig.isUseTCPNoDelay()) || !this.equals(newCfg.getMaxBlockedWriteTimeLimit(), this.currentConfig.getMaxBlockedWriteTimeLimit()) || !this.equals(newCfg.getBufferSize(), this.currentConfig.getBufferSize()) || !this.equals(newCfg.getAcceptBacklog(), this.currentConfig.getAcceptBacklog()) || !this.equals(newCfg.isUseSSL(), this.currentConfig.isUseSSL()) || !this.equals(newCfg.getKeyManagerProviderDN(), this.currentConfig.getKeyManagerProviderDN()) || !this.equals(newCfg.getSSLCertNickname(), this.currentConfig.getSSLCertNickname()) || !this.equals(newCfg.getTrustManagerProviderDN(), this.currentConfig.getTrustManagerProviderDN()) || !this.equals(newCfg.getSSLProtocol(), this.currentConfig.getSSLProtocol()) || !this.equals(newCfg.getSSLCipherSuite(), this.currentConfig.getSSLCipherSuite()) || !this.equals((Object)newCfg.getSSLClientAuthPolicy(), (Object)this.currentConfig.getSSLClientAuthPolicy());
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    private boolean equals(long l1, long l2) {
        return l1 == l2;
    }

    private boolean equals(boolean b1, boolean b2) {
        return b1 == b2;
    }

    private void configureSSL(HTTPConnectionHandlerCfg config) throws DirectoryException {
        this.protocol = config.isUseSSL() ? "HTTPS" : "HTTP";
        this.sslEngineConfigurator = config.isUseSSL() ? this.createSSLEngineConfigurator(config) : null;
    }

    @Override
    public void finalizeConnectionHandler(Message finalizeReason) {
        this.shutdownRequested = true;
        this.currentConfig.removeHTTPChangeListener(this);
        if (this.connMonitor != null) {
            DirectoryServer.deregisterMonitorProvider(this.connMonitor);
        }
        if (this.statTracker != null) {
            DirectoryServer.deregisterMonitorProvider(this.statTracker);
        }
    }

    @Override
    public Map<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.HTTPHandlerDisabledByConsecutiveFailures", "This alert type will be used to notify administrators of consecutive failures that have occurred in the HTTP connection handler that have caused it to become disabled.");
        return alerts;
    }

    @Override
    public String getClassName() {
        return HTTPConnectionHandler.class.getName();
    }

    @Override
    public Collection<ClientConnection> getClientConnections() {
        return this.clientConnections.keySet();
    }

    @Override
    public org.opends.server.types.DN getComponentEntryDN() {
        return this.currentConfig.dn();
    }

    @Override
    public String getConnectionHandlerName() {
        return this.handlerName;
    }

    HTTPConnectionHandlerCfg getCurrentConfig() {
        return this.currentConfig;
    }

    @Override
    public Collection<String> getEnabledSSLCipherSuites() {
        SSLEngineConfigurator configurator = this.sslEngineConfigurator;
        if (configurator != null) {
            return Arrays.asList(configurator.getEnabledCipherSuites());
        }
        return super.getEnabledSSLCipherSuites();
    }

    @Override
    public Collection<String> getEnabledSSLProtocols() {
        SSLEngineConfigurator configurator = this.sslEngineConfigurator;
        if (configurator != null) {
            return Arrays.asList(configurator.getEnabledProtocols());
        }
        return super.getEnabledSSLProtocols();
    }

    @Override
    public Collection<HostPort> getListeners() {
        return this.listeners;
    }

    int getListenPort() {
        return this.initConfig.getListenPort();
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    SSLEngine getSSLEngine() {
        return this.sslEngineConfigurator.createSSLEngine();
    }

    @Override
    public String getShutdownListenerName() {
        return this.handlerName;
    }

    public HTTPStatistics getStatTracker() {
        return this.statTracker;
    }

    @Override
    public void initializeConnectionHandler(HTTPConnectionHandlerCfg config) throws ConfigException, InitializationException {
        if (this.friendlyName == null) {
            this.friendlyName = ((Object)config.dn().getRDN().getAttributeValue(0)).toString();
        }
        int listenPort = config.getListenPort();
        for (InetAddress a : config.getListenAddress()) {
            this.listeners.add(new HostPort(a.getHostAddress(), listenPort));
        }
        this.handlerName = this.getHandlerName(config);
        try {
            this.configureSSL(config);
        }
        catch (DirectoryException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new InitializationException(e.getMessageObject());
        }
        this.statTracker = new HTTPStatistics(this.handlerName + " Statistics");
        DirectoryServer.registerMonitorProvider(this.statTracker);
        this.connMonitor = new ClientConnectionMonitorProvider(this);
        DirectoryServer.registerMonitorProvider(this.connMonitor);
        config.addHTTPChangeListener(this);
        this.initConfig = config;
        this.currentConfig = config;
        this.enabled = this.currentConfig.isEnabled();
    }

    private String getHandlerName(HTTPConnectionHandlerCfg config) {
        StringBuilder nameBuffer = new StringBuilder();
        nameBuffer.append(this.friendlyName);
        for (InetAddress a : config.getListenAddress()) {
            nameBuffer.append(" ");
            nameBuffer.append(a.getHostAddress());
        }
        nameBuffer.append(" port ");
        nameBuffer.append(config.getListenPort());
        return nameBuffer.toString();
    }

    @Override
    public boolean isConfigurationAcceptable(ConnectionHandlerCfg configuration, List<Message> unacceptableReasons) {
        Message errorMessage;
        HTTPConnectionHandlerCfg config = (HTTPConnectionHandlerCfg)configuration;
        if ((this.currentConfig == null || !this.enabled && config.isEnabled()) && (errorMessage = this.checkAnyListenAddressInUse(config.getListenAddress(), config.getListenPort(), config.isAllowTCPReuseAddress(), config.dn())) != null) {
            unacceptableReasons.add(errorMessage);
            return false;
        }
        if (config.isEnabled() && config.isUseSSL()) {
            try {
                this.createSSLEngineConfigurator(config);
            }
            catch (DirectoryException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                unacceptableReasons.add(e.getMessageObject());
                return false;
            }
        }
        return true;
    }

    private Message checkAnyListenAddressInUse(Collection<InetAddress> listenAddresses, int listenPort, boolean allowReuseAddress, org.opends.server.types.DN configEntryDN) {
        for (InetAddress a : listenAddresses) {
            try {
                if (!StaticUtils.isAddressInUse(a, listenPort, allowReuseAddress)) continue;
                throw new IOException(ProtocolMessages.ERR_CONNHANDLER_ADDRESS_INUSE.get().toString());
            }
            catch (IOException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                return ProtocolMessages.ERR_CONNHANDLER_CANNOT_BIND.get("HTTP", String.valueOf(configEntryDN), a.getHostAddress(), listenPort, StaticUtils.getExceptionMessage(e));
            }
        }
        return null;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(HTTPConnectionHandlerCfg configuration, List<Message> unacceptableReasons) {
        return this.isConfigurationAcceptable(configuration, unacceptableReasons);
    }

    public boolean keepStats() {
        return this.currentConfig.isKeepStats();
    }

    @Override
    public void processServerShutdown(Message reason) {
        this.shutdownRequested = true;
    }

    private boolean isListening() {
        return this.httpServer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.waitListen;
        synchronized (object) {
            super.start();
            try {
                this.waitListen.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void removeClientConnection(ClientConnection clientConnection) {
        this.clientConnections.remove(clientConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName(this.handlerName);
        boolean lastIterationFailed = false;
        while (!this.shutdownRequested) {
            if (!this.enabled) {
                if (this.isListening()) {
                    this.stopHttpServer();
                }
                StaticUtils.sleep(1000L);
                continue;
            }
            if (this.isListening()) {
                StaticUtils.sleep(1000L);
                continue;
            }
            try {
                Object object = this.waitListen;
                synchronized (object) {
                    this.waitListen.notify();
                }
                this.startHttpServer();
                lastIterationFailed = false;
            }
            catch (Exception e) {
                this.cleanUpHttpServer();
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                ErrorLogger.logError(ProtocolMessages.ERR_CONNHANDLER_CANNOT_ACCEPT_CONNECTION.get(this.friendlyName, String.valueOf(this.currentConfig.dn()), StaticUtils.getExceptionMessage(e)));
                if (lastIterationFailed) {
                    Message message = ProtocolMessages.ERR_CONNHANDLER_CONSECUTIVE_ACCEPT_FAILURES.get(this.friendlyName, String.valueOf(this.currentConfig.dn()), StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(message);
                    DirectoryServer.sendAlertNotification(this, "org.opends.server.HTTPHandlerDisabledByConsecutiveFailures", message);
                    this.enabled = false;
                    continue;
                }
                lastIterationFailed = true;
            }
        }
        this.stopHttpServer();
    }

    private void startHttpServer() throws Exception {
        Logger.getLogger("org.glassfish.grizzly").setLevel(Level.OFF);
        if (HTTPAccessLogger.getHTTPAccessLogPublishers().isEmpty()) {
            ErrorLogger.logError(ConfigMessages.WARN_CONFIG_LOGGER_NO_ACTIVE_HTTP_ACCESS_LOGGERS.get());
        }
        this.httpServer = this.createHttpServer();
        this.createAndRegisterServlet("OpenDJ Rest2LDAP servlet", "", "/*");
        TRACER.debugInfo("Starting HTTP server...");
        this.httpServer.start();
        TRACER.debugInfo("HTTP server started");
        ErrorLogger.logError(ProtocolMessages.NOTE_CONNHANDLER_STARTED_LISTENING.get(this.handlerName));
    }

    private HttpServer createHttpServer() {
        HttpServer server = new HttpServer();
        int requestSize = (int)this.currentConfig.getMaxRequestSize();
        ServerConfiguration serverConfig = server.getServerConfiguration();
        serverConfig.setMaxBufferedPostSize(requestSize);
        serverConfig.setMaxFormPostSize(requestSize);
        serverConfig.setDefaultQueryEncoding(Charsets.UTF8_CHARSET);
        if (this.keepStats()) {
            this.setHttpStatsProbe(server);
        }
        NetworkListener listener = new NetworkListener("Rest2LDAP", "0.0.0.0", this.initConfig.getListenPort());
        server.addListener(listener);
        TCPNIOTransport transport = listener.getTransport();
        transport.setReuseAddress(this.currentConfig.isAllowTCPReuseAddress());
        transport.setKeepAlive(this.currentConfig.isUseTCPKeepAlive());
        transport.setTcpNoDelay(this.currentConfig.isUseTCPNoDelay());
        transport.setWriteTimeout(this.currentConfig.getMaxBlockedWriteTimeLimit(), TimeUnit.MILLISECONDS);
        int bufferSize = (int)this.currentConfig.getBufferSize();
        transport.setReadBufferSize(bufferSize);
        transport.setWriteBufferSize(bufferSize);
        transport.setIOStrategy((IOStrategy)SameThreadIOStrategy.getInstance());
        int numRequestHandlers = this.getNumRequestHandlers(this.currentConfig.getNumRequestHandlers(), this.friendlyName);
        transport.setSelectorRunnersCount(numRequestHandlers);
        transport.setServerConnectionBackLog(this.currentConfig.getAcceptBacklog());
        if (this.sslEngineConfigurator != null) {
            listener.setSecure(true);
            listener.setSSLEngineConfig(this.sslEngineConfigurator);
        }
        return server;
    }

    private void setHttpStatsProbe(HttpServer server) {
        this.httpProbe = new HTTPStatsProbe(this.statTracker);
        this.getHttpConfig(server).addProbes((Object[])new HttpProbe[]{this.httpProbe});
    }

    private MonitoringConfig<HttpProbe> getHttpConfig(HttpServer server) {
        HttpServerMonitoringConfig monitoringCfg = server.getServerConfiguration().getMonitoringConfig();
        return monitoringCfg.getHttpConfig();
    }

    private void createAndRegisterServlet(String servletName, String ... urlPatterns) throws Exception {
        File jsonConfigFile = StaticUtils.getFileForPath(this.currentConfig.getConfigFile());
        JsonValue configuration = this.parseJsonConfiguration(jsonConfigFile).recordKeyAccesses();
        HTTPAuthenticationConfig authenticationConfig = this.getAuthenticationConfig(configuration);
        ConnectionFactory connFactory = this.getConnectionFactory(configuration);
        configuration.verifyAllKeysAccessed();
        CollectClientConnectionsFilter filter = new CollectClientConnectionsFilter(this, authenticationConfig);
        HttpServlet servlet = new HttpServlet(connFactory, (HttpServletContextFactory)Rest2LDAPContextFactory.getHttpServletContextFactory());
        WebappContext ctx = new WebappContext(servletName);
        ctx.addFilter("collectClientConnections", (Filter)filter).addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, urlPatterns);
        ctx.addServlet(servletName, (Servlet)servlet).addMapping(urlPatterns);
        ctx.deploy(this.httpServer);
    }

    private HTTPAuthenticationConfig getAuthenticationConfig(JsonValue configuration) {
        HTTPAuthenticationConfig result = new HTTPAuthenticationConfig();
        JsonValue val = configuration.get("authenticationFilter");
        result.setBasicAuthenticationSupported(this.asBool(val, "supportHTTPBasicAuthentication"));
        result.setCustomHeadersAuthenticationSupported(this.asBool(val, "supportAltAuthentication"));
        result.setCustomHeaderUsername(val.get("altAuthenticationUsernameHeader").asString());
        result.setCustomHeaderPassword(val.get("altAuthenticationPasswordHeader").asString());
        String searchBaseDN = this.asString(val, "searchBaseDN");
        result.setSearchBaseDN(DN.valueOf((String)searchBaseDN));
        result.setSearchScope(SearchScope.valueOf((String)this.asString(val, "searchScope")));
        result.setSearchFilterTemplate(this.asString(val, "searchFilterTemplate"));
        return result;
    }

    private String asString(JsonValue value, String key) {
        return value.get(key).required().asString();
    }

    private boolean asBool(JsonValue value, String key) {
        return value.get(key).defaultTo((Object)false).asBoolean();
    }

    private ConnectionFactory getConnectionFactory(JsonValue configuration) {
        Router router = new Router();
        JsonValue mappings = configuration.get("servlet").get("mappings").required();
        for (String mappingUrl : mappings.keys()) {
            JsonValue mapping = mappings.get(mappingUrl);
            CollectionResourceProvider provider = Rest2LDAP.builder().authorizationPolicy(AuthorizationPolicy.REUSE).configureMapping(mapping).build();
            router.addRoute(mappingUrl, provider);
        }
        return Resources.newInternalConnectionFactory((RequestHandler)router);
    }

    private JsonValue parseJsonConfiguration(File configFile) throws IOException, JsonParseException, JsonMappingException, ServletException {
        Object content = JSON_MAPPER.readValue(configFile, Object.class);
        if (!(content instanceof Map)) {
            throw new ServletException("Servlet configuration file '" + configFile + "' does not contain a valid JSON configuration");
        }
        return new JsonValue(content);
    }

    private void stopHttpServer() {
        if (this.httpServer != null) {
            TRACER.debugInfo("Stopping HTTP server...");
            this.httpServer.shutdownNow();
            this.cleanUpHttpServer();
            TRACER.debugInfo("HTTP server stopped");
            ErrorLogger.logError(ProtocolMessages.NOTE_CONNHANDLER_STOPPED_LISTENING.get(this.handlerName));
        }
    }

    private void cleanUpHttpServer() {
        this.httpServer = null;
        this.httpProbe = null;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append(this.handlerName);
    }

    private SSLEngineConfigurator createSSLEngineConfigurator(HTTPConnectionHandlerCfg config) throws DirectoryException {
        if (!config.isUseSSL()) {
            return null;
        }
        try {
            SortedSet<String> ciphers;
            SSLContext sslContext = this.createSSLContext(config);
            SSLEngineConfigurator configurator = new SSLEngineConfigurator(sslContext);
            configurator.setClientMode(false);
            SSLEngine defaults = sslContext.createSSLEngine();
            configurator.setEnabledProtocols(defaults.getEnabledProtocols());
            configurator.setEnabledCipherSuites(defaults.getEnabledCipherSuites());
            SortedSet<String> protocols = config.getSSLProtocol();
            if (!protocols.isEmpty()) {
                String[] array = protocols.toArray(new String[protocols.size()]);
                configurator.setEnabledProtocols(array);
            }
            if (!(ciphers = config.getSSLCipherSuite()).isEmpty()) {
                String[] array = ciphers.toArray(new String[ciphers.size()]);
                configurator.setEnabledCipherSuites(array);
            }
            switch (config.getSSLClientAuthPolicy()) {
                case DISABLED: {
                    configurator.setNeedClientAuth(false);
                    configurator.setWantClientAuth(false);
                    break;
                }
                case REQUIRED: {
                    configurator.setNeedClientAuth(true);
                    configurator.setWantClientAuth(true);
                    break;
                }
                default: {
                    configurator.setNeedClientAuth(false);
                    configurator.setWantClientAuth(true);
                }
            }
            return configurator;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            ResultCode resCode = DirectoryServer.getServerErrorResultCode();
            Message message = ProtocolMessages.ERR_CONNHANDLER_SSL_CANNOT_INITIALIZE.get(StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(resCode, message, e);
        }
    }

    private SSLContext createSSLContext(HTTPConnectionHandlerCfg config) throws Exception {
        String alias;
        if (!config.isUseSSL()) {
            return null;
        }
        org.opends.server.types.DN keyMgrDN = config.getKeyManagerProviderDN();
        KeyManagerProvider keyManagerProvider = DirectoryServer.getKeyManagerProvider(keyMgrDN);
        if (keyManagerProvider == null) {
            keyManagerProvider = new NullKeyManagerProvider();
        }
        KeyManager[] keyManagers = (alias = config.getSSLCertNickname()) == null ? keyManagerProvider.getKeyManagers() : SelectableCertificateKeyManager.wrap(keyManagerProvider.getKeyManagers(), alias);
        org.opends.server.types.DN trustMgrDN = config.getTrustManagerProviderDN();
        TrustManagerProvider trustManagerProvider = DirectoryServer.getTrustManagerProvider(trustMgrDN);
        if (trustManagerProvider == null) {
            trustManagerProvider = new NullTrustManagerProvider();
        }
        SSLContext sslContext = SSLContext.getInstance(SSL_CONTEXT_INSTANCE_NAME);
        sslContext.init(keyManagers, trustManagerProvider.getTrustManagers(), null);
        return sslContext;
    }
}

