/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalLDAPInputStream;
import org.opends.server.protocols.internal.InternalLDAPOutputStream;
import org.opends.server.types.DN;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class InternalLDAPSocket
extends Socket {
    private boolean closed = false;
    private boolean keepAlive = true;
    private boolean oobInline = true;
    private boolean reuseAddress = true;
    private boolean tcpNoDelay = true;
    private int lingerDuration = 0;
    private int receiveBufferSize = 1024;
    private int sendBufferSize = 1024;
    private int timeout = 0;
    private int trafficClass = 0;
    private InternalClientConnection conn = null;
    private InternalLDAPInputStream inputStream = new InternalLDAPInputStream(this);
    private InternalLDAPOutputStream outputStream = new InternalLDAPOutputStream(this);

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    synchronized InternalClientConnection getConnection() throws IOException {
        if (this.conn == null) {
            try {
                this.conn = new InternalClientConnection(DN.nullDN());
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        return this.conn;
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    synchronized void setConnection(InternalClientConnection conn) {
        this.conn = conn;
    }

    @Override
    public void bind(SocketAddress bindpoint) {
    }

    @Override
    public synchronized void close() {
        try {
            this.inputStream.closeInternal();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.outputStream.closeInternal();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closed = true;
        this.inputStream = null;
        this.outputStream = null;
    }

    @Override
    public synchronized void connect(SocketAddress endpoint) {
        this.closed = false;
        this.inputStream = new InternalLDAPInputStream(this);
        this.outputStream = new InternalLDAPOutputStream(this);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) {
        this.closed = false;
        this.inputStream = new InternalLDAPInputStream(this);
        this.outputStream = new InternalLDAPOutputStream(this);
    }

    @Override
    public SocketChannel getChannel() {
        return null;
    }

    @Override
    public InetAddress getInetAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public InternalLDAPInputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public InetAddress getLocalAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int getLocalPort() {
        return 389;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        try {
            return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean getOOBInline() {
        return this.oobInline;
    }

    @Override
    public InternalLDAPOutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public int getPort() {
        return 389;
    }

    @Override
    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        try {
            return new InetSocketAddress(this.getInetAddress(), this.getPort());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean getReuseAddress() {
        return this.reuseAddress;
    }

    @Override
    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    @Override
    public int getSoLinger() {
        return this.lingerDuration;
    }

    @Override
    public int getSoTimeout() {
        return this.timeout;
    }

    @Override
    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @Override
    public int getTrafficClass() {
        return this.trafficClass;
    }

    @Override
    public boolean isBound() {
        return true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isConnected() {
        return !this.closed;
    }

    @Override
    public boolean isInputShutdown() {
        return this.closed;
    }

    @Override
    public boolean isOutputShutdown() {
        return this.closed;
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.getOutputStream().write(data);
    }

    @Override
    public void setKeepAlive(boolean on) {
        this.keepAlive = on;
    }

    @Override
    public void setOOBInline(boolean on) {
        this.oobInline = on;
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }

    @Override
    public void setReceiveBufferSize(int size) {
        this.receiveBufferSize = size;
    }

    @Override
    public void setReuseAddress(boolean on) {
        this.reuseAddress = on;
    }

    @Override
    public void setSendBufferSize(int size) {
        this.sendBufferSize = size;
    }

    @Override
    public void setSoLinger(boolean on, int linger) {
        this.lingerDuration = linger;
    }

    @Override
    public void setSoTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setTcpNoDelay(boolean on) {
        this.tcpNoDelay = on;
    }

    @Override
    public void setTrafficClass(int tc) {
        this.trafficClass = tc;
    }

    @Override
    public void shutdownInput() {
        this.close();
    }

    @Override
    public void shutdownOutput() {
        this.close();
    }

    @Override
    public String toString() {
        return "InternalLDAPSocket";
    }
}

