/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.jmx;

import java.io.IOException;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import org.opends.server.protocols.jmx.DirectoryRMIClientSocketFactory;

public class OpendsJmxConnector
implements JMXConnector {
    private JMXConnector jmxc = null;
    private Map<String, Object> environment = null;
    private JMXServiceURL serviceURL = null;
    private String serverHostname = null;

    public OpendsJmxConnector(String serverHostname, int serverPort, Map<String, Object> environment) throws IOException {
        this.serviceURL = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + serverHostname + ":" + serverPort + "/org.opends.server.protocols.jmx.client-unknown");
        this.jmxc = JMXConnectorFactory.newJMXConnector(this.serviceURL, environment);
        this.serverHostname = serverHostname;
        this.environment = environment;
    }

    public Map getConnectionEnv() {
        return this.environment;
    }

    @Override
    public void connect() throws IOException, SecurityException {
        this.connect(null);
    }

    @Override
    public void connect(Map<String, ?> env) throws IOException, SecurityException {
        DirectoryRMIClientSocketFactory.setServerHostname(this.serverHostname);
        if (env != null) {
            this.updateCredentials(env);
        }
        DirectoryRMIClientSocketFactory.setConnectionEnv(this.environment);
        this.jmxc.connect(env);
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.jmxc.getMBeanServerConnection();
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(Subject delegationSubject) throws IOException {
        return this.jmxc.getMBeanServerConnection(delegationSubject);
    }

    @Override
    public void close() throws IOException {
        this.jmxc.close();
    }

    @Override
    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws NullPointerException {
        this.jmxc.addConnectionNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException, NullPointerException {
        this.jmxc.removeConnectionNotificationListener(listener);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener l, NotificationFilter f, Object handback) throws ListenerNotFoundException {
        this.jmxc.removeConnectionNotificationListener(l, f, handback);
    }

    @Override
    public String getConnectionId() throws IOException {
        return this.jmxc.getConnectionId();
    }

    private void updateCredentials(Map env) throws IOException {
        if (!env.containsKey("jmx.remote.credentials")) {
            return;
        }
        Object cred = env.get("jmx.remote.credentials");
        this.environment.put("jmx.remote.credentials", cred);
    }
}

