/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.ByteString;
import org.opends.server.types.RawAttribute;
import org.opends.server.util.Base64;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class AddRequestProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private List<RawAttribute> attributes;
    private ByteString dn;

    public AddRequestProtocolOp(ByteString dn) {
        this.dn = dn;
        this.attributes = new ArrayList<RawAttribute>();
    }

    public AddRequestProtocolOp(ByteString dn, List<RawAttribute> attributes) {
        this.dn = dn;
        this.attributes = attributes == null ? new ArrayList<RawAttribute>() : attributes;
    }

    public ByteString getDN() {
        return this.dn;
    }

    public List<RawAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public byte getType() {
        return 104;
    }

    @Override
    public String getProtocolOpName() {
        return "Add Request";
    }

    @Override
    public void write(ASN1Writer stream) throws IOException {
        stream.writeStartSequence((byte)104);
        stream.writeOctetString(this.dn);
        stream.writeStartSequence();
        for (RawAttribute attr : this.attributes) {
            attr.write(stream);
        }
        stream.writeEndSequence();
        stream.writeEndSequence();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("AddRequest(dn=");
        buffer.append(this.dn.toString());
        buffer.append(", attrs={");
        if (!this.attributes.isEmpty()) {
            Iterator<RawAttribute> iterator = this.attributes.iterator();
            iterator.next().toString(buffer);
            while (iterator.hasNext()) {
                buffer.append(", ");
                iterator.next().toString(buffer);
            }
        }
        buffer.append("})");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Add Request");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  DN:  ");
        buffer.append(this.dn.toString());
        buffer.append(ServerConstants.EOL);
        buffer.append("  Attributes:");
        buffer.append(ServerConstants.EOL);
        for (RawAttribute attribute : this.attributes) {
            attribute.toString(buffer, indent + 4);
        }
    }

    public void toLDIF(StringBuilder buffer, int wrapColumn) {
        int colsRemaining;
        String dnString;
        if (StaticUtils.needsBase64Encoding(this.dn)) {
            dnString = Base64.encode(this.dn);
            buffer.append("dn:: ");
            colsRemaining = wrapColumn - 5;
        } else {
            dnString = this.dn.toString();
            buffer.append("dn: ");
            colsRemaining = wrapColumn - 4;
        }
        int dnLength = dnString.length();
        if (dnLength <= colsRemaining || colsRemaining <= 0) {
            buffer.append(dnString);
            buffer.append(ServerConstants.EOL);
        } else {
            buffer.append(dnString.substring(0, colsRemaining));
            buffer.append(ServerConstants.EOL);
            int startPos = colsRemaining;
            while (dnLength - startPos > wrapColumn - 1) {
                buffer.append(" ");
                buffer.append(dnString.substring(startPos, startPos + wrapColumn - 1));
                buffer.append(ServerConstants.EOL);
                startPos += wrapColumn - 1;
            }
            if (startPos < dnLength) {
                buffer.append(" ");
                buffer.append(dnString.substring(startPos));
                buffer.append(ServerConstants.EOL);
            }
        }
        for (RawAttribute a : this.attributes) {
            String name = a.getAttributeType();
            int nameLength = name.length();
            for (ByteString v : a.getValues()) {
                String valueString;
                if (StaticUtils.needsBase64Encoding(v)) {
                    valueString = Base64.encode(v);
                    buffer.append(name);
                    buffer.append(":: ");
                    colsRemaining = wrapColumn - nameLength - 3;
                } else {
                    valueString = v.toString();
                    buffer.append(name);
                    buffer.append(": ");
                    colsRemaining = wrapColumn - nameLength - 2;
                }
                int valueLength = valueString.length();
                if (valueLength <= colsRemaining || colsRemaining <= 0) {
                    buffer.append(valueString);
                    buffer.append(ServerConstants.EOL);
                    continue;
                }
                buffer.append(valueString.substring(0, colsRemaining));
                buffer.append(ServerConstants.EOL);
                int startPos = colsRemaining;
                while (valueLength - startPos > wrapColumn - 1) {
                    buffer.append(" ");
                    buffer.append(valueString.substring(startPos, startPos + wrapColumn - 1));
                    buffer.append(ServerConstants.EOL);
                    startPos += wrapColumn - 1;
                }
                if (startPos >= valueLength) continue;
                buffer.append(" ");
                buffer.append(valueString.substring(startPos));
                buffer.append(ServerConstants.EOL);
            }
        }
        buffer.append(ServerConstants.EOL);
    }
}

