/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.ByteString;
import org.opends.server.types.RawModification;
import org.opends.server.util.ServerConstants;

public class ModifyRequestProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private List<RawModification> modifications;
    private ByteString dn;

    public ModifyRequestProtocolOp(ByteString dn) {
        this.dn = dn;
        this.modifications = new ArrayList<RawModification>();
    }

    public ModifyRequestProtocolOp(ByteString dn, List<RawModification> modifications) {
        this.dn = dn;
        this.modifications = modifications == null ? new ArrayList<RawModification>() : modifications;
    }

    public ByteString getDN() {
        return this.dn;
    }

    public List<RawModification> getModifications() {
        return this.modifications;
    }

    @Override
    public byte getType() {
        return 102;
    }

    @Override
    public String getProtocolOpName() {
        return "Modify Request";
    }

    @Override
    public void write(ASN1Writer stream) throws IOException {
        stream.writeStartSequence((byte)102);
        stream.writeOctetString(this.dn);
        stream.writeStartSequence();
        for (RawModification mod : this.modifications) {
            mod.write(stream);
        }
        stream.writeEndSequence();
        stream.writeEndSequence();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ModifyRequest(dn=");
        buffer.append(this.dn.toString());
        buffer.append(", mods={");
        if (!this.modifications.isEmpty()) {
            Iterator<RawModification> iterator = this.modifications.iterator();
            iterator.next().toString(buffer);
            while (iterator.hasNext()) {
                buffer.append(", ");
                iterator.next().toString(buffer);
            }
        }
        buffer.append("})");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Modify Request");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  DN:  ");
        buffer.append(this.dn.toString());
        buffer.append(ServerConstants.EOL);
        buffer.append("  Modifications:");
        buffer.append(ServerConstants.EOL);
        for (RawModification mod : this.modifications) {
            mod.toString(buffer, indent + 4);
        }
    }
}

