/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.plugin.AttrHistorical;
import org.opends.server.replication.plugin.AttrValueHistorical;
import org.opends.server.replication.plugin.HistAttrModificationKey;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;

public class AttrHistoricalSingle
extends AttrHistorical {
    private ChangeNumber deleteTime = null;
    private ChangeNumber addTime = null;
    private AttributeValue value = null;
    private HistAttrModificationKey lastMod = null;

    @Override
    public ChangeNumber getDeleteTime() {
        return this.deleteTime;
    }

    @Override
    public Map<AttrValueHistorical, AttrValueHistorical> getValuesHistorical() {
        if (this.addTime == null) {
            return Collections.emptyMap();
        }
        AttrValueHistorical val = new AttrValueHistorical(this.value, this.addTime, null);
        return Collections.singletonMap(val, val);
    }

    @Override
    public void processLocalOrNonConflictModification(ChangeNumber changeNumber, Modification mod) {
        AttributeValue newValue = null;
        Attribute modAttr = mod.getAttribute();
        if (modAttr != null && !modAttr.isEmpty()) {
            newValue = modAttr.iterator().next();
        }
        switch (mod.getModificationType()) {
            case DELETE: {
                this.addTime = null;
                this.deleteTime = changeNumber;
                this.value = newValue;
                this.lastMod = HistAttrModificationKey.DEL;
                break;
            }
            case ADD: {
                this.addTime = changeNumber;
                this.value = newValue;
                this.lastMod = HistAttrModificationKey.ADD;
                break;
            }
            case REPLACE: {
                if (newValue == null) {
                    this.addTime = null;
                    this.deleteTime = changeNumber;
                    this.value = null;
                    this.lastMod = HistAttrModificationKey.DEL;
                } else {
                    this.deleteTime = this.addTime = changeNumber;
                    this.lastMod = HistAttrModificationKey.REPL;
                }
                this.value = newValue;
                break;
            }
        }
    }

    @Override
    public boolean replayOperation(Iterator<Modification> modsIterator, ChangeNumber changeNumber, Entry modifiedEntry, Modification mod) {
        boolean conflict = false;
        AttributeValue newValue = null;
        Attribute modAttr = mod.getAttribute();
        if (modAttr != null && !modAttr.isEmpty()) {
            newValue = modAttr.iterator().next();
        }
        switch (mod.getModificationType()) {
            case DELETE: {
                if (changeNumber.newer(this.addTime)) {
                    if (newValue == null || ((Object)newValue).equals(this.value) || this.value == null) {
                        AttributeType type;
                        if (changeNumber.newer(this.deleteTime)) {
                            this.deleteTime = changeNumber;
                        }
                        if (!modifiedEntry.hasAttribute(type = modAttr.getAttributeType())) {
                            conflict = true;
                            modsIterator.remove();
                            break;
                        }
                        if (newValue != null && !modifiedEntry.hasValue(type, modAttr.getOptions(), newValue)) {
                            conflict = true;
                            modsIterator.remove();
                            break;
                        }
                        this.addTime = null;
                        this.lastMod = HistAttrModificationKey.DEL;
                        this.value = null;
                        break;
                    }
                    conflict = true;
                    modsIterator.remove();
                    break;
                }
                if (changeNumber.equals(this.addTime)) {
                    if (this.lastMod == HistAttrModificationKey.ADD || this.lastMod == HistAttrModificationKey.REPL) {
                        if (changeNumber.newer(this.deleteTime)) {
                            this.deleteTime = changeNumber;
                        }
                        this.addTime = null;
                        this.lastMod = HistAttrModificationKey.DEL;
                        this.value = null;
                        break;
                    }
                    conflict = true;
                    modsIterator.remove();
                    break;
                }
                conflict = true;
                modsIterator.remove();
                break;
            }
            case ADD: {
                if (changeNumber.newerOrEquals(this.deleteTime) && changeNumber.older(this.addTime).booleanValue()) {
                    conflict = true;
                    mod.setModificationType(ModificationType.REPLACE);
                    this.addTime = changeNumber;
                    this.value = newValue;
                    this.lastMod = HistAttrModificationKey.REPL;
                    break;
                }
                if (changeNumber.newerOrEquals(this.deleteTime) && (this.addTime == null || this.addTime.older(this.deleteTime).booleanValue())) {
                    this.addTime = changeNumber;
                    this.value = newValue;
                    this.lastMod = HistAttrModificationKey.ADD;
                    break;
                }
                if (changeNumber.equals(this.deleteTime) && changeNumber.equals(this.addTime) && this.lastMod == HistAttrModificationKey.DEL) {
                    this.value = newValue;
                    this.lastMod = HistAttrModificationKey.ADD;
                    break;
                }
                conflict = true;
                modsIterator.remove();
                break;
            }
            case REPLACE: {
                if (changeNumber.older(this.deleteTime).booleanValue()) {
                    conflict = true;
                    modsIterator.remove();
                    break;
                }
                if (newValue == null) {
                    this.addTime = null;
                    this.value = newValue;
                    this.deleteTime = changeNumber;
                    this.lastMod = HistAttrModificationKey.DEL;
                    break;
                }
                this.addTime = changeNumber;
                this.value = newValue;
                this.deleteTime = changeNumber;
                this.lastMod = HistAttrModificationKey.REPL;
                break;
            }
        }
        return conflict;
    }

    @Override
    public void assign(HistAttrModificationKey histKey, AttributeValue value, ChangeNumber cn) {
        switch (histKey) {
            case ADD: {
                this.addTime = cn;
                this.value = value;
                break;
            }
            case DEL: {
                this.deleteTime = cn;
                if (value == null) break;
                this.value = value;
                break;
            }
            case REPL: {
                this.addTime = this.deleteTime = cn;
                if (value == null) break;
                this.value = value;
                break;
            }
            case DELATTR: {
                this.deleteTime = cn;
            }
        }
    }
}

