/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.io.IOException;
import java.io.OutputStream;
import org.opends.server.replication.plugin.GenerationIdChecksum;
import org.opends.server.util.ServerConstants;

public class ReplLDIFOutputStream
extends OutputStream {
    long numEntries;
    private long numExportedEntries;
    String entryBuffer = "";
    private GenerationIdChecksum checkSum = new GenerationIdChecksum();

    public ReplLDIFOutputStream(long numEntries) {
        this.numEntries = numEntries;
    }

    @Override
    public void write(int i) throws IOException {
        throw new IOException("Invalid call");
    }

    public long getChecksumValue() {
        return this.checkSum.getValue();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        block3: {
            int endOfEntryIndex;
            String ebytes = "";
            ebytes = ebytes.concat(this.entryBuffer);
            this.entryBuffer = "";
            ebytes = ebytes.concat(new String(b, off, len));
            int endIndex = ebytes.length();
            while ((endOfEntryIndex = ebytes.indexOf(ServerConstants.EOL + ServerConstants.EOL)) >= 0) {
                this.entryBuffer = ebytes.substring(0, endOfEntryIndex += 2);
                if (this.numEntries > 0L && this.getNumExportedEntries() > this.numEntries) {
                    throw new IOException();
                }
                byte[] entryBytes = this.entryBuffer.getBytes();
                this.checkSum.update(entryBytes, 0, entryBytes.length);
                ++this.numExportedEntries;
                this.entryBuffer = "";
                if (endIndex != endOfEntryIndex) {
                    ebytes = ebytes.substring(endOfEntryIndex, endIndex);
                    endIndex = ebytes.length();
                    continue;
                }
                break block3;
            }
            this.entryBuffer = this.entryBuffer.concat(ebytes);
        }
    }

    public long getNumExportedEntries() {
        return this.numExportedEntries;
    }
}

