/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.DataFormatException;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;

public class StartSessionMsg
extends ReplicationMsg {
    private List<String> referralsURLs = new ArrayList<String>();
    private ServerStatus status = ServerStatus.INVALID_STATUS;
    private boolean assuredFlag = false;
    private AssuredMode assuredMode = AssuredMode.SAFE_DATA_MODE;
    private byte safeDataLevel = 1;
    private Set<String> eclIncludes = new HashSet<String>();
    private Set<String> eclIncludesForDeletes = new HashSet<String>();

    public StartSessionMsg(byte[] in, short version) throws DataFormatException {
        if (version <= 3) {
            this.decode_V23(in);
        } else {
            this.decode_V45(in, version);
        }
    }

    public StartSessionMsg(ServerStatus status, List<String> referralsURLs, boolean assuredFlag, AssuredMode assuredMode, byte safeDataLevel) {
        this.referralsURLs = referralsURLs;
        this.status = status;
        this.assuredFlag = assuredFlag;
        this.assuredMode = assuredMode;
        this.safeDataLevel = safeDataLevel;
    }

    public StartSessionMsg(ServerStatus status, List<String> referralsURLs) {
        this.referralsURLs = referralsURLs;
        this.status = status;
        this.assuredFlag = false;
    }

    @Override
    public byte[] getBytes(short reqProtocolVersion) throws UnsupportedEncodingException {
        if (reqProtocolVersion <= 3) {
            return this.getBytes_V23();
        }
        return this.getBytes_V45(reqProtocolVersion);
    }

    private byte[] getBytes_V45(short version) {
        try {
            ByteStringBuilder byteBuilder = new ByteStringBuilder();
            ASN1Writer writer = ASN1.getWriter(byteBuilder);
            byteBuilder.append((byte)27);
            byteBuilder.append(this.status.getValue());
            byteBuilder.append(this.assuredFlag ? (byte)1 : 0);
            byteBuilder.append(this.assuredMode.getValue());
            byteBuilder.append(this.safeDataLevel);
            writer.writeStartSequence();
            for (String url : this.referralsURLs) {
                writer.writeOctetString(url);
            }
            writer.writeEndSequence();
            writer.writeStartSequence();
            for (String attrDef : this.eclIncludes) {
                writer.writeOctetString(attrDef);
            }
            writer.writeEndSequence();
            if (version >= 5) {
                writer.writeStartSequence();
                for (String attrDef : this.eclIncludesForDeletes) {
                    writer.writeOctetString(attrDef);
                }
                writer.writeEndSequence();
            }
            return byteBuilder.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] getBytes_V23() {
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            oStream.write(27);
            oStream.write(this.status.getValue());
            oStream.write(this.assuredFlag ? 1 : 0);
            oStream.write(this.assuredMode.getValue());
            oStream.write(this.safeDataLevel);
            if (this.referralsURLs.size() >= 1) {
                for (String url : this.referralsURLs) {
                    byte[] byteArrayURL = url.getBytes("UTF-8");
                    oStream.write(byteArrayURL);
                    oStream.write(0);
                }
            }
            return oStream.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    private void decode_V45(byte[] in, short version) throws DataFormatException {
        ByteSequenceReader reader = ByteString.wrap(in).asReader();
        try {
            String s;
            if (reader.get() != 27) {
                throw new DataFormatException("input is not a valid " + this.getClass().getCanonicalName());
            }
            this.status = ServerStatus.valueOf(reader.get());
            this.assuredFlag = reader.get() == 1;
            this.assuredMode = AssuredMode.valueOf(reader.get());
            this.safeDataLevel = reader.get();
            ASN1Reader asn1Reader = ASN1.getReader(reader);
            asn1Reader.readStartSequence();
            while (asn1Reader.hasNextElement()) {
                s = asn1Reader.readOctetStringAsString();
                this.referralsURLs.add(s);
            }
            asn1Reader.readEndSequence();
            asn1Reader.readStartSequence();
            while (asn1Reader.hasNextElement()) {
                s = asn1Reader.readOctetStringAsString();
                this.eclIncludes.add(s);
            }
            asn1Reader.readEndSequence();
            if (version >= 5) {
                asn1Reader.readStartSequence();
                while (asn1Reader.hasNextElement()) {
                    s = asn1Reader.readOctetStringAsString();
                    this.eclIncludesForDeletes.add(s);
                }
                asn1Reader.readEndSequence();
            } else {
                this.eclIncludesForDeletes.addAll(this.eclIncludes);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void decode_V23(byte[] in) throws DataFormatException {
        try {
            int length;
            if (in.length < 1 || in[0] != 27) {
                throw new DataFormatException("Input is not a valid " + this.getClass().getCanonicalName());
            }
            this.status = ServerStatus.valueOf(in[1]);
            this.assuredFlag = in[2] == 1;
            this.assuredMode = AssuredMode.valueOf(in[3]);
            this.safeDataLevel = in[4];
            this.referralsURLs = new ArrayList<String>();
            for (int pos = 5; pos < in.length; pos += length + 1) {
                length = StartSessionMsg.getNextLength(in, pos);
                this.referralsURLs.add(new String(in, pos, length, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
        catch (IllegalArgumentException e) {
            throw new DataFormatException(e.getMessage());
        }
    }

    public List<String> getReferralsURLs() {
        return this.referralsURLs;
    }

    public ServerStatus getStatus() {
        return this.status;
    }

    public String toString() {
        String urls = "";
        for (String s : this.referralsURLs) {
            urls = urls + s + " | ";
        }
        return "StartSessionMsg content:\nstatus: " + (Object)((Object)this.status) + "\nassuredFlag: " + this.assuredFlag + "\nassuredMode: " + (Object)((Object)this.assuredMode) + "\nsafeDataLevel: " + this.safeDataLevel + "\nreferralsURLs: " + urls + "\nEclIncludes " + this.eclIncludes + "\nEclIncludeForDeletes: " + this.eclIncludesForDeletes;
    }

    public boolean isAssured() {
        return this.assuredFlag;
    }

    public AssuredMode getAssuredMode() {
        return this.assuredMode;
    }

    public byte getSafeDataLevel() {
        return this.safeDataLevel;
    }

    public void setEclIncludes(Set<String> includeAttributes, Set<String> includeAttributesForDeletes) {
        if (includeAttributes != null) {
            this.eclIncludes = includeAttributes;
        }
        if (includeAttributesForDeletes != null) {
            this.eclIncludesForDeletes = includeAttributesForDeletes;
        }
    }

    public Set<String> getEclIncludes() {
        return this.eclIncludes;
    }

    public Set<String> getEclIncludesForDeletes() {
        return this.eclIncludesForDeletes;
    }
}

