/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplicationMsg;

public class UpdateMsg
extends ReplicationMsg
implements Comparable<UpdateMsg> {
    protected short protocolVersion;
    protected ChangeNumber changeNumber;
    protected boolean assuredFlag = false;
    protected AssuredMode assuredMode = AssuredMode.SAFE_DATA_MODE;
    protected byte safeDataLevel = 1;
    private byte[] payload;

    protected UpdateMsg() {
    }

    UpdateMsg(byte[] bytes) throws DataFormatException {
        int pos = this.decodeHeader((byte)29, bytes);
        int length = bytes.length - pos;
        this.payload = new byte[length];
        try {
            System.arraycopy(bytes, pos, this.payload, 0, length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (ArrayStoreException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (NullPointerException e) {
            throw new DataFormatException(e.getMessage());
        }
    }

    public UpdateMsg(ChangeNumber changeNumber, byte[] payload) {
        this.payload = payload;
        this.protocolVersion = ProtocolVersion.getCurrentVersion();
        this.changeNumber = changeNumber;
    }

    public ChangeNumber getChangeNumber() {
        return this.changeNumber;
    }

    public boolean isAssured() {
        return this.assuredFlag;
    }

    public void setAssured(boolean assured) {
        this.assuredFlag = assured;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && this.changeNumber.equals(((UpdateMsg)obj).changeNumber);
    }

    public int hashCode() {
        return this.changeNumber.hashCode();
    }

    @Override
    public int compareTo(UpdateMsg msg) {
        return this.changeNumber.compareTo(msg.getChangeNumber());
    }

    public AssuredMode getAssuredMode() {
        return this.assuredMode;
    }

    public byte getSafeDataLevel() {
        return this.safeDataLevel;
    }

    public void setAssuredMode(AssuredMode assuredMode) {
        this.assuredMode = assuredMode;
    }

    public void setSafeDataLevel(byte safeDataLevel) {
        this.safeDataLevel = safeDataLevel;
    }

    public short getVersion() {
        return this.protocolVersion;
    }

    public int size() {
        return 10 + this.payload.length;
    }

    protected byte[] encodeHeader(byte type, int additionalLength, short version) throws UnsupportedEncodingException {
        byte[] changeNumberByte = this.getChangeNumber().toString().getBytes("UTF-8");
        int length = 6 + changeNumberByte.length + additionalLength;
        byte[] encodedMsg = new byte[length];
        encodedMsg[0] = type;
        encodedMsg[1] = (byte)ProtocolVersion.getCurrentVersion();
        int pos = 2;
        pos = UpdateMsg.addByteArray(changeNumberByte, encodedMsg, pos);
        encodedMsg[pos++] = this.assuredFlag ? (byte)1 : 0;
        encodedMsg[pos++] = this.assuredMode.getValue();
        encodedMsg[pos++] = this.safeDataLevel;
        return encodedMsg;
    }

    protected int decodeHeader(byte type, byte[] encodedMsg) throws DataFormatException {
        if (type != encodedMsg[0]) {
            throw new DataFormatException("byte[] is not a valid update msg: " + encodedMsg[0]);
        }
        this.protocolVersion = encodedMsg[1];
        try {
            int pos = 2;
            int length = UpdateMsg.getNextLength(encodedMsg, pos);
            String changenumberStr = new String(encodedMsg, pos, length, "UTF-8");
            pos += length + 1;
            this.changeNumber = new ChangeNumber(changenumberStr);
            this.assuredFlag = encodedMsg[pos++] == 1;
            this.assuredMode = AssuredMode.valueOf(encodedMsg[pos++]);
            this.safeDataLevel = encodedMsg[pos++];
            return pos;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
        catch (IllegalArgumentException e) {
            throw new DataFormatException(e.getMessage());
        }
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        return this.getBytes(ProtocolVersion.getCurrentVersion());
    }

    @Override
    public byte[] getBytes(short protocolVersion) throws UnsupportedEncodingException {
        byte[] resultByteArray = this.encodeHeader((byte)29, this.payload.length, ProtocolVersion.getCurrentVersion());
        int pos = resultByteArray.length - this.payload.length;
        int i = 0;
        while (i < this.payload.length) {
            resultByteArray[pos] = this.payload[i];
            ++i;
            ++pos;
        }
        return resultByteArray;
    }

    public byte[] getPayload() {
        return this.payload;
    }
}

