/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.DatabaseException;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.server.DbHandler;
import org.opends.server.replication.server.ReplicationDB;

public class ReplicationIterator {
    private UpdateMsg currentChange = null;
    private ReplicationDB.ReplServerDBCursor cursor = null;
    private DbHandler dbh;
    private ReplicationDB db;
    ChangeNumber lastNonNullCurrentCN;

    public ReplicationIterator(int id, ReplicationDB db, ChangeNumber changeNumber, DbHandler dbh) throws Exception, DatabaseException {
        this.db = db;
        this.dbh = dbh;
        this.lastNonNullCurrentCN = changeNumber;
        try {
            this.cursor = db.openReadCursor(changeNumber);
        }
        catch (Exception e) {
            this.cursor = null;
        }
        if (this.cursor == null) {
            dbh.flush();
            this.cursor = db.openReadCursor(changeNumber);
            if (this.cursor == null) {
                throw new Exception("no new change");
            }
        }
    }

    public UpdateMsg getChange() {
        return this.currentChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() {
        boolean hasNext;
        this.currentChange = this.cursor.next();
        if (this.currentChange != null) {
            this.lastNonNullCurrentCN = this.currentChange.getChangeNumber();
            hasNext = true;
        } else {
            ReplicationIterator replicationIterator = this;
            synchronized (replicationIterator) {
                if (this.cursor != null) {
                    this.cursor.close();
                    this.cursor = null;
                }
                this.dbh.flush();
                try {
                    this.cursor = this.db.openReadCursor(this.lastNonNullCurrentCN);
                    this.currentChange = this.cursor.next();
                    if (this.currentChange != null) {
                        this.lastNonNullCurrentCN = this.currentChange.getChangeNumber();
                        hasNext = true;
                    } else {
                        hasNext = false;
                    }
                }
                catch (Exception e) {
                    this.currentChange = null;
                    hasNext = false;
                }
            }
        }
        return hasNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCursor() {
        ReplicationIterator replicationIterator = this;
        synchronized (replicationIterator) {
            if (this.cursor != null) {
                this.cursor.close();
                this.cursor = null;
            }
            this.dbh = null;
            this.db = null;
        }
    }

    protected void finalize() {
        this.releaseCursor();
    }
}

