/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.replication.common.DSInfo;
import org.opends.server.replication.common.RSInfo;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplServerStartMsg;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.replication.protocol.Session;
import org.opends.server.replication.protocol.StopMsg;
import org.opends.server.replication.protocol.TopologyMsg;
import org.opends.server.replication.server.LightweightServerHandler;
import org.opends.server.replication.server.MonitorData;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.Attributes;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

public class ReplicationServerHandler
extends ServerHandler {
    private String serverAddressURL;
    private final Map<Integer, LightweightServerHandler> remoteDirectoryServers = new ConcurrentHashMap<Integer, LightweightServerHandler>();

    private boolean processStartFromRemote(ReplServerStartMsg inReplServerStartMsg) throws DirectoryException {
        try {
            short protocolVersion = ProtocolVersion.getCompatibleVersion(inReplServerStartMsg.getVersion());
            this.session.setProtocolVersion(protocolVersion);
            this.generationId = inReplServerStartMsg.getGenerationId();
            this.serverId = inReplServerStartMsg.getServerId();
            this.serverURL = inReplServerStartMsg.getServerURL();
            int separator = this.serverURL.lastIndexOf(58);
            this.serverAddressURL = this.session.getRemoteAddress() + ":" + this.serverURL.substring(separator + 1);
            this.setServiceIdAndDomain(inReplServerStartMsg.getBaseDn(), false);
            this.setInitialServerState(inReplServerStartMsg.getServerState());
            this.setSendWindowSize(inReplServerStartMsg.getWindowSize());
            if (protocolVersion > 1) {
                this.groupId = inReplServerStartMsg.getGroupId();
            }
            this.oldGenerationId = -100L;
        }
        catch (Exception e) {
            Message message = Message.raw(e.getLocalizedMessage(), new Object[0]);
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        return inReplServerStartMsg.getSSLEncryption();
    }

    private ReplServerStartMsg sendStartToRemote() throws IOException {
        ReplServerStartMsg outReplServerStartMsg = new ReplServerStartMsg(this.replicationServerId, this.replicationServerURL, this.getServiceId(), this.maxRcvWindow, this.replicationServerDomain.getDbServerState(), this.localGenerationId, this.sslEncryption, this.getLocalGroupId(), this.replicationServerDomain.getReplicationServer().getDegradedStatusThreshold());
        this.send(outReplServerStartMsg);
        return outReplServerStartMsg;
    }

    public ReplicationServerHandler(Session session, int queueSize, String replicationServerURL, int replicationServerId, ReplicationServer replicationServer, int rcvWindowSize) {
        super(session, queueSize, replicationServerURL, replicationServerId, replicationServer, rcvWindowSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String serviceId, boolean sslEncryption) throws DirectoryException {
        this.sslEncryption = sslEncryption;
        this.setServiceIdAndDomain(serviceId, false);
        this.oldGenerationId = this.localGenerationId = this.replicationServerDomain.getGenerationId();
        try {
            this.lockDomain(false);
            ReplServerStartMsg outReplServerStartMsg = this.sendStartToRemote();
            ReplicationMsg msg = this.session.receive();
            if (!(msg instanceof ReplServerStartMsg)) {
                if (msg instanceof StopMsg) {
                    this.abortStart(null);
                    return;
                }
                Message message = ReplicationMessages.ERR_REPLICATION_PROTOCOL_MESSAGE_TYPE.get(msg.getClass().getCanonicalName(), "ReplServerStartMsg");
                this.abortStart(message);
                return;
            }
            this.processStartFromRemote((ReplServerStartMsg)msg);
            if (!this.replicationServerDomain.checkForDuplicateRS(this)) {
                this.abortStart(null);
                return;
            }
            if (this.localGenerationId < 0L && this.generationId > 0L) {
                this.oldGenerationId = this.replicationServerDomain.changeGenerationId(this.generationId, false);
            }
            this.logStartHandshakeSNDandRCV(outReplServerStartMsg, (ReplServerStartMsg)msg);
            if (!this.sslEncryption) {
                this.session.stopEncryption();
            }
            if (this.getProtocolVersion() > 1) {
                TopologyMsg outTopoMsg = this.replicationServerDomain.createTopologyMsgForRS();
                this.sendTopoInfo(outTopoMsg);
                TopologyMsg inTopoMsg = this.waitAndProcessTopoFromRemoteRS();
                if (inTopoMsg == null) {
                    this.abortStart(null);
                    return;
                }
                this.logTopoHandshakeSNDandRCV(outTopoMsg, inTopoMsg);
                this.createMonitoringPublisher();
                this.registerIntoDomain();
                this.replicationServerDomain.receiveTopoInfoFromRS(inTopoMsg, this, false);
            }
            Message message = ReplicationMessages.INFO_REPLICATION_SERVER_CONNECTION_TO_RS.get(this.getReplicationServerId(), this.getServerId(), this.replicationServerDomain.getBaseDn(), this.session.getReadableRemoteAddress());
            ErrorLogger.logError(message);
            super.finalizeStart();
        }
        catch (IOException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message errMessage = ReplicationMessages.ERR_RS_DISCONNECTED_DURING_HANDSHAKE.get(String.valueOf(this.getReplicationServerId()), this.session.getReadableRemoteAddress());
            this.abortStart(errMessage);
        }
        catch (DirectoryException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.abortStart(e.getMessageObject());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.abortStart(Message.raw(e.getLocalizedMessage(), new Object[0]));
        }
        finally {
            if (this.replicationServerDomain != null && this.replicationServerDomain.hasLock()) {
                this.replicationServerDomain.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFromRemoteRS(ReplServerStartMsg inReplServerStartMsg) {
        this.localGenerationId = -1L;
        this.oldGenerationId = -100L;
        try {
            this.sslEncryption = this.processStartFromRemote(inReplServerStartMsg);
            this.lockDomain(true);
            if (!this.replicationServerDomain.checkForDuplicateRS(this)) {
                this.abortStart(null);
                return;
            }
            this.localGenerationId = this.replicationServerDomain.getGenerationId();
            ReplServerStartMsg outReplServerStartMsg = this.sendStartToRemote();
            this.logStartHandshakeRCVandSND(inReplServerStartMsg, outReplServerStartMsg);
            if (!this.sslEncryption) {
                this.session.stopEncryption();
            }
            TopologyMsg inTopoMsg = null;
            if (this.getProtocolVersion() > 1) {
                inTopoMsg = this.waitAndProcessTopoFromRemoteRS();
                if (inTopoMsg == null) {
                    this.abortStart(null);
                    return;
                }
                TopologyMsg outTopoMsg = this.replicationServerDomain.createTopologyMsgForRS();
                this.sendTopoInfo(outTopoMsg);
                this.logTopoHandshakeRCVandSND(inTopoMsg, outTopoMsg);
            } else if (this.generationId == this.localGenerationId) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + this + " RS V1 with serverID=" + this.serverId + " is connected with the right generation ID");
                }
            } else {
                this.checkGenerationId();
            }
            this.createMonitoringPublisher();
            this.registerIntoDomain();
            if (inTopoMsg != null) {
                this.replicationServerDomain.receiveTopoInfoFromRS(inTopoMsg, this, false);
            }
            Message message = ReplicationMessages.INFO_REPLICATION_SERVER_CONNECTION_FROM_RS.get(this.getReplicationServerId(), this.getServerId(), this.replicationServerDomain.getBaseDn(), this.session.getReadableRemoteAddress());
            ErrorLogger.logError(message);
            super.finalizeStart();
        }
        catch (IOException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message errMessage = ReplicationMessages.ERR_RS_DISCONNECTED_DURING_HANDSHAKE.get(Integer.toString(inReplServerStartMsg.getServerId()), Integer.toString(this.replicationServerDomain.getReplicationServer().getServerId()));
            this.abortStart(errMessage);
        }
        catch (DirectoryException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.abortStart(e.getMessageObject());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.abortStart(Message.raw(e.getLocalizedMessage(), new Object[0]));
        }
        finally {
            if (this.replicationServerDomain != null && this.replicationServerDomain.hasLock()) {
                this.replicationServerDomain.release();
            }
        }
    }

    private void registerIntoDomain() {
        Map<Integer, ReplicationServerHandler> connectedRSs = this.replicationServerDomain.getConnectedRSs();
        connectedRSs.put(this.serverId, this);
    }

    private TopologyMsg waitAndProcessTopoFromRemoteRS() throws DirectoryException {
        ReplicationMsg msg;
        try {
            msg = this.session.receive();
        }
        catch (Exception e) {
            Message message = Message.raw(e.getLocalizedMessage(), new Object[0]);
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        if (!(msg instanceof TopologyMsg)) {
            if (msg instanceof StopMsg) {
                return null;
            }
            Message message = ReplicationMessages.ERR_REPLICATION_PROTOCOL_MESSAGE_TYPE.get(msg.getClass().getCanonicalName(), "TopologyMsg");
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        TopologyMsg inTopoMsg = (TopologyMsg)msg;
        if (this.getProtocolVersion() >= 4) {
            RSInfo rsInfo = inTopoMsg.getRsList().get(0);
            this.weight = rsInfo.getWeight();
        }
        if (this.generationId == this.localGenerationId) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " RS with serverID=" + this.serverId + " is connected with the right generation ID, same as local =" + this.generationId);
            }
        } else {
            this.checkGenerationId();
        }
        return inTopoMsg;
    }

    private void checkGenerationId() {
        if (this.localGenerationId > 0L) {
            if (this.generationId > 0L && this.generationId != this.localGenerationId) {
                if (this.replicationServerDomain.getGenerationIdSavedStatus()) {
                    Message message = ReplicationMessages.WARN_BAD_GENERATION_ID_FROM_RS.get(this.serverId, this.session.getReadableRemoteAddress(), this.generationId, this.getServiceId(), this.getReplicationServerId(), this.localGenerationId);
                    ErrorLogger.logError(message);
                } else {
                    Message message = ReplicationMessages.WARN_BAD_GENERATION_ID_FROM_RS.get(this.serverId, this.session.getReadableRemoteAddress(), this.generationId, this.getServiceId(), this.getReplicationServerId(), this.localGenerationId);
                    ErrorLogger.logError(message);
                }
            }
        } else {
            this.oldGenerationId = this.replicationServerDomain.changeGenerationId(this.generationId, false);
        }
    }

    @Override
    public boolean isDataServer() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDSInfos(List<DSInfo> dsInfos) {
        Map<Integer, LightweightServerHandler> map = this.remoteDirectoryServers;
        synchronized (map) {
            for (LightweightServerHandler ls : this.remoteDirectoryServers.values()) {
                dsInfos.add(ls.toDSInfo());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        super.shutdown();
        Map<Integer, LightweightServerHandler> map = this.remoteDirectoryServers;
        synchronized (map) {
            for (LightweightServerHandler lsh : this.remoteDirectoryServers.values()) {
                lsh.stopHandler();
            }
            this.remoteDirectoryServers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTopoInfoFromRS(TopologyMsg topoMsg) {
        List<RSInfo> rsInfos = topoMsg.getRsList();
        RSInfo rsInfo = rsInfos.get(0);
        this.generationId = rsInfo.getGenerationId();
        this.groupId = rsInfo.getGroupId();
        this.weight = rsInfo.getWeight();
        List<DSInfo> dsInfos = topoMsg.getDsList();
        Map<Integer, LightweightServerHandler> map = this.remoteDirectoryServers;
        synchronized (map) {
            for (LightweightServerHandler lsh : this.remoteDirectoryServers.values()) {
                lsh.stopHandler();
            }
            this.remoteDirectoryServers.clear();
            for (DSInfo dsInfo : dsInfos) {
                LightweightServerHandler lsh = new LightweightServerHandler(this, this.serverId, dsInfo.getDsId(), dsInfo.getDsUrl(), dsInfo.getGenerationId(), dsInfo.getGroupId(), dsInfo.getStatus(), dsInfo.getRefUrls(), dsInfo.isAssured(), dsInfo.getAssuredMode(), dsInfo.getSafeDataLevel(), dsInfo.getEclIncludes(), dsInfo.getEclIncludesForDeletes(), dsInfo.getProtocolVersion());
                lsh.startHandler();
                this.remoteDirectoryServers.put(lsh.getServerId(), lsh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRemoteLDAPServer(int wantedServer) {
        Map<Integer, LightweightServerHandler> map = this.remoteDirectoryServers;
        synchronized (map) {
            for (LightweightServerHandler server : this.remoteDirectoryServers.values()) {
                if (wantedServer != server.getServerId()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRemoteLDAPServers() {
        Map<Integer, LightweightServerHandler> map = this.remoteDirectoryServers;
        synchronized (map) {
            return !this.remoteDirectoryServers.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getConnectedDirectoryServerIds() {
        Map<Integer, LightweightServerHandler> map = this.remoteDirectoryServers;
        synchronized (map) {
            return this.remoteDirectoryServers.keySet();
        }
    }

    @Override
    public String getMonitorInstanceName() {
        return "Connected replication server RS(" + this.serverId + ") " + this.serverURL + ",cn=" + this.replicationServerDomain.getMonitorInstanceName();
    }

    @Override
    public ArrayList<Attribute> getMonitorData() {
        List attributes = super.getMonitorData();
        ((ArrayList)attributes).add(Attributes.create("Replication-Server", this.serverURL));
        MonitorData md = this.replicationServerDomain.getDomainMonitorData();
        long missingChanges = md.getMissingChangesRS(this.serverId);
        ((ArrayList)attributes).add(Attributes.create("missing-changes", String.valueOf(missingChanges)));
        AttributeBuilder builder = new AttributeBuilder("server-state");
        ServerState state = md.getRSStates(this.serverId);
        if (state != null) {
            for (String str : state.toStringSet()) {
                builder.add(str);
            }
            ((ArrayList)attributes).add(builder.toAttribute());
        }
        return attributes;
    }

    public String toString() {
        if (this.serverId != 0) {
            StringBuilder builder = new StringBuilder("Replication server RS(");
            builder.append(this.serverId);
            builder.append(") for domain \"");
            builder.append(this.replicationServerDomain.getBaseDn());
            builder.append("\"");
            return builder.toString();
        }
        return "Unknown server";
    }

    @Override
    public ServerStatus getStatus() {
        return ServerStatus.INVALID_STATUS;
    }

    public String getServerAddressURL() {
        return this.serverAddressURL;
    }

    public void receiveTopoInfoFromRS(TopologyMsg topoMsg) throws DirectoryException, IOException {
        if (this.replicationServerDomain != null) {
            this.replicationServerDomain.receiveTopoInfoFromRS(topoMsg, this, true);
        }
    }
}

