/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.server.ReplicationServerDomain;

class StatusAnalyzer
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final int STATUS_ANALYZER_SLEEP_TIME = 5000;
    private final ReplicationServerDomain replicationServerDomain;
    private final Object eventMonitor = new Object();
    private boolean pendingStatusMessage = false;
    private long nextCheckDSDegradedStatusTime;

    StatusAnalyzer(ReplicationServerDomain replicationServerDomain) {
        super("Replication server RS(" + replicationServerDomain.getReplicationServer().getServerId() + ") status monitor for domain \"" + replicationServerDomain.getBaseDn() + "\"");
        this.replicationServerDomain = replicationServerDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Directory server status monitor starting for dn " + this.replicationServerDomain.getBaseDn());
        }
        try {
            while (true) {
                boolean requestStatusBroadcastWasRequested;
                Object object = this.eventMonitor;
                synchronized (object) {
                    if (!this.isShutdownInitiated() && !this.pendingStatusMessage) {
                        this.eventMonitor.wait(5000L);
                    }
                    requestStatusBroadcastWasRequested = this.pendingStatusMessage;
                    this.pendingStatusMessage = false;
                }
                if (!this.isShutdownInitiated()) {
                    if (requestStatusBroadcastWasRequested) {
                        this.replicationServerDomain.sendPendingStatusMessages();
                    }
                    if (this.nextCheckDSDegradedStatusTime >= System.currentTimeMillis()) continue;
                    this.replicationServerDomain.checkDSDegradedStatus();
                    this.nextCheckDSDegradedStatusTime = System.currentTimeMillis() + 5000L;
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        TRACER.debugInfo("Status monitor for dn " + this.replicationServerDomain.getBaseDn() + " is terminated." + " This is in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
    }

    private String getMessage(String message) {
        return "In RS " + this.replicationServerDomain.getReplicationServer().getServerId() + ", for baseDN=" + this.replicationServerDomain.getBaseDn() + ": " + message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.initiateShutdown();
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(this.getMessage("Shutting down status monitor."));
        }
        Object object = this.eventMonitor;
        synchronized (object) {
            this.eventMonitor.notifyAll();
        }
        try {
            this.join(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.isAlive()) {
            this.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPendingStatusMessage() {
        Object object = this.eventMonitor;
        synchronized (object) {
            this.pendingStatusMessage = true;
            this.eventMonitor.notifyAll();
        }
    }
}

