/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.DSInfo;
import org.opends.server.replication.common.MutableBoolean;
import org.opends.server.replication.common.RSInfo;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.plugin.MultimasterReplication;
import org.opends.server.replication.protocol.ChangeStatusMsg;
import org.opends.server.replication.protocol.MonitorMsg;
import org.opends.server.replication.protocol.MonitorRequestMsg;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplServerStartDSMsg;
import org.opends.server.replication.protocol.ReplServerStartMsg;
import org.opends.server.replication.protocol.ReplSessionSecurity;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.replication.protocol.ServerStartECLMsg;
import org.opends.server.replication.protocol.ServerStartMsg;
import org.opends.server.replication.protocol.Session;
import org.opends.server.replication.protocol.StartECLSessionMsg;
import org.opends.server.replication.protocol.StartMsg;
import org.opends.server.replication.protocol.StartSessionMsg;
import org.opends.server.replication.protocol.StopMsg;
import org.opends.server.replication.protocol.TopologyMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.protocol.WindowMsg;
import org.opends.server.replication.protocol.WindowProbeMsg;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.service.CTHeartbeatPublisherThread;
import org.opends.server.replication.service.HeartbeatMonitor;
import org.opends.server.replication.service.ReplicationDomain;
import org.opends.server.replication.service.ReplicationMonitor;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.StaticUtils;

public class ReplicationBroker {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private volatile boolean shutdown = false;
    private final Object startStopLock = new Object();
    private volatile Collection<String> replicationServerUrls;
    private volatile boolean connected = false;
    public static final String NO_CONNECTED_SERVER = "Not connected";
    private volatile String replicationServer = "Not connected";
    private volatile Session session = null;
    private final ServerState state;
    private final String baseDn;
    private final int serverId;
    private Semaphore sendWindow;
    private int maxSendWindow;
    private int rcvWindow = 100;
    private int halfRcvWindow = this.rcvWindow / 2;
    private int maxRcvWindow = this.rcvWindow;
    private int timeout = 0;
    private short protocolVersion;
    private ReplSessionSecurity replSessionSecurity;
    private byte groupId = (byte)-1;
    private byte rsGroupId = (byte)-1;
    private Integer rsServerId = -1;
    private String rsServerUrl = null;
    private ReplicationDomain domain = null;
    private InetAddress sourceAddress = null;
    private final MutableBoolean monitorResponse = new MutableBoolean(false);
    private HashMap<Integer, ServerState> replicaStates = new HashMap();
    private long heartbeatInterval = 0L;
    private HeartbeatMonitor heartbeatMonitor = null;
    private int numLostConnections = 0;
    private volatile boolean connectionError = false;
    private final Object connectPhaseLock = new Object();
    private CTHeartbeatPublisherThread ctHeartbeatPublisherThread = null;
    private long changeTimeHeartbeatSendInterval = 0L;
    private volatile List<DSInfo> dsList = new ArrayList<DSInfo>();
    private volatile long generationID;
    private volatile int updateDoneCount = 0;
    private volatile boolean connectRequiresRecovery = false;
    private volatile Map<Integer, ReplicationServerInfo> replicationServerInfos = null;
    private int mustRunBestServerCheckingAlgorithm = 0;
    private final ReplicationMonitor monitor;

    public ReplicationBroker(ReplicationDomain replicationDomain, ServerState state, String baseDn, int serverID2, int window, long generationId, long heartbeatInterval, ReplSessionSecurity replSessionSecurity, byte groupId, long changeTimeHeartbeatInterval, InetAddress sourceAddress) {
        this.domain = replicationDomain;
        this.baseDn = baseDn;
        this.serverId = serverID2;
        this.state = state;
        this.protocolVersion = ProtocolVersion.getCurrentVersion();
        this.replSessionSecurity = replSessionSecurity;
        this.groupId = groupId;
        this.generationID = generationId;
        this.heartbeatInterval = heartbeatInterval;
        this.rcvWindow = window;
        this.maxRcvWindow = window;
        this.halfRcvWindow = window / 2;
        this.changeTimeHeartbeatSendInterval = changeTimeHeartbeatInterval;
        this.sourceAddress = sourceAddress;
        this.monitor = replicationDomain != null ? new ReplicationMonitor(replicationDomain) : null;
        this.registerReplicationMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.startStopLock;
        synchronized (object) {
            this.shutdown = false;
            this.rcvWindow = this.maxRcvWindow;
            this.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Collection<String> replicationServers) {
        Object object = this.startStopLock;
        synchronized (object) {
            this.shutdown = false;
            this.replicationServerUrls = replicationServers;
            if (this.replicationServerUrls.size() < 1) {
                Message message = ReplicationMessages.NOTE_NEED_MORE_THAN_ONE_CHANGELOG_SERVER.get();
                ErrorLogger.logError(message);
            }
            this.rcvWindow = this.maxRcvWindow;
            this.connect();
        }
    }

    public byte getRsGroupId() {
        return this.rsGroupId;
    }

    public Integer getRsServerId() {
        return this.rsServerId;
    }

    public int getServerId() {
        return this.serverId;
    }

    private long getGenerationID() {
        if (this.domain != null) {
            this.generationID = this.domain.getGenerationID();
        }
        return this.generationID;
    }

    public void setGenerationID(long generationID) {
        this.generationID = generationID;
    }

    public String getRsServerUrl() {
        return this.rsServerUrl;
    }

    private void updateRSInfoLocallyConfiguredStatus(ReplicationServerInfo replicationServerInfo) {
        String rsUrl = replicationServerInfo.getServerURL();
        if (rsUrl == null) {
            replicationServerInfo.setLocallyConfigured(false);
            return;
        }
        for (String serverUrl : this.replicationServerUrls) {
            if (!ReplicationBroker.isSameReplicationServerUrl(serverUrl, rsUrl)) continue;
            replicationServerInfo.setLocallyConfigured(true);
            replicationServerInfo.serverURL = serverUrl;
            return;
        }
        replicationServerInfo.setLocallyConfigured(false);
    }

    private static boolean isSameReplicationServerUrl(String rs1Url, String rs2Url) {
        InetAddress[] rs2Addresses;
        InetAddress[] rs1Addresses;
        int separator1 = rs1Url.lastIndexOf(58);
        if (separator1 < 0) {
            return false;
        }
        int rs1Port = Integer.parseInt(rs1Url.substring(separator1 + 1));
        int separator2 = rs2Url.lastIndexOf(58);
        if (separator2 < 0) {
            return false;
        }
        int rs2Port = Integer.parseInt(rs2Url.substring(separator2 + 1));
        if (rs1Port != rs2Port) {
            return false;
        }
        String rs1 = rs1Url.substring(0, separator1);
        try {
            rs1Addresses = StaticUtils.isLocalAddress(rs1) ? null : InetAddress.getAllByName(rs1);
        }
        catch (UnknownHostException ex) {
            return false;
        }
        String rs2 = rs2Url.substring(0, separator2);
        try {
            rs2Addresses = StaticUtils.isLocalAddress(rs2) ? null : InetAddress.getAllByName(rs2);
        }
        catch (UnknownHostException ex) {
            return false;
        }
        if (rs1Addresses == null && rs2Addresses == null) {
            return true;
        }
        if (rs1Addresses == null || rs2Addresses == null) {
            return false;
        }
        for (InetAddress inetAddress1 : rs1Addresses) {
            for (InetAddress inetAddress2 : rs2Addresses) {
                if (!inetAddress2.equals(inetAddress1)) continue;
                return true;
            }
        }
        return false;
    }

    private void connect() {
        if (this.baseDn.compareToIgnoreCase("cn=changelog") == 0) {
            this.connectAsECL();
        } else {
            this.connectAsDataServer();
        }
    }

    private Map<Integer, ReplicationServerInfo> collectReplicationServersInfo() {
        ConcurrentHashMap<Integer, ReplicationServerInfo> rsInfos = new ConcurrentHashMap<Integer, ReplicationServerInfo>();
        for (String serverUrl : this.replicationServerUrls) {
            ReplicationServerInfo replicationServerInfo = this.performPhaseOneHandshake(serverUrl, false, false);
            if (replicationServerInfo == null) continue;
            rsInfos.put(replicationServerInfo.getServerId(), replicationServerInfo);
        }
        return rsInfos;
    }

    private void connectAsECL() {
        String bestServer = this.replicationServerUrls.iterator().next();
        if (this.performPhaseOneHandshake(bestServer, true, true) != null) {
            this.performECLPhaseTwoHandshake(bestServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectAsDataServer() {
        if (this.domain != null) {
            this.domain.toNotConnectedStatus();
        }
        this.stopRSHeartBeatMonitoring();
        this.stopChangeTimeHeartBeatPublishing();
        this.mustRunBestServerCheckingAlgorithm = 0;
        Object object = this.connectPhaseLock;
        synchronized (object) {
            Message message;
            if (DebugLogger.debugEnabled()) {
                this.debugInfo("phase 1 : will perform PhaseOneH with each RS in order to elect the preferred one");
            }
            this.replicationServerInfos = this.collectReplicationServersInfo();
            ReplicationServerInfo electedRsInfo = null;
            if (this.replicationServerInfos.size() > 0) {
                RSEvaluations evals = ReplicationBroker.computeBestReplicationServer(true, -1, this.state, this.replicationServerInfos, this.serverId, this.groupId, this.getGenerationID());
                electedRsInfo = evals.getBestRS();
                if (DebugLogger.debugEnabled()) {
                    this.debugInfo("phase 2 : will perform PhaseOneH with the preferred RS=" + electedRsInfo);
                }
                if ((electedRsInfo = this.performPhaseOneHandshake(electedRsInfo.getServerURL(), true, false)) != null) {
                    this.replicationServerInfos.put(electedRsInfo.getServerId(), electedRsInfo);
                    ServerStatus initStatus = this.computeInitialServerStatus(electedRsInfo.getGenerationId(), electedRsInfo.getServerState(), electedRsInfo.getDegradedStatusThreshold(), this.getGenerationID());
                    TopologyMsg topologyMsg = this.performPhaseTwoHandshake(electedRsInfo.getServerURL(), initStatus);
                    if (topologyMsg != null) {
                        this.connectToReplicationServer(electedRsInfo, initStatus, topologyMsg);
                    }
                }
            }
            if (electedRsInfo != null && this.connected) {
                this.connectPhaseLock.notify();
                if (electedRsInfo.getGenerationId() == this.getGenerationID() || electedRsInfo.getGenerationId() == -1L) {
                    message = ReplicationMessages.NOTE_NOW_FOUND_SAME_GENERATION_CHANGELOG.get(this.serverId, this.rsServerId, this.baseDn, this.session.getReadableRemoteAddress(), this.getGenerationID());
                    ErrorLogger.logError(message);
                } else {
                    message = ReplicationMessages.WARN_NOW_FOUND_BAD_GENERATION_CHANGELOG.get(this.serverId, this.rsServerId, this.baseDn, this.session.getReadableRemoteAddress(), this.getGenerationID(), electedRsInfo.getGenerationId());
                    ErrorLogger.logError(message);
                }
            } else {
                this.connected = false;
                this.replicationServer = NO_CONNECTED_SERVER;
                if (!this.connectionError) {
                    this.connectionError = true;
                    this.connectPhaseLock.notify();
                    if (this.replicationServerInfos.size() > 0) {
                        message = ReplicationMessages.WARN_COULD_NOT_FIND_CHANGELOG.get(this.serverId, this.baseDn, StaticUtils.collectionToString(this.replicationServerInfos.keySet(), ", "));
                        ErrorLogger.logError(message);
                    } else {
                        message = ReplicationMessages.WARN_NO_AVAILABLE_CHANGELOGS.get(this.serverId, this.baseDn);
                        ErrorLogger.logError(message);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToReplicationServer(ReplicationServerInfo rsInfo, ServerStatus initStatus, TopologyMsg topologyMsg) {
        try {
            this.replicationServer = this.session.getReadableRemoteAddress();
            this.maxSendWindow = rsInfo.getWindowSize();
            this.rsGroupId = rsInfo.getGroupId();
            this.rsServerId = rsInfo.getServerId();
            this.rsServerUrl = rsInfo.getServerURL();
            this.receiveTopo(topologyMsg);
            this.connectionError = false;
            if (this.sendWindow != null) {
                int MAX_PERMITS = 0x1FFFFFFF;
                if (this.sendWindow.availablePermits() < 0x1FFFFFFF) {
                    this.sendWindow.release(0x1FFFFFFF);
                }
            }
            this.sendWindow = new Semaphore(this.maxSendWindow);
            this.rcvWindow = this.maxRcvWindow;
            this.connected = true;
            if (this.domain != null) {
                this.domain.sessionInitiated(initStatus, rsInfo.getServerState(), rsInfo.getGenerationId(), this.session);
            }
            if (this.getRsGroupId() != this.groupId) {
                Message message = ReplicationMessages.WARN_CONNECTED_TO_SERVER_WITH_WRONG_GROUP_ID.get(Byte.toString(this.groupId), Integer.toString(this.rsServerId), rsInfo.getServerURL(), Byte.toString(this.getRsGroupId()), this.baseDn, Integer.toString(this.serverId));
                ErrorLogger.logError(message);
            }
            this.startRSHeartBeatMonitoring();
            if (rsInfo.getProtocolVersion() >= 3) {
                this.startChangeTimeHeartBeatPublishing();
            }
        }
        catch (Exception e) {
            Message message = ReplicationMessages.ERR_COMPUTING_FAKE_OPS.get(this.baseDn, rsInfo.getServerURL(), e.getLocalizedMessage() + StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
        }
        finally {
            if (!this.connected) {
                this.setSession(null);
            }
        }
    }

    public ServerStatus computeInitialServerStatus(long rsGenId, ServerState rsState, int degradedStatusThreshold, long dsGenId) {
        if (rsGenId == -1L) {
            return ServerStatus.NORMAL_STATUS;
        }
        if (rsGenId == dsGenId) {
            int nChanges = ServerState.diffChanges(rsState, this.state);
            if (DebugLogger.debugEnabled()) {
                this.debugInfo("computed " + nChanges + " changes late.");
            }
            ServerStatus initStatus = degradedStatusThreshold > 0 ? (nChanges >= degradedStatusThreshold ? ServerStatus.DEGRADED_STATUS : ServerStatus.NORMAL_STATUS) : ServerStatus.NORMAL_STATUS;
            return initStatus;
        }
        return ServerStatus.BAD_GEN_ID_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplicationServerInfo performPhaseOneHandshake(String server, boolean keepConnection, boolean isECL) {
        ReplicationServerInfo replicationServerInfo;
        int separator = server.lastIndexOf(58);
        String port = server.substring(separator + 1);
        String hostname = server.substring(0, separator);
        Session localSession = null;
        Socket socket = null;
        boolean hasConnected = false;
        Message errorMessage = null;
        try {
            ReplicationServerInfo replServerInfo;
            String repDn;
            int intPort = Integer.parseInt(port);
            InetSocketAddress serverAddr = new InetSocketAddress(InetAddress.getByName(hostname), intPort);
            socket = new Socket();
            socket.setReceiveBufferSize(1000000);
            socket.setTcpNoDelay(true);
            if (this.sourceAddress != null) {
                InetSocketAddress local = new InetSocketAddress(this.sourceAddress, 0);
                socket.bind(local);
            }
            int timeoutMS = MultimasterReplication.getConnectionTimeoutMS();
            socket.connect(serverAddr, timeoutMS);
            localSession = this.replSessionSecurity.createClientSession(socket, timeoutMS);
            boolean isSslEncryption = this.replSessionSecurity.isSslEncryption(server);
            String url = socket.getLocalAddress().getHostName() + ":" + socket.getLocalPort();
            StartMsg serverStartMsg = !isECL ? new ServerStartMsg(this.serverId, url, this.baseDn, this.maxRcvWindow, this.heartbeatInterval, this.state, this.getGenerationID(), isSslEncryption, this.groupId) : new ServerStartECLMsg(url, 0, 0, 0, 0, this.maxRcvWindow, this.heartbeatInterval, this.state, this.getGenerationID(), isSslEncryption, this.groupId);
            localSession.publish(serverStartMsg);
            ReplicationMsg msg = localSession.receive();
            if (DebugLogger.debugEnabled()) {
                this.debugInfo("RB HANDSHAKE SENT:\n" + serverStartMsg + "\nAND RECEIVED:\n" + msg);
            }
            if (!this.baseDn.equals(repDn = (replServerInfo = ReplicationServerInfo.newInstance(msg, server)).getBaseDn())) {
                errorMessage = ReplicationMessages.ERR_DS_DN_DOES_NOT_MATCH.get(repDn, this.baseDn);
                ReplicationServerInfo replicationServerInfo2 = null;
                return replicationServerInfo2;
            }
            short localProtocolVersion = ProtocolVersion.getCompatibleVersion(replServerInfo.getProtocolVersion());
            if (keepConnection) {
                this.protocolVersion = localProtocolVersion;
            }
            localSession.setProtocolVersion(localProtocolVersion);
            if (!isSslEncryption) {
                localSession.stopEncryption();
            }
            hasConnected = true;
            if (keepConnection) {
                this.setSession(localSession);
            }
            ReplicationServerInfo replicationServerInfo3 = replServerInfo;
            return replicationServerInfo3;
        }
        catch (ConnectException e) {
            errorMessage = ReplicationMessages.WARN_NO_CHANGELOG_SERVER_LISTENING.get(this.serverId, server, this.baseDn);
            replicationServerInfo = null;
            return replicationServerInfo;
        }
        catch (SocketTimeoutException e) {
            errorMessage = ReplicationMessages.WARN_TIMEOUT_CONNECTING_TO_RS.get(this.serverId, server, this.baseDn);
            replicationServerInfo = null;
            return replicationServerInfo;
        }
        catch (Exception e) {
            errorMessage = ReplicationMessages.WARN_EXCEPTION_STARTING_SESSION_PHASE.get(this.serverId, server, this.baseDn, StaticUtils.stackTraceToSingleLineString(e));
            replicationServerInfo = null;
            return replicationServerInfo;
        }
        finally {
            if (!hasConnected || !keepConnection) {
                if (localSession != null) {
                    localSession.close();
                }
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (!hasConnected && errorMessage != null && !this.connectionError) {
                if (keepConnection) {
                    ErrorLogger.logError(errorMessage);
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo(errorMessage.toString());
                }
            }
        }
    }

    private TopologyMsg performECLPhaseTwoHandshake(String server) {
        TopologyMsg topologyMsg = null;
        try {
            StartECLSessionMsg startECLSessionMsg = new StartECLSessionMsg();
            startECLSessionMsg.setOperationId("-1");
            this.session.publish(startECLSessionMsg);
            if (DebugLogger.debugEnabled()) {
                this.debugInfo("RB HANDSHAKE SENT:\n" + startECLSessionMsg.toString());
            }
            this.session.setSoTimeout(this.timeout);
            this.connected = true;
        }
        catch (Exception e) {
            Message message = ReplicationMessages.WARN_EXCEPTION_STARTING_SESSION_PHASE.get(this.serverId, server, this.baseDn, StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
            this.setSession(null);
            topologyMsg = null;
        }
        return topologyMsg;
    }

    private TopologyMsg performPhaseTwoHandshake(String server, ServerStatus initStatus) {
        TopologyMsg topologyMsg;
        try {
            StartSessionMsg startSessionMsg;
            if (this.domain != null) {
                startSessionMsg = new StartSessionMsg(initStatus, this.domain.getRefUrls(), this.domain.isAssured(), this.domain.getAssuredMode(), this.domain.getAssuredSdLevel());
                startSessionMsg.setEclIncludes(this.domain.getEclIncludes(this.domain.getServerId()), this.domain.getEclIncludesForDeletes(this.domain.getServerId()));
            } else {
                startSessionMsg = new StartSessionMsg(initStatus, new ArrayList<String>());
            }
            this.session.publish(startSessionMsg);
            topologyMsg = (TopologyMsg)this.session.receive();
            if (DebugLogger.debugEnabled()) {
                this.debugInfo("RB HANDSHAKE SENT:\n" + startSessionMsg + "\nAND RECEIVED:\n" + topologyMsg);
            }
            this.session.setSoTimeout(this.timeout);
        }
        catch (Exception e) {
            Message message = ReplicationMessages.WARN_EXCEPTION_STARTING_SESSION_PHASE.get(this.serverId, server, this.baseDn, StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
            this.setSession(null);
            topologyMsg = null;
        }
        return topologyMsg;
    }

    public static RSEvaluations computeBestReplicationServer(boolean firstConnection, int rsServerId, ServerState myState, Map<Integer, ReplicationServerInfo> rsInfos, int localServerId, byte groupId, long generationId) {
        RSEvaluations evals = new RSEvaluations(localServerId, rsInfos);
        if (evals.foundBestRS()) {
            return evals;
        }
        ReplicationBroker.filterServersLocallyConfigured(evals, localServerId);
        ReplicationBroker.filterServersWithSameGroupId(evals, localServerId, groupId);
        boolean rssWithSameGenerationIdExist = ReplicationBroker.filterServersWithSameGenerationId(evals, localServerId, generationId);
        if (rssWithSameGenerationIdExist) {
            ReplicationBroker.filterServersWithAllLocalDSChanges(evals, myState, localServerId);
        }
        ReplicationBroker.filterServersOnSameHost(evals, localServerId);
        if (evals.foundBestRS()) {
            return evals;
        }
        if (firstConnection) {
            ReplicationBroker.computeBestServerForWeight(evals, -1, -1);
        } else {
            ReplicationBroker.computeBestServerForWeight(evals, rsServerId, localServerId);
        }
        return evals;
    }

    private static void filterServersLocallyConfigured(RSEvaluations evals, int localServerId) {
        LocalEvaluation eval = new LocalEvaluation();
        for (Map.Entry entry : evals.bestRSs.entrySet()) {
            Integer rsId = (Integer)entry.getKey();
            ReplicationServerInfo rsInfo = (ReplicationServerInfo)entry.getValue();
            if (rsInfo.isLocallyConfigured()) {
                eval.accept(rsId, rsInfo);
                continue;
            }
            eval.reject(rsInfo, ReplicationMessages.NOTE_RS_NOT_LOCALLY_CONFIGURED.get(rsId, localServerId));
        }
        evals.keepBest(eval);
    }

    private static void filterServersWithSameGroupId(RSEvaluations evals, int localServerId, byte groupId) {
        LocalEvaluation eval = new LocalEvaluation();
        for (Map.Entry entry : evals.bestRSs.entrySet()) {
            Integer rsId = (Integer)entry.getKey();
            ReplicationServerInfo rsInfo = (ReplicationServerInfo)entry.getValue();
            if (rsInfo.getGroupId() == groupId) {
                eval.accept(rsId, rsInfo);
                continue;
            }
            eval.reject(rsInfo, ReplicationMessages.NOTE_RS_HAS_DIFFERENT_GROUP_ID_THAN_DS.get(rsId, rsInfo.getGroupId(), localServerId, groupId));
        }
        evals.keepBest(eval);
    }

    private static boolean filterServersWithSameGenerationId(RSEvaluations evals, long localServerId, long generationId) {
        Map bestServers = evals.bestRSs;
        LocalEvaluation eval = new LocalEvaluation();
        boolean emptyState = true;
        for (Map.Entry entry : bestServers.entrySet()) {
            Integer rsId = (Integer)entry.getKey();
            ReplicationServerInfo rsInfo = (ReplicationServerInfo)entry.getValue();
            if (rsInfo.getGenerationId() == generationId) {
                eval.accept(rsId, rsInfo);
                if (rsInfo.serverState.isEmpty()) continue;
                emptyState = false;
                continue;
            }
            if (rsInfo.getGenerationId() == -1L) {
                eval.reject(rsInfo, ReplicationMessages.NOTE_RS_HAS_NO_GENERATION_ID.get(rsId, generationId, localServerId));
                continue;
            }
            eval.reject(rsInfo, ReplicationMessages.NOTE_RS_HAS_DIFFERENT_GENERATION_ID_THAN_DS.get(rsId, rsInfo.getGenerationId(), localServerId, generationId));
        }
        if (emptyState) {
            for (Map.Entry entry : bestServers.entrySet()) {
                ReplicationServerInfo rsInfo = (ReplicationServerInfo)entry.getValue();
                if (rsInfo.getGenerationId() != -1L) continue;
                eval.accept((Integer)entry.getKey(), rsInfo);
            }
        }
        return evals.keepBest(eval);
    }

    private static void filterServersWithAllLocalDSChanges(RSEvaluations evals, ServerState localState, int localServerId) {
        ChangeNumber localCN = ReplicationBroker.getMaxChangeNumber(localState, localServerId);
        LocalEvaluation mostUpToDateEval = new LocalEvaluation();
        boolean foundRSMoreUpToDateThanLocalDS = false;
        ChangeNumber latestRsCN = null;
        for (Map.Entry entry : evals.bestRSs.entrySet()) {
            Integer rsId = (Integer)entry.getKey();
            ReplicationServerInfo rsInfo = (ReplicationServerInfo)entry.getValue();
            ChangeNumber rsCN = ReplicationBroker.getMaxChangeNumber(rsInfo.getServerState(), localServerId);
            if (rsCN.older(localCN).booleanValue()) {
                mostUpToDateEval.reject(rsInfo, ReplicationMessages.NOTE_RS_LATER_THAN_LOCAL_DS.get(rsId, rsCN.toStringUI(), localServerId, localCN.toStringUI()));
                continue;
            }
            if (rsCN.equals(localCN)) {
                if (!foundRSMoreUpToDateThanLocalDS) {
                    mostUpToDateEval.accept(rsId, rsInfo);
                    continue;
                }
                mostUpToDateEval.reject(rsInfo, ReplicationMessages.NOTE_RS_LATER_THAN_ANOTHER_RS_MORE_UP_TO_DATE_THAN_LOCAL_DS.get(rsId, rsCN.toStringUI(), localServerId, localCN.toStringUI()));
                continue;
            }
            if (!rsCN.newer(localCN)) continue;
            if (latestRsCN == null) {
                foundRSMoreUpToDateThanLocalDS = true;
                ReplicationBroker.rejectAllWithRSIsLaterThanBestRS(mostUpToDateEval, localServerId, localCN);
                latestRsCN = rsCN;
            }
            if (rsCN.equals(latestRsCN)) {
                mostUpToDateEval.accept(rsId, rsInfo);
                continue;
            }
            if (rsCN.newer(latestRsCN)) {
                ReplicationBroker.rejectAllWithRSIsLaterThanBestRS(mostUpToDateEval, localServerId, localCN);
                mostUpToDateEval.accept(rsId, rsInfo);
                latestRsCN = rsCN;
                continue;
            }
            mostUpToDateEval.reject(rsInfo, ReplicationMessages.NOTE_RS_LATER_THAN_ANOTHER_RS_MORE_UP_TO_DATE_THAN_LOCAL_DS.get(rsId, rsCN.toStringUI(), localServerId, localCN.toStringUI()));
        }
        evals.keepBest(mostUpToDateEval);
    }

    private static ChangeNumber getMaxChangeNumber(ServerState state, int serverId) {
        ChangeNumber cn = state.getMaxChangeNumber(serverId);
        if (cn != null) {
            return cn;
        }
        return new ChangeNumber(0L, 0, serverId);
    }

    private static void rejectAllWithRSIsLaterThanBestRS(LocalEvaluation eval, int localServerId, ChangeNumber localCN) {
        for (ReplicationServerInfo rsInfo : eval.getAcceptedRSInfos()) {
            String rsCN = ReplicationBroker.getMaxChangeNumber(rsInfo.getServerState(), localServerId).toStringUI();
            Message reason = ReplicationMessages.NOTE_RS_LATER_THAN_ANOTHER_RS_MORE_UP_TO_DATE_THAN_LOCAL_DS.get(rsInfo.getServerId(), rsCN, localServerId, localCN.toStringUI());
            eval.reject(rsInfo, reason);
        }
    }

    private static void filterServersOnSameHost(RSEvaluations evals, int localServerId) {
        boolean foundRSInSameVM = false;
        LocalEvaluation eval = new LocalEvaluation();
        for (Map.Entry entry : evals.bestRSs.entrySet()) {
            Integer rsId = (Integer)entry.getKey();
            ReplicationServerInfo rsInfo = (ReplicationServerInfo)entry.getValue();
            String server = rsInfo.getServerURL();
            int separator = server.lastIndexOf(58);
            if (separator > 0) {
                String hostname = server.substring(0, separator);
                if (StaticUtils.isLocalAddress(hostname)) {
                    int port = Integer.parseInt(server.substring(separator + 1));
                    if (ReplicationServer.isLocalReplicationServerPort(port)) {
                        if (!foundRSInSameVM) {
                            ReplicationBroker.rejectAllWithRSOnDifferentVMThanDS(eval, localServerId);
                            foundRSInSameVM = true;
                        }
                        eval.accept(rsId, rsInfo);
                        continue;
                    }
                    if (!foundRSInSameVM) {
                        eval.accept(rsId, rsInfo);
                        continue;
                    }
                    eval.reject(rsInfo, ReplicationMessages.NOTE_RS_ON_DIFFERENT_VM_THAN_DS.get(rsId, localServerId));
                    continue;
                }
                eval.reject(rsInfo, ReplicationMessages.NOTE_RS_ON_DIFFERENT_HOST_THAN_DS.get(rsId, localServerId));
                continue;
            }
            eval.reject(rsInfo, ReplicationMessages.NOTE_RS_URL_HAS_NO_PORT_NUMBER.get(rsId, server));
        }
        evals.keepBest(eval);
    }

    private static void rejectAllWithRSOnDifferentVMThanDS(LocalEvaluation eval, int localServerId) {
        for (ReplicationServerInfo rsInfo : eval.getAcceptedRSInfos()) {
            eval.reject(rsInfo, ReplicationMessages.NOTE_RS_ON_DIFFERENT_VM_THAN_DS.get(rsInfo.getServerId(), localServerId));
        }
    }

    public static void computeBestServerForWeight(RSEvaluations evals, int currentRsServerId, int localServerId) {
        Map bestServers = evals.bestRSs;
        int sumOfWeights = 0;
        int sumOfConnectedDSs = 0;
        for (ReplicationServerInfo rsInfo : bestServers.values()) {
            sumOfWeights += rsInfo.getWeight();
            sumOfConnectedDSs += rsInfo.getConnectedDSNumber();
        }
        HashMap<Integer, BigDecimal> loadDistances = new HashMap<Integer, BigDecimal>();
        MathContext mathContext = new MathContext(32, RoundingMode.HALF_UP);
        for (Map.Entry entry : bestServers.entrySet()) {
            Integer rsId = (Integer)entry.getKey();
            ReplicationServerInfo rsInfo = (ReplicationServerInfo)entry.getValue();
            BigDecimal loadGoalBd = BigDecimal.valueOf(rsInfo.getWeight()).divide(BigDecimal.valueOf(sumOfWeights), mathContext);
            BigDecimal currentLoadBd = BigDecimal.ZERO;
            if (sumOfConnectedDSs != 0) {
                int connectedDSs = rsInfo.getConnectedDSNumber();
                currentLoadBd = BigDecimal.valueOf(connectedDSs).divide(BigDecimal.valueOf(sumOfConnectedDSs), mathContext);
            }
            BigDecimal loadDistanceBd = loadGoalBd.subtract(currentLoadBd, mathContext);
            loadDistances.put(rsId, loadDistanceBd);
        }
        if (currentRsServerId == -1) {
            ReplicationBroker.computeBestServerWhenNotConnected(evals, loadDistances, localServerId);
        } else {
            ReplicationBroker.computeBestServerWhenConnected(evals, loadDistances, localServerId, currentRsServerId, sumOfWeights, sumOfConnectedDSs);
        }
    }

    private static void computeBestServerWhenNotConnected(RSEvaluations evals, Map<Integer, BigDecimal> loadDistances, int localServerId) {
        Map bestServers = evals.bestRSs;
        int bestRsId = 0;
        float highestDistance = Float.NEGATIVE_INFINITY;
        boolean allRsWithZeroDistance = true;
        int highestWeightRsId = -1;
        int highestWeight = -1;
        for (Integer rsId : bestServers.keySet()) {
            int weight;
            float loadDistance = loadDistances.get(rsId).floatValue();
            if (loadDistance > highestDistance) {
                bestRsId = rsId;
                highestDistance = loadDistance;
            }
            if (loadDistance != 0.0f) {
                allRsWithZeroDistance = false;
            }
            if ((weight = ((ReplicationServerInfo)bestServers.get(rsId)).getWeight()) <= highestWeight) continue;
            highestWeightRsId = rsId;
            highestWeight = weight;
        }
        if (allRsWithZeroDistance) {
            bestRsId = highestWeightRsId;
        }
        evals.setBestRS(bestRsId, ReplicationMessages.NOTE_BIGGEST_WEIGHT_RS.get(localServerId, bestRsId));
    }

    private static void computeBestServerWhenConnected(RSEvaluations evals, Map<Integer, BigDecimal> loadDistances, int localServerId, int currentRsServerId, int sumOfWeights, int sumOfConnectedDSs) {
        Map bestServers = evals.bestRSs;
        MathContext mathContext = new MathContext(32, RoundingMode.HALF_UP);
        float currentLoadDistance = loadDistances.get(currentRsServerId).floatValue();
        if (currentLoadDistance < 0.0f) {
            BigDecimal sumOfLoadDistancesOfOtherRSsBd = BigDecimal.ZERO;
            for (Integer rsId : bestServers.keySet()) {
                if (rsId == currentRsServerId) continue;
                sumOfLoadDistancesOfOtherRSsBd = sumOfLoadDistancesOfOtherRSsBd.add(loadDistances.get(rsId), mathContext);
            }
            if (sumOfLoadDistancesOfOtherRSsBd.floatValue() > 0.0f) {
                ReplicationServerInfo currentRsInfo;
                float notRoundedOverloadingDSsNumber = sumOfLoadDistancesOfOtherRSsBd.multiply(BigDecimal.valueOf(sumOfConnectedDSs), mathContext).floatValue();
                int overloadingDSsNumber = Math.round(notRoundedOverloadingDSsNumber);
                if (overloadingDSsNumber == 1) {
                    ReplicationServerInfo currentReplicationServerInfo = (ReplicationServerInfo)bestServers.get(currentRsServerId);
                    int currentRsWeight = currentReplicationServerInfo.getWeight();
                    BigDecimal currentRsWeightBd = BigDecimal.valueOf(currentRsWeight);
                    BigDecimal sumOfWeightsBd = BigDecimal.valueOf(sumOfWeights);
                    BigDecimal currentRsLoadGoalBd = currentRsWeightBd.divide(sumOfWeightsBd, mathContext);
                    BigDecimal potentialCurrentRsNewLoadBd = BigDecimal.ZERO;
                    if (sumOfConnectedDSs != 0) {
                        int connectedDSs = currentReplicationServerInfo.getConnectedDSNumber();
                        BigDecimal potentialNewConnectedDSsBd = BigDecimal.valueOf(connectedDSs - 1);
                        BigDecimal sumOfConnectedDSsBd = BigDecimal.valueOf(sumOfConnectedDSs);
                        potentialCurrentRsNewLoadBd = potentialNewConnectedDSsBd.divide(sumOfConnectedDSsBd, mathContext);
                    }
                    BigDecimal potentialCurrentRsNewLoadDistanceBd = currentRsLoadGoalBd.subtract(potentialCurrentRsNewLoadBd, mathContext);
                    BigDecimal additionalDsLoadBd = BigDecimal.ONE.divide(BigDecimal.valueOf(sumOfConnectedDSs), mathContext);
                    BigDecimal potentialNewSumOfLoadDistancesOfOtherRSsBd = sumOfLoadDistancesOfOtherRSsBd.subtract(additionalDsLoadBd, mathContext);
                    MathContext roundMc = new MathContext(6, RoundingMode.DOWN);
                    BigDecimal potentialCurrentRsNewLoadDistanceBdRounded = potentialCurrentRsNewLoadDistanceBd.round(roundMc);
                    BigDecimal potentialNewSumOfLoadDistancesOfOtherRSsBdRounded = potentialNewSumOfLoadDistancesOfOtherRSsBd.round(roundMc);
                    if (potentialCurrentRsNewLoadDistanceBdRounded.compareTo(BigDecimal.ZERO) != 0 && potentialCurrentRsNewLoadDistanceBdRounded.equals(potentialNewSumOfLoadDistancesOfOtherRSsBdRounded.negate())) {
                        evals.setBestRS(currentRsServerId, ReplicationMessages.NOTE_AVOID_YOYO_EFFECT.get(localServerId, currentRsServerId));
                        return;
                    }
                }
                if (ReplicationBroker.isServerOverloadingRS(localServerId, currentRsInfo = (ReplicationServerInfo)bestServers.get(currentRsServerId), overloadingDSsNumber)) {
                    evals.discardAll(ReplicationMessages.NOTE_DISCONNECT_DS_FROM_OVERLOADED_RS.get(localServerId, currentRsServerId));
                } else {
                    evals.setBestRS(currentRsServerId, ReplicationMessages.NOTE_DO_NOT_DISCONNECT_DS_FROM_OVERLOADED_RS.get(localServerId, currentRsServerId));
                }
            } else {
                evals.setBestRS(currentRsServerId, ReplicationMessages.NOTE_NO_NEED_TO_REBALANCE_DSS_BETWEEN_RSS.get(localServerId, currentRsServerId));
            }
        } else {
            evals.setBestRS(currentRsServerId, ReplicationMessages.NOTE_DO_NOT_DISCONNECT_DS_FROM_ACCEPTABLE_LOAD_RS.get(localServerId, currentRsServerId));
        }
    }

    private static boolean isServerOverloadingRS(int localServerId, ReplicationServerInfo currentRsInfo, int overloadingDSsNumber) {
        ArrayList<Integer> serversConnectedToCurrentRS = new ArrayList<Integer>(currentRsInfo.getConnectedDSs());
        Collections.sort(serversConnectedToCurrentRS);
        int idx = serversConnectedToCurrentRS.indexOf(localServerId);
        return idx != -1 && idx < overloadingDSsNumber;
    }

    private void startRSHeartBeatMonitoring() {
        if (this.heartbeatInterval > 0L) {
            this.heartbeatMonitor = new HeartbeatMonitor(this.getServerId(), this.getRsServerId(), this.baseDn, this.session, this.heartbeatInterval);
            this.heartbeatMonitor.start();
        }
    }

    synchronized void stopRSHeartBeatMonitoring() {
        if (this.heartbeatMonitor != null) {
            this.heartbeatMonitor.shutdown();
            this.heartbeatMonitor = null;
        }
    }

    public void reStart(boolean infiniteTry) {
        this.reStart(this.session, infiniteTry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reStart(Session failingSession, boolean infiniteTry) {
        if (failingSession != null) {
            failingSession.close();
            ++this.numLostConnections;
        }
        if (failingSession == this.session) {
            this.connected = false;
            this.rsGroupId = (byte)-1;
            this.rsServerId = -1;
            this.rsServerUrl = null;
            this.setSession(null);
        }
        while (true) {
            Object object = this.startStopLock;
            synchronized (object) {
                if (this.connected || this.shutdown) {
                    break;
                }
                try {
                    this.connect();
                }
                catch (Exception e) {
                    MessageBuilder mb = new MessageBuilder();
                    mb.append(ReplicationMessages.NOTE_EXCEPTION_RESTARTING_SESSION.get(this.baseDn, e.getLocalizedMessage()));
                    mb.append(StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(mb.toMessage());
                }
                if (this.connected || !infiniteTry) {
                    break;
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (DebugLogger.debugEnabled()) {
            this.debugInfo("end restart : connected=" + this.connected + " with RS(" + this.getRsServerId() + ") genId=" + this.generationID);
        }
    }

    public void publish(ReplicationMsg msg) {
        this._publish(msg, false, true);
    }

    public boolean publish(ReplicationMsg msg, boolean retryOnFailure) {
        return this._publish(msg, false, retryOnFailure);
    }

    public void publishRecovery(ReplicationMsg msg) {
        this._publish(msg, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _publish(ReplicationMsg msg, boolean recoveryMsg, boolean retryOnFailure) {
        boolean done = false;
        while (!done && !this.shutdown) {
            if (this.connectionError) {
                if (DebugLogger.debugEnabled()) {
                    this.debugInfo("publish(): Publishing a message is not possible due to existing connection error.");
                }
                return false;
            }
            try {
                Semaphore currentWindowSemaphore;
                Session current_session;
                Object object = this.connectPhaseLock;
                synchronized (object) {
                    current_session = this.session;
                    currentWindowSemaphore = this.sendWindow;
                }
                if (!recoveryMsg & this.connectRequiresRecovery) {
                    return false;
                }
                boolean credit = msg instanceof UpdateMsg ? currentWindowSemaphore.tryAcquire(500L, TimeUnit.MILLISECONDS) : true;
                if (credit) {
                    object = this.connectPhaseLock;
                    synchronized (object) {
                        if (this.session != null && this.session == current_session) {
                            this.session.publish(msg);
                            done = true;
                        }
                    }
                }
                if (credit || currentWindowSemaphore.availablePermits() != 0) continue;
                object = this.connectPhaseLock;
                synchronized (object) {
                    if (this.session != null) {
                        this.session.publish(new WindowProbeMsg());
                    }
                }
            }
            catch (IOException e) {
                if (!retryOnFailure) {
                    return false;
                }
                Object object = this.connectPhaseLock;
                synchronized (object) {
                    block25: {
                        try {
                            this.connectPhaseLock.wait(100L);
                        }
                        catch (InterruptedException e1) {
                            if (!DebugLogger.debugEnabled()) break block25;
                            this.debugInfo("publish(): Interrupted exception raised : " + e.getLocalizedMessage());
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                if (!DebugLogger.debugEnabled()) continue;
                this.debugInfo("publish(): Interrupted exception raised." + e.getLocalizedMessage());
            }
        }
        return true;
    }

    public ReplicationMsg receive() throws SocketTimeoutException {
        return this.receive(false, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationMsg receive(boolean reconnectToTheBestRS, boolean reconnectOnFailure, boolean returnOnTopoChange) throws SocketTimeoutException {
        while (!this.shutdown) {
            Session savedSession;
            if (reconnectOnFailure && !this.connected) {
                this.reStart(null, true);
            }
            if ((savedSession = this.session) == null) break;
            int replicationServerID = this.rsServerId;
            try {
                ReplicationMsg msg = savedSession.receive();
                if (msg instanceof UpdateMsg) {
                    ReplicationBroker replicationBroker = this;
                    synchronized (replicationBroker) {
                        --this.rcvWindow;
                    }
                }
                if (msg instanceof WindowMsg) {
                    WindowMsg windowMsg = (WindowMsg)msg;
                    this.sendWindow.release(windowMsg.getNumAck());
                    continue;
                }
                if (msg instanceof TopologyMsg) {
                    TopologyMsg topoMsg = (TopologyMsg)msg;
                    this.receiveTopo(topoMsg);
                    if (reconnectToTheBestRS) {
                        this.mustRunBestServerCheckingAlgorithm = 0;
                    }
                    if (!returnOnTopoChange) continue;
                    return msg;
                }
                if (msg instanceof StopMsg) {
                    Message message = ReplicationMessages.WARN_REPLICATION_SERVER_PROPERLY_DISCONNECTED.get(replicationServerID, savedSession.getReadableRemoteAddress(), this.serverId, this.baseDn);
                    ErrorLogger.logError(message);
                    this.reStart(savedSession, true);
                    continue;
                }
                if (msg instanceof MonitorMsg) {
                    MonitorMsg monitorMsg = (MonitorMsg)msg;
                    this.replicaStates = new HashMap();
                    for (int srvId : StaticUtils.toIterable(monitorMsg.ldapIterator())) {
                        this.replicaStates.put(srvId, monitorMsg.getLDAPServerState(srvId));
                    }
                    Iterator<Integer> i$ = this.monitorResponse;
                    synchronized (i$) {
                        this.monitorResponse.set(true);
                        this.monitorResponse.notify();
                    }
                    for (int srvId : StaticUtils.toIterable(monitorMsg.rsIterator())) {
                        ReplicationServerInfo rsInfo = this.replicationServerInfos.get(srvId);
                        if (rsInfo == null) continue;
                        rsInfo.update(monitorMsg.getRSServerState(srvId));
                    }
                    if (!reconnectToTheBestRS) continue;
                    ++this.mustRunBestServerCheckingAlgorithm;
                    if (this.mustRunBestServerCheckingAlgorithm != 2) continue;
                    RSEvaluations evals = ReplicationBroker.computeBestReplicationServer(false, this.rsServerId, this.state, this.replicationServerInfos, this.serverId, this.groupId, this.generationID);
                    ReplicationServerInfo bestServerInfo = evals.getBestRS();
                    if (this.rsServerId != -1 && (bestServerInfo == null || bestServerInfo.getServerId() != this.rsServerId.intValue())) {
                        Message message;
                        if (bestServerInfo == null) {
                            message = ReplicationMessages.NOTE_LOAD_BALANCE_REPLICATION_SERVER.get(this.serverId, replicationServerID, savedSession.getReadableRemoteAddress(), this.baseDn);
                        } else {
                            int bestRsServerId = bestServerInfo.getServerId();
                            message = ReplicationMessages.NOTE_NEW_BEST_REPLICATION_SERVER.get(this.serverId, replicationServerID, savedSession.getReadableRemoteAddress(), bestRsServerId, this.baseDn, evals.getEvaluation(replicationServerID).toString(), evals.getEvaluation(bestRsServerId).toString());
                        }
                        ErrorLogger.logError(message);
                        if (DebugLogger.debugEnabled()) {
                            this.debugInfo("best replication servers evaluation results: " + evals);
                        }
                        this.reStart(true);
                    }
                    this.mustRunBestServerCheckingAlgorithm = 0;
                    continue;
                }
                return msg;
            }
            catch (SocketTimeoutException e) {
                throw e;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                if (this.shutdown) continue;
                Session tmpSession = this.session;
                if (tmpSession == null || !tmpSession.closeInitiated()) {
                    Message message = ReplicationMessages.WARN_REPLICATION_SERVER_BADLY_DISCONNECTED.get(this.serverId, this.baseDn, replicationServerID, savedSession.getReadableRemoteAddress());
                    ErrorLogger.logError(message);
                }
                if (!reconnectOnFailure) break;
                this.reStart(savedSession, true);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, ServerState> getReplicaStates() {
        this.monitorResponse.set(false);
        this.publish(new MonitorRequestMsg(this.serverId, this.getRsServerId()));
        try {
            MutableBoolean mutableBoolean = this.monitorResponse;
            synchronized (mutableBoolean) {
                if (!this.monitorResponse.get()) {
                    this.monitorResponse.wait(10000L);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this.replicaStates;
    }

    public synchronized void updateWindowAfterReplay() {
        try {
            ++this.updateDoneCount;
            if (this.updateDoneCount >= this.halfRcvWindow && this.session != null) {
                this.session.publish(new WindowMsg(this.updateDoneCount));
                this.rcvWindow += this.updateDoneCount;
                this.updateDoneCount = 0;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (DebugLogger.debugEnabled()) {
            this.debugInfo("is stopping and will close the connection to replication server " + this.rsServerId);
        }
        Object object = this.startStopLock;
        synchronized (object) {
            this.shutdown = true;
            this.connected = false;
            this.stopRSHeartBeatMonitoring();
            this.stopChangeTimeHeartBeatPublishing();
            this.replicationServer = "stopped";
            this.rsGroupId = (byte)-1;
            this.rsServerId = -1;
            this.rsServerUrl = null;
            this.setSession(null);
            this.deregisterReplicationMonitor();
        }
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.timeout = timeout;
        if (this.session != null) {
            this.session.setSoTimeout(timeout);
        }
    }

    public String getReplicationServer() {
        return this.replicationServer;
    }

    public int getMaxRcvWindow() {
        return this.maxRcvWindow;
    }

    public int getCurrentRcvWindow() {
        return this.rcvWindow;
    }

    public int getMaxSendWindow() {
        return this.maxSendWindow;
    }

    public int getCurrentSendWindow() {
        if (this.connected) {
            return this.sendWindow.availablePermits();
        }
        return 0;
    }

    public int getNumLostConnections() {
        return this.numLostConnections;
    }

    public boolean changeConfig(Collection<String> replicationServers, int window, long heartbeatInterval, byte groupId) {
        Boolean needToRestartSession = false;
        if (this.replicationServerUrls == null || replicationServers.size() != this.replicationServerUrls.size() || !replicationServers.containsAll(this.replicationServerUrls) || window != this.maxRcvWindow || heartbeatInterval != this.heartbeatInterval || groupId != this.groupId) {
            needToRestartSession = true;
        }
        this.replicationServerUrls = replicationServers;
        this.rcvWindow = window;
        this.maxRcvWindow = window;
        this.halfRcvWindow = window / 2;
        this.heartbeatInterval = heartbeatInterval;
        this.groupId = groupId;
        return needToRestartSession;
    }

    public short getProtocolVersion() {
        return this.protocolVersion;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isSessionEncrypted() {
        Session tmp = this.session;
        return tmp != null ? tmp.isEncrypted() : false;
    }

    public void signalStatusChange(ServerStatus newStatus) {
        try {
            ChangeStatusMsg csMsg = new ChangeStatusMsg(ServerStatus.INVALID_STATUS, newStatus);
            this.session.publish(csMsg);
        }
        catch (IOException ex) {
            Message message = ReplicationMessages.ERR_EXCEPTION_SENDING_CS.get(this.baseDn, Integer.toString(this.serverId), ex.getLocalizedMessage() + StaticUtils.stackTraceToSingleLineString(ex));
            ErrorLogger.logError(message);
        }
    }

    public void setGroupId(byte groupId) {
        this.groupId = groupId;
    }

    public List<DSInfo> getDsList() {
        return this.dsList;
    }

    public List<RSInfo> getRsList() {
        ArrayList<RSInfo> result = new ArrayList<RSInfo>();
        for (ReplicationServerInfo rsInfo : this.replicationServerInfos.values()) {
            result.add(rsInfo.toRSInfo());
        }
        return result;
    }

    private List<Integer> computeConnectedDSs(int rsId, List<DSInfo> dsList) {
        ArrayList<Integer> connectedDSs = new ArrayList<Integer>();
        if (this.rsServerId == rsId) {
            connectedDSs.add(this.serverId);
        }
        for (DSInfo dsInfo : dsList) {
            if (dsInfo.getRsId() != rsId) continue;
            connectedDSs.add(dsInfo.getDsId());
        }
        return connectedDSs;
    }

    public void receiveTopo(TopologyMsg topoMsg) {
        if (DebugLogger.debugEnabled()) {
            this.debugInfo("receive TopologyMsg=" + topoMsg);
        }
        this.dsList = topoMsg.getDsList();
        ArrayList<Integer> rsToKeepList = new ArrayList<Integer>();
        for (RSInfo rsInfo : topoMsg.getRsList()) {
            int rsId = rsInfo.getId();
            rsToKeepList.add(rsId);
            List<Integer> connectedDSs = this.computeConnectedDSs(rsId, this.dsList);
            ReplicationServerInfo replicationServerInfo = this.replicationServerInfos.get(rsId);
            if (replicationServerInfo == null) {
                replicationServerInfo = new ReplicationServerInfo(rsInfo, connectedDSs);
                this.updateRSInfoLocallyConfiguredStatus(replicationServerInfo);
                this.replicationServerInfos.put(rsId, replicationServerInfo);
                continue;
            }
            replicationServerInfo.update(rsInfo, connectedDSs);
        }
        Iterator<Map.Entry<Integer, ReplicationServerInfo>> rsInfoIt = this.replicationServerInfos.entrySet().iterator();
        while (rsInfoIt.hasNext()) {
            Map.Entry<Integer, ReplicationServerInfo> rsInfoEntry = rsInfoIt.next();
            if (rsToKeepList.contains(rsInfoEntry.getKey())) continue;
            rsInfoIt.remove();
        }
        if (this.domain != null) {
            for (DSInfo info : this.dsList) {
                this.domain.setEclIncludes(info.getDsId(), info.getEclIncludes(), info.getEclIncludesForDeletes());
            }
        }
    }

    public boolean hasConnectionError() {
        return this.connectionError;
    }

    public void startChangeTimeHeartBeatPublishing() {
        if (this.changeTimeHeartbeatSendInterval > 0L) {
            String threadName = "Replica DS(" + this.getServerId() + ") change time heartbeat publisher for domain \"" + this.baseDn + "\" to RS(" + this.getRsServerId() + ") at " + this.session.getReadableRemoteAddress();
            this.ctHeartbeatPublisherThread = new CTHeartbeatPublisherThread(threadName, this.session, this.changeTimeHeartbeatSendInterval, this.serverId);
            this.ctHeartbeatPublisherThread.start();
        } else if (DebugLogger.debugEnabled()) {
            this.debugInfo("is not configured to send CN heartbeat interval");
        }
    }

    public synchronized void stopChangeTimeHeartBeatPublishing() {
        if (this.ctHeartbeatPublisherThread != null) {
            this.ctHeartbeatPublisherThread.shutdown();
            this.ctHeartbeatPublisherThread = null;
        }
    }

    public void setChangeTimeHeartbeatInterval(int changeTimeHeartbeatInterval) {
        this.stopChangeTimeHeartBeatPublishing();
        this.changeTimeHeartbeatSendInterval = changeTimeHeartbeatInterval;
        this.startChangeTimeHeartBeatPublishing();
    }

    public void setRecoveryRequired(boolean b) {
        this.connectRequiresRecovery = b;
    }

    public boolean shuttingDown() {
        return this.shutdown;
    }

    String getLocalUrl() {
        Session tmp = this.session;
        return tmp != null ? tmp.getLocalUrl() : "";
    }

    ReplicationMonitor getReplicationMonitor() {
        return this.monitor;
    }

    private void setSession(Session newSession) {
        this.deregisterReplicationMonitor();
        Session oldSession = this.session;
        if (oldSession != null) {
            oldSession.close();
        }
        this.session = newSession;
        this.registerReplicationMonitor();
    }

    private void registerReplicationMonitor() {
        if (this.monitor != null) {
            DirectoryServer.registerMonitorProvider(this.monitor);
        }
    }

    private void deregisterReplicationMonitor() {
        if (this.monitor != null) {
            DirectoryServer.deregisterMonitorProvider(this.monitor);
        }
    }

    private void debugInfo(String message) {
        TRACER.debugInfo(this.getClass().getSimpleName() + " for baseDN=" + this.baseDn + " and serverId=" + this.getServerId() + " " + message);
    }

    private static class LocalEvaluation {
        private final Map<Integer, ReplicationServerInfo> accepted = new HashMap<Integer, ReplicationServerInfo>();
        private final Map<ReplicationServerInfo, Message> rsEvals = new HashMap<ReplicationServerInfo, Message>();

        private LocalEvaluation() {
        }

        private void accept(Integer rsId, ReplicationServerInfo rsInfo) {
            this.rsEvals.remove(rsInfo);
            this.accepted.put(rsId, rsInfo);
        }

        private void reject(ReplicationServerInfo rsInfo, Message reason) {
            this.accepted.remove(rsInfo.getServerId());
            this.rsEvals.put(rsInfo, reason);
        }

        private Map<Integer, ReplicationServerInfo> getAccepted() {
            return this.accepted;
        }

        private ReplicationServerInfo[] getAcceptedRSInfos() {
            return this.accepted.values().toArray(new ReplicationServerInfo[this.accepted.size()]);
        }

        public Map<Integer, Message> getRejected() {
            HashMap<Integer, Message> result = new HashMap<Integer, Message>();
            for (Map.Entry<ReplicationServerInfo, Message> entry : this.rsEvals.entrySet()) {
                result.put(entry.getKey().getServerId(), entry.getValue());
            }
            return result;
        }

        private boolean hasAcceptedAny() {
            return !this.accepted.isEmpty();
        }
    }

    static class RSEvaluations {
        private final int localServerId;
        private Map<Integer, ReplicationServerInfo> bestRSs;
        private final Map<Integer, Message> rsEvals = new HashMap<Integer, Message>();

        RSEvaluations(int localServerId, Map<Integer, ReplicationServerInfo> rsInfos) {
            this.localServerId = localServerId;
            this.bestRSs = rsInfos;
        }

        private boolean keepBest(LocalEvaluation eval) {
            if (eval.hasAcceptedAny()) {
                this.bestRSs = eval.getAccepted();
                this.rsEvals.putAll(eval.getRejected());
                return true;
            }
            return false;
        }

        private void setBestRS(int bestRsId, Message rejectedRSsEval) {
            Iterator<Map.Entry<Integer, ReplicationServerInfo>> it = this.bestRSs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, ReplicationServerInfo> entry = it.next();
                Integer rsId = entry.getKey();
                ReplicationServerInfo rsInfo = entry.getValue();
                if (rsInfo.getServerId() != bestRsId) {
                    it.remove();
                }
                this.rsEvals.put(rsId, rejectedRSsEval);
            }
        }

        private void discardAll(Message eval) {
            for (Integer rsId : this.bestRSs.keySet()) {
                this.rsEvals.put(rsId, eval);
            }
        }

        private boolean foundBestRS() {
            return this.bestRSs.size() == 1;
        }

        ReplicationServerInfo getBestRS() {
            if (this.foundBestRS()) {
                return this.bestRSs.values().iterator().next();
            }
            return null;
        }

        Map<Integer, Message> getEvaluations() {
            Integer bestRSServerId;
            if (this.foundBestRS() && this.rsEvals.get(bestRSServerId = Integer.valueOf(this.getBestRS().getServerId())) == null) {
                Message eval = ReplicationMessages.NOTE_BEST_RS.get(bestRSServerId, this.localServerId);
                this.rsEvals.put(bestRSServerId, eval);
            }
            return Collections.unmodifiableMap(this.rsEvals);
        }

        private Message getEvaluation(int rsServerId) {
            Message evaluation = this.getEvaluations().get(rsServerId);
            if (evaluation != null) {
                return evaluation;
            }
            return ReplicationMessages.NOTE_UNKNOWN_RS.get(rsServerId, this.localServerId);
        }

        public String toString() {
            return "Current best replication server Ids: " + this.bestRSs.keySet() + ", Evaluation of connected replication servers" + " (ServerId => Evaluation): " + this.rsEvals.keySet() + ", Any replication server not appearing here" + " could not be contacted.";
        }
    }

    public static class ReplicationServerInfo {
        private short protocolVersion;
        private long generationId;
        private byte groupId = (byte)-1;
        private int serverId;
        private String serverURL;
        private String baseDn = null;
        private int windowSize;
        private ServerState serverState = null;
        private boolean sslEncryption;
        private int degradedStatusThreshold = -1;
        private int weight = 1;
        private int connectedDSNumber = 0;
        private List<Integer> connectedDSs = null;
        private boolean locallyConfigured = true;

        public static ReplicationServerInfo newInstance(ReplicationMsg msg, String server) throws IllegalArgumentException {
            ReplicationServerInfo rsInfo = ReplicationServerInfo.newInstance(msg);
            rsInfo.serverURL = server;
            return rsInfo;
        }

        public static ReplicationServerInfo newInstance(ReplicationMsg msg) throws IllegalArgumentException {
            if (msg instanceof ReplServerStartMsg) {
                ReplServerStartMsg replServerStartMsg = (ReplServerStartMsg)msg;
                return new ReplicationServerInfo(replServerStartMsg);
            }
            if (msg instanceof ReplServerStartDSMsg) {
                ReplServerStartDSMsg replServerStartDSMsg = (ReplServerStartDSMsg)msg;
                return new ReplicationServerInfo(replServerStartDSMsg);
            }
            throw new IllegalArgumentException("Unexpected PDU type: " + msg.getClass().getName() + " :\n" + msg.toString());
        }

        private ReplicationServerInfo(ReplServerStartMsg replServerStartMsg) {
            this.protocolVersion = replServerStartMsg.getVersion();
            this.generationId = replServerStartMsg.getGenerationId();
            this.groupId = replServerStartMsg.getGroupId();
            this.serverId = replServerStartMsg.getServerId();
            this.serverURL = replServerStartMsg.getServerURL();
            this.baseDn = replServerStartMsg.getBaseDn();
            this.windowSize = replServerStartMsg.getWindowSize();
            this.serverState = replServerStartMsg.getServerState();
            this.sslEncryption = replServerStartMsg.getSSLEncryption();
            this.degradedStatusThreshold = replServerStartMsg.getDegradedStatusThreshold();
        }

        private ReplicationServerInfo(ReplServerStartDSMsg replServerStartDSMsg) {
            this.protocolVersion = replServerStartDSMsg.getVersion();
            this.generationId = replServerStartDSMsg.getGenerationId();
            this.groupId = replServerStartDSMsg.getGroupId();
            this.serverId = replServerStartDSMsg.getServerId();
            this.serverURL = replServerStartDSMsg.getServerURL();
            this.baseDn = replServerStartDSMsg.getBaseDn();
            this.windowSize = replServerStartDSMsg.getWindowSize();
            this.serverState = replServerStartDSMsg.getServerState();
            this.sslEncryption = replServerStartDSMsg.getSSLEncryption();
            this.degradedStatusThreshold = replServerStartDSMsg.getDegradedStatusThreshold();
            this.weight = replServerStartDSMsg.getWeight();
            this.connectedDSNumber = replServerStartDSMsg.getConnectedDSNumber();
        }

        public ServerState getServerState() {
            return this.serverState;
        }

        public byte getGroupId() {
            return this.groupId;
        }

        public short getProtocolVersion() {
            return this.protocolVersion;
        }

        public long getGenerationId() {
            return this.generationId;
        }

        public int getServerId() {
            return this.serverId;
        }

        public String getServerURL() {
            return this.serverURL;
        }

        public String getBaseDn() {
            return this.baseDn;
        }

        public int getWindowSize() {
            return this.windowSize;
        }

        public boolean isSslEncryption() {
            return this.sslEncryption;
        }

        public int getDegradedStatusThreshold() {
            return this.degradedStatusThreshold;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getConnectedDSNumber() {
            return this.connectedDSNumber;
        }

        public ReplicationServerInfo(RSInfo rsInfo, List<Integer> connectedDSs) {
            this.serverId = rsInfo.getId();
            this.serverURL = rsInfo.getServerUrl();
            this.generationId = rsInfo.getGenerationId();
            this.groupId = rsInfo.getGroupId();
            this.weight = rsInfo.getWeight();
            this.connectedDSs = connectedDSs;
            this.connectedDSNumber = connectedDSs.size();
            this.serverState = new ServerState();
        }

        public RSInfo toRSInfo() {
            return new RSInfo(this.serverId, this.serverURL, this.generationId, this.groupId, this.weight);
        }

        public void update(RSInfo rsInfo, List<Integer> connectedDSs) {
            this.generationId = rsInfo.getGenerationId();
            this.groupId = rsInfo.getGroupId();
            this.weight = rsInfo.getWeight();
            this.connectedDSs = connectedDSs;
            this.connectedDSNumber = connectedDSs.size();
        }

        public void update(ServerState serverState) {
            if (this.serverState != null) {
                this.serverState.update(serverState);
            } else {
                this.serverState = serverState;
            }
        }

        public List<Integer> getConnectedDSs() {
            return this.connectedDSs;
        }

        public boolean isLocallyConfigured() {
            return this.locallyConfigured;
        }

        public void setLocallyConfigured(boolean locallyConfigured) {
            this.locallyConfigured = locallyConfigured;
        }

        public String toString() {
            return "Url:" + this.serverURL + " ServerId:" + this.serverId + " GroupId:" + this.groupId;
        }
    }
}

