/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;

class AuthPasswordExactEqualityMatchingRule
extends EqualityMatchingRule {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "authPasswordExactMatch";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.4203.1.2.2";
    }

    @Override
    public String getDescription() {
        return "authentication password exact matching rule";
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.4203.1.1.2";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        try {
            StringBuilder[] authPWComponents = AuthPasswordSyntax.decodeAuthPassword(((Object)value).toString());
            StringBuilder normalizedValue = new StringBuilder(2 + authPWComponents[0].length() + authPWComponents[1].length() + authPWComponents[2].length());
            normalizedValue.append((CharSequence)authPWComponents[0]);
            normalizedValue.append('$');
            normalizedValue.append((CharSequence)authPWComponents[1]);
            normalizedValue.append('$');
            normalizedValue.append((CharSequence)authPWComponents[2]);
            return ByteString.valueOf(normalizedValue.toString());
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw de;
                }
                case WARN: {
                    ErrorLogger.logError(de.getMessageObject());
                    return ByteString.valueOf(((Object)value).toString());
                }
            }
            return ByteString.valueOf(((Object)value).toString());
        }
    }
}

