/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.messages.Message;
import org.opends.messages.SchemaMessages;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AcceptRejectWarn;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

class DistinguishedNameEqualityMatchingRule
extends EqualityMatchingRule {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "distinguishedNameMatch";
    }

    @Override
    public String getOID() {
        return "2.5.13.1";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.12";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        DN dn;
        try {
            dn = DN.decode(((Object)value).toString());
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            if (DirectoryServer.getSyntaxEnforcementPolicy() == AcceptRejectWarn.REJECT) {
                throw de;
            }
            return this.bestEffortNormalize(StaticUtils.toLowerCase(((Object)value).toString()));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            if (DirectoryServer.getSyntaxEnforcementPolicy() == AcceptRejectWarn.REJECT) {
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DN_INVALID.get(((Object)value).toString(), String.valueOf(e));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            return this.bestEffortNormalize(StaticUtils.toLowerCase(((Object)value).toString()));
        }
        return ByteString.valueOf(dn.toNormalizedString());
    }

    private ByteString bestEffortNormalize(String lowerString) {
        int length = lowerString.length();
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = lowerString.charAt(i);
            if (c == ' ') {
                if (i == 0) continue;
                char previous = lowerString.charAt(i - 1);
                if (previous == '\\') {
                    buffer.append(' ');
                    continue;
                }
                if (previous == ',') continue;
                if (i == length - 1) break;
                char next = lowerString.charAt(i + 1);
                if (next == ' ' || next == ',') continue;
                buffer.append(' ');
                continue;
            }
            buffer.append(c);
        }
        return ByteString.valueOf(buffer.toString());
    }
}

