/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.HashSet;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.schema.PrintableString;
import org.opends.server.types.ByteSequence;

public class TeletexTerminalIdentifierSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    public static final HashSet<String> ALLOWED_TTX_PARAMETERS = new HashSet(5);
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.2", "TeletexTerminalIdentifier"));
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.3", "TeletexTerminalIdentifier"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.4", "TeletexTerminalIdentifier"));
        }
    }

    @Override
    public String getSyntaxName() {
        return "TeletexTerminalIdentifier";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.51";
    }

    @Override
    public String getDescription() {
        return "Teletex Terminal Identifier";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
        String paramName;
        int colonPos;
        String paramStr;
        int pos;
        String valueString = ((Object)value).toString();
        int valueLength = valueString.length();
        if (valueLength == 0) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_TELETEXID_EMPTY.get());
            return false;
        }
        char c = valueString.charAt(0);
        if (!PrintableString.isPrintableCharacter(c)) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_TELETEXID_NOT_PRINTABLE.get(valueString, String.valueOf(c), 0));
            return false;
        }
        for (pos = 1; pos < valueLength; ++pos) {
            c = valueString.charAt(pos);
            if (c == '$') {
                ++pos;
                break;
            }
            if (PrintableString.isPrintableCharacter(c)) continue;
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_TELETEXID_NOT_PRINTABLE.get(valueString, String.valueOf(c), pos));
        }
        if (pos >= valueLength) {
            if (c == '$') {
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_TELETEXID_END_WITH_DOLLAR.get(valueString));
                return false;
            }
            return true;
        }
        int paramStartPos = pos;
        boolean escaped = false;
        while (pos < valueLength) {
            if (escaped) {
                ++pos;
                continue;
            }
            if ((c = valueString.charAt(pos++)) == '\\') {
                escaped = true;
                continue;
            }
            if (c != '$') continue;
            paramStr = valueString.substring(paramStartPos, pos);
            colonPos = paramStr.indexOf(58);
            if (colonPos < 0) {
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_TELETEXID_PARAM_NO_COLON.get(valueString));
                return false;
            }
            paramName = paramStr.substring(0, colonPos);
            if (!ALLOWED_TTX_PARAMETERS.contains(paramName)) {
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_TELETEXID_ILLEGAL_PARAMETER.get(valueString, paramName));
                return false;
            }
            paramStartPos = pos;
        }
        paramStr = valueString.substring(paramStartPos);
        colonPos = paramStr.indexOf(58);
        if (colonPos < 0) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_TELETEXID_PARAM_NO_COLON.get(valueString));
            return false;
        }
        paramName = paramStr.substring(0, colonPos);
        if (!ALLOWED_TTX_PARAMETERS.contains(paramName)) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_TELETEXID_ILLEGAL_PARAMETER.get(valueString, paramName));
            return false;
        }
        return true;
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    static {
        ALLOWED_TTX_PARAMETERS.add("graphic");
        ALLOWED_TTX_PARAMETERS.add("control");
        ALLOWED_TTX_PARAMETERS.add("misc");
        ALLOWED_TTX_PARAMETERS.add("page");
        ALLOWED_TTX_PARAMETERS.add("private");
    }
}

