/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.schema.StringPrepProfile;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.ServerConstants;

class WordEqualityMatchingRule
extends EqualityMatchingRule {
    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "wordMatch";
    }

    @Override
    public String getOID() {
        return "2.5.13.32";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.15";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        StringPrepProfile.prepareUnicode(buffer, value, true, true);
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (value.length() > 0) {
                return ServerConstants.SINGLE_SPACE_VALUE;
            }
            return ByteString.empty();
        }
        for (int pos = bufferLength - 1; pos > 0; --pos) {
            if (buffer.charAt(pos) != ' ' || buffer.charAt(pos - 1) != ' ') continue;
            buffer.delete(pos, pos + 1);
        }
        return ByteString.valueOf(buffer.toString());
    }

    @Override
    public boolean areEqual(ByteSequence value1, ByteSequence value2) {
        char c;
        String valueStr2;
        String valueStr1 = ((Object)value1).toString();
        int pos = valueStr1.indexOf(valueStr2 = ((Object)value2).toString());
        if (pos < 0) {
            return false;
        }
        if (pos > 0) {
            c = valueStr1.charAt(pos - 1);
            switch (c) {
                case ' ': 
                case '#': 
                case '$': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '=': 
                case '_': {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (valueStr1.length() > pos + valueStr2.length()) {
            c = valueStr1.charAt(pos + valueStr2.length());
            switch (c) {
                case ' ': 
                case '#': 
                case '$': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '=': 
                case '_': {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int generateHashCode(ByteSequence attributeValue) {
        return 1;
    }
}

