/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.util.Utils;
import org.opends.server.core.DirectoryServer;
import org.opends.server.tools.StartWindowsService;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.DynamicConstants;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class ConfigureWindowsService {
    private static final String CLASS_NAME = "org.opends.server.tools.ConfigureWindowsService";
    private static final String DEBUG_OPTION = "--debug";
    public static final String LAUNCHER_OPTION = "run";
    private static int ERROR = 1;
    public static final int SERVICE_ENABLE_SUCCESS = 0;
    public static final int SERVICE_ALREADY_ENABLED = 1;
    public static final int SERVICE_NAME_ALREADY_IN_USE = 2;
    public static final int SERVICE_ENABLE_ERROR = 3;
    public static final int SERVICE_DISABLE_SUCCESS = 0;
    public static final int SERVICE_ALREADY_DISABLED = 1;
    public static final int SERVICE_MARKED_FOR_DELETION = 2;
    public static final int SERVICE_DISABLE_ERROR = 3;
    public static final int SERVICE_STATE_ENABLED = 0;
    public static final int SERVICE_STATE_DISABLED = 1;
    public static final int SERVICE_STATE_ERROR = 2;
    public static final int SERVICE_CLEANUP_SUCCESS = 0;
    public static final int SERVICE_NOT_FOUND = 1;
    public static final int SERVICE_CLEANUP_ERROR = 2;
    public static final int SERVICE_CLEANUP_MARKED_FOR_DELETION = 3;

    public static void main(String[] args) {
        int result = ConfigureWindowsService.configureWindowsService(args, System.out, System.err);
        System.exit(StaticUtils.filterExitCode(result));
    }

    public static int configureWindowsService(String[] args, OutputStream outStream, OutputStream errStream) {
        Message message;
        int returnValue = 0;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        Message toolDescription = ToolMessages.INFO_CONFIGURE_WINDOWS_SERVICE_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
        BooleanArgument enableService = null;
        BooleanArgument disableService = null;
        Argument serviceState = null;
        Argument cleanupService = null;
        BooleanArgument showUsage = null;
        try {
            enableService = new BooleanArgument("enableservice", Character.valueOf('e'), "enableService", ToolMessages.INFO_CONFIGURE_WINDOWS_SERVICE_DESCRIPTION_ENABLE.get());
            argParser.addArgument(enableService);
            disableService = new BooleanArgument("disableservice", Character.valueOf('d'), "disableService", ToolMessages.INFO_CONFIGURE_WINDOWS_SERVICE_DESCRIPTION_DISABLE.get());
            argParser.addArgument(disableService);
            serviceState = new BooleanArgument("servicestate", Character.valueOf('s'), "serviceState", ToolMessages.INFO_CONFIGURE_WINDOWS_SERVICE_DESCRIPTION_STATE.get());
            argParser.addArgument(serviceState);
            cleanupService = new StringArgument("cleanupservice", Character.valueOf('c'), "cleanupService", false, false, true, ToolMessages.INFO_SERVICE_NAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_CONFIGURE_WINDOWS_SERVICE_DESCRIPTION_CLEANUP.get());
            argParser.addArgument(cleanupService);
            showUsage = new BooleanArgument("showusage", Character.valueOf('H'), "help", ToolMessages.INFO_CONFIGURE_WINDOWS_SERVICE_DESCRIPTION_SHOWUSAGE.get());
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage, out);
        }
        catch (ArgumentException ae) {
            message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            returnValue = ERROR;
        }
        if (returnValue == 0) {
            try {
                argParser.parseArguments(args);
            }
            catch (ArgumentException ae) {
                message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                returnValue = ERROR;
            }
        }
        if (returnValue == 0 && !argParser.usageOrVersionDisplayed()) {
            int nArgs = 0;
            if (enableService.isPresent()) {
                ++nArgs;
            }
            if (disableService.isPresent()) {
                ++nArgs;
            }
            if (serviceState.isPresent()) {
                ++nArgs;
            }
            if (cleanupService.isPresent()) {
                ++nArgs;
            }
            if (nArgs > 1) {
                message = ToolMessages.ERR_CONFIGURE_WINDOWS_SERVICE_TOO_MANY_ARGS.get();
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                returnValue = ERROR;
            }
            if (nArgs == 0) {
                message = ToolMessages.ERR_CONFIGURE_WINDOWS_SERVICE_TOO_FEW_ARGS.get();
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                returnValue = ERROR;
            }
        }
        if (returnValue == 0 && !argParser.usageOrVersionDisplayed()) {
            returnValue = enableService.isPresent() ? ConfigureWindowsService.enableService(out, err) : (disableService.isPresent() ? ConfigureWindowsService.disableService(out, err) : (serviceState.isPresent() ? ConfigureWindowsService.serviceState(out, err) : ConfigureWindowsService.cleanupService(cleanupService.getValue(), out, err)));
        }
        return returnValue;
    }

    static String getServiceName() {
        String serviceName = null;
        String serverRoot = ConfigureWindowsService.getServerRoot();
        String[] cmd = new String[]{ConfigureWindowsService.getBinaryFullPath(), "state", serverRoot};
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader stdout = new BufferedReader(new InputStreamReader(p.getInputStream()));
            boolean processDone = false;
            while (!processDone) {
                String s;
                try {
                    p.exitValue();
                    processDone = true;
                }
                catch (Throwable t) {
                    // empty catch block
                }
                while ((s = stdout.readLine()) != null) {
                    serviceName = s;
                    if (serviceName.trim().length() != 0) continue;
                    serviceName = null;
                }
            }
        }
        catch (Throwable t) {
            serviceName = null;
        }
        return serviceName;
    }

    public static int enableService(PrintStream out, PrintStream err) {
        Message serviceName = Utils.getCustomizedObject("INFO_WINDOWS_SERVICE_NAME", ToolMessages.INFO_WINDOWS_SERVICE_NAME.get(DynamicConstants.PRODUCT_NAME), Message.class);
        Message serviceDescription = Utils.getCustomizedObject("INFO_WINDOWS_SERVICE_DESCRIPTION", ToolMessages.INFO_WINDOWS_SERVICE_DESCRIPTION.get(ConfigureWindowsService.getServerRoot()), Message.class);
        return ConfigureWindowsService.enableService(out, err, serviceName.toString(), serviceDescription.toString());
    }

    public static int enableService(PrintStream out, PrintStream err, String serviceName, String serviceDescription) {
        int returnValue;
        String serverRoot = ConfigureWindowsService.getServerRoot();
        String[] cmd = SetupUtils.hasUAC() ? new String[]{ConfigureWindowsService.getLauncherBinaryFullPath(), LAUNCHER_OPTION, ConfigureWindowsService.getLauncherAdministratorBinaryFullPath(), LAUNCHER_OPTION, ConfigureWindowsService.getBinaryFullPath(), "create", serverRoot, serviceName, serviceDescription, DEBUG_OPTION} : new String[]{ConfigureWindowsService.getBinaryFullPath(), "create", serverRoot, serviceName, serviceDescription, DEBUG_OPTION};
        try {
            boolean isServerRunning = Utilities.isServerRunning(new File(serverRoot));
            int resultCode = Runtime.getRuntime().exec(cmd).waitFor();
            switch (resultCode) {
                case 0: {
                    if (isServerRunning) {
                        returnValue = StartWindowsService.startWindowsService(out, err);
                        if (returnValue == 0) {
                            returnValue = 0;
                            Message msg = ToolMessages.INFO_WINDOWS_SERVICE_SUCCESSULLY_ENABLED.get();
                            out.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
                            break;
                        }
                        Message msg = ToolMessages.ERR_WINDOWS_SERVICE_ENABLING_ERROR_STARTING_SERVER.get(returnValue);
                        returnValue = 3;
                        err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
                        break;
                    }
                    returnValue = 0;
                    Message msg = ToolMessages.INFO_WINDOWS_SERVICE_SUCCESSULLY_ENABLED.get();
                    out.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
                    break;
                }
                case 1: {
                    returnValue = 1;
                    Message msg = ToolMessages.INFO_WINDOWS_SERVICE_ALREADY_ENABLED.get();
                    out.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
                    break;
                }
                case 2: {
                    returnValue = 2;
                    Message msg = ToolMessages.ERR_WINDOWS_SERVICE_NAME_ALREADY_IN_USE.get();
                    err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
                    break;
                }
                case 3: {
                    returnValue = 3;
                    Message msg = ToolMessages.ERR_WINDOWS_SERVICE_ENABLE_ERROR.get();
                    err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
                    break;
                }
                default: {
                    returnValue = 3;
                    Message msg = ToolMessages.ERR_WINDOWS_SERVICE_ENABLE_ERROR.get();
                    err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
                    break;
                }
            }
        }
        catch (Throwable t) {
            err.println("Unexpected throwable: " + t);
            t.printStackTrace();
            returnValue = 3;
            Message msg = ToolMessages.ERR_WINDOWS_SERVICE_ENABLE_ERROR.get();
            err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
        }
        return returnValue;
    }

    public static int disableService(PrintStream out, PrintStream err) {
        int returnValue;
        String serverRoot = ConfigureWindowsService.getServerRoot();
        String[] cmd = SetupUtils.hasUAC() ? new String[]{ConfigureWindowsService.getLauncherBinaryFullPath(), LAUNCHER_OPTION, ConfigureWindowsService.getLauncherAdministratorBinaryFullPath(), LAUNCHER_OPTION, ConfigureWindowsService.getBinaryFullPath(), "remove", serverRoot, DEBUG_OPTION} : new String[]{ConfigureWindowsService.getBinaryFullPath(), "remove", serverRoot, DEBUG_OPTION};
        try {
            int resultCode = Runtime.getRuntime().exec(cmd).waitFor();
            switch (resultCode) {
                case 0: {
                    returnValue = 0;
                    Message msg = ToolMessages.INFO_WINDOWS_SERVICE_SUCCESSULLY_DISABLED.get();
                    out.println(msg);
                    break;
                }
                case 1: {
                    returnValue = 1;
                    Message msg = ToolMessages.INFO_WINDOWS_SERVICE_ALREADY_DISABLED.get();
                    out.println(msg);
                    break;
                }
                case 2: {
                    returnValue = 2;
                    Message msg = ToolMessages.WARN_WINDOWS_SERVICE_MARKED_FOR_DELETION.get();
                    out.println(msg);
                    break;
                }
                case 3: {
                    returnValue = 3;
                    Message msg = ToolMessages.ERR_WINDOWS_SERVICE_DISABLE_ERROR.get();
                    err.println(msg);
                    break;
                }
                default: {
                    returnValue = 3;
                    Message msg = ToolMessages.ERR_WINDOWS_SERVICE_DISABLE_ERROR.get();
                    err.println(msg);
                    break;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            returnValue = 3;
            Message msg = ToolMessages.ERR_WINDOWS_SERVICE_DISABLE_ERROR.get();
            err.println(msg);
        }
        return returnValue;
    }

    public static int cleanupService(String serviceName, PrintStream out, PrintStream err) {
        int returnValue;
        String[] cmd = SetupUtils.hasUAC() ? new String[]{ConfigureWindowsService.getLauncherBinaryFullPath(), LAUNCHER_OPTION, ConfigureWindowsService.getLauncherAdministratorBinaryFullPath(), LAUNCHER_OPTION, ConfigureWindowsService.getBinaryFullPath(), "cleanup", serviceName, DEBUG_OPTION} : new String[]{ConfigureWindowsService.getBinaryFullPath(), "cleanup", serviceName, DEBUG_OPTION};
        try {
            int resultCode = Runtime.getRuntime().exec(cmd).waitFor();
            switch (resultCode) {
                case 0: {
                    returnValue = 0;
                    Message msg = ToolMessages.INFO_WINDOWS_SERVICE_CLEANUP_SUCCESS.get(serviceName);
                    out.println(msg);
                    break;
                }
                case 1: {
                    returnValue = 1;
                    Message msg = ToolMessages.ERR_WINDOWS_SERVICE_CLEANUP_NOT_FOUND.get(serviceName);
                    err.println(msg);
                    break;
                }
                case 2: {
                    returnValue = 3;
                    Message msg = ToolMessages.WARN_WINDOWS_SERVICE_CLEANUP_MARKED_FOR_DELETION.get(serviceName);
                    out.println(msg);
                    break;
                }
                case 3: {
                    returnValue = 2;
                    Message msg = ToolMessages.ERR_WINDOWS_SERVICE_CLEANUP_ERROR.get(serviceName);
                    err.println(msg);
                    break;
                }
                default: {
                    returnValue = 2;
                    Message msg = ToolMessages.ERR_WINDOWS_SERVICE_CLEANUP_ERROR.get(serviceName);
                    err.println(msg);
                    break;
                }
            }
        }
        catch (Throwable t) {
            returnValue = 2;
            Message msg = ToolMessages.ERR_WINDOWS_SERVICE_CLEANUP_ERROR.get(serviceName);
            err.println(msg);
            err.println("Exception:" + t.toString());
        }
        return returnValue;
    }

    public static int serviceState(PrintStream out, PrintStream err) {
        int returnValue;
        block15: {
            String serviceName = null;
            String serverRoot = ConfigureWindowsService.getServerRoot();
            String[] cmd = new String[]{ConfigureWindowsService.getBinaryFullPath(), "state", serverRoot, DEBUG_OPTION};
            try {
                int resultCode = -1;
                ProcessBuilder pb = new ProcessBuilder(cmd);
                Process process = pb.start();
                BufferedReader stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
                boolean processDone = false;
                while (!processDone) {
                    String s;
                    try {
                        resultCode = process.exitValue();
                        processDone = true;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    while ((s = stdout.readLine()) != null) {
                        if (s.trim().length() == 0) continue;
                        serviceName = s;
                    }
                }
                switch (resultCode) {
                    case 0: {
                        returnValue = 0;
                        if (out != null) {
                            Message msg = ToolMessages.INFO_WINDOWS_SERVICE_ENABLED.get(serviceName);
                            out.println(msg);
                        }
                        break;
                    }
                    case 1: {
                        returnValue = 1;
                        if (out != null) {
                            Message msg = ToolMessages.INFO_WINDOWS_SERVICE_DISABLED.get();
                            out.println(msg);
                        }
                        break;
                    }
                    case 2: {
                        returnValue = 2;
                        if (err != null) {
                            Message msg = ToolMessages.ERR_WINDOWS_SERVICE_STATE_ERROR.get();
                            err.println(msg);
                        }
                        break;
                    }
                    default: {
                        returnValue = 2;
                        if (err != null) {
                            Message msg = ToolMessages.ERR_WINDOWS_SERVICE_STATE_ERROR.get();
                            err.println(msg);
                        }
                        break;
                    }
                }
            }
            catch (Throwable t) {
                returnValue = 2;
                if (err == null) break block15;
                Message msg = ToolMessages.ERR_WINDOWS_SERVICE_STATE_ERROR.get();
                err.println(msg);
                err.println(StaticUtils.wrapText(t.toString(), ServerConstants.MAX_LINE_WIDTH));
            }
        }
        return returnValue;
    }

    private static String getServerRoot() {
        String serverRoot = DirectoryServer.getServerRoot();
        File f = new File(serverRoot);
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        serverRoot = f.toString();
        if (serverRoot.endsWith(File.separator)) {
            serverRoot = serverRoot.substring(0, serverRoot.length() - 1);
        }
        return serverRoot;
    }

    private static String getBinaryFullPath() {
        return SetupUtils.getScriptPath(ConfigureWindowsService.getServerRoot() + "\\lib\\opendj_service.exe");
    }

    public static String getLauncherAdministratorBinaryFullPath() {
        return ConfigureWindowsService.getServerRoot() + "\\lib\\launcher_administrator.exe";
    }

    public static String getLauncherBinaryFullPath() {
        return ConfigureWindowsService.getServerRoot() + "\\lib\\winlauncher.exe";
    }
}

