/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.FilePermission;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.OperatingSystem;
import org.opends.server.util.DynamicConstants;
import org.opends.server.util.EmbeddedUtils;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class CreateRCScript {
    public static void main(String[] args) {
        int exitCode = CreateRCScript.main(args, System.out, System.err);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    public static int main(String[] args, OutputStream outStream, OutputStream errStream) {
        String javaHomeDir;
        StringArgument javaArgs;
        StringArgument javaHome;
        StringArgument userName;
        StringArgument outputFile;
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        EmbeddedUtils.initializeForClientUse();
        OperatingSystem operatingSystem = DirectoryServer.getOperatingSystem();
        if (!OperatingSystem.isUNIXBased(operatingSystem)) {
            err.println(ToolMessages.ERR_CREATERC_ONLY_RUNS_ON_UNIX.get().toString());
            return 1;
        }
        File serverRoot = DirectoryServer.getEnvironmentConfig().getServerRoot();
        if (serverRoot == null) {
            err.println(ToolMessages.ERR_CREATERC_UNABLE_TO_DETERMINE_SERVER_ROOT.get("org.opends.server.ServerRoot", "INSTALL_ROOT").toString());
            return 1;
        }
        Message description = ToolMessages.INFO_CREATERC_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(CreateRCScript.class.getName(), description, false);
        try {
            outputFile = new StringArgument("outputfile", Character.valueOf('f'), "outputFile", true, false, true, ToolMessages.INFO_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_CREATERC_OUTFILE_DESCRIPTION.get());
            argParser.addArgument(outputFile);
            userName = new StringArgument("username", Character.valueOf('u'), "userName", false, false, true, ToolMessages.INFO_USER_NAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_CREATERC_USER_DESCRIPTION.get());
            argParser.addArgument(userName);
            javaHome = new StringArgument("javahome", Character.valueOf('j'), "javaHome", false, false, true, ToolMessages.INFO_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_CREATERC_JAVA_HOME_DESCRIPTION.get());
            argParser.addArgument(javaHome);
            javaArgs = new StringArgument("javaargs", Character.valueOf('J'), "javaArgs", false, false, true, ToolMessages.INFO_ARGS_PLACEHOLDER.get(), null, null, ToolMessages.INFO_CREATERC_JAVA_ARGS_DESCRIPTION.get());
            argParser.addArgument(javaArgs);
            BooleanArgument showUsage = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_SHOWUSAGE.get());
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage);
        }
        catch (ArgumentException ae) {
            err.println(ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage()));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            err.println(ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage()).toString());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (javaHome.isPresent()) {
            File f = new File(javaHome.getValue());
            if (!f.exists() || !f.isDirectory()) {
                err.println(ToolMessages.ERR_CREATERC_JAVA_HOME_DOESNT_EXIST.get(javaHome.getValue()).toString());
                return 1;
            }
            javaHomeDir = f.getAbsolutePath();
        } else {
            javaHomeDir = System.getenv("OPENDJ_JAVA_HOME");
        }
        String suString = "";
        String EscQuote1 = "\"";
        String EscQuote2 = "";
        if (userName.isPresent()) {
            File f2;
            String suCmd = "/bin/su";
            File f = new File(suCmd);
            if (!f.exists() && !(f2 = new File(suCmd = "/usr/bin/su")).exists()) {
                suCmd = "/bin/su";
            }
            suString = suCmd + " " + userName.getValue() + " -c ";
            EscQuote1 = "";
            EscQuote2 = "\"";
        }
        try {
            File f = new File(outputFile.getValue());
            PrintWriter w = new PrintWriter(f);
            w.println("#!/bin/sh");
            w.println("#");
            for (String headerLine : ServerConstants.CDDL_HEADER_LINES) {
                w.println("# " + headerLine);
            }
            w.println("# chkconfig: 345 95 5");
            w.println("# description: Control the " + DynamicConstants.SHORT_NAME + " Directory Server");
            w.println();
            w.println();
            w.println("# Set the path to the " + DynamicConstants.SHORT_NAME + " instance to manage");
            w.println("INSTALL_ROOT=\"" + serverRoot.getAbsolutePath() + "\"");
            w.println("export INSTALL_ROOT");
            w.println();
            w.println("cd ${INSTALL_ROOT}");
            w.println();
            if (javaHomeDir != null) {
                w.println("# Specify the path to the Java installation to use");
                w.println("OPENDJ_JAVA_HOME=\"" + javaHomeDir + "\"");
                w.println("export OPENDJ_JAVA_HOME");
                w.println();
            }
            if (javaArgs.isPresent()) {
                w.println("# Specify arguments that should be provided to the JVM");
                w.println("OPENDJ_JAVA_ARGS=\"" + javaArgs.getValue() + "\"");
                w.println("export OPENDJ_JAVA_ARGS");
                w.println();
            }
            w.println("# Determine what action should be performed on the server");
            w.println("case \"${1}\" in");
            w.println("start)");
            w.println("  " + suString + "\"${INSTALL_ROOT}/bin/start-ds" + EscQuote1 + " --quiet" + EscQuote2);
            w.println("  exit ${?}");
            w.println("  ;;");
            w.println("stop)");
            w.println("  " + suString + "\"${INSTALL_ROOT}/bin/stop-ds" + EscQuote1 + " --quiet" + EscQuote2);
            w.println("  exit ${?}");
            w.println("  ;;");
            w.println("restart)");
            w.println("  " + suString + "\"${INSTALL_ROOT}/bin/stop-ds" + EscQuote1 + " --restart --quiet" + EscQuote2);
            w.println("  exit ${?}");
            w.println("  ;;");
            w.println("*)");
            w.println("  echo \"Usage:  $0 { start | stop | restart }\"");
            w.println("  exit 1");
            w.println("  ;;");
            w.println("esac");
            w.println();
            w.close();
            if (FilePermission.canSetPermissions()) {
                FilePermission.setPermissions(f, FilePermission.decodeUNIXMode("755"));
            }
        }
        catch (Exception e) {
            err.println(ToolMessages.ERR_CREATERC_CANNOT_WRITE.get(StaticUtils.getExceptionMessage(e)).toString());
            return 1;
        }
        return 0;
    }
}

