/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.tools.ConfigureWindowsService;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.StaticUtils;

public class StopWindowsService {
    public static final int SERVICE_STOP_SUCCESSFUL = 0;
    public static final int SERVICE_NOT_FOUND = 1;
    public static final int SERVICE_STOP_ERROR = 3;

    public static void main(String[] args) {
        int result = StopWindowsService.stopWindowsService(System.out, System.err);
        System.exit(StaticUtils.filterExitCode(result));
    }

    public static int stopWindowsService(OutputStream outStream, OutputStream errStream) {
        int returnValue;
        if (outStream == null) {
            PrintStream out = NullOutputStream.printStream();
        } else {
            PrintStream out = new PrintStream(outStream);
        }
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        String serviceName = ConfigureWindowsService.getServiceName();
        if (serviceName == null) {
            Message message = ToolMessages.ERR_WINDOWS_SERVICE_NOT_FOUND.get();
            err.println(message);
            returnValue = 1;
        } else {
            String[] cmd = SetupUtils.hasUAC() ? new String[]{ConfigureWindowsService.getLauncherBinaryFullPath(), "run", ConfigureWindowsService.getLauncherAdministratorBinaryFullPath(), "run", "net", "stop", serviceName} : new String[]{"net", "stop", serviceName};
            try {
                int resultCode = Runtime.getRuntime().exec(cmd).waitFor();
                returnValue = resultCode == 0 ? 0 : (resultCode == 2 ? 0 : 3);
            }
            catch (Throwable t) {
                Message message = ToolMessages.ERR_WINDOWS_SERVICE_STOP_ERROR.get();
                err.println(message);
                err.println("Exception:" + t.toString());
                returnValue = 3;
            }
        }
        return returnValue;
    }
}

