/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opends.server.tools.makeldif.EntryWriter;
import org.opends.server.tools.makeldif.MakeLDIFException;
import org.opends.server.tools.makeldif.MakeLDIFInputStreamThread;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFWriter;

public class MakeLDIFInputStream
extends InputStream
implements EntryWriter {
    private boolean allGenerated;
    private boolean closed;
    private ByteArrayOutputStream entryOutputStream;
    private ByteBuffer entryBytes;
    private IOException ioException;
    private LDIFWriter ldifWriter;
    private LinkedBlockingQueue<TemplateEntry> entryQueue;
    private MakeLDIFInputStreamThread generatorThread;
    private TemplateFile templateFile;

    public MakeLDIFInputStream(TemplateFile templateFile) {
        this.templateFile = templateFile;
        this.allGenerated = false;
        this.closed = false;
        this.entryQueue = new LinkedBlockingQueue(10);
        this.ioException = null;
        this.entryBytes = null;
        this.entryOutputStream = new ByteArrayOutputStream(8192);
        LDIFExportConfig exportConfig = new LDIFExportConfig(this.entryOutputStream);
        try {
            this.ldifWriter = new LDIFWriter(exportConfig);
        }
        catch (IOException ioe) {
            this.ioException = ioe;
        }
        this.generatorThread = new MakeLDIFInputStreamThread(this, templateFile);
        this.generatorThread.start();
    }

    @Override
    public void close() {
        this.closed = true;
        this.ioException = null;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        if (this.ioException != null) {
            throw this.ioException;
        }
        if (!(this.entryBytes != null && this.entryBytes.hasRemaining() || this.getNextEntry())) {
            this.closed = true;
            return -1;
        }
        return 0xFF & this.entryBytes.get();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return -1;
        }
        if (this.ioException != null) {
            throw this.ioException;
        }
        if (!(this.entryBytes != null && this.entryBytes.hasRemaining() || this.getNextEntry())) {
            this.closed = true;
            return -1;
        }
        int bytesRead = Math.min(len, this.entryBytes.remaining());
        this.entryBytes.get(b, off, bytesRead);
        return bytesRead;
    }

    @Override
    public boolean writeEntry(TemplateEntry entry) throws IOException, MakeLDIFException {
        while (!this.closed) {
            try {
                if (!this.entryQueue.offer(entry, 500L, TimeUnit.MILLISECONDS)) continue;
                return true;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return false;
    }

    @Override
    public void closeEntryWriter() {
        this.allGenerated = true;
    }

    void setIOException(IOException ioException) {
        this.ioException = ioException;
    }

    private boolean getNextEntry() {
        TemplateEntry entry = this.entryQueue.poll();
        while (entry == null) {
            if (this.closed) {
                return false;
            }
            if (this.allGenerated) {
                entry = this.entryQueue.poll();
                if (entry != null) continue;
                return false;
            }
            try {
                entry = this.entryQueue.poll(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {}
        }
        try {
            this.entryOutputStream.reset();
            this.ldifWriter.writeTemplateEntry(entry);
            this.ldifWriter.flush();
            this.entryBytes = ByteBuffer.wrap(this.entryOutputStream.toByteArray());
        }
        catch (LDIFException le) {
            this.ioException = new IOException(le.getMessage());
            return false;
        }
        catch (IOException ioe) {
            this.ioException = ioe;
            return false;
        }
        return true;
    }
}

