/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;

public class ParentDNTag
extends Tag {
    @Override
    public String getName() {
        return "ParentDN";
    }

    @Override
    public boolean allowedInBranch() {
        return false;
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] arguments, int lineNumber, List<Message> warnings) throws InitializationException {
        if (arguments.length != 0) {
            Message message = ToolMessages.ERR_MAKELDIF_TAG_INVALID_ARGUMENT_COUNT.get(this.getName(), lineNumber, 0, arguments.length);
            throw new InitializationException(message);
        }
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        DN parentDN = templateEntry.getParentDN();
        if (parentDN == null || parentDN.isNullDN()) {
            return TagResult.SUCCESS_RESULT;
        }
        parentDN.toString(templateValue.getValue());
        return TagResult.SUCCESS_RESULT;
    }
}

