/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Collection;
import java.util.Set;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public abstract class AbstractAttribute
implements Attribute {
    protected AbstractAttribute() {
    }

    @Override
    public boolean containsAll(Collection<AttributeValue> values) {
        for (AttributeValue value : values) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Attribute) {
            Attribute a = (Attribute)o;
            if (!this.getAttributeType().equals(a.getAttributeType())) {
                return false;
            }
            if (this.size() != a.size()) {
                return false;
            }
            for (AttributeValue v : a) {
                if (this.contains(v)) continue;
                return false;
            }
            return this.optionsEqual(a.getOptions());
        }
        return false;
    }

    @Override
    public String getName() {
        return this.getAttributeType().getNameOrOID();
    }

    @Override
    public String getNameWithOptions() {
        if (!this.hasOptions()) {
            return this.getName();
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getName());
        for (String option : this.getOptions()) {
            buffer.append(';');
            buffer.append(option);
        }
        return buffer.toString();
    }

    @Override
    public boolean hasAllOptions(Collection<String> options) {
        if (options == null || options.isEmpty()) {
            return true;
        }
        if (!this.hasOptions()) {
            return false;
        }
        for (String option : options) {
            if (this.hasOption(option)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int hashCode = this.getAttributeType().hashCode();
        for (AttributeValue value : this) {
            hashCode += ((Object)value).hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean hasOption(String option) {
        String noption = StaticUtils.toLowerCase(option);
        for (String o : this.getOptions()) {
            String no = StaticUtils.toLowerCase(o);
            if (!no.equals(noption)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasOptions() {
        return !this.getOptions().isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean optionsEqual(Set<String> options) {
        if (options == null) {
            return !this.hasOptions();
        }
        if (this.getOptions().size() != options.size()) {
            return false;
        }
        for (String option : options) {
            if (this.hasOption(option)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }
}

