/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.DITStructureRuleSyntax;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.Schema;
import org.opends.server.types.SchemaFileElement;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.Validator;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class DITStructureRule
implements SchemaFileElement {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final boolean isObsolete;
    private final int ruleID;
    private final NameForm nameForm;
    private final Map<String, List<String>> extraProperties;
    private final Map<String, String> names;
    private final Set<DITStructureRule> superiorRules;
    private final String definition;
    private final String description;

    public DITStructureRule(String definition, Map<String, String> names, int ruleID, String description, boolean isObsolete, NameForm nameForm, Set<DITStructureRule> superiorRules, Map<String, List<String>> extraProperties) {
        Validator.ensureNotNull(definition);
        this.ruleID = ruleID;
        this.description = description;
        this.isObsolete = isObsolete;
        this.nameForm = nameForm;
        int schemaFilePos = definition.indexOf("X-SCHEMA-FILE");
        if (schemaFilePos > 0) {
            String defStr;
            try {
                int firstQuotePos = definition.indexOf(39, schemaFilePos);
                int secondQuotePos = definition.indexOf(39, firstQuotePos + 1);
                defStr = definition.substring(0, schemaFilePos).trim() + " " + definition.substring(secondQuotePos + 1).trim();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                defStr = definition;
            }
            this.definition = defStr;
        } else {
            this.definition = definition;
        }
        this.names = names == null || names.isEmpty() ? new LinkedHashMap<String, String>(0) : new LinkedHashMap<String, String>(names);
        this.superiorRules = superiorRules == null || superiorRules.isEmpty() ? new LinkedHashSet<DITStructureRule>(0) : new LinkedHashSet<DITStructureRule>(superiorRules);
        this.extraProperties = extraProperties == null || extraProperties.isEmpty() ? new LinkedHashMap<String, List<String>>(0) : new LinkedHashMap<String, List<String>>(extraProperties);
    }

    @Override
    public String getDefinition() {
        return this.definition;
    }

    @Override
    public DITStructureRule recreateFromDefinition(Schema schema) throws DirectoryException {
        ByteString value = ByteString.valueOf(this.definition);
        DITStructureRule dsr = DITStructureRuleSyntax.decodeDITStructureRule(value, schema, false);
        dsr.setSchemaFile(this.getSchemaFile());
        return dsr;
    }

    public Map<String, String> getNames() {
        return this.names;
    }

    public boolean hasName(String lowerName) {
        return this.names.containsKey(lowerName);
    }

    public int getRuleID() {
        return this.ruleID;
    }

    public String getNameOrRuleID() {
        if (this.names.isEmpty()) {
            return String.valueOf(this.ruleID);
        }
        return this.names.values().iterator().next();
    }

    @Override
    public String getSchemaFile() {
        List<String> values = this.extraProperties.get("X-SCHEMA-FILE");
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    @Override
    public void setSchemaFile(String schemaFile) {
        this.setExtraProperty("X-SCHEMA-FILE", schemaFile);
    }

    public String getDescription() {
        return this.description;
    }

    public NameForm getNameForm() {
        return this.nameForm;
    }

    public ObjectClass getStructuralClass() {
        return this.nameForm.getStructuralClass();
    }

    public Set<DITStructureRule> getSuperiorRules() {
        return this.superiorRules;
    }

    public boolean hasSuperiorRules() {
        return this.superiorRules != null && !this.superiorRules.isEmpty();
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public Map<String, List<String>> getExtraProperties() {
        return this.extraProperties;
    }

    public List<String> getExtraProperty(String propertyName) {
        return this.extraProperties.get(propertyName);
    }

    public void setExtraProperty(String name, String value) {
        Validator.ensureNotNull(name);
        if (value == null) {
            this.extraProperties.remove(name);
        } else {
            LinkedList<String> values = new LinkedList<String>();
            values.add(value);
            this.extraProperties.put(name, values);
        }
    }

    public void setExtraProperty(String name, List<String> values) {
        Validator.ensureNotNull(name);
        if (values == null || values.isEmpty()) {
            this.extraProperties.remove(name);
        } else {
            LinkedList<String> valuesCopy = new LinkedList<String>(values);
            this.extraProperties.put(name, valuesCopy);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof DITStructureRule)) {
            return false;
        }
        return this.ruleID == ((DITStructureRule)o).ruleID;
    }

    public int hashCode() {
        return this.ruleID;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer, true);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer, boolean includeFileElement) {
        Iterator<Object> iterator;
        buffer.append("( ");
        buffer.append(this.ruleID);
        if (!this.names.isEmpty()) {
            iterator = this.names.values().iterator();
            String firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append((String)iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        if (this.description != null && this.description.length() > 0) {
            buffer.append(" DESC '");
            buffer.append(this.description);
            buffer.append("'");
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        buffer.append(" FORM ");
        buffer.append(this.nameForm.getNameOrOID());
        if (this.superiorRules != null && !this.superiorRules.isEmpty()) {
            iterator = this.superiorRules.iterator();
            int firstRule = ((DITStructureRule)iterator.next()).getRuleID();
            if (iterator.hasNext()) {
                buffer.append(" SUP ( ");
                buffer.append(firstRule);
                while (iterator.hasNext()) {
                    buffer.append(" ");
                    buffer.append(((DITStructureRule)iterator.next()).getRuleID());
                }
                buffer.append(" )");
            } else {
                buffer.append(" SUP ");
                buffer.append(firstRule);
            }
        }
        if (!this.extraProperties.isEmpty()) {
            for (String property : this.extraProperties.keySet()) {
                if (!includeFileElement && property.equals("X-SCHEMA-FILE")) continue;
                List<String> valueList = this.extraProperties.get(property);
                buffer.append(" ");
                buffer.append(property);
                if (valueList.size() == 1) {
                    buffer.append(" '");
                    buffer.append(valueList.get(0));
                    buffer.append("'");
                    continue;
                }
                buffer.append(" ( ");
                for (String value : valueList) {
                    buffer.append("'");
                    buffer.append(value);
                    buffer.append("' ");
                }
                buffer.append(")");
            }
        }
        buffer.append(" )");
    }
}

