/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.ChangeNotificationListener;
import org.opends.server.api.ConfigHandler;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.api.InvokableComponent;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.CryptoManager;
import org.opends.server.types.DITContentRule;
import org.opends.server.types.DITStructureRule;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.MatchingRuleUse;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.OperatingSystem;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class DirectoryConfig {
    public static CryptoManager getCryptoManager() {
        return DirectoryServer.getCryptoManager();
    }

    public static OperatingSystem getOperatingSystem() {
        return DirectoryServer.getOperatingSystem();
    }

    public static ConfigHandler getConfigHandler() {
        return DirectoryServer.getConfigHandler();
    }

    public static ConfigEntry getConfigEntry(DN entryDN) throws ConfigException {
        return DirectoryServer.getConfigEntry(entryDN);
    }

    public static String getServerRoot() {
        return DirectoryServer.getServerRoot();
    }

    public static long getStartTime() {
        return DirectoryServer.getStartTime();
    }

    public static String getStartTimeUTC() {
        return DirectoryServer.getStartTimeUTC();
    }

    public static Schema getSchema() {
        return DirectoryServer.getSchema();
    }

    public static Map<String, MatchingRule> getMatchingRules() {
        return DirectoryServer.getMatchingRules();
    }

    public static MatchingRule getMatchingRule(String lowerName) {
        return DirectoryServer.getMatchingRule(lowerName);
    }

    public static ApproximateMatchingRule getApproximateMatchingRule(String lowerName) {
        return DirectoryServer.getApproximateMatchingRule(lowerName);
    }

    public static EqualityMatchingRule getEqualityMatchingRule(String lowerName) {
        return DirectoryServer.getEqualityMatchingRule(lowerName);
    }

    public static OrderingMatchingRule getOrderingMatchingRule(String lowerName) {
        return DirectoryServer.getOrderingMatchingRule(lowerName);
    }

    public static SubstringMatchingRule getSubstringMatchingRule(String lowerName) {
        return DirectoryServer.getSubstringMatchingRule(lowerName);
    }

    public static Map<String, ObjectClass> getObjectClasses() {
        return DirectoryServer.getObjectClasses();
    }

    public static ObjectClass getObjectClass(String lowerName, boolean returnDefault) {
        return DirectoryServer.getObjectClass(lowerName, returnDefault);
    }

    public static ObjectClass getTopObjectClass() {
        return DirectoryServer.getTopObjectClass();
    }

    public static Map<String, AttributeType> getAttributeTypes() {
        return DirectoryServer.getAttributeTypes();
    }

    public static AttributeType getAttributeType(String lowerName, boolean returnDefault) {
        return DirectoryServer.getAttributeType(lowerName, returnDefault);
    }

    public static AttributeType getObjectClassAttributeType() {
        return DirectoryServer.getObjectClassAttributeType();
    }

    public static Map<String, AttributeSyntax<?>> getAttributeSyntaxes() {
        return DirectoryServer.getAttributeSyntaxes();
    }

    public static AttributeSyntax getAttributeSyntax(String oid, boolean allowDefault) {
        return DirectoryServer.getAttributeSyntax(oid, allowDefault);
    }

    public static AttributeSyntax getDefaultAttributeSyntax() {
        return DirectoryServer.getDefaultAttributeSyntax();
    }

    public static AttributeSyntax getDefaultBinarySyntax() {
        return DirectoryServer.getDefaultBinarySyntax();
    }

    public static AttributeSyntax getDefaultBooleanSyntax() {
        return DirectoryServer.getDefaultBooleanSyntax();
    }

    public static AttributeSyntax getDefaultDNSyntax() {
        return DirectoryServer.getDefaultDNSyntax();
    }

    public static AttributeSyntax getDefaultIntegerSyntax() {
        return DirectoryServer.getDefaultIntegerSyntax();
    }

    public static AttributeSyntax getDefaultStringSyntax() {
        return DirectoryServer.getDefaultStringSyntax();
    }

    public static Map<MatchingRule, MatchingRuleUse> getMatchingRuleUses() {
        return DirectoryServer.getMatchingRuleUses();
    }

    public static MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
        return DirectoryServer.getMatchingRuleUse(matchingRule);
    }

    public static Map<ObjectClass, DITContentRule> getDITContentRules() {
        return DirectoryServer.getDITContentRules();
    }

    public static DITContentRule getDITContentRule(ObjectClass objectClass) {
        return DirectoryServer.getDITContentRule(objectClass);
    }

    public static Map<NameForm, DITStructureRule> getDITStructureRules() {
        return DirectoryServer.getDITStructureRules();
    }

    public static DITStructureRule getDITStructureRule(int ruleID) {
        return DirectoryServer.getDITStructureRule(ruleID);
    }

    public static DITStructureRule getDITStructureRule(NameForm nameForm) {
        return DirectoryServer.getDITStructureRule(nameForm);
    }

    public static Map<ObjectClass, List<NameForm>> getNameForms() {
        return DirectoryServer.getNameForms();
    }

    public static List<NameForm> getNameForm(ObjectClass objectClass) {
        return DirectoryServer.getNameForm(objectClass);
    }

    public static NameForm getNameForm(String lowerName) {
        return DirectoryServer.getNameForm(lowerName);
    }

    public static void registerInvokableComponent(InvokableComponent component) {
        DirectoryServer.registerInvokableComponent(component);
    }

    public static void deregisterInvokableComponent(InvokableComponent component) {
        DirectoryServer.deregisterInvokableComponent(component);
    }

    public static void registerAlertGenerator(AlertGenerator alertGenerator) {
        DirectoryServer.registerAlertGenerator(alertGenerator);
    }

    public static void deregisterAlertGenerator(AlertGenerator alertGenerator) {
        DirectoryServer.deregisterAlertGenerator(alertGenerator);
    }

    public static void sendAlertNotification(AlertGenerator generator, String alertType, Message alertMessage) {
        DirectoryServer.sendAlertNotification(generator, alertType, alertMessage);
    }

    public static ResultCode getServerErrorResultCode() {
        return DirectoryServer.getServerErrorResultCode();
    }

    public static Entry getEntry(DN entryDN) throws DirectoryException {
        return DirectoryServer.getEntry(entryDN);
    }

    public static boolean entryExists(DN entryDN) throws DirectoryException {
        return DirectoryServer.entryExists(entryDN);
    }

    public static Set<String> getSupportedControls() {
        return DirectoryServer.getSupportedControls();
    }

    public static boolean isSupportedControl(String controlOID) {
        return DirectoryServer.isSupportedControl(controlOID);
    }

    public static void registerSupportedControl(String controlOID) {
        DirectoryServer.registerSupportedControl(controlOID);
    }

    public static void deregisterSupportedControl(String controlOID) {
        DirectoryServer.deregisterSupportedControl(controlOID);
    }

    public static Set<String> getSupportedFeatures() {
        return DirectoryServer.getSupportedFeatures();
    }

    public static boolean isSupportedFeature(String featureOID) {
        return DirectoryServer.isSupportedFeature(featureOID);
    }

    public static void registerSupportedFeature(String featureOID) {
        DirectoryServer.registerSupportedFeature(featureOID);
    }

    public static void deregisterSupportedFeature(String featureOID) {
        DirectoryServer.deregisterSupportedFeature(featureOID);
    }

    public static Map<String, ExtendedOperationHandler> getSupportedExtensions() {
        return DirectoryServer.getSupportedExtensions();
    }

    public static ExtendedOperationHandler getExtendedOperationHandler(String oid) {
        return DirectoryServer.getExtendedOperationHandler(oid);
    }

    public static void registerSupportedExtension(String oid, ExtendedOperationHandler handler) {
        DirectoryServer.registerSupportedExtension(oid, handler);
    }

    public static void deregisterSupportedExtension(String oid) {
        DirectoryServer.deregisterSupportedExtension(oid);
    }

    public static Map<String, SASLMechanismHandler> getSupportedSASLMechanisms() {
        return DirectoryServer.getSupportedSASLMechanisms();
    }

    public static SASLMechanismHandler getSASLMechanismHandler(String name) {
        return DirectoryServer.getSASLMechanismHandler(name);
    }

    public static void registerSASLMechanismHandler(String name, SASLMechanismHandler handler) {
        DirectoryServer.registerSASLMechanismHandler(name, handler);
    }

    public static void deregisterSASLMechanismHandler(String name) {
        DirectoryServer.deregisterSASLMechanismHandler(name);
    }

    public static void registerChangeNotificationListener(ChangeNotificationListener changeListener) {
        DirectoryServer.registerChangeNotificationListener(changeListener);
    }

    public static void deregisterChangeNotificationListener(ChangeNotificationListener changeListener) {
        DirectoryServer.deregisterChangeNotificationListener(changeListener);
    }

    public static void registerShutdownListener(ServerShutdownListener listener) {
        DirectoryServer.registerShutdownListener(listener);
    }

    public static void deregisterShutdownListener(ServerShutdownListener listener) {
        DirectoryServer.deregisterShutdownListener(listener);
    }

    public static String getVersionString() {
        return DirectoryServer.getVersionString();
    }
}

