/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.opends.messages.Message;
import org.opends.messages.UtilityMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.FilePermission;
import org.opends.server.types.OperationConfig;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class LDIFExportConfig
extends OperationConfig
implements Closeable {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean compressData;
    private boolean encryptData;
    private boolean excludeOperationalAttributes;
    private boolean hashData;
    private boolean includeObjectClasses;
    private boolean includeOperationalAttributes;
    private boolean includeVirtualAttributes;
    private boolean invokeExportPlugins;
    private boolean signHash;
    private boolean typesOnly;
    private BufferedWriter writer;
    private ExistingFileBehavior existingFileBehavior;
    private int wrapColumn;
    private List<DN> excludeBranches;
    private List<DN> includeBranches;
    private List<SearchFilter> excludeFilters;
    private List<SearchFilter> includeFilters;
    private OutputStream ldifOutputStream;
    private Set<AttributeType> excludeAttributes;
    private Set<AttributeType> includeAttributes;
    private String ldifFile;

    public LDIFExportConfig(String ldifFile, ExistingFileBehavior existingFileBehavior) {
        this.ldifFile = ldifFile;
        this.existingFileBehavior = existingFileBehavior;
        this.ldifOutputStream = null;
        this.excludeBranches = new ArrayList<DN>();
        this.includeBranches = new ArrayList<DN>();
        this.excludeFilters = new ArrayList<SearchFilter>();
        this.includeFilters = new ArrayList<SearchFilter>();
        this.compressData = false;
        this.encryptData = false;
        this.excludeOperationalAttributes = false;
        this.hashData = false;
        this.includeObjectClasses = true;
        this.includeOperationalAttributes = true;
        this.includeVirtualAttributes = false;
        this.invokeExportPlugins = false;
        this.signHash = false;
        this.typesOnly = false;
        this.writer = null;
        this.excludeAttributes = new HashSet<AttributeType>();
        this.includeAttributes = new HashSet<AttributeType>();
        this.wrapColumn = -1;
    }

    public LDIFExportConfig(OutputStream ldifOutputStream) {
        this.ldifOutputStream = ldifOutputStream;
        this.ldifFile = null;
        this.existingFileBehavior = ExistingFileBehavior.FAIL;
        this.excludeBranches = new ArrayList<DN>();
        this.includeBranches = new ArrayList<DN>();
        this.excludeFilters = new ArrayList<SearchFilter>();
        this.includeFilters = new ArrayList<SearchFilter>();
        this.compressData = false;
        this.encryptData = false;
        this.hashData = false;
        this.includeObjectClasses = true;
        this.includeOperationalAttributes = true;
        this.includeVirtualAttributes = false;
        this.invokeExportPlugins = false;
        this.signHash = false;
        this.typesOnly = false;
        this.writer = null;
        this.excludeAttributes = new HashSet<AttributeType>();
        this.includeAttributes = new HashSet<AttributeType>();
        this.wrapColumn = -1;
    }

    public BufferedWriter getWriter() throws IOException {
        if (this.writer == null) {
            if (this.ldifOutputStream == null) {
                File f = new File(this.ldifFile);
                boolean mustSetPermissions = false;
                switch (this.existingFileBehavior) {
                    case APPEND: {
                        if (!f.exists()) {
                            f.createNewFile();
                            mustSetPermissions = true;
                        }
                        this.ldifOutputStream = new FileOutputStream(this.ldifFile, true);
                        break;
                    }
                    case OVERWRITE: {
                        if (!f.exists()) {
                            f.createNewFile();
                            mustSetPermissions = true;
                        }
                        this.ldifOutputStream = new FileOutputStream(this.ldifFile, false);
                        break;
                    }
                    case FAIL: {
                        if (f.exists()) {
                            Message message = UtilityMessages.ERR_LDIF_FILE_EXISTS.get(this.ldifFile);
                            throw new IOException(message.toString());
                        }
                        f.createNewFile();
                        mustSetPermissions = true;
                        this.ldifOutputStream = new FileOutputStream(this.ldifFile);
                    }
                }
                if (mustSetPermissions) {
                    try {
                        FilePermission.setPermissions(f, new FilePermission(384));
                    }
                    catch (Exception e) {
                        Message message = UtilityMessages.WARN_EXPORT_LDIF_SET_PERMISSION_FAILED.get(f.toString(), StaticUtils.stackTraceToSingleLineString(e));
                        throw new IOException(message.toString());
                    }
                }
            }
            OutputStream outputStream = this.compressData ? new GZIPOutputStream(this.ldifOutputStream) : this.ldifOutputStream;
            if (this.encryptData) {
                // empty if block
            }
            this.writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        }
        return this.writer;
    }

    public boolean invokeExportPlugins() {
        return this.invokeExportPlugins;
    }

    public void setInvokeExportPlugins(boolean invokeExportPlugins) {
        this.invokeExportPlugins = invokeExportPlugins;
    }

    public boolean compressData() {
        return this.compressData;
    }

    public void setCompressData(boolean compressData) {
        this.compressData = compressData;
    }

    public boolean encryptData() {
        return this.encryptData;
    }

    public void setEncryptData(boolean encryptData) {
        this.encryptData = encryptData;
    }

    public boolean hashData() {
        return this.hashData;
    }

    public void setHashData(boolean hashData) {
        this.hashData = hashData;
    }

    public boolean signHash() {
        return this.signHash;
    }

    public void setSignHash(boolean signHash) {
        this.signHash = signHash;
    }

    public boolean typesOnly() {
        return this.typesOnly;
    }

    public void setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
    }

    public int getWrapColumn() {
        return this.wrapColumn;
    }

    public void setWrapColumn(int wrapColumn) {
        this.wrapColumn = wrapColumn;
    }

    public List<DN> getExcludeBranches() {
        return this.excludeBranches;
    }

    public void setExcludeBranches(List<DN> excludeBranches) {
        this.excludeBranches = excludeBranches == null ? new ArrayList<DN>(0) : excludeBranches;
    }

    public List<DN> getIncludeBranches() {
        return this.includeBranches;
    }

    public void setIncludeBranches(List<DN> includeBranches) {
        this.includeBranches = includeBranches == null ? new ArrayList<DN>(0) : includeBranches;
    }

    public boolean includeObjectClasses() {
        return this.includeObjectClasses;
    }

    public boolean includeOperationalAttributes() {
        return this.includeOperationalAttributes;
    }

    public void setIncludeObjectClasses(boolean includeObjectClasses) {
        this.includeObjectClasses = includeObjectClasses;
    }

    public void setIncludeOperationalAttributes(boolean includeOperationalAttributes) {
        this.includeOperationalAttributes = includeOperationalAttributes;
    }

    public boolean includeVirtualAttributes() {
        return this.includeVirtualAttributes;
    }

    public void setIncludeVirtualAttributes(boolean includeVirtualAttributes) {
        this.includeVirtualAttributes = includeVirtualAttributes;
    }

    public Set<AttributeType> getExcludeAttributes() {
        return this.excludeAttributes;
    }

    public void setExcludeAttributes(Set<AttributeType> excludeAttributes) {
        this.excludeAttributes = excludeAttributes == null ? new HashSet<AttributeType>(0) : excludeAttributes;
    }

    public Set<AttributeType> getIncludeAttributes() {
        return this.includeAttributes;
    }

    public void setIncludeAttributes(Set<AttributeType> includeAttributes) {
        this.includeAttributes = includeAttributes == null ? new HashSet<AttributeType>(0) : includeAttributes;
    }

    public boolean includeAttribute(AttributeType attributeType) {
        if (!this.excludeAttributes.isEmpty() && this.excludeAttributes.contains(attributeType)) {
            return false;
        }
        return this.includeAttributes.isEmpty() || this.includeAttributes.contains(attributeType);
    }

    public List<SearchFilter> getExcludeFilters() {
        return this.excludeFilters;
    }

    public void setExcludeFilters(List<SearchFilter> excludeFilters) {
        this.excludeFilters = excludeFilters == null ? new ArrayList<SearchFilter>(0) : excludeFilters;
    }

    public List<SearchFilter> getIncludeFilters() {
        return this.includeFilters;
    }

    public void setIncludeFilters(List<SearchFilter> includeFilters) {
        this.includeFilters = includeFilters == null ? new ArrayList<SearchFilter>(0) : includeFilters;
    }

    public boolean includeEntry(Entry entry) throws DirectoryException {
        block8: {
            DN dn = entry.getDN();
            if (!this.excludeBranches.isEmpty()) {
                for (DN excludeBranch : this.excludeBranches) {
                    if (!excludeBranch.isAncestorOf(dn)) continue;
                    return false;
                }
            }
            if (!this.includeBranches.isEmpty()) {
                for (DN includeBranch : this.includeBranches) {
                    if (!includeBranch.isAncestorOf(dn)) continue;
                    break block8;
                }
                return false;
            }
        }
        if (!this.excludeFilters.isEmpty()) {
            for (SearchFilter filter : this.excludeFilters) {
                if (!filter.matchesEntry(entry)) continue;
                return false;
            }
        }
        if (!this.includeFilters.isEmpty()) {
            for (SearchFilter filter : this.includeFilters) {
                if (!filter.matchesEntry(entry)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        block3: {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block3;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }
}

