/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.opends.messages.UtilityMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.tools.makeldif.MakeLDIFInputStream;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.OperationConfig;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class LDIFImportConfig
extends OperationConfig
implements Closeable {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private boolean appendToExistingData;
    private boolean includeObjectClasses;
    private boolean invokeImportPlugins;
    private boolean isCompressed;
    private boolean isEncrypted;
    private boolean clearBackend;
    private boolean replaceExistingEntries;
    private boolean validateSchema;
    private BufferedReader reader;
    private BufferedWriter rejectWriter;
    private BufferedWriter skipWriter;
    private InputStream ldifInputStream;
    private int bufferSize;
    private Iterator<String> ldifFileIterator;
    private List<DN> excludeBranches;
    private List<DN> includeBranches;
    private List<SearchFilter> excludeFilters;
    private List<SearchFilter> includeFilters;
    private List<String> ldifFiles;
    private Set<AttributeType> excludeAttributes;
    private Set<AttributeType> includeAttributes;
    private boolean includeAllUserAttrs;
    private boolean includeAllOpAttrs;
    private boolean excludeAllUserAttrs;
    private boolean excludeAllOpAttrs;
    private String tmpDirectory;
    private boolean skipDNValidation = false;
    private int threadCount = 0;

    public LDIFImportConfig(String ldifFile) {
        this.ldifFiles = new ArrayList<String>(1);
        this.ldifFiles.add(ldifFile);
        this.ldifFileIterator = this.ldifFiles.iterator();
        this.ldifInputStream = null;
        this.bufferSize = 8192;
        this.excludeBranches = new ArrayList<DN>();
        this.includeBranches = new ArrayList<DN>();
        this.excludeFilters = new ArrayList<SearchFilter>();
        this.includeFilters = new ArrayList<SearchFilter>();
        this.appendToExistingData = false;
        this.replaceExistingEntries = false;
        this.includeObjectClasses = true;
        this.invokeImportPlugins = false;
        this.isCompressed = false;
        this.isEncrypted = false;
        this.clearBackend = false;
        this.validateSchema = true;
        this.reader = null;
        this.rejectWriter = null;
        this.skipWriter = null;
        this.excludeAttributes = new HashSet<AttributeType>();
        this.includeAttributes = new HashSet<AttributeType>();
        this.includeAllUserAttrs = false;
        this.includeAllOpAttrs = false;
        this.excludeAllUserAttrs = false;
        this.excludeAllOpAttrs = false;
    }

    public LDIFImportConfig(List<String> ldifFiles) {
        this.ldifFiles = ldifFiles;
        this.ldifFileIterator = ldifFiles.iterator();
        this.ldifInputStream = null;
        this.bufferSize = 8192;
        this.excludeBranches = new ArrayList<DN>();
        this.includeBranches = new ArrayList<DN>();
        this.excludeFilters = new ArrayList<SearchFilter>();
        this.includeFilters = new ArrayList<SearchFilter>();
        this.appendToExistingData = false;
        this.replaceExistingEntries = false;
        this.includeObjectClasses = true;
        this.invokeImportPlugins = false;
        this.isCompressed = false;
        this.isEncrypted = false;
        this.validateSchema = true;
        this.reader = null;
        this.rejectWriter = null;
        this.skipWriter = null;
        this.excludeAttributes = new HashSet<AttributeType>();
        this.includeAttributes = new HashSet<AttributeType>();
        this.includeAllUserAttrs = false;
        this.includeAllOpAttrs = false;
        this.excludeAllUserAttrs = false;
        this.excludeAllOpAttrs = false;
    }

    public LDIFImportConfig(InputStream ldifInputStream) {
        this.ldifInputStream = ldifInputStream;
        this.bufferSize = 8192;
        this.ldifFiles = null;
        this.ldifFileIterator = null;
        this.excludeBranches = new ArrayList<DN>();
        this.includeBranches = new ArrayList<DN>();
        this.excludeFilters = new ArrayList<SearchFilter>();
        this.includeFilters = new ArrayList<SearchFilter>();
        this.appendToExistingData = false;
        this.replaceExistingEntries = false;
        this.includeObjectClasses = true;
        this.invokeImportPlugins = false;
        this.isCompressed = false;
        this.isEncrypted = false;
        this.validateSchema = true;
        this.reader = null;
        this.rejectWriter = null;
        this.skipWriter = null;
        this.excludeAttributes = new HashSet<AttributeType>();
        this.includeAttributes = new HashSet<AttributeType>();
        this.includeAllUserAttrs = false;
        this.includeAllOpAttrs = false;
        this.excludeAllUserAttrs = false;
        this.excludeAllOpAttrs = false;
    }

    public LDIFImportConfig(Reader ldifInputReader) {
        this.ldifInputStream = null;
        this.bufferSize = 8192;
        this.ldifFiles = null;
        this.ldifFileIterator = null;
        this.excludeBranches = new ArrayList<DN>();
        this.includeBranches = new ArrayList<DN>();
        this.excludeFilters = new ArrayList<SearchFilter>();
        this.includeFilters = new ArrayList<SearchFilter>();
        this.appendToExistingData = false;
        this.replaceExistingEntries = false;
        this.includeObjectClasses = true;
        this.invokeImportPlugins = false;
        this.isCompressed = false;
        this.isEncrypted = false;
        this.validateSchema = true;
        this.reader = this.getBufferedReader(ldifInputReader);
        this.rejectWriter = null;
        this.skipWriter = null;
        this.excludeAttributes = new HashSet<AttributeType>();
        this.includeAttributes = new HashSet<AttributeType>();
        this.includeAllUserAttrs = false;
        this.includeAllOpAttrs = false;
        this.excludeAllUserAttrs = false;
        this.excludeAllOpAttrs = false;
    }

    private BufferedReader getBufferedReader(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    public LDIFImportConfig(TemplateFile templateFile) {
        this(new MakeLDIFInputStream(templateFile));
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            InputStream inputStream = this.ldifInputStream == null ? (this.ldifInputStream = new FileInputStream(this.ldifFileIterator.next())) : this.ldifInputStream;
            if (this.isEncrypted) {
                // empty if block
            }
            if (this.isCompressed) {
                inputStream = new GZIPInputStream(inputStream);
            }
            this.reader = new BufferedReader(new InputStreamReader(inputStream), this.bufferSize);
        }
        return this.reader;
    }

    public BufferedReader nextReader() throws IOException {
        if (this.ldifFileIterator == null || !this.ldifFileIterator.hasNext()) {
            return null;
        }
        this.reader.close();
        this.ldifInputStream = new FileInputStream(this.ldifFileIterator.next());
        InputStream inputStream = this.ldifInputStream;
        if (this.isEncrypted) {
            // empty if block
        }
        if (this.isCompressed) {
            inputStream = new GZIPInputStream(inputStream);
        }
        this.reader = new BufferedReader(new InputStreamReader(inputStream), this.bufferSize);
        return this.reader;
    }

    public BufferedWriter getRejectWriter() {
        return this.rejectWriter;
    }

    public BufferedWriter getSkipWriter() {
        return this.skipWriter;
    }

    public void writeRejectedEntries(String rejectFile, ExistingFileBehavior existingFileBehavior) throws IOException {
        if (rejectFile == null) {
            if (this.rejectWriter != null) {
                try {
                    this.rejectWriter.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.rejectWriter = null;
            }
            return;
        }
        switch (existingFileBehavior) {
            case APPEND: {
                this.rejectWriter = new BufferedWriter(new FileWriter(rejectFile, true));
                break;
            }
            case OVERWRITE: {
                this.rejectWriter = new BufferedWriter(new FileWriter(rejectFile, false));
                break;
            }
            case FAIL: {
                File f = new File(rejectFile);
                if (f.exists()) {
                    throw new IOException(UtilityMessages.ERR_REJECT_FILE_EXISTS.get(rejectFile).toString());
                }
                this.rejectWriter = new BufferedWriter(new FileWriter(rejectFile));
            }
        }
    }

    public void writeRejectedEntries(OutputStream outputStream) {
        if (outputStream == null) {
            if (this.rejectWriter != null) {
                try {
                    this.rejectWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.rejectWriter = null;
            }
            return;
        }
        this.rejectWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    public void writeSkippedEntries(String skipFile, ExistingFileBehavior existingFileBehavior) throws IOException {
        if (skipFile == null) {
            if (this.skipWriter != null) {
                try {
                    this.skipWriter.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.skipWriter = null;
            }
            return;
        }
        switch (existingFileBehavior) {
            case APPEND: {
                this.skipWriter = new BufferedWriter(new FileWriter(skipFile, true));
                break;
            }
            case OVERWRITE: {
                this.skipWriter = new BufferedWriter(new FileWriter(skipFile, false));
                break;
            }
            case FAIL: {
                File f = new File(skipFile);
                if (f.exists()) {
                    throw new IOException(UtilityMessages.ERR_SKIP_FILE_EXISTS.get(skipFile).toString());
                }
                this.skipWriter = new BufferedWriter(new FileWriter(skipFile));
            }
        }
    }

    public void writeSkippedEntries(OutputStream outputStream) {
        if (outputStream == null) {
            if (this.skipWriter != null) {
                try {
                    this.skipWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.skipWriter = null;
            }
            return;
        }
        this.skipWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    public boolean appendToExistingData() {
        return this.appendToExistingData;
    }

    public void setAppendToExistingData(boolean appendToExistingData) {
        this.appendToExistingData = appendToExistingData;
    }

    public boolean replaceExistingEntries() {
        return this.replaceExistingEntries;
    }

    public void setReplaceExistingEntries(boolean replaceExistingEntries) {
        this.replaceExistingEntries = replaceExistingEntries;
    }

    public boolean invokeImportPlugins() {
        return this.invokeImportPlugins;
    }

    public void setInvokeImportPlugins(boolean invokeImportPlugins) {
        this.invokeImportPlugins = invokeImportPlugins;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public void setCompressed(boolean isCompressed) {
        this.isCompressed = isCompressed;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public void setEncrypted(boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    public boolean clearBackend() {
        return this.clearBackend;
    }

    public void setClearBackend(boolean clearBackend) {
        this.clearBackend = clearBackend;
    }

    public boolean validateSchema() {
        return this.validateSchema;
    }

    public void setValidateSchema(boolean validateSchema) {
        this.validateSchema = validateSchema;
    }

    public List<DN> getExcludeBranches() {
        return this.excludeBranches;
    }

    public void setExcludeBranches(List<DN> excludeBranches) {
        this.excludeBranches = excludeBranches == null ? new ArrayList<DN>(0) : excludeBranches;
    }

    public List<DN> getIncludeBranches() {
        return this.includeBranches;
    }

    public void setIncludeBranches(List<DN> includeBranches) {
        this.includeBranches = includeBranches == null ? new ArrayList<DN>(0) : includeBranches;
    }

    public boolean includeEntry(DN dn) {
        if (!this.excludeBranches.isEmpty()) {
            for (DN excludeBranch : this.excludeBranches) {
                if (!excludeBranch.isAncestorOf(dn)) continue;
                return false;
            }
        }
        if (!this.includeBranches.isEmpty()) {
            for (DN includeBranch : this.includeBranches) {
                if (!includeBranch.isAncestorOf(dn)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean includeObjectClasses() {
        return this.includeObjectClasses;
    }

    public void setIncludeObjectClasses(boolean includeObjectClasses) {
        this.includeObjectClasses = includeObjectClasses;
    }

    public Set<AttributeType> getExcludeAttributes() {
        return this.excludeAttributes;
    }

    public void setExcludeAttributes(Set<AttributeType> excludeAttributes) {
        this.excludeAttributes = excludeAttributes == null ? new HashSet<AttributeType>(0) : excludeAttributes;
    }

    public Set<AttributeType> getIncludeAttributes() {
        return this.includeAttributes;
    }

    public void setIncludeAttributes(Set<AttributeType> includeAttributes) {
        this.includeAttributes = includeAttributes == null ? new HashSet<AttributeType>(0) : includeAttributes;
    }

    public boolean includeAttribute(AttributeType attributeType) {
        if (!this.excludeAttributes.isEmpty() && this.excludeAttributes.contains(attributeType)) {
            return false;
        }
        if (this.excludeAllOpAttrs && attributeType.isOperational() || this.excludeAllUserAttrs && !attributeType.isOperational()) {
            return false;
        }
        if (this.includeAllUserAttrs && !attributeType.isOperational() || this.includeAllOpAttrs && attributeType.isOperational()) {
            return true;
        }
        if (!this.includeAttributes.isEmpty()) {
            return this.includeAttributes.contains(attributeType);
        }
        return (!this.includeAllUserAttrs || !attributeType.isOperational()) && (!this.includeAllOpAttrs || attributeType.isOperational());
    }

    public List<SearchFilter> getExcludeFilters() {
        return this.excludeFilters;
    }

    public void setExcludeFilters(List<SearchFilter> excludeFilters) {
        this.excludeFilters = excludeFilters == null ? new ArrayList<SearchFilter>(0) : excludeFilters;
    }

    public List<SearchFilter> getIncludeFilters() {
        return this.includeFilters;
    }

    public void setIncludeFilters(List<SearchFilter> includeFilters) {
        this.includeFilters = includeFilters == null ? new ArrayList<SearchFilter>(0) : includeFilters;
    }

    public boolean includeEntry(Entry entry) throws DirectoryException {
        if (!this.excludeFilters.isEmpty()) {
            for (SearchFilter filter : this.excludeFilters) {
                if (!filter.matchesEntry(entry)) continue;
                return false;
            }
        }
        if (!this.includeFilters.isEmpty()) {
            for (SearchFilter filter : this.includeFilters) {
                if (!filter.matchesEntry(entry)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setExcludeAllUserAttributes(boolean excludeAllUserAttrs) {
        this.excludeAllUserAttrs = excludeAllUserAttrs;
    }

    public void setExcludeAllOperationalAttributes(boolean excludeAllOpAttrs) {
        this.excludeAllOpAttrs = excludeAllOpAttrs;
    }

    public void setIncludeAllOpAttributes(boolean includeAllOpAttrs) {
        this.includeAllOpAttrs = includeAllOpAttrs;
    }

    public void setIncludeAllUserAttributes(boolean includeAllUserAttrs) {
        this.includeAllUserAttrs = includeAllUserAttrs;
    }

    @Override
    public void close() {
        block11: {
            block10: {
                block9: {
                    if (this.reader != null) {
                        try {
                            this.reader.close();
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) break block9;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
                if (this.rejectWriter != null) {
                    try {
                        this.rejectWriter.close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block10;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
            if (this.skipWriter != null) {
                try {
                    this.skipWriter.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block11;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    public void setTmpDirectory(String path) {
        this.tmpDirectory = path;
    }

    public String getTmpDirectory() {
        return this.tmpDirectory;
    }

    public void setSkipDNValidation(boolean v) {
        this.skipDNValidation = v;
    }

    public boolean getSkipDNValidation() {
        return this.skipDNValidation;
    }

    public void setThreadCount(int c) {
        this.threadCount = c;
    }

    public int getThreadCount() {
        return this.threadCount;
    }
}

