/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryEnvironmentConfig;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class LockManager {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final boolean DEFAULT_FAIR_ORDERING = true;
    public static final int DEFAULT_INITIAL_TABLE_SIZE = 64;
    public static final int DEFAULT_CONCURRENCY_LEVEL = 32;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final long DEFAULT_TIMEOUT = 9000L;
    private static ConcurrentHashMap<DN, ReentrantReadWriteLock> lockTable;
    private static boolean fair;

    public static synchronized void reinitializeLockTable() {
        ConcurrentHashMap<DN, ReentrantReadWriteLock> oldTable = lockTable;
        DirectoryEnvironmentConfig environmentConfig = DirectoryServer.getEnvironmentConfig();
        lockTable = new ConcurrentHashMap(environmentConfig.getLockManagerTableSize(), 0.75f, environmentConfig.getLockManagerConcurrencyLevel());
        if (!oldTable.isEmpty()) {
            for (DN dn : oldTable.keySet()) {
                try {
                    ReentrantReadWriteLock lock = oldTable.get(dn);
                    if (lock.isWriteLocked()) {
                        TRACER.debugWarning("Found stale write lock on " + dn.toString());
                        continue;
                    }
                    if (lock.getReadLockCount() > 0) {
                        TRACER.debugWarning("Found stale read lock on " + dn.toString());
                        continue;
                    }
                    TRACER.debugWarning("Found stale unheld lock on " + dn.toString());
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            oldTable.clear();
        }
        fair = environmentConfig.getLockManagerFairOrdering();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Lock tryLockRead(DN entryDN) {
        ReentrantReadWriteLock entryLock = new ReentrantReadWriteLock(fair);
        ReentrantReadWriteLock.ReadLock readLock = entryLock.readLock();
        readLock.lock();
        ReentrantReadWriteLock existingLock = lockTable.putIfAbsent(entryDN, entryLock);
        if (existingLock == null) {
            return readLock;
        }
        if (existingLock.isWriteLocked()) {
            readLock.unlock();
            return null;
        }
        ReentrantReadWriteLock reentrantReadWriteLock = existingLock;
        synchronized (reentrantReadWriteLock) {
            ReentrantReadWriteLock existingLock2 = lockTable.putIfAbsent(entryDN, entryLock);
            if (existingLock2 == null) {
                return readLock;
            }
            if (existingLock == existingLock2) {
                readLock.unlock();
                readLock = existingLock.readLock();
                try {
                    if (readLock.tryLock(0L, TimeUnit.SECONDS)) {
                        return readLock;
                    }
                    return null;
                }
                catch (InterruptedException ie) {
                    return null;
                }
            }
            readLock.unlock();
            return null;
        }
    }

    public static Lock lockRead(DN entryDN) {
        return LockManager.lockRead(entryDN, 9000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Lock lockRead(DN entryDN, long timeout) {
        Lock readLock = LockManager.tryLockRead(entryDN);
        if (readLock != null) {
            return readLock;
        }
        ReentrantReadWriteLock entryLock = new ReentrantReadWriteLock(fair);
        readLock = entryLock.readLock();
        readLock.lock();
        ReentrantReadWriteLock existingLock = lockTable.putIfAbsent(entryDN, entryLock);
        if (existingLock == null) {
            return readLock;
        }
        long surrenderTime = System.currentTimeMillis() + timeout;
        readLock.unlock();
        readLock = existingLock.readLock();
        do {
            try {
                if (readLock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
                    ReentrantReadWriteLock reentrantReadWriteLock = existingLock;
                    synchronized (reentrantReadWriteLock) {
                        if (lockTable.get(entryDN) == existingLock) {
                            return readLock;
                        }
                        ReentrantReadWriteLock existingLock2 = lockTable.putIfAbsent(entryDN, existingLock);
                        if (existingLock2 == null) {
                            return readLock;
                        }
                        readLock.unlock();
                        existingLock = existingLock2;
                        readLock = existingLock.readLock();
                        continue;
                    }
                }
                return null;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        } while ((timeout = surrenderTime - System.currentTimeMillis()) > 0L);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Lock tryLockWrite(DN entryDN) {
        ReentrantReadWriteLock entryLock = new ReentrantReadWriteLock(fair);
        ReentrantReadWriteLock.WriteLock writeLock = entryLock.writeLock();
        writeLock.lock();
        ReentrantReadWriteLock existingLock = lockTable.putIfAbsent(entryDN, entryLock);
        if (existingLock == null) {
            return writeLock;
        }
        if (existingLock.getReadLockCount() > 0 || existingLock.isWriteLocked()) {
            writeLock.unlock();
            return null;
        }
        ReentrantReadWriteLock reentrantReadWriteLock = existingLock;
        synchronized (reentrantReadWriteLock) {
            ReentrantReadWriteLock existingLock2 = lockTable.putIfAbsent(entryDN, entryLock);
            if (existingLock2 == null) {
                return writeLock;
            }
            if (existingLock == existingLock2) {
                writeLock.unlock();
                writeLock = existingLock.writeLock();
                try {
                    if (writeLock.tryLock(0L, TimeUnit.SECONDS)) {
                        return writeLock;
                    }
                    return null;
                }
                catch (InterruptedException ie) {
                    return null;
                }
            }
            writeLock.unlock();
            return null;
        }
    }

    public static Lock lockWrite(DN entryDN) {
        return LockManager.lockWrite(entryDN, 9000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Lock lockWrite(DN entryDN, long timeout) {
        Lock writeLock = LockManager.tryLockWrite(entryDN);
        if (writeLock != null) {
            return writeLock;
        }
        ReentrantReadWriteLock entryLock = new ReentrantReadWriteLock(fair);
        writeLock = entryLock.writeLock();
        writeLock.lock();
        ReentrantReadWriteLock existingLock = lockTable.putIfAbsent(entryDN, entryLock);
        if (existingLock == null) {
            return writeLock;
        }
        long surrenderTime = System.currentTimeMillis() + timeout;
        writeLock.unlock();
        writeLock = existingLock.writeLock();
        do {
            try {
                if (writeLock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
                    ReentrantReadWriteLock reentrantReadWriteLock = existingLock;
                    synchronized (reentrantReadWriteLock) {
                        if (lockTable.get(entryDN) == existingLock) {
                            return writeLock;
                        }
                        ReentrantReadWriteLock existingLock2 = lockTable.putIfAbsent(entryDN, existingLock);
                        if (existingLock2 == null) {
                            return writeLock;
                        }
                        writeLock.unlock();
                        existingLock = existingLock2;
                        writeLock = existingLock.writeLock();
                        continue;
                    }
                }
                return null;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        } while ((timeout = surrenderTime - System.currentTimeMillis()) > 0L);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlock(DN entryDN, Lock lock) {
        ReentrantReadWriteLock existingLock = lockTable.get(entryDN);
        if (existingLock == null) {
            lock.unlock();
            return;
        }
        if (existingLock.hasQueuedThreads() || existingLock.getReadLockCount() > 1) {
            lock.unlock();
            return;
        }
        lock.unlock();
        ReentrantReadWriteLock reentrantReadWriteLock = existingLock;
        synchronized (reentrantReadWriteLock) {
            if (!existingLock.isWriteLocked() && existingLock.getReadLockCount() == 0) {
                lockTable.remove(entryDN, existingLock);
            }
        }
    }

    public static ReentrantReadWriteLock destroyLock(DN entryDN) {
        return lockTable.remove(entryDN);
    }

    public static int lockTableSize() {
        return lockTable.size();
    }

    static {
        DirectoryEnvironmentConfig environmentConfig = DirectoryServer.getEnvironmentConfig();
        lockTable = new ConcurrentHashMap(environmentConfig.getLockManagerTableSize(), 0.75f, environmentConfig.getLockManagerConcurrencyLevel());
        fair = environmentConfig.getLockManagerFairOrdering();
    }
}

