/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.IOException;
import java.io.InputStream;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;

public class RecordingInputStream
extends InputStream {
    private boolean enableRecording = false;
    private InputStream parentStream;
    private ByteStringBuilder buffer;

    public RecordingInputStream(InputStream parentStream) {
        this.parentStream = parentStream;
        this.buffer = new ByteStringBuilder(32);
    }

    @Override
    public int read() throws IOException {
        int readByte = this.parentStream.read();
        if (this.enableRecording) {
            this.buffer.append((byte)readByte);
        }
        return readByte;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        int bytesRead = this.parentStream.read(bytes);
        if (this.enableRecording) {
            this.buffer.append(bytes, 0, bytesRead);
        }
        return bytesRead;
    }

    @Override
    public int read(byte[] bytes, int i, int i1) throws IOException {
        int bytesRead = this.parentStream.read(bytes, i, i1);
        if (this.enableRecording) {
            this.buffer.append(bytes, i, bytesRead);
        }
        return bytesRead;
    }

    @Override
    public long skip(long l) throws IOException {
        return this.parentStream.skip(l);
    }

    @Override
    public int available() throws IOException {
        return this.parentStream.available();
    }

    @Override
    public void close() throws IOException {
        this.parentStream.close();
    }

    @Override
    public void mark(int i) {
        this.parentStream.mark(i);
    }

    @Override
    public void reset() throws IOException {
        this.parentStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.parentStream.markSupported();
    }

    public ByteString getRecordedBytes() {
        return this.buffer.toByteString();
    }

    public void clearRecordedBytes() {
        this.buffer.clear();
    }

    public boolean isRecordingEnabled() {
        return this.enableRecording;
    }

    public void setRecordingEnabled(boolean enabled) {
        this.enableRecording = enabled;
    }
}

