/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.FilterType;
import org.opends.server.types.MatchingRuleUse;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class SearchFilter {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final AttributeType attributeType;
    private final AttributeValue assertionValue;
    private final boolean dnAttributes;
    private final ByteString subFinalElement;
    private final ByteString subInitialElement;
    private final FilterType filterType;
    private final List<ByteString> subAnyElements;
    private final LinkedHashSet<SearchFilter> filterComponents;
    private final SearchFilter notComponent;
    private final Set<String> attributeOptions;
    private final String matchingRuleID;

    public SearchFilter(FilterType filterType, Collection<SearchFilter> filterComponents, SearchFilter notComponent, AttributeType attributeType, Set<String> attributeOptions, AttributeValue assertionValue, ByteString subInitialElement, List<ByteString> subAnyElements, ByteString subFinalElement, String matchingRuleID, boolean dnAttributes) {
        if (subAnyElements == null) {
            subAnyElements = new ArrayList<ByteString>(0);
        }
        if (filterComponents == null) {
            filterComponents = Collections.emptyList();
        }
        this.filterType = filterType;
        this.filterComponents = new LinkedHashSet<SearchFilter>(filterComponents);
        this.notComponent = notComponent;
        this.attributeType = attributeType;
        this.attributeOptions = attributeOptions;
        this.assertionValue = assertionValue;
        this.subInitialElement = subInitialElement;
        this.subAnyElements = subAnyElements;
        this.subFinalElement = subFinalElement;
        this.matchingRuleID = matchingRuleID;
        this.dnAttributes = dnAttributes;
    }

    public static SearchFilter createANDFilter(Collection<SearchFilter> filterComponents) {
        return new SearchFilter(FilterType.AND, filterComponents, null, null, null, null, null, null, null, null, false);
    }

    public static SearchFilter createORFilter(Collection<SearchFilter> filterComponents) {
        return new SearchFilter(FilterType.OR, filterComponents, null, null, null, null, null, null, null, null, false);
    }

    public static SearchFilter createNOTFilter(SearchFilter notComponent) {
        return new SearchFilter(FilterType.NOT, null, notComponent, null, null, null, null, null, null, null, false);
    }

    public static SearchFilter createEqualityFilter(AttributeType attributeType, AttributeValue assertionValue) {
        return new SearchFilter(FilterType.EQUALITY, null, null, attributeType, null, assertionValue, null, null, null, null, false);
    }

    public static SearchFilter createEqualityFilter(AttributeType attributeType, Set<String> attributeOptions, AttributeValue assertionValue) {
        return new SearchFilter(FilterType.EQUALITY, null, null, attributeType, attributeOptions, assertionValue, null, null, null, null, false);
    }

    public static SearchFilter createSubstringFilter(AttributeType attributeType, ByteString subInitialElement, List<ByteString> subAnyElements, ByteString subFinalElement) {
        return new SearchFilter(FilterType.SUBSTRING, null, null, attributeType, null, null, subInitialElement, subAnyElements, subFinalElement, null, false);
    }

    public static SearchFilter createSubstringFilter(AttributeType attributeType, Set<String> attributeOptions, ByteString subInitialElement, List<ByteString> subAnyElements, ByteString subFinalElement) {
        return new SearchFilter(FilterType.SUBSTRING, null, null, attributeType, attributeOptions, null, subInitialElement, subAnyElements, subFinalElement, null, false);
    }

    public static SearchFilter createGreaterOrEqualFilter(AttributeType attributeType, AttributeValue assertionValue) {
        return new SearchFilter(FilterType.GREATER_OR_EQUAL, null, null, attributeType, null, assertionValue, null, null, null, null, false);
    }

    public static SearchFilter createGreaterOrEqualFilter(AttributeType attributeType, Set<String> attributeOptions, AttributeValue assertionValue) {
        return new SearchFilter(FilterType.GREATER_OR_EQUAL, null, null, attributeType, attributeOptions, assertionValue, null, null, null, null, false);
    }

    public static SearchFilter createLessOrEqualFilter(AttributeType attributeType, AttributeValue assertionValue) {
        return new SearchFilter(FilterType.LESS_OR_EQUAL, null, null, attributeType, null, assertionValue, null, null, null, null, false);
    }

    public static SearchFilter createLessOrEqualFilter(AttributeType attributeType, Set<String> attributeOptions, AttributeValue assertionValue) {
        return new SearchFilter(FilterType.LESS_OR_EQUAL, null, null, attributeType, attributeOptions, assertionValue, null, null, null, null, false);
    }

    public static SearchFilter createPresenceFilter(AttributeType attributeType) {
        return new SearchFilter(FilterType.PRESENT, null, null, attributeType, null, null, null, null, null, null, false);
    }

    public static SearchFilter createPresenceFilter(AttributeType attributeType, Set<String> attributeOptions) {
        return new SearchFilter(FilterType.PRESENT, null, null, attributeType, attributeOptions, null, null, null, null, null, false);
    }

    public static SearchFilter createApproximateFilter(AttributeType attributeType, AttributeValue assertionValue) {
        return new SearchFilter(FilterType.APPROXIMATE_MATCH, null, null, attributeType, null, assertionValue, null, null, null, null, false);
    }

    public static SearchFilter createApproximateFilter(AttributeType attributeType, Set<String> attributeOptions, AttributeValue assertionValue) {
        return new SearchFilter(FilterType.APPROXIMATE_MATCH, null, null, attributeType, attributeOptions, assertionValue, null, null, null, null, false);
    }

    public static SearchFilter createExtensibleMatchFilter(AttributeType attributeType, AttributeValue assertionValue, String matchingRuleID, boolean dnAttributes) throws DirectoryException {
        if (attributeType == null && matchingRuleID == null) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_CREATE_EXTENSIBLE_MATCH_NO_AT_OR_MR.get();
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        return new SearchFilter(FilterType.EXTENSIBLE_MATCH, null, null, attributeType, null, assertionValue, null, null, null, matchingRuleID, dnAttributes);
    }

    public static SearchFilter createExtensibleMatchFilter(AttributeType attributeType, Set<String> attributeOptions, AttributeValue assertionValue, String matchingRuleID, boolean dnAttributes) throws DirectoryException {
        if (attributeType == null && matchingRuleID == null) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_CREATE_EXTENSIBLE_MATCH_NO_AT_OR_MR.get();
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        return new SearchFilter(FilterType.EXTENSIBLE_MATCH, null, null, attributeType, attributeOptions, assertionValue, null, null, null, matchingRuleID, dnAttributes);
    }

    public static SearchFilter createFilterFromString(String filterString) throws DirectoryException {
        if (filterString == null) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_NULL.get();
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        try {
            return SearchFilter.createFilterFromString(filterString, 0, filterString.length());
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            throw de;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = CoreMessages.ERR_SEARCH_FILTER_UNCAUGHT_EXCEPTION.get(filterString, String.valueOf(e));
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, e);
        }
    }

    private static SearchFilter createFilterFromString(String filterString, int startPos, int endPos) throws DirectoryException {
        ByteString userValue;
        String valueStr;
        int i;
        int attrEndPos;
        FilterType filterType;
        char c;
        int length = endPos - startPos;
        if (length <= 0) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_NULL.get();
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        if (filterString.charAt(startPos) == '(') {
            if (filterString.charAt(endPos - 1) == ')') {
                ++startPos;
                --endPos;
            } else {
                Message message = CoreMessages.ERR_SEARCH_FILTER_MISMATCHED_PARENTHESES.get(filterString, startPos, endPos);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
        }
        if ((c = filterString.charAt(startPos)) == '&') {
            return SearchFilter.decodeCompoundFilter(FilterType.AND, filterString, startPos + 1, endPos);
        }
        if (c == '|') {
            return SearchFilter.decodeCompoundFilter(FilterType.OR, filterString, startPos + 1, endPos);
        }
        if (c == '!') {
            return SearchFilter.decodeCompoundFilter(FilterType.NOT, filterString, startPos + 1, endPos);
        }
        int equalPos = -1;
        for (int i2 = startPos; i2 < endPos; ++i2) {
            if (filterString.charAt(i2) != '=') continue;
            equalPos = i2;
            break;
        }
        if (equalPos <= startPos) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_NO_EQUAL_SIGN.get(filterString, startPos, endPos);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        switch (filterString.charAt(equalPos - 1)) {
            case '~': {
                filterType = FilterType.APPROXIMATE_MATCH;
                attrEndPos = equalPos - 1;
                break;
            }
            case '>': {
                filterType = FilterType.GREATER_OR_EQUAL;
                attrEndPos = equalPos - 1;
                break;
            }
            case '<': {
                filterType = FilterType.LESS_OR_EQUAL;
                attrEndPos = equalPos - 1;
                break;
            }
            case ':': {
                return SearchFilter.decodeExtensibleMatchFilter(filterString, startPos, equalPos, endPos);
            }
            default: {
                filterType = FilterType.EQUALITY;
                attrEndPos = equalPos;
            }
        }
        String attrType = filterString.substring(startPos, attrEndPos);
        StringBuilder lowerType = new StringBuilder(attrType.length());
        HashSet<String> attributeOptions = new HashSet<String>();
        int semicolonPos = attrType.indexOf(59);
        if (semicolonPos < 0) {
            for (i = 0; i < attrType.length(); ++i) {
                lowerType.append(Character.toLowerCase(attrType.charAt(i)));
            }
        } else {
            for (i = 0; i < semicolonPos; ++i) {
                lowerType.append(Character.toLowerCase(attrType.charAt(i)));
            }
            int nextPos = attrType.indexOf(59, semicolonPos + 1);
            while (nextPos > 0) {
                attributeOptions.add(attrType.substring(semicolonPos + 1, nextPos));
                semicolonPos = nextPos;
                nextPos = attrType.indexOf(59, semicolonPos + 1);
            }
            attributeOptions.add(attrType.substring(semicolonPos + 1));
        }
        AttributeType attributeType = DirectoryServer.getAttributeType(lowerType.toString());
        if (attributeType == null) {
            String typeStr = attrType.substring(0, lowerType.length());
            attributeType = DirectoryServer.getDefaultAttributeType(typeStr);
        }
        if ((valueStr = filterString.substring(equalPos + 1, endPos)).length() == 0) {
            return new SearchFilter(filterType, null, null, attributeType, attributeOptions, AttributeValues.create(ByteString.empty(), ByteString.empty()), null, null, null, null, false);
        }
        if (valueStr.equals("*")) {
            return new SearchFilter(FilterType.PRESENT, null, null, attributeType, attributeOptions, null, null, null, null, null, false);
        }
        if (valueStr.indexOf(42) >= 0) {
            return SearchFilter.decodeSubstringFilter(filterString, attributeType, attributeOptions, equalPos, endPos);
        }
        boolean hasEscape = false;
        byte[] valueBytes = StaticUtils.getBytes(valueStr);
        for (int i3 = 0; i3 < valueBytes.length; ++i3) {
            if (valueBytes[i3] != 92) continue;
            hasEscape = true;
            break;
        }
        if (hasEscape) {
            ByteStringBuilder valueBuffer = new ByteStringBuilder(valueStr.length());
            for (int i4 = 0; i4 < valueBytes.length; ++i4) {
                if (valueBytes[i4] == 92) {
                    if (i4 + 2 >= valueBytes.length) {
                        Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i4 + 1);
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                    }
                    byte byteValue = 0;
                    switch (valueBytes[++i4]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            byteValue = 16;
                            break;
                        }
                        case 50: {
                            byteValue = 32;
                            break;
                        }
                        case 51: {
                            byteValue = 48;
                            break;
                        }
                        case 52: {
                            byteValue = 64;
                            break;
                        }
                        case 53: {
                            byteValue = 80;
                            break;
                        }
                        case 54: {
                            byteValue = 96;
                            break;
                        }
                        case 55: {
                            byteValue = 112;
                            break;
                        }
                        case 56: {
                            byteValue = -128;
                            break;
                        }
                        case 57: {
                            byteValue = -112;
                            break;
                        }
                        case 65: 
                        case 97: {
                            byteValue = -96;
                            break;
                        }
                        case 66: 
                        case 98: {
                            byteValue = -80;
                            break;
                        }
                        case 67: 
                        case 99: {
                            byteValue = -64;
                            break;
                        }
                        case 68: 
                        case 100: {
                            byteValue = -48;
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteValue = -32;
                            break;
                        }
                        case 70: 
                        case 102: {
                            byteValue = -16;
                            break;
                        }
                        default: {
                            Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i4 + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                        }
                    }
                    switch (valueBytes[++i4]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            byteValue = (byte)(byteValue | 1);
                            break;
                        }
                        case 50: {
                            byteValue = (byte)(byteValue | 2);
                            break;
                        }
                        case 51: {
                            byteValue = (byte)(byteValue | 3);
                            break;
                        }
                        case 52: {
                            byteValue = (byte)(byteValue | 4);
                            break;
                        }
                        case 53: {
                            byteValue = (byte)(byteValue | 5);
                            break;
                        }
                        case 54: {
                            byteValue = (byte)(byteValue | 6);
                            break;
                        }
                        case 55: {
                            byteValue = (byte)(byteValue | 7);
                            break;
                        }
                        case 56: {
                            byteValue = (byte)(byteValue | 8);
                            break;
                        }
                        case 57: {
                            byteValue = (byte)(byteValue | 9);
                            break;
                        }
                        case 65: 
                        case 97: {
                            byteValue = (byte)(byteValue | 0xA);
                            break;
                        }
                        case 66: 
                        case 98: {
                            byteValue = (byte)(byteValue | 0xB);
                            break;
                        }
                        case 67: 
                        case 99: {
                            byteValue = (byte)(byteValue | 0xC);
                            break;
                        }
                        case 68: 
                        case 100: {
                            byteValue = (byte)(byteValue | 0xD);
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteValue = (byte)(byteValue | 0xE);
                            break;
                        }
                        case 70: 
                        case 102: {
                            byteValue = (byte)(byteValue | 0xF);
                            break;
                        }
                        default: {
                            Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i4 + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                        }
                    }
                    valueBuffer.append(byteValue);
                    continue;
                }
                valueBuffer.append(valueBytes[i4]);
            }
            userValue = valueBuffer.toByteString();
        } else {
            userValue = ByteString.wrap(valueBytes);
        }
        AttributeValue value = AttributeValues.create(attributeType, userValue);
        return new SearchFilter(filterType, null, null, attributeType, attributeOptions, value, null, null, null, null, false);
    }

    private static SearchFilter decodeCompoundFilter(FilterType filterType, String filterString, int startPos, int endPos) throws DirectoryException {
        ArrayList<SearchFilter> filterComponents = new ArrayList<SearchFilter>();
        if (startPos == endPos) {
            if (filterType == FilterType.NOT) {
                Message message = CoreMessages.ERR_SEARCH_FILTER_NOT_EXACTLY_ONE.get(filterString, startPos, endPos);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            return new SearchFilter(filterType, filterComponents, null, null, null, null, null, null, null, null, false);
        }
        if (filterString.charAt(startPos) != '(' || filterString.charAt(endPos - 1) != ')') {
            Message message = CoreMessages.ERR_SEARCH_FILTER_COMPOUND_MISSING_PARENTHESES.get(filterString, startPos, endPos);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        int pendingOpens = 0;
        int openPos = -1;
        for (int i = startPos; i < endPos; ++i) {
            char c = filterString.charAt(i);
            if (c == '(') {
                if (openPos < 0) {
                    openPos = i;
                }
                ++pendingOpens;
                continue;
            }
            if (c == ')') {
                if (--pendingOpens == 0) {
                    filterComponents.add(SearchFilter.createFilterFromString(filterString, openPos, i + 1));
                    openPos = -1;
                    continue;
                }
                if (pendingOpens >= 0) continue;
                Message message = CoreMessages.ERR_SEARCH_FILTER_NO_CORRESPONDING_OPEN_PARENTHESIS.get(filterString, i);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            if (pendingOpens > 0) continue;
            Message message = CoreMessages.ERR_SEARCH_FILTER_COMPOUND_MISSING_PARENTHESES.get(filterString, startPos, endPos);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        if (pendingOpens != 0) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_NO_CORRESPONDING_CLOSE_PARENTHESIS.get(filterString, openPos);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        if (filterType == FilterType.NOT) {
            if (filterComponents.size() != 1) {
                Message message = CoreMessages.ERR_SEARCH_FILTER_NOT_EXACTLY_ONE.get(filterString, startPos, endPos);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            SearchFilter notComponent = (SearchFilter)filterComponents.get(0);
            return new SearchFilter(filterType, null, notComponent, null, null, null, null, null, null, null, false);
        }
        return new SearchFilter(filterType, filterComponents, null, null, null, null, null, null, null, null, false);
    }

    private static SearchFilter decodeSubstringFilter(String filterString, AttributeType attrType, Set<String> options, int equalPos, int endPos) throws DirectoryException {
        ByteString subFinal;
        ByteString subInitial;
        byte[] valueBytes = StaticUtils.getBytes(filterString.substring(equalPos + 1, endPos));
        boolean hasEscape = false;
        LinkedList<Integer> asteriskPositions = new LinkedList<Integer>();
        for (int i = 0; i < valueBytes.length; ++i) {
            if (valueBytes[i] == 42) {
                asteriskPositions.add(i);
                continue;
            }
            if (valueBytes[i] != 92) continue;
            hasEscape = true;
        }
        if (asteriskPositions.isEmpty()) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_SUBSTRING_NO_ASTERISKS.get(filterString, equalPos + 1, endPos);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        endPos = valueBytes.length;
        int firstPos = (Integer)asteriskPositions.removeFirst();
        if (firstPos == 0) {
            subInitial = null;
        } else if (hasEscape) {
            ByteStringBuilder buffer = new ByteStringBuilder(firstPos);
            for (int i = 0; i < firstPos; ++i) {
                if (valueBytes[i] == 92) {
                    if (i + 2 >= valueBytes.length) {
                        Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                    }
                    byte byteValue = 0;
                    switch (valueBytes[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            byteValue = 16;
                            break;
                        }
                        case 50: {
                            byteValue = 32;
                            break;
                        }
                        case 51: {
                            byteValue = 48;
                            break;
                        }
                        case 52: {
                            byteValue = 64;
                            break;
                        }
                        case 53: {
                            byteValue = 80;
                            break;
                        }
                        case 54: {
                            byteValue = 96;
                            break;
                        }
                        case 55: {
                            byteValue = 112;
                            break;
                        }
                        case 56: {
                            byteValue = -128;
                            break;
                        }
                        case 57: {
                            byteValue = -112;
                            break;
                        }
                        case 65: 
                        case 97: {
                            byteValue = -96;
                            break;
                        }
                        case 66: 
                        case 98: {
                            byteValue = -80;
                            break;
                        }
                        case 67: 
                        case 99: {
                            byteValue = -64;
                            break;
                        }
                        case 68: 
                        case 100: {
                            byteValue = -48;
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteValue = -32;
                            break;
                        }
                        case 70: 
                        case 102: {
                            byteValue = -16;
                            break;
                        }
                        default: {
                            Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                        }
                    }
                    switch (valueBytes[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            byteValue = (byte)(byteValue | 1);
                            break;
                        }
                        case 50: {
                            byteValue = (byte)(byteValue | 2);
                            break;
                        }
                        case 51: {
                            byteValue = (byte)(byteValue | 3);
                            break;
                        }
                        case 52: {
                            byteValue = (byte)(byteValue | 4);
                            break;
                        }
                        case 53: {
                            byteValue = (byte)(byteValue | 5);
                            break;
                        }
                        case 54: {
                            byteValue = (byte)(byteValue | 6);
                            break;
                        }
                        case 55: {
                            byteValue = (byte)(byteValue | 7);
                            break;
                        }
                        case 56: {
                            byteValue = (byte)(byteValue | 8);
                            break;
                        }
                        case 57: {
                            byteValue = (byte)(byteValue | 9);
                            break;
                        }
                        case 65: 
                        case 97: {
                            byteValue = (byte)(byteValue | 0xA);
                            break;
                        }
                        case 66: 
                        case 98: {
                            byteValue = (byte)(byteValue | 0xB);
                            break;
                        }
                        case 67: 
                        case 99: {
                            byteValue = (byte)(byteValue | 0xC);
                            break;
                        }
                        case 68: 
                        case 100: {
                            byteValue = (byte)(byteValue | 0xD);
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteValue = (byte)(byteValue | 0xE);
                            break;
                        }
                        case 70: 
                        case 102: {
                            byteValue = (byte)(byteValue | 0xF);
                            break;
                        }
                        default: {
                            Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                        }
                    }
                    buffer.append(byteValue);
                    continue;
                }
                buffer.append(valueBytes[i]);
            }
            subInitial = buffer.toByteString();
        } else {
            subInitial = ByteString.wrap(valueBytes, 0, firstPos);
        }
        ArrayList<ByteString> subAny = new ArrayList<ByteString>();
        Iterator i$ = asteriskPositions.iterator();
        while (i$.hasNext()) {
            int asteriskPos = (Integer)i$.next();
            int length = asteriskPos - firstPos - 1;
            if (hasEscape) {
                ByteStringBuilder buffer = new ByteStringBuilder(length);
                for (int i = firstPos + 1; i < asteriskPos; ++i) {
                    if (valueBytes[i] == 92) {
                        if (i + 2 >= valueBytes.length) {
                            Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                        }
                        byte byteValue = 0;
                        switch (valueBytes[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                byteValue = 16;
                                break;
                            }
                            case 50: {
                                byteValue = 32;
                                break;
                            }
                            case 51: {
                                byteValue = 48;
                                break;
                            }
                            case 52: {
                                byteValue = 64;
                                break;
                            }
                            case 53: {
                                byteValue = 80;
                                break;
                            }
                            case 54: {
                                byteValue = 96;
                                break;
                            }
                            case 55: {
                                byteValue = 112;
                                break;
                            }
                            case 56: {
                                byteValue = -128;
                                break;
                            }
                            case 57: {
                                byteValue = -112;
                                break;
                            }
                            case 65: 
                            case 97: {
                                byteValue = -96;
                                break;
                            }
                            case 66: 
                            case 98: {
                                byteValue = -80;
                                break;
                            }
                            case 67: 
                            case 99: {
                                byteValue = -64;
                                break;
                            }
                            case 68: 
                            case 100: {
                                byteValue = -48;
                                break;
                            }
                            case 69: 
                            case 101: {
                                byteValue = -32;
                                break;
                            }
                            case 70: 
                            case 102: {
                                byteValue = -16;
                                break;
                            }
                            default: {
                                Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                            }
                        }
                        switch (valueBytes[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                byteValue = (byte)(byteValue | 1);
                                break;
                            }
                            case 50: {
                                byteValue = (byte)(byteValue | 2);
                                break;
                            }
                            case 51: {
                                byteValue = (byte)(byteValue | 3);
                                break;
                            }
                            case 52: {
                                byteValue = (byte)(byteValue | 4);
                                break;
                            }
                            case 53: {
                                byteValue = (byte)(byteValue | 5);
                                break;
                            }
                            case 54: {
                                byteValue = (byte)(byteValue | 6);
                                break;
                            }
                            case 55: {
                                byteValue = (byte)(byteValue | 7);
                                break;
                            }
                            case 56: {
                                byteValue = (byte)(byteValue | 8);
                                break;
                            }
                            case 57: {
                                byteValue = (byte)(byteValue | 9);
                                break;
                            }
                            case 65: 
                            case 97: {
                                byteValue = (byte)(byteValue | 0xA);
                                break;
                            }
                            case 66: 
                            case 98: {
                                byteValue = (byte)(byteValue | 0xB);
                                break;
                            }
                            case 67: 
                            case 99: {
                                byteValue = (byte)(byteValue | 0xC);
                                break;
                            }
                            case 68: 
                            case 100: {
                                byteValue = (byte)(byteValue | 0xD);
                                break;
                            }
                            case 69: 
                            case 101: {
                                byteValue = (byte)(byteValue | 0xE);
                                break;
                            }
                            case 70: 
                            case 102: {
                                byteValue = (byte)(byteValue | 0xF);
                                break;
                            }
                            default: {
                                Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                            }
                        }
                        buffer.append(byteValue);
                        continue;
                    }
                    buffer.append(valueBytes[i]);
                }
                subAny.add(buffer.toByteString());
                buffer.clear();
            } else {
                subAny.add(ByteString.wrap(valueBytes, firstPos + 1, length));
            }
            firstPos = asteriskPos;
        }
        if (firstPos == endPos - 1) {
            subFinal = null;
        } else {
            int length = endPos - firstPos - 1;
            if (hasEscape) {
                ByteStringBuilder buffer = new ByteStringBuilder(length);
                for (int i = firstPos + 1; i < endPos; ++i) {
                    if (valueBytes[i] == 92) {
                        if (i + 2 >= valueBytes.length) {
                            Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                        }
                        byte byteValue = 0;
                        switch (valueBytes[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                byteValue = 16;
                                break;
                            }
                            case 50: {
                                byteValue = 32;
                                break;
                            }
                            case 51: {
                                byteValue = 48;
                                break;
                            }
                            case 52: {
                                byteValue = 64;
                                break;
                            }
                            case 53: {
                                byteValue = 80;
                                break;
                            }
                            case 54: {
                                byteValue = 96;
                                break;
                            }
                            case 55: {
                                byteValue = 112;
                                break;
                            }
                            case 56: {
                                byteValue = -128;
                                break;
                            }
                            case 57: {
                                byteValue = -112;
                                break;
                            }
                            case 65: 
                            case 97: {
                                byteValue = -96;
                                break;
                            }
                            case 66: 
                            case 98: {
                                byteValue = -80;
                                break;
                            }
                            case 67: 
                            case 99: {
                                byteValue = -64;
                                break;
                            }
                            case 68: 
                            case 100: {
                                byteValue = -48;
                                break;
                            }
                            case 69: 
                            case 101: {
                                byteValue = -32;
                                break;
                            }
                            case 70: 
                            case 102: {
                                byteValue = -16;
                                break;
                            }
                            default: {
                                Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                            }
                        }
                        switch (valueBytes[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                byteValue = (byte)(byteValue | 1);
                                break;
                            }
                            case 50: {
                                byteValue = (byte)(byteValue | 2);
                                break;
                            }
                            case 51: {
                                byteValue = (byte)(byteValue | 3);
                                break;
                            }
                            case 52: {
                                byteValue = (byte)(byteValue | 4);
                                break;
                            }
                            case 53: {
                                byteValue = (byte)(byteValue | 5);
                                break;
                            }
                            case 54: {
                                byteValue = (byte)(byteValue | 6);
                                break;
                            }
                            case 55: {
                                byteValue = (byte)(byteValue | 7);
                                break;
                            }
                            case 56: {
                                byteValue = (byte)(byteValue | 8);
                                break;
                            }
                            case 57: {
                                byteValue = (byte)(byteValue | 9);
                                break;
                            }
                            case 65: 
                            case 97: {
                                byteValue = (byte)(byteValue | 0xA);
                                break;
                            }
                            case 66: 
                            case 98: {
                                byteValue = (byte)(byteValue | 0xB);
                                break;
                            }
                            case 67: 
                            case 99: {
                                byteValue = (byte)(byteValue | 0xC);
                                break;
                            }
                            case 68: 
                            case 100: {
                                byteValue = (byte)(byteValue | 0xD);
                                break;
                            }
                            case 69: 
                            case 101: {
                                byteValue = (byte)(byteValue | 0xE);
                                break;
                            }
                            case 70: 
                            case 102: {
                                byteValue = (byte)(byteValue | 0xF);
                                break;
                            }
                            default: {
                                Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                            }
                        }
                        buffer.append(byteValue);
                        continue;
                    }
                    buffer.append(valueBytes[i]);
                }
                subFinal = buffer.toByteString();
            } else {
                subFinal = ByteString.wrap(valueBytes, firstPos + 1, length);
            }
        }
        return new SearchFilter(FilterType.SUBSTRING, null, null, attrType, options, null, subInitial, subAny, subFinal, null, false);
    }

    private static SearchFilter decodeExtensibleMatchFilter(String filterString, int startPos, int equalPos, int endPos) throws DirectoryException {
        AttributeValue value;
        ByteString userValue;
        AttributeType attributeType = null;
        HashSet<String> attributeOptions = new HashSet<String>();
        boolean dnAttributes = false;
        String matchingRuleID = null;
        String lowerLeftStr = StaticUtils.toLowerCase(filterString.substring(startPos, equalPos));
        if (filterString.charAt(startPos) == ':') {
            if (lowerLeftStr.startsWith(":dn:")) {
                dnAttributes = true;
                matchingRuleID = filterString.substring(startPos + 4, equalPos - 1);
            } else {
                matchingRuleID = filterString.substring(startPos + 1, equalPos - 1);
            }
        } else {
            int i;
            int colonPos = filterString.indexOf(58, startPos);
            if (colonPos < 0) {
                Message message = CoreMessages.ERR_SEARCH_FILTER_EXTENSIBLE_MATCH_NO_COLON.get(filterString, startPos);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            String attrType = filterString.substring(startPos, colonPos);
            StringBuilder lowerType = new StringBuilder(attrType.length());
            int semicolonPos = attrType.indexOf(59);
            if (semicolonPos < 0) {
                for (i = 0; i < attrType.length(); ++i) {
                    lowerType.append(Character.toLowerCase(attrType.charAt(i)));
                }
            } else {
                for (i = 0; i < semicolonPos; ++i) {
                    lowerType.append(Character.toLowerCase(attrType.charAt(i)));
                }
                int nextPos = attrType.indexOf(59, semicolonPos + 1);
                while (nextPos > 0) {
                    attributeOptions.add(attrType.substring(semicolonPos + 1, nextPos));
                    semicolonPos = nextPos;
                    nextPos = attrType.indexOf(59, semicolonPos + 1);
                }
                attributeOptions.add(attrType.substring(semicolonPos + 1));
            }
            attributeType = DirectoryServer.getAttributeType(lowerType.toString());
            if (attributeType == null) {
                String typeStr = attrType.substring(0, lowerType.length());
                attributeType = DirectoryServer.getDefaultAttributeType(typeStr);
            }
            if (colonPos < equalPos - 1) {
                if (lowerLeftStr.startsWith(":dn:", colonPos)) {
                    dnAttributes = true;
                    if (colonPos + 4 < equalPos - 1) {
                        matchingRuleID = filterString.substring(colonPos + 4, equalPos - 1);
                    }
                } else {
                    matchingRuleID = filterString.substring(colonPos + 1, equalPos - 1);
                }
            }
        }
        byte[] valueBytes = StaticUtils.getBytes(filterString.substring(equalPos + 1, endPos));
        boolean hasEscape = false;
        for (int i = 0; i < valueBytes.length; ++i) {
            if (valueBytes[i] != 92) continue;
            hasEscape = true;
            break;
        }
        if (hasEscape) {
            ByteStringBuilder valueBuffer = new ByteStringBuilder(valueBytes.length);
            for (int i = 0; i < valueBytes.length; ++i) {
                if (valueBytes[i] == 92) {
                    if (i + 2 >= valueBytes.length) {
                        Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                    }
                    byte byteValue = 0;
                    switch (valueBytes[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            byteValue = 16;
                            break;
                        }
                        case 50: {
                            byteValue = 32;
                            break;
                        }
                        case 51: {
                            byteValue = 48;
                            break;
                        }
                        case 52: {
                            byteValue = 64;
                            break;
                        }
                        case 53: {
                            byteValue = 80;
                            break;
                        }
                        case 54: {
                            byteValue = 96;
                            break;
                        }
                        case 55: {
                            byteValue = 112;
                            break;
                        }
                        case 56: {
                            byteValue = -128;
                            break;
                        }
                        case 57: {
                            byteValue = -112;
                            break;
                        }
                        case 65: 
                        case 97: {
                            byteValue = -96;
                            break;
                        }
                        case 66: 
                        case 98: {
                            byteValue = -80;
                            break;
                        }
                        case 67: 
                        case 99: {
                            byteValue = -64;
                            break;
                        }
                        case 68: 
                        case 100: {
                            byteValue = -48;
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteValue = -32;
                            break;
                        }
                        case 70: 
                        case 102: {
                            byteValue = -16;
                            break;
                        }
                        default: {
                            Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                        }
                    }
                    switch (valueBytes[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            byteValue = (byte)(byteValue | 1);
                            break;
                        }
                        case 50: {
                            byteValue = (byte)(byteValue | 2);
                            break;
                        }
                        case 51: {
                            byteValue = (byte)(byteValue | 3);
                            break;
                        }
                        case 52: {
                            byteValue = (byte)(byteValue | 4);
                            break;
                        }
                        case 53: {
                            byteValue = (byte)(byteValue | 5);
                            break;
                        }
                        case 54: {
                            byteValue = (byte)(byteValue | 6);
                            break;
                        }
                        case 55: {
                            byteValue = (byte)(byteValue | 7);
                            break;
                        }
                        case 56: {
                            byteValue = (byte)(byteValue | 8);
                            break;
                        }
                        case 57: {
                            byteValue = (byte)(byteValue | 9);
                            break;
                        }
                        case 65: 
                        case 97: {
                            byteValue = (byte)(byteValue | 0xA);
                            break;
                        }
                        case 66: 
                        case 98: {
                            byteValue = (byte)(byteValue | 0xB);
                            break;
                        }
                        case 67: 
                        case 99: {
                            byteValue = (byte)(byteValue | 0xC);
                            break;
                        }
                        case 68: 
                        case 100: {
                            byteValue = (byte)(byteValue | 0xD);
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteValue = (byte)(byteValue | 0xE);
                            break;
                        }
                        case 70: 
                        case 102: {
                            byteValue = (byte)(byteValue | 0xF);
                            break;
                        }
                        default: {
                            Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_ESCAPED_BYTE.get(filterString, equalPos + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                        }
                    }
                    valueBuffer.append(byteValue);
                    continue;
                }
                valueBuffer.append(valueBytes[i]);
            }
            userValue = valueBuffer.toByteString();
        } else {
            userValue = ByteString.wrap(valueBytes);
        }
        if (attributeType == null) {
            if (matchingRuleID == null) {
                Message message = CoreMessages.ERR_SEARCH_FILTER_EXTENSIBLE_MATCH_NO_AD_OR_MR.get(filterString, startPos);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            MatchingRule mr = DirectoryServer.getMatchingRule(StaticUtils.toLowerCase(matchingRuleID));
            if (mr == null) {
                Message message = CoreMessages.ERR_SEARCH_FILTER_EXTENSIBLE_MATCH_NO_SUCH_MR.get(filterString, startPos, matchingRuleID);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            value = AttributeValues.create(userValue, mr.normalizeValue(userValue));
        } else {
            value = AttributeValues.create(attributeType, userValue);
        }
        return new SearchFilter(FilterType.EXTENSIBLE_MATCH, null, null, attributeType, attributeOptions, value, null, null, null, matchingRuleID, dnAttributes);
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public Set<SearchFilter> getFilterComponents() {
        return this.filterComponents;
    }

    public SearchFilter getNotComponent() {
        return this.notComponent;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public AttributeValue getAssertionValue() {
        return this.assertionValue;
    }

    public ByteString getSubInitialElement() {
        return this.subInitialElement;
    }

    public List<ByteString> getSubAnyElements() {
        return this.subAnyElements;
    }

    public ByteString getSubFinalElement() {
        return this.subFinalElement;
    }

    public String getMatchingRuleID() {
        return this.matchingRuleID;
    }

    public boolean getDNAttributes() {
        return this.dnAttributes;
    }

    public boolean matchesEntry(Entry entry) throws DirectoryException {
        ConditionResult result = this.matchesEntryInternal(this, entry, 0);
        switch (result) {
            case TRUE: {
                return true;
            }
            case FALSE: 
            case UNDEFINED: {
                return false;
            }
        }
        Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_RESULT_TYPE.get(String.valueOf(entry.getDN()), this.toString(), String.valueOf((Object)result));
        ErrorLogger.logError(message);
        return false;
    }

    private ConditionResult matchesEntryInternal(SearchFilter completeFilter, Entry entry, int depth) throws DirectoryException {
        switch (this.filterType) {
            case AND: {
                return this.processAND(completeFilter, entry, depth);
            }
            case OR: {
                return this.processOR(completeFilter, entry, depth);
            }
            case NOT: {
                return this.processNOT(completeFilter, entry, depth);
            }
            case EQUALITY: {
                return this.processEquality(completeFilter, entry);
            }
            case SUBSTRING: {
                return this.processSubstring(completeFilter, entry);
            }
            case GREATER_OR_EQUAL: {
                return this.processGreaterOrEqual(completeFilter, entry);
            }
            case LESS_OR_EQUAL: {
                return this.processLessOrEqual(completeFilter, entry);
            }
            case PRESENT: {
                return this.processPresent(completeFilter, entry);
            }
            case APPROXIMATE_MATCH: {
                return this.processApproximate(completeFilter, entry);
            }
            case EXTENSIBLE_MATCH: {
                return this.processExtensibleMatch(completeFilter, entry);
            }
        }
        Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_FILTER_TYPE.get(String.valueOf(entry.getDN()), this.toString(), this.filterType.toString());
        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
    }

    private ConditionResult processAND(SearchFilter completeFilter, Entry entry, int depth) throws DirectoryException {
        if (this.filterComponents == null) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_COMPOUND_COMPONENTS_NULL.get(String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)this.filterType));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        if (this.filterComponents.isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning TRUE for LDAP TRUE filter (&)");
            }
            return ConditionResult.TRUE;
        }
        if (depth >= 100) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_NESTED_TOO_DEEP.get(String.valueOf(entry.getDN()), String.valueOf(completeFilter));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        block5: for (SearchFilter f : this.filterComponents) {
            ConditionResult result = f.matchesEntryInternal(completeFilter, entry, depth + 1);
            switch (result) {
                case TRUE: {
                    continue block5;
                }
                case FALSE: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Returning FALSE for AND component %s in filter %s for entry %s", f, completeFilter, entry.getDN());
                    }
                    return result;
                }
                case UNDEFINED: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Undefined result for AND component %s in filter %s for entry %s", f, completeFilter, entry.getDN());
                    }
                    return result;
                }
            }
            Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_RESULT_TYPE.get(String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)result));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("Returning TRUE for AND component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
        }
        return ConditionResult.TRUE;
    }

    private ConditionResult processOR(SearchFilter completeFilter, Entry entry, int depth) throws DirectoryException {
        if (this.filterComponents == null) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_COMPOUND_COMPONENTS_NULL.get(String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)this.filterType));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        if (this.filterComponents.isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning FALSE for LDAP FALSE filter (|)");
            }
            return ConditionResult.FALSE;
        }
        if (depth >= 100) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_NESTED_TOO_DEEP.get(String.valueOf(entry.getDN()), String.valueOf(completeFilter));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        ConditionResult result = ConditionResult.FALSE;
        block5: for (SearchFilter f : this.filterComponents) {
            switch (f.matchesEntryInternal(completeFilter, entry, depth + 1)) {
                case TRUE: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Returning TRUE for OR component %s in filter %s for entry %s", f, completeFilter, entry.getDN());
                    }
                    return ConditionResult.TRUE;
                }
                case FALSE: {
                    continue block5;
                }
                case UNDEFINED: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Undefined result for OR component %s in filter %s for entry %s", f, completeFilter, entry.getDN());
                    }
                    result = ConditionResult.UNDEFINED;
                    continue block5;
                }
            }
            Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_RESULT_TYPE.get(String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)result));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("Returning %s for OR component %s in filter %s for entry %s", new Object[]{result, this, completeFilter, entry.getDN()});
        }
        return result;
    }

    private ConditionResult processNOT(SearchFilter completeFilter, Entry entry, int depth) throws DirectoryException {
        if (this.notComponent == null) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_NOT_COMPONENT_NULL.get(String.valueOf(entry.getDN()), String.valueOf(completeFilter));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        if (depth >= 100) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_NESTED_TOO_DEEP.get(String.valueOf(entry.getDN()), String.valueOf(completeFilter));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        ConditionResult result = this.notComponent.matchesEntryInternal(completeFilter, entry, depth + 1);
        switch (result) {
            case TRUE: {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("Returning FALSE for NOT component %s in filter %s for entry %s", this.notComponent, completeFilter, entry.getDN());
                }
                return ConditionResult.FALSE;
            }
            case FALSE: {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("Returning TRUE for NOT component %s in filter %s for entry %s", this.notComponent, completeFilter, entry.getDN());
                }
                return ConditionResult.TRUE;
            }
            case UNDEFINED: {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Undefined result for NOT component %s in filter %s for entry %s", this.notComponent, completeFilter, entry.getDN());
                }
                return ConditionResult.UNDEFINED;
            }
        }
        Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_RESULT_TYPE.get(String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)result));
        throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
    }

    private ConditionResult processEquality(SearchFilter completeFilter, Entry entry) throws DirectoryException {
        if (this.attributeType == null) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_EQUALITY_NO_ATTRIBUTE_TYPE.get(String.valueOf(entry.getDN()), this.toString());
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        if (this.assertionValue == null) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_EQUALITY_NO_ASSERTION_VALUE.get(String.valueOf(entry.getDN()), this.toString(), this.attributeType.getNameOrOID());
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        List<Attribute> attrs = entry.getAttribute(this.attributeType, this.attributeOptions);
        if (attrs == null || attrs.isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("Returning FALSE for equality component %s in filter %s because entry %s didn't have attribute type %s", this, completeFilter, entry.getDN(), this.attributeType.getNameOrOID());
            }
            return ConditionResult.FALSE;
        }
        for (Attribute a : attrs) {
            if (!a.contains(this.assertionValue)) continue;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("Returning TRUE for equality component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
            }
            return ConditionResult.TRUE;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("Returning FALSE for equality component %s in filter %s because entry %s didn't have attribute type %s with value %s", this, completeFilter, entry.getDN(), this.attributeType.getNameOrOID(), this.assertionValue.getValue().toString());
        }
        return ConditionResult.FALSE;
    }

    private ConditionResult processSubstring(SearchFilter completeFilter, Entry entry) throws DirectoryException {
        if (this.attributeType == null) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_SUBSTRING_NO_ATTRIBUTE_TYPE.get(String.valueOf(entry.getDN()), this.toString());
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        if (this.subInitialElement == null && this.subFinalElement == null && (this.subAnyElements == null || this.subAnyElements.isEmpty())) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_SUBSTRING_NO_SUBSTRING_COMPONENTS.get(String.valueOf(entry.getDN()), this.toString(), this.attributeType.getNameOrOID());
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        List<Attribute> attrs = entry.getAttribute(this.attributeType, this.attributeOptions);
        if (attrs == null || attrs.isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("Returning FALSE for substring component %s in filter %s because entry %s didn't have attribute type %s", this, completeFilter, entry.getDN(), this.attributeType.getNameOrOID());
            }
            return ConditionResult.FALSE;
        }
        ConditionResult result = ConditionResult.FALSE;
        for (Attribute a : attrs) {
            switch (a.matchesSubstring(this.subInitialElement, this.subAnyElements, this.subFinalElement)) {
                case TRUE: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Returning TRUE for substring component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                    }
                    return ConditionResult.TRUE;
                }
                case FALSE: {
                    break;
                }
                case UNDEFINED: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Undefined result encountered for substring component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                    }
                    result = ConditionResult.UNDEFINED;
                    break;
                }
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("Returning %s for substring component %s in filter %s for entry %s", new Object[]{result, this, completeFilter, entry.getDN()});
        }
        return result;
    }

    private ConditionResult processGreaterOrEqual(SearchFilter completeFilter, Entry entry) throws DirectoryException {
        if (this.attributeType == null) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_GREATER_OR_EQUAL_NO_ATTRIBUTE_TYPE.get(String.valueOf(entry.getDN()), this.toString());
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        if (this.assertionValue == null) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_GREATER_OR_EQUAL_NO_VALUE.get(String.valueOf(entry.getDN()), this.toString(), this.attributeType.getNameOrOID());
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        List<Attribute> attrs = entry.getAttribute(this.attributeType, this.attributeOptions);
        if (attrs == null || attrs.isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("Returning FALSE for greater-or-equal component %s in filter %s because entry %s didn't have attribute type %s", this, completeFilter, entry.getDN(), this.attributeType.getNameOrOID());
            }
            return ConditionResult.FALSE;
        }
        ConditionResult result = ConditionResult.FALSE;
        for (Attribute a : attrs) {
            switch (a.greaterThanOrEqualTo(this.assertionValue)) {
                case TRUE: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Returning TRUE for greater-or-equal component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                    }
                    return ConditionResult.TRUE;
                }
                case FALSE: {
                    break;
                }
                case UNDEFINED: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Undefined result encountered for greater-or-equal component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                    }
                    result = ConditionResult.UNDEFINED;
                    break;
                }
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("Returning %s for greater-or-equal component %s in filter %s for entry %s", new Object[]{result, this, completeFilter, entry.getDN()});
        }
        return result;
    }

    private ConditionResult processLessOrEqual(SearchFilter completeFilter, Entry entry) throws DirectoryException {
        if (this.attributeType == null) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_LESS_OR_EQUAL_NO_ATTRIBUTE_TYPE.get(String.valueOf(entry.getDN()), this.toString());
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        if (this.assertionValue == null) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_LESS_OR_EQUAL_NO_ASSERTION_VALUE.get(String.valueOf(entry.getDN()), this.toString(), this.attributeType.getNameOrOID());
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        List<Attribute> attrs = entry.getAttribute(this.attributeType, this.attributeOptions);
        if (attrs == null || attrs.isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("Returning FALSE for less-or-equal component %s in filter %s because entry %s didn't have attribute type %s", this, completeFilter, entry.getDN(), this.attributeType.getNameOrOID());
            }
            return ConditionResult.FALSE;
        }
        ConditionResult result = ConditionResult.FALSE;
        for (Attribute a : attrs) {
            switch (a.lessThanOrEqualTo(this.assertionValue)) {
                case TRUE: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Returning TRUE for less-or-equal component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                    }
                    return ConditionResult.TRUE;
                }
                case FALSE: {
                    break;
                }
                case UNDEFINED: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Undefined result encountered for less-or-equal component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                    }
                    result = ConditionResult.UNDEFINED;
                    break;
                }
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("Returning %s for less-or-equal component %s in filter %s for entry %s", new Object[]{result, this, completeFilter, entry.getDN()});
        }
        return result;
    }

    private ConditionResult processPresent(SearchFilter completeFilter, Entry entry) throws DirectoryException {
        if (this.attributeType == null) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_PRESENCE_NO_ATTRIBUTE_TYPE.get(String.valueOf(entry.getDN()), this.toString());
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        if (entry.hasAttribute(this.attributeType, this.attributeOptions)) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("Returning TRUE for presence component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
            }
            return ConditionResult.TRUE;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("Returning FALSE for presence component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
        }
        return ConditionResult.FALSE;
    }

    private ConditionResult processApproximate(SearchFilter completeFilter, Entry entry) throws DirectoryException {
        if (this.attributeType == null) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_APPROXIMATE_NO_ATTRIBUTE_TYPE.get(String.valueOf(entry.getDN()), this.toString());
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        if (this.assertionValue == null) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_APPROXIMATE_NO_ASSERTION_VALUE.get(String.valueOf(entry.getDN()), this.toString(), this.attributeType.getNameOrOID());
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        List<Attribute> attrs = entry.getAttribute(this.attributeType, this.attributeOptions);
        if (attrs == null || attrs.isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("Returning FALSE for approximate component %s in filter %s because entry %s didn't have attribute type %s", this, completeFilter, entry.getDN(), this.attributeType.getNameOrOID());
            }
            return ConditionResult.FALSE;
        }
        ConditionResult result = ConditionResult.FALSE;
        for (Attribute a : attrs) {
            switch (a.approximatelyEqualTo(this.assertionValue)) {
                case TRUE: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Returning TRUE for approximate component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                    }
                    return ConditionResult.TRUE;
                }
                case FALSE: {
                    break;
                }
                case UNDEFINED: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Undefined result encountered for approximate component %s in filter %s for entry %s", this, completeFilter, entry.getDN());
                    }
                    result = ConditionResult.UNDEFINED;
                    break;
                }
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("Returning %s for approximate component %s in filter %s for entry %s", new Object[]{result, this, completeFilter, entry.getDN()});
        }
        return result;
    }

    private ConditionResult processExtensibleMatch(SearchFilter completeFilter, Entry entry) throws DirectoryException {
        ByteString normalizedValue;
        MatchingRuleUse mru;
        if (this.assertionValue == null) {
            Message message = CoreMessages.ERR_SEARCH_FILTER_EXTENSIBLE_MATCH_NO_ASSERTION_VALUE.get(String.valueOf(entry.getDN()), String.valueOf(completeFilter));
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
        }
        MatchingRule matchingRule = null;
        if (this.matchingRuleID != null) {
            matchingRule = DirectoryServer.getMatchingRule(StaticUtils.toLowerCase(this.matchingRuleID));
            if (matchingRule == null) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Unknown matching rule %s defined in extensibleMatch component of filter %s -- returning undefined.", this.matchingRuleID, this);
                }
                return ConditionResult.UNDEFINED;
            }
        } else {
            if (this.attributeType == null) {
                Message message = CoreMessages.ERR_SEARCH_FILTER_EXTENSIBLE_MATCH_NO_RULE_OR_TYPE.get(String.valueOf(entry.getDN()), String.valueOf(completeFilter));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            matchingRule = this.attributeType.getEqualityMatchingRule();
            if (matchingRule == null) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Attribute type %s does not have an equality matching rule -- returning undefined.", this.attributeType.getNameOrOID());
                }
                return ConditionResult.UNDEFINED;
            }
        }
        if (this.attributeType != null && (mru = DirectoryServer.getMatchingRuleUse(matchingRule)) != null && !mru.appliesToAttribute(this.attributeType)) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Attribute type %s is not allowed for use with matching rule %s because of matching rule use definition %s", this.attributeType.getNameOrOID(), matchingRule.getNameOrOID(), mru.getName());
            }
            return ConditionResult.UNDEFINED;
        }
        try {
            normalizedValue = matchingRule.normalizeAssertionValue(this.assertionValue.getValue());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return ConditionResult.UNDEFINED;
        }
        ConditionResult result = ConditionResult.FALSE;
        if (this.attributeType == null) {
            ConditionResult r;
            ByteString nv;
            for (List<Attribute> attrList : entry.getUserAttributes().values()) {
                for (Attribute a : attrList) {
                    for (AttributeValue v : a) {
                        try {
                            nv = matchingRule.normalizeValue(v.getValue());
                            r = matchingRule.valuesMatch(nv, normalizedValue);
                            switch (r) {
                                case TRUE: {
                                    return ConditionResult.TRUE;
                                }
                                case FALSE: {
                                    break;
                                }
                                case UNDEFINED: {
                                    result = ConditionResult.UNDEFINED;
                                    break;
                                }
                                default: {
                                    Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_RESULT_TYPE.get(String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)r));
                                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            result = ConditionResult.UNDEFINED;
                        }
                    }
                }
            }
            for (List<Attribute> attrList : entry.getOperationalAttributes().values()) {
                for (Attribute a : attrList) {
                    for (AttributeValue v : a) {
                        try {
                            nv = matchingRule.normalizeValue(v.getValue());
                            r = matchingRule.valuesMatch(nv, normalizedValue);
                            switch (r) {
                                case TRUE: {
                                    return ConditionResult.TRUE;
                                }
                                case FALSE: {
                                    break;
                                }
                                case UNDEFINED: {
                                    result = ConditionResult.UNDEFINED;
                                    break;
                                }
                                default: {
                                    Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_RESULT_TYPE.get(String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)r));
                                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            result = ConditionResult.UNDEFINED;
                        }
                    }
                }
            }
            Attribute a = entry.getObjectClassAttribute();
            for (AttributeValue v : a) {
                try {
                    ByteString nv2 = matchingRule.normalizeValue(v.getValue());
                    ConditionResult r2 = matchingRule.valuesMatch(nv2, normalizedValue);
                    switch (r2) {
                        case TRUE: {
                            return ConditionResult.TRUE;
                        }
                        case FALSE: {
                            break;
                        }
                        case UNDEFINED: {
                            result = ConditionResult.UNDEFINED;
                            break;
                        }
                        default: {
                            Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_RESULT_TYPE.get(String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)r2));
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                        }
                    }
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    result = ConditionResult.UNDEFINED;
                }
            }
        } else {
            List<Attribute> attrList = entry.getAttribute(this.attributeType, this.attributeOptions);
            if (attrList != null) {
                for (Attribute a : attrList) {
                    for (AttributeValue v : a) {
                        try {
                            ByteString nv = matchingRule.normalizeValue(v.getValue());
                            ConditionResult r = matchingRule.valuesMatch(nv, normalizedValue);
                            switch (r) {
                                case TRUE: {
                                    return ConditionResult.TRUE;
                                }
                                case FALSE: {
                                    break;
                                }
                                case UNDEFINED: {
                                    result = ConditionResult.UNDEFINED;
                                    break;
                                }
                                default: {
                                    Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_RESULT_TYPE.get(String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)r));
                                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            result = ConditionResult.UNDEFINED;
                        }
                    }
                }
            }
        }
        if (this.dnAttributes) {
            DN entryDN = entry.getDN();
            int count = entryDN.getNumComponents();
            for (int rdnIndex = 0; rdnIndex < count; ++rdnIndex) {
                RDN rdn = entryDN.getRDN(rdnIndex);
                int numAVAs = rdn.getNumValues();
                for (int i = 0; i < numAVAs; ++i) {
                    try {
                        if (this.attributeType != null && !this.attributeType.equals(rdn.getAttributeType(i))) continue;
                        AttributeValue v = rdn.getAttributeValue(i);
                        ByteString nv = matchingRule.normalizeValue(v.getValue());
                        ConditionResult r = matchingRule.valuesMatch(nv, normalizedValue);
                        switch (r) {
                            case TRUE: {
                                return ConditionResult.TRUE;
                            }
                            case FALSE: {
                                break;
                            }
                            case UNDEFINED: {
                                result = ConditionResult.UNDEFINED;
                                break;
                            }
                            default: {
                                Message message = CoreMessages.ERR_SEARCH_FILTER_INVALID_RESULT_TYPE.get(String.valueOf(entry.getDN()), String.valueOf(completeFilter), String.valueOf((Object)r));
                                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                            }
                        }
                        continue;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        result = ConditionResult.UNDEFINED;
                    }
                }
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchFilter)) {
            return false;
        }
        SearchFilter f = (SearchFilter)o;
        if (this.filterType != f.filterType) {
            return false;
        }
        switch (this.filterType) {
            case AND: 
            case OR: {
                if (this.filterComponents.size() != f.filterComponents.size()) {
                    return false;
                }
                block19: for (SearchFilter outerFilter : this.filterComponents) {
                    for (SearchFilter innerFilter : f.filterComponents) {
                        if (!outerFilter.equals(innerFilter)) continue;
                        continue block19;
                    }
                    return false;
                }
                return true;
            }
            case NOT: {
                return this.notComponent.equals(f.notComponent);
            }
            case EQUALITY: {
                return this.attributeType.equals(f.attributeType) && SearchFilter.optionsEqual(this.attributeOptions, f.attributeOptions) && ((Object)this.assertionValue).equals(f.assertionValue);
            }
            case SUBSTRING: {
                if (!this.attributeType.equals(f.attributeType)) {
                    return false;
                }
                SubstringMatchingRule smr = this.attributeType.getSubstringMatchingRule();
                if (smr == null) {
                    return false;
                }
                if (!SearchFilter.optionsEqual(this.attributeOptions, f.attributeOptions)) {
                    return false;
                }
                if (this.subInitialElement == null) {
                    if (f.subInitialElement != null) {
                        return false;
                    }
                } else {
                    if (f.subInitialElement == null) {
                        return false;
                    }
                    try {
                        ByteString nSI1 = smr.normalizeSubstring(this.subInitialElement);
                        ByteString nSI2 = smr.normalizeSubstring(f.subInitialElement);
                        if (!nSI1.equals(nSI2)) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                if (this.subFinalElement == null) {
                    if (f.subFinalElement != null) {
                        return false;
                    }
                } else {
                    if (f.subFinalElement == null) {
                        return false;
                    }
                    try {
                        ByteString nSF1 = smr.normalizeSubstring(this.subFinalElement);
                        ByteString nSF2 = smr.normalizeSubstring(f.subFinalElement);
                        if (!nSF1.equals(nSF2)) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                if (this.subAnyElements.size() != f.subAnyElements.size()) {
                    return false;
                }
                for (int i = 0; i < this.subAnyElements.size(); ++i) {
                    try {
                        ByteString nSA1 = smr.normalizeSubstring(this.subAnyElements.get(i));
                        ByteString nSA2 = smr.normalizeSubstring(f.subAnyElements.get(i));
                        if (nSA1.equals(nSA2)) continue;
                        return false;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                return true;
            }
            case GREATER_OR_EQUAL: {
                return this.attributeType.equals(f.attributeType) && SearchFilter.optionsEqual(this.attributeOptions, f.attributeOptions) && ((Object)this.assertionValue).equals(f.assertionValue);
            }
            case LESS_OR_EQUAL: {
                return this.attributeType.equals(f.attributeType) && SearchFilter.optionsEqual(this.attributeOptions, f.attributeOptions) && ((Object)this.assertionValue).equals(f.assertionValue);
            }
            case PRESENT: {
                return this.attributeType.equals(f.attributeType) && SearchFilter.optionsEqual(this.attributeOptions, f.attributeOptions);
            }
            case APPROXIMATE_MATCH: {
                return this.attributeType.equals(f.attributeType) && SearchFilter.optionsEqual(this.attributeOptions, f.attributeOptions) && ((Object)this.assertionValue).equals(f.assertionValue);
            }
            case EXTENSIBLE_MATCH: {
                if (this.attributeType == null) {
                    if (f.attributeType != null) {
                        return false;
                    }
                } else {
                    if (!this.attributeType.equals(f.attributeType)) {
                        return false;
                    }
                    if (!SearchFilter.optionsEqual(this.attributeOptions, f.attributeOptions)) {
                        return false;
                    }
                }
                if (this.dnAttributes != f.dnAttributes) {
                    return false;
                }
                if (this.matchingRuleID == null ? f.matchingRuleID != null : !this.matchingRuleID.equals(f.matchingRuleID)) {
                    return false;
                }
                if (this.assertionValue == null) {
                    if (f.assertionValue != null) {
                        return false;
                    }
                } else if (this.matchingRuleID == null) {
                    if (!((Object)this.assertionValue).equals(f.assertionValue)) {
                        return false;
                    }
                } else {
                    MatchingRule mr = DirectoryServer.getMatchingRule(StaticUtils.toLowerCase(this.matchingRuleID));
                    if (mr == null) {
                        return false;
                    }
                    try {
                        ConditionResult cr = mr.valuesMatch(mr.normalizeValue(this.assertionValue.getValue()), mr.normalizeValue(f.assertionValue.getValue()));
                        if (cr != ConditionResult.TRUE) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static boolean optionsEqual(Set<String> options1, Set<String> options2) {
        if (options1 == null || options1.isEmpty()) {
            return options2 == null || options2.isEmpty();
        }
        if (options2 == null || options2.isEmpty()) {
            return false;
        }
        if (options1.size() != options2.size()) {
            return false;
        }
        HashSet<String> lowerOptions = new HashSet<String>(options1.size());
        for (String option : options1) {
            lowerOptions.add(StaticUtils.toLowerCase(option));
        }
        for (String option : options2) {
            if (lowerOptions.remove(StaticUtils.toLowerCase(option))) continue;
            return false;
        }
        return lowerOptions.isEmpty();
    }

    public int hashCode() {
        switch (this.filterType) {
            case AND: 
            case OR: {
                int hashCode = 0;
                for (SearchFilter filterComp : this.filterComponents) {
                    hashCode += filterComp.hashCode();
                }
                return hashCode;
            }
            case NOT: {
                return this.notComponent.hashCode();
            }
            case EQUALITY: {
                return this.attributeType.hashCode() + ((Object)this.assertionValue).hashCode();
            }
            case SUBSTRING: {
                int hashCode = this.attributeType.hashCode();
                SubstringMatchingRule smr = this.attributeType.getSubstringMatchingRule();
                if (this.subInitialElement != null) {
                    if (smr == null) {
                        hashCode += this.subInitialElement.hashCode();
                    } else {
                        try {
                            hashCode += smr.normalizeSubstring(this.subInitialElement).hashCode();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (this.subAnyElements != null) {
                    for (ByteString e : this.subAnyElements) {
                        if (smr == null) {
                            hashCode += e.hashCode();
                            continue;
                        }
                        try {
                            hashCode += smr.normalizeSubstring(e).hashCode();
                        }
                        catch (Exception e2) {}
                    }
                }
                if (this.subFinalElement != null) {
                    if (smr == null) {
                        hashCode += this.subFinalElement.hashCode();
                    } else {
                        try {
                            hashCode += smr.normalizeSubstring(this.subFinalElement).hashCode();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                return hashCode;
            }
            case GREATER_OR_EQUAL: {
                return this.attributeType.hashCode() + ((Object)this.assertionValue).hashCode();
            }
            case LESS_OR_EQUAL: {
                return this.attributeType.hashCode() + ((Object)this.assertionValue).hashCode();
            }
            case PRESENT: {
                return this.attributeType.hashCode();
            }
            case APPROXIMATE_MATCH: {
                return this.attributeType.hashCode() + ((Object)this.assertionValue).hashCode();
            }
            case EXTENSIBLE_MATCH: {
                int hashCode = 0;
                if (this.attributeType != null) {
                    hashCode += this.attributeType.hashCode();
                }
                if (this.dnAttributes) {
                    ++hashCode;
                }
                if (this.matchingRuleID != null) {
                    hashCode += this.matchingRuleID.hashCode();
                }
                if (this.assertionValue != null) {
                    hashCode += ((Object)this.assertionValue).hashCode();
                }
                return hashCode;
            }
        }
        return 1;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        switch (this.filterType) {
            case AND: {
                buffer.append("(&");
                for (SearchFilter f : this.filterComponents) {
                    f.toString(buffer);
                }
                buffer.append(")");
                break;
            }
            case OR: {
                buffer.append("(|");
                for (SearchFilter f : this.filterComponents) {
                    f.toString(buffer);
                }
                buffer.append(")");
                break;
            }
            case NOT: {
                buffer.append("(!");
                this.notComponent.toString(buffer);
                buffer.append(")");
                break;
            }
            case EQUALITY: {
                buffer.append("(");
                buffer.append(this.attributeType.getNameOrOID());
                if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                    for (String option : this.attributeOptions) {
                        buffer.append(";");
                        buffer.append(option);
                    }
                }
                buffer.append("=");
                this.valueToFilterString(buffer, this.assertionValue.getValue());
                buffer.append(")");
                break;
            }
            case SUBSTRING: {
                buffer.append("(");
                buffer.append(this.attributeType.getNameOrOID());
                if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                    for (String option : this.attributeOptions) {
                        buffer.append(";");
                        buffer.append(option);
                    }
                }
                buffer.append("=");
                if (this.subInitialElement != null) {
                    this.valueToFilterString(buffer, this.subInitialElement);
                }
                if (this.subAnyElements != null && !this.subAnyElements.isEmpty()) {
                    for (ByteString s : this.subAnyElements) {
                        buffer.append("*");
                        this.valueToFilterString(buffer, s);
                    }
                }
                buffer.append("*");
                if (this.subFinalElement != null) {
                    this.valueToFilterString(buffer, this.subFinalElement);
                }
                buffer.append(")");
                break;
            }
            case GREATER_OR_EQUAL: {
                buffer.append("(");
                buffer.append(this.attributeType.getNameOrOID());
                if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                    for (String option : this.attributeOptions) {
                        buffer.append(";");
                        buffer.append(option);
                    }
                }
                buffer.append(">=");
                this.valueToFilterString(buffer, this.assertionValue.getValue());
                buffer.append(")");
                break;
            }
            case LESS_OR_EQUAL: {
                buffer.append("(");
                buffer.append(this.attributeType.getNameOrOID());
                if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                    for (String option : this.attributeOptions) {
                        buffer.append(";");
                        buffer.append(option);
                    }
                }
                buffer.append("<=");
                this.valueToFilterString(buffer, this.assertionValue.getValue());
                buffer.append(")");
                break;
            }
            case PRESENT: {
                buffer.append("(");
                buffer.append(this.attributeType.getNameOrOID());
                if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                    for (String option : this.attributeOptions) {
                        buffer.append(";");
                        buffer.append(option);
                    }
                }
                buffer.append("=*)");
                break;
            }
            case APPROXIMATE_MATCH: {
                buffer.append("(");
                buffer.append(this.attributeType.getNameOrOID());
                if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                    for (String option : this.attributeOptions) {
                        buffer.append(";");
                        buffer.append(option);
                    }
                }
                buffer.append("~=");
                this.valueToFilterString(buffer, this.assertionValue.getValue());
                buffer.append(")");
                break;
            }
            case EXTENSIBLE_MATCH: {
                buffer.append("(");
                if (this.attributeType != null) {
                    buffer.append(this.attributeType.getNameOrOID());
                    if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                        for (String option : this.attributeOptions) {
                            buffer.append(";");
                            buffer.append(option);
                        }
                    }
                }
                if (this.dnAttributes) {
                    buffer.append(":dn");
                }
                if (this.matchingRuleID != null) {
                    buffer.append(":");
                    buffer.append(this.matchingRuleID);
                }
                buffer.append(":=");
                this.valueToFilterString(buffer, this.assertionValue.getValue());
                buffer.append(")");
            }
        }
    }

    private void valueToFilterString(StringBuilder buffer, ByteString value) {
        if (value == null) {
            return;
        }
        buffer.ensureCapacity(buffer.length() + value.length());
        for (int i = 0; i < value.length(); ++i) {
            byte b = value.byteAt(i);
            if ((b & 0x7F) != b || b <= 31 || b == 40 || b == 41 || b == 42 || b == 92 || b == 127) {
                buffer.append("\\");
                buffer.append(StaticUtils.byteToHex(b));
                continue;
            }
            buffer.append((char)b);
        }
    }
}

