/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.opends.messages.Message;
import org.opends.messages.SchemaMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public final class SubtreeSpecification {
    private final DN baseDN;
    private final int minimumDepth;
    private final int maximumDepth;
    private final Map<DN, DN> chopBefore;
    private final Map<DN, DN> chopAfter;
    private final DN rootDN;
    private final DN relativeBaseDN;
    private final Refinement refinements;

    public static SubtreeSpecification valueOf(DN rootDN, String s) throws DirectoryException {
        DN relativeBaseDN = null;
        int minimum = -1;
        int maximum = -1;
        HashSet<DN> chopBefore = new HashSet<DN>();
        HashSet<DN> chopAfter = new HashSet<DN>();
        Refinement refinement = null;
        Parser parser = new Parser(s);
        boolean isValid = true;
        try {
            block22: {
                parser.skipLeftBrace();
                boolean isFirst = true;
                while (true) {
                    if (parser.hasNextRightBrace()) {
                        parser.skipRightBrace();
                        if (parser.hasNext()) {
                            throw new InputMismatchException();
                        }
                        break block22;
                    }
                    if (!isFirst) {
                        parser.skipSeparator();
                    } else {
                        isFirst = false;
                    }
                    String key = parser.nextKey();
                    if (key.equals("base")) {
                        if (relativeBaseDN != null) {
                            throw new InputMismatchException();
                        }
                        relativeBaseDN = DN.decode(parser.nextStringValue());
                        continue;
                    }
                    if (key.equals("minimum")) {
                        if (minimum != -1) {
                            throw new InputMismatchException();
                        }
                        minimum = parser.nextInt();
                        continue;
                    }
                    if (key.equals("maximum")) {
                        if (maximum != -1) {
                            throw new InputMismatchException();
                        }
                        maximum = parser.nextInt();
                        continue;
                    }
                    if (key.equals("specificationfilter")) {
                        if (refinement != null) {
                            throw new InputMismatchException();
                        }
                        try {
                            SearchFilter filter = SearchFilter.createFilterFromString(parser.nextStringValue());
                            refinement = new FilterRefinement(filter);
                        }
                        catch (InputMismatchException e) {
                            refinement = SubtreeSpecification.parseRefinement(parser);
                        }
                        continue;
                    }
                    if (!key.equals("specificexclusions")) break;
                    if (!chopBefore.isEmpty() || !chopAfter.isEmpty()) {
                        throw new InputMismatchException();
                    }
                    parser.nextSpecificExclusions(chopBefore, chopAfter);
                }
                throw new InputMismatchException();
            }
            if (minimum < 0) {
                minimum = 0;
            }
            if (maximum >= 0 && maximum < minimum) {
                isValid = false;
            }
        }
        catch (InputMismatchException e) {
            isValid = false;
        }
        catch (NoSuchElementException e) {
            isValid = false;
        }
        if (isValid) {
            return new SubtreeSpecification(rootDN, relativeBaseDN, minimum, maximum, chopBefore, chopAfter, refinement);
        }
        Message message = SchemaMessages.ERR_ATTR_SYNTAX_RFC3672_SUBTREE_SPECIFICATION_INVALID.get(s);
        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
    }

    private static Refinement parseRefinement(Parser parser) throws InputMismatchException, NoSuchElementException {
        String type = StaticUtils.toLowerCase(parser.nextName());
        parser.skipColon();
        if (type.equals("item")) {
            return new ItemRefinement(parser.nextName());
        }
        if (type.equals("not")) {
            Refinement refinement = SubtreeSpecification.parseRefinement(parser);
            return new NotRefinement(refinement);
        }
        if (type.equals("and")) {
            ArrayList<Refinement> refinements = SubtreeSpecification.parseRefinementSet(parser);
            return new AndRefinement(refinements);
        }
        if (type.equals("or")) {
            ArrayList<Refinement> refinements = SubtreeSpecification.parseRefinementSet(parser);
            return new OrRefinement(refinements);
        }
        throw new InputMismatchException();
    }

    private static ArrayList<Refinement> parseRefinementSet(Parser parser) throws InputMismatchException, NoSuchElementException {
        ArrayList<Refinement> refinements = new ArrayList<Refinement>();
        parser.skipLeftBrace();
        boolean isFirstValue = true;
        while (true) {
            if (parser.hasNextRightBrace()) break;
            if (!isFirstValue) {
                parser.skipSeparator();
            } else {
                isFirstValue = false;
            }
            Refinement refinement = SubtreeSpecification.parseRefinement(parser);
            refinements.add(refinement);
        }
        parser.skipRightBrace();
        return refinements;
    }

    public SubtreeSpecification(DN rootDN, DN relativeBaseDN, int minimumDepth, int maximumDepth, Iterable<DN> chopBefore, Iterable<DN> chopAfter, Refinement refinements) {
        TreeMap<DN, DN> map;
        this.baseDN = relativeBaseDN == null ? rootDN : rootDN.concat(relativeBaseDN);
        this.minimumDepth = minimumDepth;
        this.maximumDepth = maximumDepth;
        if (chopBefore != null && chopBefore.iterator().hasNext()) {
            map = new TreeMap<DN, DN>();
            for (DN localName : chopBefore) {
                map.put(this.baseDN.concat(localName), localName);
            }
            this.chopBefore = Collections.unmodifiableMap(map);
        } else {
            this.chopBefore = Collections.emptyMap();
        }
        if (chopAfter != null && chopAfter.iterator().hasNext()) {
            map = new TreeMap();
            for (DN localName : chopAfter) {
                map.put(this.baseDN.concat(localName), localName);
            }
            this.chopAfter = Collections.unmodifiableMap(map);
        } else {
            this.chopAfter = Collections.emptyMap();
        }
        this.rootDN = rootDN;
        this.relativeBaseDN = relativeBaseDN;
        this.refinements = refinements;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SubtreeSpecification) {
            SubtreeSpecification other = (SubtreeSpecification)obj;
            if (!this.commonComponentsEquals(other)) {
                return false;
            }
            if (!this.getBaseDN().equals(other.getBaseDN())) {
                return false;
            }
            if (this.refinements != null) {
                return this.refinements.equals(other.refinements);
            }
            return this.refinements == other.refinements;
        }
        return false;
    }

    public DN getBaseDN() {
        return this.baseDN;
    }

    public Iterable<DN> getChopAfter() {
        return this.chopAfter.values();
    }

    public Iterable<DN> getChopBefore() {
        return this.chopBefore.values();
    }

    public int getMaximumDepth() {
        return this.maximumDepth;
    }

    public int getMinimumDepth() {
        return this.minimumDepth;
    }

    public Refinement getRefinements() {
        return this.refinements;
    }

    public DN getRelativeBaseDN() {
        return this.relativeBaseDN;
    }

    public DN getRootDN() {
        return this.rootDN;
    }

    public int hashCode() {
        int hash = this.commonComponentsHashCode();
        hash = hash * 31 + this.getBaseDN().hashCode();
        if (this.refinements != null) {
            hash = hash * 31 + this.refinements.hashCode();
        }
        return hash;
    }

    public boolean isDNWithinScope(DN dn) {
        int entryRDNCount;
        if (!dn.isDescendantOf(this.baseDN)) {
            return false;
        }
        int baseRDNCount = this.baseDN.getNumComponents();
        if (this.minimumDepth > 0 && (entryRDNCount = dn.getNumComponents()) - baseRDNCount < this.minimumDepth) {
            return false;
        }
        if (this.maximumDepth >= 0 && (entryRDNCount = dn.getNumComponents()) - baseRDNCount > this.maximumDepth) {
            return false;
        }
        for (DN chopBeforeDN : this.chopBefore.keySet()) {
            if (!dn.isDescendantOf(chopBeforeDN)) continue;
            return false;
        }
        for (DN chopAfterDN : this.chopAfter.keySet()) {
            if (dn.equals(chopAfterDN) || !dn.isDescendantOf(chopAfterDN)) continue;
            return false;
        }
        return true;
    }

    public boolean isWithinScope(Entry entry) {
        if (this.isDNWithinScope(entry.getDN())) {
            if (this.refinements != null) {
                return this.refinements.matches(entry);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        return this.toString(builder).toString();
    }

    public StringBuilder toString(StringBuilder builder) {
        boolean isFirstElement = true;
        builder.append("{");
        if (this.relativeBaseDN != null && !this.relativeBaseDN.isNullDN()) {
            builder.append(" base ");
            StaticUtils.toRFC3641StringValue(builder, this.relativeBaseDN.toString());
            isFirstElement = false;
        }
        Iterable<DN> chopBefore = this.getChopBefore();
        Iterable<DN> chopAfter = this.getChopAfter();
        if (chopBefore.iterator().hasNext() || chopAfter.iterator().hasNext()) {
            if (!isFirstElement) {
                builder.append(",");
            } else {
                isFirstElement = false;
            }
            builder.append(" specificExclusions { ");
            boolean isFirst = true;
            for (DN dn : chopBefore) {
                if (!isFirst) {
                    builder.append(", chopBefore:");
                } else {
                    builder.append("chopBefore:");
                    isFirst = false;
                }
                StaticUtils.toRFC3641StringValue(builder, dn.toString());
            }
            for (DN dn : chopAfter) {
                if (!isFirst) {
                    builder.append(", chopAfter:");
                } else {
                    builder.append("chopAfter:");
                    isFirst = false;
                }
                StaticUtils.toRFC3641StringValue(builder, dn.toString());
            }
            builder.append(" }");
        }
        if (this.getMinimumDepth() > 0) {
            if (!isFirstElement) {
                builder.append(",");
            } else {
                isFirstElement = false;
            }
            builder.append(" minimum ");
            builder.append(this.getMinimumDepth());
        }
        if (this.getMaximumDepth() >= 0) {
            if (!isFirstElement) {
                builder.append(",");
            } else {
                isFirstElement = false;
            }
            builder.append(" maximum ");
            builder.append(this.getMaximumDepth());
        }
        if (this.refinements != null) {
            if (!isFirstElement) {
                builder.append(",");
            } else {
                isFirstElement = false;
            }
            builder.append(" specificationFilter ");
            this.refinements.toString(builder);
        }
        builder.append(" }");
        return builder;
    }

    private boolean commonComponentsEquals(SubtreeSpecification other) {
        if (this == other) {
            return true;
        }
        if (this.minimumDepth != other.minimumDepth) {
            return false;
        }
        if (this.maximumDepth != other.maximumDepth) {
            return false;
        }
        if (!((Object)this.chopBefore.values()).equals(other.chopBefore.values())) {
            return false;
        }
        return ((Object)this.chopAfter.values()).equals(other.chopAfter.values());
    }

    private int commonComponentsHashCode() {
        int hash = this.minimumDepth * 31 + this.maximumDepth;
        hash = hash * 31 + ((Object)this.chopBefore.values()).hashCode();
        hash = hash * 31 + ((Object)this.chopAfter.values()).hashCode();
        return hash;
    }

    protected static final class Parser {
        private final Scanner scanner;
        private static Pattern LBRACE = Pattern.compile("\\{.*");
        private static Pattern LBRACE_TOKEN = Pattern.compile("\\{");
        private static Pattern RBRACE = Pattern.compile("\\}.*");
        private static Pattern RBRACE_TOKEN = Pattern.compile("\\}");
        private static Pattern SEP = Pattern.compile(",.*");
        private static Pattern SEP_TOKEN = Pattern.compile(",");
        private static Pattern COLON = Pattern.compile(":.*");
        private static Pattern COLON_TOKEN = Pattern.compile(":");
        private static Pattern INT = Pattern.compile("\\d.*");
        private static Pattern INT_TOKEN = Pattern.compile("\\d+");
        private static Pattern NAME = Pattern.compile("[\\w_;-].*");
        private static Pattern NAME_TOKEN = Pattern.compile("[\\w_;-]+");
        private static Pattern STRING_VALUE = Pattern.compile("\".*");
        private static Pattern STRING_VALUE_TOKEN = Pattern.compile("\"([^\"]|(\"\"))*\"");

        public Parser(String value) {
            this.scanner = new Scanner(value);
        }

        public boolean hasNext() {
            return this.scanner.hasNext();
        }

        public boolean hasNextRightBrace() {
            return this.scanner.hasNext(RBRACE);
        }

        public int nextInt() throws InputMismatchException, NoSuchElementException {
            String s = this.nextValue(INT, INT_TOKEN);
            return Integer.parseInt(s);
        }

        public String nextKey() throws InputMismatchException, NoSuchElementException {
            return StaticUtils.toLowerCase(this.scanner.next());
        }

        public String nextName() throws InputMismatchException, NoSuchElementException {
            return this.nextValue(NAME, NAME_TOKEN);
        }

        public void nextSpecificExclusions(Set<DN> chopBefore, Set<DN> chopAfter) throws InputMismatchException, NoSuchElementException, DirectoryException {
            block4: {
                this.skipLeftBrace();
                boolean isFirstValue = true;
                while (true) {
                    if (this.hasNextRightBrace()) break block4;
                    if (!isFirstValue) {
                        this.skipSeparator();
                    } else {
                        isFirstValue = false;
                    }
                    String type = StaticUtils.toLowerCase(this.nextName());
                    this.skipColon();
                    if (type.equals("chopbefore")) {
                        chopBefore.add(DN.decode(this.nextStringValue()));
                        continue;
                    }
                    if (!type.equals("chopafter")) break;
                    chopAfter.add(DN.decode(this.nextStringValue()));
                }
                throw new InputMismatchException();
            }
            this.skipRightBrace();
        }

        public String nextStringValue() throws InputMismatchException, NoSuchElementException {
            String s = this.nextValue(STRING_VALUE, STRING_VALUE_TOKEN);
            return s.substring(1, s.length() - 1).replace("\"\"", "\"");
        }

        public void skipColon() throws InputMismatchException, NoSuchElementException {
            this.nextValue(COLON, COLON_TOKEN);
        }

        public void skipLeftBrace() throws InputMismatchException, NoSuchElementException {
            this.nextValue(LBRACE, LBRACE_TOKEN);
        }

        public void skipRightBrace() throws InputMismatchException, NoSuchElementException {
            this.nextValue(RBRACE, RBRACE_TOKEN);
        }

        public void skipSeparator() throws InputMismatchException, NoSuchElementException {
            this.nextValue(SEP, SEP_TOKEN);
        }

        private String nextValue(Pattern head, Pattern content) throws InputMismatchException, NoSuchElementException {
            if (!this.scanner.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.scanner.hasNext(head)) {
                throw new InputMismatchException();
            }
            String s = this.scanner.findInLine(content);
            if (s == null) {
                throw new InputMismatchException();
            }
            return s;
        }
    }

    public static abstract class Refinement {
        protected Refinement() {
        }

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        public abstract boolean matches(Entry var1);

        public final String toString() {
            StringBuilder builder = new StringBuilder();
            return this.toString(builder).toString();
        }

        public abstract StringBuilder toString(StringBuilder var1);
    }

    public static final class OrRefinement
    extends Refinement {
        private final Collection<Refinement> refinementSet;

        public OrRefinement(Collection<Refinement> refinementSet) {
            this.refinementSet = refinementSet;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AndRefinement) {
                AndRefinement other = (AndRefinement)obj;
                return ((Object)this.refinementSet).equals(other.refinementSet);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((Object)this.refinementSet).hashCode();
        }

        @Override
        public boolean matches(Entry entry) {
            for (Refinement refinement : this.refinementSet) {
                if (!refinement.matches(entry)) continue;
                return true;
            }
            return false;
        }

        @Override
        public StringBuilder toString(StringBuilder builder) {
            switch (this.refinementSet.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.refinementSet.iterator().next().toString(builder);
                    break;
                }
                default: {
                    builder.append("or:{");
                    Iterator<Refinement> iterator = this.refinementSet.iterator();
                    iterator.next().toString(builder);
                    while (iterator.hasNext()) {
                        builder.append(", ");
                        iterator.next().toString(builder);
                    }
                    builder.append("}");
                }
            }
            return builder;
        }
    }

    public static final class NotRefinement
    extends Refinement {
        private final Refinement refinement;

        public NotRefinement(Refinement refinement) {
            this.refinement = refinement;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof NotRefinement) {
                NotRefinement other = (NotRefinement)obj;
                return this.refinement.equals(other.refinement);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.refinement.hashCode();
        }

        @Override
        public boolean matches(Entry entry) {
            return !this.refinement.matches(entry);
        }

        @Override
        public StringBuilder toString(StringBuilder builder) {
            builder.append("not:");
            return this.refinement.toString(builder);
        }
    }

    public static final class ItemRefinement
    extends Refinement {
        private final String objectClass;
        private final String normalizedObjectClass;

        public ItemRefinement(String objectClass) {
            this.objectClass = objectClass;
            this.normalizedObjectClass = StaticUtils.toLowerCase(objectClass.trim());
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ItemRefinement) {
                ItemRefinement other = (ItemRefinement)obj;
                return this.normalizedObjectClass.equals(other.normalizedObjectClass);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.normalizedObjectClass.hashCode();
        }

        @Override
        public boolean matches(Entry entry) {
            ObjectClass oc = DirectoryServer.getObjectClass(this.normalizedObjectClass);
            if (oc == null) {
                return false;
            }
            return entry.hasObjectClass(oc);
        }

        @Override
        public StringBuilder toString(StringBuilder builder) {
            builder.append("item:");
            builder.append(this.objectClass);
            return builder;
        }
    }

    public static final class FilterRefinement
    extends Refinement {
        private final SearchFilter filter;

        public FilterRefinement(SearchFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof FilterRefinement) {
                FilterRefinement other = (FilterRefinement)obj;
                return this.filter.equals(other.filter);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.filter.hashCode();
        }

        @Override
        public boolean matches(Entry entry) {
            try {
                return this.filter.matchesEntry(entry);
            }
            catch (DirectoryException e) {
                return false;
            }
        }

        @Override
        public StringBuilder toString(StringBuilder builder) {
            StaticUtils.toRFC3641StringValue(builder, this.filter.toString());
            return builder;
        }
    }

    public static final class AndRefinement
    extends Refinement {
        private final Collection<Refinement> refinementSet;

        public AndRefinement(Collection<Refinement> refinementSet) {
            this.refinementSet = refinementSet;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AndRefinement) {
                AndRefinement other = (AndRefinement)obj;
                return ((Object)this.refinementSet).equals(other.refinementSet);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((Object)this.refinementSet).hashCode();
        }

        @Override
        public boolean matches(Entry entry) {
            for (Refinement refinement : this.refinementSet) {
                if (refinement.matches(entry)) continue;
                return false;
            }
            return true;
        }

        @Override
        public StringBuilder toString(StringBuilder builder) {
            switch (this.refinementSet.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.refinementSet.iterator().next().toString(builder);
                    break;
                }
                default: {
                    builder.append("and:{");
                    Iterator<Refinement> iterator = this.refinementSet.iterator();
                    iterator.next().toString(builder);
                    while (iterator.hasNext()) {
                        builder.append(", ");
                        iterator.next().toString(builder);
                    }
                    builder.append("}");
                }
            }
            return builder;
        }
    }
}

