/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opends.server.types.DN;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.RawModification;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.ChangeOperationType;
import org.opends.server.util.ChangeRecordEntry;
import org.opends.server.util.Validator;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class ModifyChangeRecordEntry
extends ChangeRecordEntry {
    private final List<RawModification> modifications;

    public ModifyChangeRecordEntry(DN dn, Collection<RawModification> modifications) {
        super(dn);
        Validator.ensureNotNull(modifications);
        this.modifications = new ArrayList<RawModification>(modifications);
    }

    public List<RawModification> getModifications() {
        return Collections.unmodifiableList(this.modifications);
    }

    @Override
    public ChangeOperationType getChangeOperationType() {
        return ChangeOperationType.MODIFY;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ModifyChangeRecordEntry(dn=\"");
        buffer.append(String.valueOf(this.getDN()));
        buffer.append("\", mods={");
        Iterator<RawModification> iterator = this.modifications.iterator();
        while (iterator.hasNext()) {
            RawModification mod = iterator.next();
            buffer.append(mod.getModificationType().getLDIFName());
            buffer.append(" ");
            buffer.append(mod.getAttribute().getAttributeType());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
        return buffer.toString();
    }
}

