/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.io.OutputStream;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.Validator;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class MultiOutputStream
extends OutputStream {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final OutputStream[] targetStreams;

    public MultiOutputStream(OutputStream ... targetStreams) {
        Validator.ensureNotNull(targetStreams);
        this.targetStreams = targetStreams;
    }

    @Override
    public void close() {
        for (OutputStream s : this.targetStreams) {
            try {
                s.close();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public void flush() {
        for (OutputStream s : this.targetStreams) {
            try {
                s.flush();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public void write(byte[] b) {
        for (OutputStream s : this.targetStreams) {
            try {
                s.write(b);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        for (OutputStream s : this.targetStreams) {
            try {
                s.write(b, off, len);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public void write(int b) {
        for (OutputStream s : this.targetStreams) {
            try {
                s.write(b);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }
}

