/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement.localbackend;

import java.util.List;
import java.util.concurrent.locks.Lock;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageDescriptor;
import org.opends.server.admin.std.meta.PasswordPolicyCfgDefn;
import org.opends.server.api.AuthenticationPolicyState;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.controls.AuthorizationIdentityResponseControl;
import org.opends.server.controls.PasswordExpiredControl;
import org.opends.server.controls.PasswordExpiringControl;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyResponseControl;
import org.opends.server.controls.PasswordPolicyWarningType;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.BindOperation;
import org.opends.server.core.BindOperationWrapper;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AccountStatusNotification;
import org.opends.server.types.AccountStatusNotificationType;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LockManager;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.types.WritabilityMode;
import org.opends.server.types.operation.PostOperationBindOperation;
import org.opends.server.types.operation.PostResponseBindOperation;
import org.opends.server.types.operation.PreOperationBindOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.workflowelement.localbackend.LocalBackendWorkflowElement;

public class LocalBackendBindOperation
extends BindOperationWrapper
implements PreOperationBindOperation,
PostOperationBindOperation,
PostResponseBindOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    protected Backend backend;
    protected boolean isFirstWarning;
    protected boolean isGraceLogin;
    private boolean mustChangePassword;
    private boolean pwPolicyControlRequested;
    private boolean returnAuthzID;
    protected boolean executePostOpPlugins;
    private ClientConnection clientConnection;
    protected DN bindDN;
    private int lookthroughLimit;
    private int pwPolicyWarningValue;
    private int sizeLimit;
    private int timeLimit;
    private long idleTimeLimit;
    private AuthenticationPolicyState authPolicyState;
    private PasswordPolicyErrorType pwPolicyErrorType;
    private PasswordPolicyWarningType pwPolicyWarningType;
    protected PluginConfigManager pluginConfigManager;
    private String saslMechanism;

    public LocalBackendBindOperation(BindOperation bind) {
        super(bind);
        LocalBackendWorkflowElement.attachLocalOperation(bind, this);
    }

    public void processLocalBind(LocalBackendWorkflowElement wfe) {
        PluginResult.PostOperation postOpResult;
        this.backend = wfe.getBackend();
        this.clientConnection = this.getClientConnection();
        this.returnAuthzID = false;
        this.executePostOpPlugins = false;
        this.sizeLimit = DirectoryServer.getSizeLimit();
        this.timeLimit = DirectoryServer.getTimeLimit();
        this.lookthroughLimit = DirectoryServer.getLookthroughLimit();
        this.idleTimeLimit = DirectoryServer.getIdleTimeLimit();
        this.bindDN = this.getBindDN();
        this.saslMechanism = this.getSASLMechanism();
        this.authPolicyState = null;
        this.pwPolicyErrorType = null;
        this.pwPolicyControlRequested = false;
        this.isGraceLogin = false;
        this.isFirstWarning = false;
        this.mustChangePassword = false;
        this.pwPolicyWarningType = null;
        this.pwPolicyWarningValue = -1;
        this.pluginConfigManager = DirectoryServer.getPluginConfigManager();
        this.processBind();
        try {
            if (this.authPolicyState != null) {
                this.authPolicyState.finalizeStateAfterBind();
            }
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            this.setResponseData(de);
        }
        if (this.executePostOpPlugins && !(postOpResult = this.pluginConfigManager.invokePostOperationBindPlugins(this)).continueProcessing()) {
            this.setResultCode(postOpResult.getResultCode());
            this.appendErrorMessage(postOpResult.getErrorMessage());
            this.setMatchedDN(postOpResult.getMatchedDN());
            this.setReferralURLs(postOpResult.getReferralURLs());
        }
        AuthenticationInfo authInfo = this.getAuthenticationInfo();
        if (this.getResultCode() == ResultCode.SUCCESS && authInfo != null) {
            this.clientConnection.setAuthenticationInfo(authInfo);
            this.clientConnection.setSizeLimit(this.sizeLimit);
            this.clientConnection.setTimeLimit(this.timeLimit);
            this.clientConnection.setIdleTimeLimit(this.idleTimeLimit);
            this.clientConnection.setLookthroughLimit(this.lookthroughLimit);
            this.clientConnection.setMustChangePassword(this.mustChangePassword);
            if (this.returnAuthzID) {
                this.addResponseControl(new AuthorizationIdentityResponseControl(authInfo.getAuthorizationDN()));
            }
        }
        if (this.getResultCode() == ResultCode.SUCCESS) {
            if (this.pwPolicyControlRequested) {
                PasswordPolicyResponseControl pwpControl = new PasswordPolicyResponseControl(this.pwPolicyWarningType, this.pwPolicyWarningValue, this.pwPolicyErrorType);
                this.addResponseControl(pwpControl);
            } else if (this.pwPolicyErrorType == PasswordPolicyErrorType.PASSWORD_EXPIRED) {
                this.addResponseControl(new PasswordExpiredControl());
            } else if (this.pwPolicyWarningType == PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION) {
                this.addResponseControl(new PasswordExpiringControl(this.pwPolicyWarningValue));
            } else if (this.mustChangePassword) {
                this.addResponseControl(new PasswordExpiredControl());
            }
        } else if (this.pwPolicyControlRequested) {
            PasswordPolicyResponseControl pwpControl = new PasswordPolicyResponseControl(this.pwPolicyWarningType, this.pwPolicyWarningValue, this.pwPolicyErrorType);
            this.addResponseControl(pwpControl);
        } else if (this.pwPolicyErrorType == PasswordPolicyErrorType.PASSWORD_EXPIRED) {
            this.addResponseControl(new PasswordExpiredControl());
        }
    }

    private void processBind() {
        try {
            if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this)) {
                this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                this.setAuthFailureReason(CoreMessages.ERR_BIND_AUTHZ_INSUFFICIENT_ACCESS_RIGHTS.get());
                return;
            }
        }
        catch (DirectoryException e) {
            this.setResultCode(e.getResultCode());
            this.setAuthFailureReason(e.getMessageObject());
            return;
        }
        try {
            this.handleRequestControls();
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            this.setResponseData(de);
            return;
        }
        try {
            switch (this.getAuthenticationType()) {
                case SIMPLE: {
                    this.processSimpleBind();
                    break;
                }
                case SASL: {
                    this.processSASLBind();
                    break;
                }
                default: {
                    this.setResultCode(ResultCode.PROTOCOL_ERROR);
                    break;
                }
            }
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            if (de.getResultCode() == ResultCode.INVALID_CREDENTIALS) {
                this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                this.setAuthFailureReason(de.getMessageObject());
            }
            this.setResponseData(de);
        }
    }

    private void handleRequestControls() throws DirectoryException {
        LocalBackendWorkflowElement.removeAllDisallowedControls(this.bindDN, this);
        List<Control> requestControls = this.getRequestControls();
        if (requestControls != null && !requestControls.isEmpty()) {
            for (int i = 0; i < requestControls.size(); ++i) {
                Control c = requestControls.get(i);
                String oid = c.getOID();
                if (oid.equals("2.16.840.1.113730.3.4.16")) {
                    this.returnAuthzID = true;
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.42.2.27.8.5.1")) {
                    this.pwPolicyControlRequested = true;
                    continue;
                }
                if (!c.isCritical()) continue;
                throw new DirectoryException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, CoreMessages.ERR_BIND_UNSUPPORTED_CRITICAL_CONTROL.get(oid));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processSimpleBind() throws DirectoryException {
        Lock userLock;
        ByteString simplePassword = this.getSimplePassword();
        if (simplePassword == null || simplePassword.length() == 0) {
            return this.processAnonymousSimpleBind();
        }
        DN actualRootDN = DirectoryServer.getActualRootBindDN(this.bindDN);
        if (actualRootDN != null) {
            this.bindDN = actualRootDN;
        }
        if ((userLock = LockManager.lockRead(this.bindDN)) == null) {
            throw new DirectoryException(ResultCode.BUSY, CoreMessages.ERR_BIND_OPERATION_CANNOT_LOCK_USER.get(String.valueOf(this.bindDN)));
        }
        try {
            Entry userEntry2;
            try {
                userEntry2 = this.backend.getEntry(this.bindDN);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                Object userEntry2 = null;
                if (de.getResultCode() == ResultCode.REFERRAL) {
                    throw de;
                }
                throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, de.getMessageObject());
            }
            if (userEntry2 == null) {
                throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_OPERATION_UNKNOWN_USER.get());
            }
            this.setUserEntryDN(userEntry2.getDN());
            this.authPolicyState = AuthenticationPolicyState.forUser(userEntry2, false);
            if (this.authPolicyState.isPasswordPolicy()) {
                PasswordPolicyState pwPolicyState = (PasswordPolicyState)this.authPolicyState;
                PasswordPolicy policy = pwPolicyState.getAuthenticationPolicy();
                AttributeType pwType = policy.getPasswordAttribute();
                List<Attribute> pwAttr = userEntry2.getAttribute(pwType);
                if (pwAttr == null || pwAttr.isEmpty()) {
                    throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_OPERATION_NO_PASSWORD.get());
                }
                this.checkPasswordPolicyState(userEntry2, null);
                if (!this.invokePreOpPlugins()) {
                    boolean bl = false;
                    return bl;
                }
                if (pwPolicyState.passwordMatches(simplePassword)) {
                    this.setResultCode(ResultCode.SUCCESS);
                    if (DirectoryServer.lockdownMode() && !ClientConnection.hasPrivilege(userEntry2, Privilege.BYPASS_LOCKDOWN)) {
                        throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_REJECTED_LOCKDOWN_MODE.get());
                    }
                    this.setAuthenticationInfo(new AuthenticationInfo(userEntry2, this.getBindDN(), DirectoryServer.isRootDN(userEntry2.getDN())));
                    this.setResourceLimits(userEntry2);
                    pwPolicyState.handleDeprecatedStorageSchemes(simplePassword);
                    pwPolicyState.clearFailureLockout();
                    if (this.isFirstWarning) {
                        pwPolicyState.setWarnedTime();
                        int numSeconds = pwPolicyState.getSecondsUntilExpiration();
                        Message m = CoreMessages.WARN_BIND_PASSWORD_EXPIRING.get(StaticUtils.secondsToTimeString(numSeconds));
                        pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRING, userEntry2, m, AccountStatusNotification.createProperties(pwPolicyState, false, numSeconds, null, null));
                    }
                    if (this.isGraceLogin) {
                        pwPolicyState.updateGraceLoginTimes();
                    }
                    pwPolicyState.setLastLoginTime();
                } else {
                    this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    this.setAuthFailureReason(CoreMessages.ERR_BIND_OPERATION_WRONG_PASSWORD.get());
                    if (policy.getLockoutFailureCount() > 0) {
                        this.generateAccountStatusNotificationForLockedBindAccount(userEntry2, pwPolicyState);
                    }
                }
            } else {
                if (this.authPolicyState.isDisabled()) {
                    throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_OPERATION_ACCOUNT_DISABLED.get());
                }
                if (!this.invokePreOpPlugins()) {
                    boolean bl = false;
                    return bl;
                }
                if (this.authPolicyState.passwordMatches(simplePassword)) {
                    this.setResultCode(ResultCode.SUCCESS);
                    if (DirectoryServer.lockdownMode() && !ClientConnection.hasPrivilege(userEntry2, Privilege.BYPASS_LOCKDOWN)) {
                        throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_REJECTED_LOCKDOWN_MODE.get());
                    }
                    this.setAuthenticationInfo(new AuthenticationInfo(userEntry2, this.getBindDN(), DirectoryServer.isRootDN(userEntry2.getDN())));
                    this.setResourceLimits(userEntry2);
                } else {
                    this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    this.setAuthFailureReason(CoreMessages.ERR_BIND_OPERATION_WRONG_PASSWORD.get());
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            LockManager.unlock(this.bindDN, userLock);
        }
    }

    protected boolean processAnonymousSimpleBind() throws DirectoryException {
        if (DirectoryServer.lockdownMode()) {
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_REJECTED_LOCKDOWN_MODE.get());
        }
        if (DirectoryServer.bindWithDNRequiresPassword() && this.bindDN != null && !this.bindDN.isNullDN()) {
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_BIND_DN_BUT_NO_PASSWORD.get());
        }
        if (!this.invokePreOpPlugins()) {
            return false;
        }
        this.setResultCode(ResultCode.SUCCESS);
        this.setAuthenticationInfo(new AuthenticationInfo());
        return true;
    }

    private boolean processSASLBind() throws DirectoryException {
        ResultCode resultCode;
        SASLMechanismHandler saslHandler = DirectoryServer.getSASLMechanismHandler(this.saslMechanism);
        if (saslHandler == null) {
            throw new DirectoryException(ResultCode.AUTH_METHOD_NOT_SUPPORTED, CoreMessages.ERR_BIND_OPERATION_UNKNOWN_SASL_MECHANISM.get(this.saslMechanism));
        }
        if (!this.invokePreOpPlugins()) {
            return false;
        }
        saslHandler.processSASLBind(this);
        Entry saslAuthUserEntry = this.getSASLAuthUserEntry();
        if (DirectoryServer.lockdownMode() && (resultCode = this.getResultCode()) != ResultCode.SASL_BIND_IN_PROGRESS && (resultCode != ResultCode.SUCCESS || saslAuthUserEntry == null || !ClientConnection.hasPrivilege(saslAuthUserEntry, Privilege.BYPASS_LOCKDOWN))) {
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_REJECTED_LOCKDOWN_MODE.get());
        }
        if (saslAuthUserEntry != null) {
            this.setUserEntryDN(saslAuthUserEntry.getDN());
            this.authPolicyState = AuthenticationPolicyState.forUser(saslAuthUserEntry, false);
            if (this.authPolicyState.isPasswordPolicy()) {
                this.checkPasswordPolicyState(saslAuthUserEntry, saslHandler);
            }
        }
        if ((resultCode = this.getResultCode()) == ResultCode.SUCCESS) {
            if (this.authPolicyState != null && this.authPolicyState.isPasswordPolicy()) {
                PasswordPolicyState pwPolicyState = (PasswordPolicyState)this.authPolicyState;
                if (saslHandler.isPasswordBased(this.saslMechanism) && pwPolicyState.mustChangePassword()) {
                    this.mustChangePassword = true;
                }
                if (this.isFirstWarning) {
                    pwPolicyState.setWarnedTime();
                    int numSeconds = pwPolicyState.getSecondsUntilExpiration();
                    Message m = CoreMessages.WARN_BIND_PASSWORD_EXPIRING.get(StaticUtils.secondsToTimeString(numSeconds));
                    pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRING, saslAuthUserEntry, m, AccountStatusNotification.createProperties(pwPolicyState, false, numSeconds, null, null));
                }
                if (this.isGraceLogin) {
                    pwPolicyState.updateGraceLoginTimes();
                }
                pwPolicyState.setLastLoginTime();
            }
            if (saslAuthUserEntry != null) {
                this.setResourceLimits(saslAuthUserEntry);
            }
        } else {
            if (resultCode == ResultCode.SASL_BIND_IN_PROGRESS) {
                return false;
            }
            if (this.authPolicyState != null && this.authPolicyState.isPasswordPolicy()) {
                PasswordPolicyState pwPolicyState = (PasswordPolicyState)this.authPolicyState;
                if (saslHandler.isPasswordBased(this.saslMechanism) && pwPolicyState.getAuthenticationPolicy().getLockoutFailureCount() > 0) {
                    this.generateAccountStatusNotificationForLockedBindAccount(saslAuthUserEntry, pwPolicyState);
                }
            }
        }
        return true;
    }

    private void generateAccountStatusNotificationForLockedBindAccount(Entry userEntry, PasswordPolicyState pwPolicyState) {
        pwPolicyState.updateAuthFailureTimes();
        if (pwPolicyState.lockedDueToFailures()) {
            Message m;
            boolean tempLocked;
            AccountStatusNotificationType notificationType;
            int lockoutDuration = pwPolicyState.getSecondsUntilUnlock();
            if (lockoutDuration > -1) {
                notificationType = AccountStatusNotificationType.ACCOUNT_TEMPORARILY_LOCKED;
                tempLocked = true;
                m = CoreMessages.ERR_BIND_ACCOUNT_TEMPORARILY_LOCKED.get(StaticUtils.secondsToTimeString(lockoutDuration));
            } else {
                notificationType = AccountStatusNotificationType.ACCOUNT_PERMANENTLY_LOCKED;
                tempLocked = false;
                m = CoreMessages.ERR_BIND_ACCOUNT_PERMANENTLY_LOCKED.get();
            }
            pwPolicyState.generateAccountStatusNotification(notificationType, userEntry, m, AccountStatusNotification.createProperties(pwPolicyState, tempLocked, -1, null, null));
        }
    }

    private boolean invokePreOpPlugins() {
        this.executePostOpPlugins = true;
        PluginResult.PreOperation preOpResult = this.pluginConfigManager.invokePreOperationBindPlugins(this);
        if (!preOpResult.continueProcessing()) {
            this.setResultCode(preOpResult.getResultCode());
            this.appendErrorMessage(preOpResult.getErrorMessage());
            this.setMatchedDN(preOpResult.getMatchedDN());
            this.setReferralURLs(preOpResult.getReferralURLs());
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkPasswordPolicyState(Entry userEntry, SASLMechanismHandler<?> saslHandler) throws DirectoryException {
        block21: {
            PasswordPolicyState pwPolicyState;
            block23: {
                block22: {
                    int maxGraceLogins;
                    boolean isSASLBind;
                    pwPolicyState = (PasswordPolicyState)this.authPolicyState;
                    PasswordPolicy policy = pwPolicyState.getAuthenticationPolicy();
                    boolean bl = isSASLBind = saslHandler != null;
                    if (!(policy.getStateUpdateFailurePolicy() != PasswordPolicyCfgDefn.StateUpdateFailurePolicy.PROACTIVE || policy.getLockoutFailureCount() <= 0 && (policy.getLastLoginTimeAttribute() == null || policy.getLastLoginTimeFormat() == null) || DirectoryServer.getWritabilityMode() != WritabilityMode.DISABLED && this.backend.getWritabilityMode() != WritabilityMode.DISABLED || DirectoryServer.isRootDN(userEntry.getDN()))) {
                        throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_OPERATION_WRITABILITY_DISABLED.get(String.valueOf(userEntry.getDN())));
                    }
                    if (policy.isRequireSecureAuthentication() && !this.clientConnection.isSecure()) {
                        if (!isSASLBind) {
                            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_OPERATION_INSECURE_SIMPLE_BIND.get());
                        }
                        if (!saslHandler.isSecure(this.saslMechanism)) {
                            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_OPERATION_INSECURE_SASL_BIND.get(this.saslMechanism, String.valueOf(userEntry.getDN())));
                        }
                    }
                    if (pwPolicyState.isDisabled()) {
                        throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_OPERATION_ACCOUNT_DISABLED.get());
                    }
                    if (pwPolicyState.isAccountExpired()) {
                        Message m = CoreMessages.ERR_BIND_OPERATION_ACCOUNT_EXPIRED.get();
                        pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_EXPIRED, userEntry, m, AccountStatusNotification.createProperties(pwPolicyState, false, -1, null, null));
                        throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, m);
                    }
                    if (pwPolicyState.lockedDueToFailures()) {
                        if (this.pwPolicyErrorType == null) {
                            this.pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                        }
                        throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_OPERATION_ACCOUNT_FAILURE_LOCKED.get());
                    }
                    if (pwPolicyState.lockedDueToIdleInterval()) {
                        if (this.pwPolicyErrorType == null) {
                            this.pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                        }
                        Message m = CoreMessages.ERR_BIND_OPERATION_ACCOUNT_IDLE_LOCKED.get();
                        pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_IDLE_LOCKED, userEntry, m, AccountStatusNotification.createProperties(pwPolicyState, false, -1, null, null));
                        throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, m);
                    }
                    if (isSASLBind && !saslHandler.isPasswordBased(this.saslMechanism)) break block21;
                    if (pwPolicyState.lockedDueToMaximumResetAge()) {
                        if (this.pwPolicyErrorType == null) {
                            this.pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                        }
                        Message m = CoreMessages.ERR_BIND_OPERATION_ACCOUNT_RESET_LOCKED.get();
                        pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_RESET_LOCKED, userEntry, m, AccountStatusNotification.createProperties(pwPolicyState, false, -1, null, null));
                        throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, m);
                    }
                    if (!pwPolicyState.isPasswordExpired()) break block22;
                    if (this.pwPolicyErrorType == null) {
                        this.pwPolicyErrorType = PasswordPolicyErrorType.PASSWORD_EXPIRED;
                    }
                    if ((maxGraceLogins = policy.getGraceLoginCount()) > 0 && pwPolicyState.mayUseGraceLogin()) {
                        List<Long> graceLoginTimes = pwPolicyState.getGraceLoginTimes();
                        if (graceLoginTimes != null && graceLoginTimes.size() >= maxGraceLogins) {
                            Message m = CoreMessages.ERR_BIND_OPERATION_PASSWORD_EXPIRED.get();
                            pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, userEntry, m, AccountStatusNotification.createProperties(pwPolicyState, false, -1, null, null));
                            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, m);
                        }
                        this.isGraceLogin = true;
                        this.mustChangePassword = true;
                        if (this.pwPolicyWarningType == null) {
                            this.pwPolicyWarningType = PasswordPolicyWarningType.GRACE_LOGINS_REMAINING;
                            this.pwPolicyWarningValue = maxGraceLogins - (graceLoginTimes.size() + 1);
                        }
                        break block23;
                    } else {
                        Message m = CoreMessages.ERR_BIND_OPERATION_PASSWORD_EXPIRED.get();
                        pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, userEntry, m, AccountStatusNotification.createProperties(pwPolicyState, false, -1, null, null));
                        throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, m);
                    }
                }
                if (pwPolicyState.shouldWarn()) {
                    int numSeconds = pwPolicyState.getSecondsUntilExpiration();
                    if (this.pwPolicyWarningType == null) {
                        this.pwPolicyWarningType = PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION;
                        this.pwPolicyWarningValue = numSeconds;
                    }
                    this.isFirstWarning = pwPolicyState.isFirstWarning();
                }
            }
            if (pwPolicyState.mustChangePassword()) {
                this.mustChangePassword = true;
                if (this.pwPolicyErrorType == null) {
                    this.pwPolicyErrorType = PasswordPolicyErrorType.CHANGE_AFTER_RESET;
                }
            }
        }
    }

    protected void setResourceLimits(Entry userEntry) {
        Integer customLookthroughLimit;
        Integer customIdleTimeLimitInSec;
        Integer customTimeLimit;
        Integer customSizeLimit = this.getIntegerUserAttribute(userEntry, "ds-rlim-size-limit", CoreMessages.WARN_BIND_MULTIPLE_USER_SIZE_LIMITS, CoreMessages.WARN_BIND_CANNOT_PROCESS_USER_SIZE_LIMIT);
        if (customSizeLimit != null) {
            this.sizeLimit = customSizeLimit;
        }
        if ((customTimeLimit = this.getIntegerUserAttribute(userEntry, "ds-rlim-time-limit", CoreMessages.WARN_BIND_MULTIPLE_USER_TIME_LIMITS, CoreMessages.WARN_BIND_CANNOT_PROCESS_USER_TIME_LIMIT)) != null) {
            this.timeLimit = customTimeLimit;
        }
        if ((customIdleTimeLimitInSec = this.getIntegerUserAttribute(userEntry, "ds-rlim-idle-time-limit", CoreMessages.WARN_BIND_MULTIPLE_USER_IDLE_TIME_LIMITS, CoreMessages.WARN_BIND_CANNOT_PROCESS_USER_IDLE_TIME_LIMIT)) != null) {
            this.idleTimeLimit = 1000L * (long)customIdleTimeLimitInSec.intValue();
        }
        if ((customLookthroughLimit = this.getIntegerUserAttribute(userEntry, "ds-rlim-lookthrough-limit", CoreMessages.WARN_BIND_MULTIPLE_USER_LOOKTHROUGH_LIMITS, CoreMessages.WARN_BIND_CANNOT_PROCESS_USER_LOOKTHROUGH_LIMIT)) != null) {
            this.lookthroughLimit = customLookthroughLimit;
        }
    }

    private Integer getIntegerUserAttribute(Entry userEntry, String attributeTypeName, MessageDescriptor.Arg1<CharSequence> nonUniqueAttributeMessage, MessageDescriptor.Arg2<CharSequence, CharSequence> cannotProcessAttributeMessage) {
        AttributeType attrType = DirectoryServer.getAttributeType(attributeTypeName, true);
        List<Attribute> attrList = userEntry.getAttribute(attrType);
        if (attrList != null && attrList.size() == 1) {
            Attribute a = attrList.get(0);
            if (a.size() == 1) {
                AttributeValue v = a.iterator().next();
                try {
                    return Integer.valueOf(v.getValue().toString());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    ErrorLogger.logError(cannotProcessAttributeMessage.get(v.getValue().toString(), String.valueOf(userEntry.getDN())));
                }
            } else if (a.size() > 1) {
                ErrorLogger.logError(nonUniqueAttributeMessage.get(String.valueOf(userEntry.getDN())));
            }
        }
        return null;
    }
}

