/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement.localbackend;

import java.util.LinkedList;
import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.std.server.SynchronizationProviderCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.SynchronizationProvider;
import org.opends.server.controls.LDAPAssertionRequestControl;
import org.opends.server.controls.LDAPPostReadRequestControl;
import org.opends.server.controls.LDAPPreReadRequestControl;
import org.opends.server.controls.ProxiedAuthV1Control;
import org.opends.server.controls.ProxiedAuthV2Control;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyDNOperationWrapper;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AdditionalLogItem;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.Privilege;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SynchronizationProviderResult;
import org.opends.server.types.operation.PostOperationModifyDNOperation;
import org.opends.server.types.operation.PostResponseModifyDNOperation;
import org.opends.server.types.operation.PostSynchronizationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.workflowelement.localbackend.LocalBackendWorkflowElement;

public class LocalBackendModifyDNOperation
extends ModifyDNOperationWrapper
implements PreOperationModifyDNOperation,
PostOperationModifyDNOperation,
PostResponseModifyDNOperation,
PostSynchronizationModifyDNOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    protected Backend backend;
    protected boolean noOp;
    protected ClientConnection clientConnection;
    protected DN entryDN;
    protected Entry currentEntry;
    protected Entry newEntry;
    private LDAPPostReadRequestControl postReadRequest;
    private LDAPPreReadRequestControl preReadRequest;
    protected RDN newRDN;

    public LocalBackendModifyDNOperation(ModifyDNOperation operation) {
        super(operation);
        LocalBackendWorkflowElement.attachLocalOperation(operation, this);
    }

    @Override
    public final Entry getOriginalEntry() {
        return this.currentEntry;
    }

    @Override
    public final Entry getUpdatedEntry() {
        return this.newEntry;
    }

    /*
     * Exception decompiling
     */
    public void processLocalModifyDN(LocalBackendWorkflowElement wfe) throws CanceledOperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK]], but top level block is 24[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void handleRequestControls() throws DirectoryException {
        LocalBackendWorkflowElement.removeAllDisallowedControls(this.entryDN, this);
        List<Control> requestControls = this.getRequestControls();
        if (requestControls != null && !requestControls.isEmpty()) {
            for (int i = 0; i < requestControls.size(); ++i) {
                Entry authorizationEntry;
                Control proxyControl;
                Control c = requestControls.get(i);
                String oid = c.getOID();
                if (oid.equals("1.3.6.1.1.12")) {
                    SearchFilter filter;
                    LDAPAssertionRequestControl assertControl = this.getRequestControl(LDAPAssertionRequestControl.DECODER);
                    try {
                        filter = assertControl.getSearchFilter();
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        throw new DirectoryException(de.getResultCode(), CoreMessages.ERR_MODDN_CANNOT_PROCESS_ASSERTION_FILTER.get(String.valueOf(this.entryDN), de.getMessageObject()));
                    }
                    if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this, this.currentEntry, filter)) {
                        throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, CoreMessages.ERR_CONTROL_INSUFFICIENT_ACCESS_RIGHTS.get(oid));
                    }
                    try {
                        if (filter.matchesEntry(this.currentEntry)) continue;
                        throw new DirectoryException(ResultCode.ASSERTION_FAILED, CoreMessages.ERR_MODDN_ASSERTION_FAILED.get(String.valueOf(this.entryDN)));
                    }
                    catch (DirectoryException de) {
                        if (de.getResultCode() == ResultCode.ASSERTION_FAILED) {
                            throw de;
                        }
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        throw new DirectoryException(de.getResultCode(), CoreMessages.ERR_MODDN_CANNOT_PROCESS_ASSERTION_FILTER.get(String.valueOf(this.entryDN), de.getMessageObject()));
                    }
                }
                if (oid.equals("1.3.6.1.4.1.4203.1.10.2")) {
                    this.noOp = true;
                    continue;
                }
                if (oid.equals("1.3.6.1.1.13.1")) {
                    this.preReadRequest = this.getRequestControl(LDAPPreReadRequestControl.DECODER);
                    requestControls.set(i, this.preReadRequest);
                    continue;
                }
                if (oid.equals("1.3.6.1.1.13.2")) {
                    if (c instanceof LDAPPostReadRequestControl) {
                        this.postReadRequest = (LDAPPostReadRequestControl)c;
                        continue;
                    }
                    this.postReadRequest = this.getRequestControl(LDAPPostReadRequestControl.DECODER);
                    requestControls.set(i, this.postReadRequest);
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.12")) {
                    this.addAdditionalLogItem(AdditionalLogItem.keyOnly(this.getClass(), "obsoleteProxiedAuthzV1Control"));
                    if (!this.clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, this)) {
                        throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    }
                    proxyControl = this.getRequestControl(ProxiedAuthV1Control.DECODER);
                    authorizationEntry = ((ProxiedAuthV1Control)proxyControl).getAuthorizationEntry();
                    this.setAuthorizationEntry(authorizationEntry);
                    if (authorizationEntry == null) {
                        this.setProxiedAuthorizationDN(DN.nullDN());
                        continue;
                    }
                    this.setProxiedAuthorizationDN(authorizationEntry.getDN());
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.18")) {
                    if (!this.clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, this)) {
                        throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    }
                    proxyControl = this.getRequestControl(ProxiedAuthV2Control.DECODER);
                    authorizationEntry = ((ProxiedAuthV2Control)proxyControl).getAuthorizationEntry();
                    this.setAuthorizationEntry(authorizationEntry);
                    if (authorizationEntry == null) {
                        this.setProxiedAuthorizationDN(DN.nullDN());
                        continue;
                    }
                    this.setProxiedAuthorizationDN(authorizationEntry.getDN());
                    continue;
                }
                if (!c.isCritical() || this.backend != null && this.backend.supportsControl(oid)) continue;
                throw new DirectoryException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, CoreMessages.ERR_MODDN_UNSUPPORTED_CRITICAL_CONTROL.get(String.valueOf(this.entryDN), oid));
            }
        }
    }

    protected void applyRDNChanges(List<Modification> modifications) throws DirectoryException {
        int i;
        if (this.deleteOldRDN()) {
            RDN currentRDN = this.entryDN.getRDN();
            int numValues = currentRDN.getNumValues();
            for (i = 0; i < numValues; ++i) {
                Attribute a = Attributes.create(currentRDN.getAttributeType(i), currentRDN.getAttributeName(i), currentRDN.getAttributeValue(i));
                if (a.getAttributeType().isNoUserModification() && !this.isInternalOperation() && !this.isSynchronizationOperation()) {
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, CoreMessages.ERR_MODDN_OLD_RDN_ATTR_IS_NO_USER_MOD.get(String.valueOf(this.entryDN), a.getName()));
                }
                LinkedList<AttributeValue> missingValues = new LinkedList<AttributeValue>();
                this.newEntry.removeAttribute(a, missingValues);
                if (!missingValues.isEmpty()) continue;
                modifications.add(new Modification(ModificationType.DELETE, a));
            }
        }
        int newRDNValues = this.newRDN.getNumValues();
        for (int i2 = 0; i2 < newRDNValues; ++i2) {
            Attribute a = Attributes.create(this.newRDN.getAttributeType(i2), this.newRDN.getAttributeName(i2), this.newRDN.getAttributeValue(i2));
            LinkedList<AttributeValue> duplicateValues = new LinkedList<AttributeValue>();
            this.newEntry.addAttribute(a, duplicateValues);
            if (!duplicateValues.isEmpty()) continue;
            if (a.getAttributeType().isNoUserModification()) {
                if (this.isInternalOperation() || this.isSynchronizationOperation()) continue;
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, CoreMessages.ERR_MODDN_NEW_RDN_ATTR_IS_NO_USER_MOD.get(String.valueOf(this.entryDN), a.getName()));
            }
            modifications.add(new Modification(ModificationType.ADD, a));
        }
        if (DirectoryServer.checkSchema() && !this.isSynchronizationOperation()) {
            MessageBuilder invalidReason = new MessageBuilder();
            if (!this.newEntry.conformsToSchema(null, false, true, true, invalidReason)) {
                throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, CoreMessages.ERR_MODDN_VIOLATES_SCHEMA.get(String.valueOf(this.entryDN), String.valueOf(invalidReason)));
            }
            for (i = 0; i < newRDNValues; ++i) {
                AttributeType at = this.newRDN.getAttributeType(i);
                if (!at.isObsolete()) continue;
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, CoreMessages.ERR_MODDN_NEWRDN_ATTR_IS_OBSOLETE.get(String.valueOf(this.entryDN), at.getNameOrOID()));
            }
        }
    }

    protected void applyPreOpModifications(List<Modification> modifications, int startPos, boolean checkSchema) throws DirectoryException {
        MessageBuilder invalidReason;
        block6: for (int i = startPos; i < modifications.size(); ++i) {
            Modification m = modifications.get(i);
            Attribute a = m.getAttribute();
            switch (m.getModificationType()) {
                case ADD: {
                    LinkedList<AttributeValue> duplicateValues = new LinkedList<AttributeValue>();
                    this.newEntry.addAttribute(a, duplicateValues);
                    continue block6;
                }
                case DELETE: {
                    LinkedList<AttributeValue> missingValues = new LinkedList<AttributeValue>();
                    this.newEntry.removeAttribute(a, missingValues);
                    continue block6;
                }
                case REPLACE: {
                    this.newEntry.replaceAttribute(a);
                    continue block6;
                }
                case INCREMENT: {
                    this.newEntry.incrementAttribute(a);
                }
            }
        }
        if (DirectoryServer.checkSchema() && checkSchema && !this.newEntry.conformsToSchema(null, false, true, true, invalidReason = new MessageBuilder())) {
            throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, CoreMessages.ERR_MODDN_PREOP_VIOLATES_SCHEMA.get(String.valueOf(this.entryDN), String.valueOf(invalidReason)));
        }
    }

    protected boolean handleConflictResolution() {
        for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
            try {
                SynchronizationProviderResult result = provider.handleConflictResolution(this);
                if (result.continueProcessing()) continue;
                this.setResultCode(result.getResultCode());
                this.appendErrorMessage(result.getErrorMessage());
                this.setMatchedDN(result.getMatchedDN());
                this.setReferralURLs(result.getReferralURLs());
                return false;
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                ErrorLogger.logError(CoreMessages.ERR_MODDN_SYNCH_CONFLICT_RESOLUTION_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                this.setResponseData(de);
                return false;
            }
        }
        return true;
    }

    protected boolean processPreOperation() {
        for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
            try {
                SynchronizationProviderResult result = provider.doPreOperation(this);
                if (result.continueProcessing()) continue;
                this.setResultCode(result.getResultCode());
                this.appendErrorMessage(result.getErrorMessage());
                this.setMatchedDN(result.getMatchedDN());
                this.setReferralURLs(result.getReferralURLs());
                return false;
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                ErrorLogger.logError(CoreMessages.ERR_MODDN_SYNCH_PREOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                this.setResponseData(de);
                return false;
            }
        }
        return true;
    }

    protected void processSynchPostOperationPlugins() {
        for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
            try {
                provider.doPostOperation(this);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                ErrorLogger.logError(CoreMessages.ERR_MODDN_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                this.setResponseData(de);
                return;
            }
        }
    }
}

