/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.bridge.proxies.facilitators;

import org.xadisk.bridge.proxies.facilitators.OptimizedRemoteReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayRemoteReference
extends OptimizedRemoteReference<byte[]> {
    private static final long serialVersionUID = 1L;
    private transient byte[] originalByteArray;
    private int lengthForUpdate;
    private transient int offsetForUpdate;
    private byte[] resultBytes;

    public ByteArrayRemoteReference(byte[] b, int offset, int length) {
        this.originalByteArray = b;
        this.lengthForUpdate = length;
        this.offsetForUpdate = offset;
    }

    @Override
    public byte[] regenerateRemoteObject() {
        return new byte[this.lengthForUpdate];
    }

    @Override
    public void setResultObject(byte[] b) {
        this.resultBytes = b;
    }

    @Override
    public void mergeWithRemoteObject(byte[] resultBytes) {
        byte[] result = resultBytes;
        System.arraycopy(result, 0, this.originalByteArray, this.offsetForUpdate, result.length);
    }

    @Override
    public byte[] getResultObject() {
        return this.resultBytes;
    }
}

