/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.bridge.proxies.facilitators;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import org.xadisk.bridge.proxies.facilitators.ByteArrayRemoteReference;
import org.xadisk.bridge.proxies.facilitators.InternalXASystemException;
import org.xadisk.bridge.proxies.facilitators.OptimizedRemoteReference;
import org.xadisk.filesystem.exceptions.ConnectionException;

public class RemoteMethodInvoker
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String serverAddress;
    private final int serverPort;
    private transient SocketChannel channel;
    private transient Socket socket;
    private boolean connected = false;
    private static final String UTF8CharsetName = "UTF-8";

    public RemoteMethodInvoker(String serverAddress, int serverPort) {
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
    }

    public RemoteMethodInvoker makeCopy() {
        return new RemoteMethodInvoker(this.serverAddress, this.serverPort);
    }

    public RemoteMethodInvoker ensureConnected() throws IOException {
        if (this.connected) {
            return this;
        }
        this.channel = SocketChannel.open(new InetSocketAddress(this.serverAddress, this.serverPort));
        this.channel.configureBlocking(true);
        this.channel.finishConnect();
        this.socket = this.channel.socket();
        this.connected = true;
        return this;
    }

    public void disconnect() throws IOException {
        if (this.connected) {
            this.socket.close();
            this.connected = false;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public Object invokeRemoteMethod(long targetObjectId, String method, Serializable ... args) throws Throwable {
        Object returnObject;
        boolean isError;
        try {
            this.ensureConnected();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeLong(targetObjectId);
            byte[] methodNameBytes = method.getBytes(UTF8CharsetName);
            oos.writeInt(methodNameBytes.length);
            oos.write(methodNameBytes);
            oos.writeInt(args.length);
            ArrayList<OptimizedRemoteReference> remoteReferences = new ArrayList<OptimizedRemoteReference>();
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof OptimizedRemoteReference) {
                    remoteReferences.add((OptimizedRemoteReference)args[i]);
                }
                oos.writeObject(args[i]);
            }
            oos.flush();
            byte[] toSend = baos.toByteArray();
            int lengthOfInvocation = toSend.length;
            OutputStream socketOS = this.socket.getOutputStream();
            socketOS.write(this.getDataOutputCompliantBytesFromInteger(lengthOfInvocation));
            socketOS.write(toSend);
            socketOS.flush();
            ObjectInputStream ois = new ObjectInputStream(this.socket.getInputStream());
            isError = ois.readBoolean();
            int numOutputs = ois.readInt();
            returnObject = ois.readObject();
            for (int i = 1; i < numOutputs; ++i) {
                OptimizedRemoteReference updatedRef = (OptimizedRemoteReference)ois.readObject();
                if (!(updatedRef instanceof ByteArrayRemoteReference)) continue;
                ByteArrayRemoteReference barr = (ByteArrayRemoteReference)remoteReferences.get(i - 1);
                ByteArrayRemoteReference updatedBarr = (ByteArrayRemoteReference)updatedRef;
                barr.mergeWithRemoteObject(updatedBarr.getResultObject());
            }
        }
        catch (IOException ioe) {
            this.disconnect();
            throw new ConnectionException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new InternalXASystemException(cnfe);
        }
        if (isError) {
            throw (Throwable)returnObject;
        }
        return returnObject;
    }

    private byte[] getDataOutputCompliantBytesFromInteger(int i) {
        byte[] b = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return b;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoteMethodInvoker) {
            RemoteMethodInvoker that = (RemoteMethodInvoker)obj;
            return this.serverAddress.equals(that.serverAddress) && this.serverPort == that.serverPort;
        }
        return false;
    }

    public int hashCode() {
        return this.serverPort + this.serverAddress.hashCode();
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }
}

