/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.bridge.proxies.impl;

import java.io.IOException;
import java.io.Serializable;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.xadisk.bridge.proxies.facilitators.RemoteMethodInvoker;
import org.xadisk.bridge.proxies.facilitators.RemoteObjectProxy;
import org.xadisk.bridge.proxies.facilitators.RemoteXADiskActivationSpecImpl;
import org.xadisk.bridge.proxies.impl.RemoteMessageEndpointFactory;
import org.xadisk.bridge.proxies.impl.RemoteXASession;
import org.xadisk.bridge.proxies.interfaces.Session;
import org.xadisk.bridge.proxies.interfaces.XAFileSystem;
import org.xadisk.bridge.proxies.interfaces.XASession;
import org.xadisk.bridge.server.conversation.GlobalHostedContext;
import org.xadisk.connector.inbound.EndPointActivation;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.XAFileSystemCommonness;

public class RemoteXAFileSystem
extends RemoteObjectProxy
implements XAFileSystemCommonness {
    private static final long serialVersionUID = 1L;
    private NativeXAFileSystem localXAFileSystem;

    public RemoteXAFileSystem(String serverAddress, int serverPort, NativeXAFileSystem localXAFileSystem) {
        super(0L, new RemoteMethodInvoker(serverAddress, serverPort));
        this.localXAFileSystem = localXAFileSystem;
    }

    public RemoteXAFileSystem(String serverAddress, int serverPort) {
        super(0L, new RemoteMethodInvoker(serverAddress, serverPort));
    }

    public RemoteXAFileSystem(long objectId, RemoteMethodInvoker invoker, NativeXAFileSystem localXAFileSystem) {
        super(objectId, invoker);
        this.localXAFileSystem = localXAFileSystem;
    }

    public boolean pointToSameXAFileSystem(XAFileSystem xaFileSystem) {
        if (xaFileSystem instanceof RemoteXAFileSystem) {
            RemoteXAFileSystem that = (RemoteXAFileSystem)xaFileSystem;
            return this.invoker.getServerAddress().equalsIgnoreCase(that.invoker.getServerAddress()) && this.invoker.getServerPort() == that.invoker.getServerPort();
        }
        return false;
    }

    public Session createSessionForLocalTransaction() {
        try {
            return (Session)this.invokeRemoteMethod("createSessionForLocalTransaction", new Serializable[0]);
        }
        catch (Throwable t) {
            throw this.assertExceptionHandling(t);
        }
    }

    public Session createSessionForXATransaction(Xid xid) {
        try {
            return (Session)this.invokeRemoteMethod("createSessionForXATransaction", (Serializable)((Object)xid));
        }
        catch (Throwable t) {
            throw this.assertExceptionHandling(t);
        }
    }

    public XASession createSessionForXATransaction() {
        return new RemoteXASession(this);
    }

    public int getDefaultTransactionTimeout() {
        try {
            return (Integer)this.invokeRemoteMethod("getDefaultTransactionTimeout", new Serializable[0]);
        }
        catch (Throwable t) {
            throw this.assertExceptionHandling(t);
        }
    }

    public Session getSessionForTransaction(Xid xid) {
        try {
            return (Session)this.invokeRemoteMethod("getSessionForTransaction", (Serializable)((Object)xid));
        }
        catch (Throwable t) {
            throw this.assertExceptionHandling(t);
        }
    }

    public void notifySystemFailureAndContinue(Throwable t) {
        try {
            this.invokeRemoteMethod("notifySystemFailureAndContinue", t);
        }
        catch (Throwable th) {
            throw this.assertExceptionHandling(th);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        try {
            return (Xid[])this.invokeRemoteMethod("recover", Integer.valueOf(flag));
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Throwable th) {
            throw this.assertExceptionHandling(th);
        }
    }

    public void shutdown() {
        try {
            this.invoker.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void waitForBootup(long timeout) throws InterruptedException {
        try {
            this.invokeRemoteMethod("waitForBootup", Long.valueOf(timeout));
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Throwable th) {
            throw this.assertExceptionHandling(th);
        }
    }

    public void registerEndPointActivation(EndPointActivation epActivation) throws IOException {
        try {
            MessageEndpointFactory messageEndpointFactory = epActivation.getMessageEndpointFactory();
            GlobalHostedContext globalCallbackContext = this.localXAFileSystem.getGlobalCallbackContext();
            long objectId = globalCallbackContext.hostObject(messageEndpointFactory);
            String xaDiskSystemId = this.localXAFileSystem.getXADiskSystemId();
            RemoteMessageEndpointFactory remoteMessageEndpointFactory = new RemoteMessageEndpointFactory(objectId, xaDiskSystemId, this.localXAFileSystem.createRemoteMethodInvokerToSelf());
            RemoteXADiskActivationSpecImpl ras = new RemoteXADiskActivationSpecImpl(epActivation.getActivationSpecImpl());
            EndPointActivation callbackEndPointActivation = new EndPointActivation(remoteMessageEndpointFactory, ras);
            this.invokeRemoteMethod("registerEndPointActivation", callbackEndPointActivation);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable th) {
            throw this.assertExceptionHandling(th);
        }
    }

    public void deRegisterEndPointActivation(EndPointActivation epActivation) throws IOException {
        try {
            MessageEndpointFactory messageEndpointFactory = epActivation.getMessageEndpointFactory();
            GlobalHostedContext globalCallbackContext = this.localXAFileSystem.getGlobalCallbackContext();
            long objectId = globalCallbackContext.deHostObject(messageEndpointFactory);
            String xaDiskSystemId = this.localXAFileSystem.getXADiskSystemId();
            RemoteMessageEndpointFactory remoteMessageEndpointFactory = new RemoteMessageEndpointFactory(objectId, xaDiskSystemId, null);
            RemoteXADiskActivationSpecImpl ras = new RemoteXADiskActivationSpecImpl(epActivation.getActivationSpecImpl());
            EndPointActivation callbackEndPointActivation = new EndPointActivation(remoteMessageEndpointFactory, ras);
            this.invokeRemoteMethod("deRegisterEndPointActivation", callbackEndPointActivation);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable th) {
            throw this.assertExceptionHandling(th);
        }
    }

    public XAResource getEventProcessingXAResourceForRecovery() {
        try {
            return (XAResource)this.invokeRemoteMethod("getEventProcessingXAResourceForRecovery", new Serializable[0]);
        }
        catch (Throwable th) {
            throw this.assertExceptionHandling(th);
        }
    }
}

