/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.bridge.server.conversation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Set;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.work.Work;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.xadisk.bridge.proxies.facilitators.ByteArrayRemoteReference;
import org.xadisk.bridge.proxies.facilitators.MethodSerializabler;
import org.xadisk.bridge.proxies.facilitators.OptimizedRemoteReference;
import org.xadisk.bridge.proxies.facilitators.SerializedMethod;
import org.xadisk.bridge.server.conversation.ContextOutOfSyncException;
import org.xadisk.bridge.server.conversation.ConversationContext;
import org.xadisk.bridge.server.conversation.GlobalHostedContext;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.pools.PooledSelector;
import org.xadisk.filesystem.pools.SelectorPool;

public class RemoteMethodInvocationHandler
implements Work {
    private ConversationContext context;
    private static final String UTF8CharsetName = "UTF-8";
    private final PooledSelector pooledWriteSelector;
    private final Selector writeSelector;
    private volatile boolean enabled = true;
    private final SelectorPool selectorPool;
    private final NativeXAFileSystem xaFileSystem;

    public RemoteMethodInvocationHandler(ConversationContext context, NativeXAFileSystem xaFileSystem) throws IOException {
        this.xaFileSystem = xaFileSystem;
        this.context = context;
        this.selectorPool = xaFileSystem.getSelectorPool();
        this.pooledWriteSelector = this.selectorPool.checkOut();
        if (this.pooledWriteSelector == null) {
            System.err.println("No more Selectors could be created.");
            throw new IOException("Could not get a Selector from the SelectorPool.");
        }
        this.writeSelector = this.pooledWriteSelector.getSelector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        byte[] methodInvocationResponse;
        try {
            this.context.reAssociatedTransactionThreadWithSessions(Thread.currentThread());
            methodInvocationResponse = this.handleRemoteInvocation(this.context.getCurrentMethodInvocation());
        }
        catch (Throwable t) {
            methodInvocationResponse = this.handleInvocationFailedSystemError(t);
        }
        try {
            SocketChannel channel = this.context.getConversationChannel();
            channel.register(this.writeSelector, 4);
            ByteBuffer toSend = ByteBuffer.wrap(methodInvocationResponse);
            while (toSend.remaining() > 0 && this.enabled) {
                int n = this.writeSelector.select();
                if (n == 0) {
                    break;
                }
                Set<SelectionKey> selectionKeys = this.writeSelector.selectedKeys();
                channel.write(toSend);
                selectionKeys.clear();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            try {
                this.selectorPool.checkIn(this.pooledWriteSelector);
            }
            catch (Throwable t) {}
        }
    }

    private byte[] handleInvocationFailedSystemError(Throwable t) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeBoolean(true);
            oos.writeInt(1);
            oos.writeObject(t);
            return baos.toByteArray();
        }
        catch (Throwable th) {
            throw new AssertionError((Object)th);
        }
    }

    byte[] handleRemoteInvocation(byte[] invocation) throws IOException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, ContextOutOfSyncException {
        Object response;
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(invocation));
        long targetObjectId = ois.readLong();
        Object targetObject = this.context.getInvocationTarget(targetObjectId);
        if (targetObject == null) {
            throw new ContextOutOfSyncException("No object with id " + targetObjectId);
        }
        byte[] methodNameBytes = new byte[ois.readInt()];
        ois.read(methodNameBytes);
        String methodName = new String(methodNameBytes, UTF8CharsetName);
        int numOfArgs = ois.readInt();
        Object[] args = new Object[numOfArgs];
        Class[] argTypes = new Class[numOfArgs];
        ArrayList<OptimizedRemoteReference> remoteReferences = new ArrayList<OptimizedRemoteReference>();
        ArrayList<Object> regenerateObjects = new ArrayList<Object>();
        for (int i = 0; i < numOfArgs; ++i) {
            args[i] = ois.readObject();
            argTypes[i] = args[i].getClass();
            if (args[i] instanceof OptimizedRemoteReference) {
                OptimizedRemoteReference remoteRef = (OptimizedRemoteReference)args[i];
                args[i] = remoteRef.regenerateRemoteObject();
                regenerateObjects.add(args[i]);
                remoteReferences.add(remoteRef);
            }
            if (args[i] instanceof SerializedMethod) {
                SerializedMethod serializedMethod = (SerializedMethod)args[i];
                args[i] = new MethodSerializabler().reconstruct(serializedMethod);
                argTypes[i] = Method.class;
            }
            argTypes[i] = this.getApplicableInterfaceClassIfRequired(args[i]);
            argTypes[i] = this.getPrimitiveClassIfRequired(argTypes[i]);
        }
        Method method = targetObject.getClass().getMethod(methodName, argTypes);
        boolean isError = false;
        try {
            response = method.invoke(targetObject, args);
            for (int i = 0; i < remoteReferences.size(); ++i) {
                OptimizedRemoteReference ref = (OptimizedRemoteReference)remoteReferences.get(i);
                if (!(ref instanceof ByteArrayRemoteReference)) continue;
                ByteArrayRemoteReference barr = (ByteArrayRemoteReference)ref;
                Integer bytesGotUpdated = (Integer)response;
                byte[] inputArgument = (byte[])regenerateObjects.get(i);
                byte[] minimalToSend = new byte[bytesGotUpdated.intValue()];
                System.arraycopy(inputArgument, 0, minimalToSend, 0, bytesGotUpdated);
                barr.setResultObject(minimalToSend);
            }
            response = this.context.convertToProxyResponseIfRequired(response);
            this.checkForMessageEndpointRelease(targetObject, method);
        }
        catch (InvocationTargetException ite) {
            response = ite.getCause();
            isError = true;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeBoolean(isError);
        oos.writeInt(1 + remoteReferences.size());
        oos.writeObject(response);
        for (OptimizedRemoteReference ref : remoteReferences) {
            oos.writeObject(ref);
        }
        return baos.toByteArray();
    }

    public void release() {
        this.enabled = false;
        if (this.writeSelector.isOpen()) {
            this.writeSelector.wakeup();
        }
    }

    private void checkForMessageEndpointRelease(Object targetObject, Method method) throws NoSuchMethodException {
        if (method.equals(MessageEndpoint.class.getMethod("release", new Class[0]))) {
            GlobalHostedContext globalCallbackContext = this.xaFileSystem.getGlobalCallbackContext();
            globalCallbackContext.deHostObject(targetObject);
        }
    }

    private Class getPrimitiveClassIfRequired(Class type) {
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        if (type == Character.class) {
            return Character.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        return type;
    }

    private Class getApplicableInterfaceClassIfRequired(Object obj) {
        if (obj instanceof XAResource) {
            return XAResource.class;
        }
        if (obj instanceof Xid) {
            return Xid.class;
        }
        return obj.getClass();
    }
}

