/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.xadisk.bridge.proxies.facilitators.RemoteMethodInvoker;
import org.xadisk.bridge.proxies.facilitators.RemoteXADiskActivationSpecImpl;
import org.xadisk.bridge.proxies.impl.RemoteMessageEndpointFactory;
import org.xadisk.connector.inbound.EndPointActivation;
import org.xadisk.filesystem.FileSystemStateChangeEvent;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.XidImpl;
import org.xadisk.filesystem.utilities.FileIOUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionLogEntry {
    public static final byte FILE_APPEND = 2;
    public static final byte FILE_MOVE = 3;
    public static final byte FILE_COPY = 4;
    public static final byte FILE_DELETE = 5;
    public static final byte FILE_CREATE = 6;
    public static final byte DIR_CREATE = 7;
    public static final byte FILE_TRUNCATE = 8;
    public static final byte FILE_SPECIAL_MOVE = 9;
    public static final byte EVENT_ENQUEUE = 10;
    public static final byte FILES_ALREADY_ONDISK = 11;
    public static final byte COMMIT_BEGINS = 12;
    public static final byte TXN_COMMIT_DONE = 13;
    public static final byte TXN_ROLLBACK_DONE = 14;
    public static final byte PREPARE_COMPLETES = 15;
    public static final byte UNDOABLE_FILE_APPEND = 16;
    public static final byte UNDOABLE_FILE_TRUNCATE = 17;
    public static final byte TXN_USES_UNDO_LOGS = 18;
    public static final byte EVENT_DEQUEUE = 19;
    public static final byte PREPARE_COMPLETES_FOR_EVENT_DEQUEUE = 20;
    public static final byte CHECKPOINT_AVOIDING_COPY_OR_MOVE_REDO = 21;
    public static final byte REMOTE_ENDPOINT_ACTIVATES = 22;
    public static final byte REMOTE_ENDPOINT_DEACTIVATES = 23;
    public static final String UTF8Charset = "UTF8";
    private XidImpl xid;
    private byte operationType;
    private String fileName;
    private long filePosition;
    private int fileContentLength;
    private int headerLength;
    private String destFileName;
    private long newLength;
    private HashSet<File> fileList;
    private ArrayList<FileSystemStateChangeEvent> eventList;
    private int checkPointPosition = -1;
    private EndPointActivation remoteActivation;

    static byte[] getUTF8Bytes(String str) {
        try {
            return str.getBytes(UTF8Charset);
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    static String getUTF8AssumedString(byte[] bytes) {
        try {
            return new String(bytes, UTF8Charset);
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    public static byte[] getLogEntry(XidImpl xid, String file, long filePosition, int fileContentLength, byte appendOrUndoTruncate) {
        byte[] filePathBytes = TransactionLogEntry.getUTF8Bytes(file);
        int filePathLength = filePathBytes.length;
        ByteBuffer buffer = ByteBuffer.allocate(200 + filePathLength);
        buffer.putInt(0);
        buffer.putInt(fileContentLength);
        buffer.put(appendOrUndoTruncate);
        buffer.put(TransactionLogEntry.serializeXid(xid));
        buffer.putInt(filePathLength);
        buffer.put(filePathBytes);
        buffer.putLong(filePosition);
        buffer.putInt(0, buffer.position());
        buffer.flip();
        byte[] temp = new byte[buffer.limit()];
        buffer.get(temp);
        return temp;
    }

    static byte[] getLogEntry(XidImpl xid, String file, byte createFileOrDirOrDeleteOrUndoCreate) {
        byte[] filePathBytes = TransactionLogEntry.getUTF8Bytes(file);
        int filePathLength = filePathBytes.length;
        ByteBuffer buffer = ByteBuffer.allocate(200 + filePathLength);
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.put(createFileOrDirOrDeleteOrUndoCreate);
        buffer.put(TransactionLogEntry.serializeXid(xid));
        buffer.putInt(filePathLength);
        buffer.put(filePathBytes);
        buffer.putInt(0, buffer.position());
        buffer.flip();
        byte[] temp = new byte[buffer.limit()];
        buffer.get(temp);
        return temp;
    }

    public static byte[] getLogEntry(XidImpl xid, String file, long newLength, byte truncateOrUndoAppend) {
        byte[] filePathBytes = TransactionLogEntry.getUTF8Bytes(file);
        int filePathLength = filePathBytes.length;
        ByteBuffer buffer = ByteBuffer.allocate(200 + filePathLength);
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.put(truncateOrUndoAppend);
        buffer.put(TransactionLogEntry.serializeXid(xid));
        buffer.putInt(filePathLength);
        buffer.put(filePathBytes);
        buffer.putLong(newLength);
        buffer.putInt(0, buffer.position());
        buffer.flip();
        byte[] temp = new byte[buffer.limit()];
        buffer.get(temp);
        return temp;
    }

    public static byte[] getLogEntry(XidImpl xid, String sourceFile, String destinationFile, byte moveOrCopyOrUndoDelete) {
        byte[] sourceFilePathBytes = TransactionLogEntry.getUTF8Bytes(sourceFile);
        byte[] destFilePathBytes = TransactionLogEntry.getUTF8Bytes(destinationFile);
        int srcFilePathLength = sourceFilePathBytes.length;
        int destFilePathLength = destFilePathBytes.length;
        ByteBuffer buffer = ByteBuffer.allocate(200 + srcFilePathLength + destFilePathLength);
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.put(moveOrCopyOrUndoDelete);
        buffer.put(TransactionLogEntry.serializeXid(xid));
        buffer.putInt(srcFilePathLength);
        buffer.put(sourceFilePathBytes);
        buffer.putInt(destFilePathLength);
        buffer.put(destFilePathBytes);
        buffer.putInt(0, buffer.position());
        buffer.flip();
        byte[] temp = new byte[buffer.limit()];
        buffer.get(temp);
        return temp;
    }

    public static byte[] getLogEntry(XidImpl xid, byte commitStatus) {
        ByteBuffer buffer = ByteBuffer.allocate(200);
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.put(commitStatus);
        buffer.put(TransactionLogEntry.serializeXid(xid));
        buffer.putInt(0, buffer.position());
        buffer.flip();
        byte[] temp = new byte[buffer.limit()];
        buffer.get(temp);
        return temp;
    }

    static byte[] getLogEntry(XidImpl xid, int checkPointPosition) {
        ByteBuffer buffer = ByteBuffer.allocate(200);
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.put((byte)21);
        buffer.put(TransactionLogEntry.serializeXid(xid));
        buffer.putInt(checkPointPosition);
        buffer.putInt(0, buffer.position());
        buffer.flip();
        byte[] temp = new byte[buffer.limit()];
        buffer.get(temp);
        return temp;
    }

    public static byte[] getLogEntry(XidImpl xid, Set<File> files) {
        byte[][] filePathsBytes = new byte[files.size()][];
        int totalFilePathsLength = 0;
        int i = 0;
        Iterator<File> iter = files.iterator();
        while (iter.hasNext()) {
            filePathsBytes[i] = TransactionLogEntry.getUTF8Bytes(iter.next().getAbsolutePath());
            totalFilePathsLength += filePathsBytes[i].length;
            ++i;
        }
        ByteBuffer buffer = ByteBuffer.allocate(200 + totalFilePathsLength + 4 * filePathsBytes.length);
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.put((byte)11);
        buffer.put(TransactionLogEntry.serializeXid(xid));
        buffer.putInt(files.size());
        for (i = 0; i < filePathsBytes.length; ++i) {
            buffer.putInt(filePathsBytes[i].length);
            buffer.put(filePathsBytes[i]);
        }
        buffer.putInt(0, buffer.position());
        buffer.flip();
        byte[] temp = new byte[buffer.limit()];
        buffer.get(temp);
        return temp;
    }

    public static byte[] getLogEntry(XidImpl xid, ArrayList<FileSystemStateChangeEvent> events, byte enQ_deQ_prepareDequeue) {
        int totalEventsLength = 0;
        byte[][] eventsBytes = new byte[events.size()][];
        for (int i = 0; i < events.size(); ++i) {
            eventsBytes[i] = TransactionLogEntry.getBytesFromEvent(events.get(i));
            totalEventsLength += eventsBytes[i].length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(200 + totalEventsLength);
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.put(enQ_deQ_prepareDequeue);
        buffer.put(TransactionLogEntry.serializeXid(xid));
        buffer.putInt(events.size());
        for (int i = 0; i < eventsBytes.length; ++i) {
            buffer.put(eventsBytes[i]);
        }
        buffer.putInt(0, buffer.position());
        buffer.flip();
        byte[] temp = new byte[buffer.limit()];
        buffer.get(temp);
        return temp;
    }

    public static byte[] getLogEntry(EndPointActivation remoteEPActivation, byte activation_deActivation) {
        try {
            RemoteXADiskActivationSpecImpl ras = (RemoteXADiskActivationSpecImpl)remoteEPActivation.getActivationSpecImpl();
            RemoteMessageEndpointFactory remoteMEPF = (RemoteMessageEndpointFactory)remoteEPActivation.getMessageEndpointFactory();
            byte[][] variableBytes = new byte[][]{activation_deActivation == 23 ? "".getBytes(UTF8Charset) : remoteMEPF.getInvoker().getServerAddress().getBytes(UTF8Charset), ras.getFileNamesAndEventInterests().getBytes(UTF8Charset), remoteMEPF.getXaDiskSystemId().getBytes(UTF8Charset)};
            int variableBytesLength = 0;
            for (int i = 0; i < 3; ++i) {
                variableBytesLength += variableBytes[i].length;
            }
            ByteBuffer buffer = ByteBuffer.allocate(41 + variableBytesLength);
            buffer.putInt(0);
            buffer.putInt(0);
            buffer.put(activation_deActivation);
            buffer.putInt(variableBytes[0].length);
            buffer.put(variableBytes[0]);
            if (activation_deActivation == 23) {
                buffer.putInt(0);
            } else {
                buffer.putInt(remoteMEPF.getInvoker().getServerPort());
            }
            buffer.putInt(variableBytes[1].length);
            buffer.put(variableBytes[1]);
            buffer.putInt(ras.getOriginalActivationSpecObjectsHashCode());
            buffer.putInt(variableBytes[2].length);
            buffer.put(variableBytes[2]);
            buffer.putLong(remoteMEPF.getRemoteObjectId());
            buffer.putInt(0, buffer.position());
            buffer.flip();
            byte[] temp = new byte[buffer.limit()];
            buffer.get(temp);
            return temp;
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    static TransactionLogEntry parseLogEntry(ByteBuffer buffer) {
        TransactionLogEntry temp = new TransactionLogEntry();
        int position = buffer.position();
        buffer.position(0);
        temp.headerLength = buffer.getInt();
        buffer.getInt();
        temp.operationType = buffer.get();
        if (temp.operationType != 22 && temp.operationType != 23) {
            temp.xid = TransactionLogEntry.deSerializeXid(buffer);
        }
        if (temp.operationType == 2 || temp.operationType == 17) {
            temp.fileName = TransactionLogEntry.readFileName(buffer);
            temp.filePosition = buffer.getLong();
            temp.fileContentLength = buffer.getInt(4);
        } else if (temp.operationType == 5 || temp.operationType == 6 || temp.operationType == 7) {
            temp.fileName = TransactionLogEntry.readFileName(buffer);
        } else if (temp.operationType == 4 || temp.operationType == 3 || temp.operationType == 9) {
            temp.fileName = TransactionLogEntry.readFileName(buffer);
            temp.destFileName = TransactionLogEntry.readFileName(buffer);
        } else if (temp.operationType == 8 || temp.operationType == 16) {
            temp.fileName = TransactionLogEntry.readFileName(buffer);
            temp.newLength = buffer.getLong();
        } else if (temp.operationType == 11) {
            int numFiles = buffer.getInt();
            temp.fileList = new HashSet(numFiles);
            for (int i = 0; i < numFiles; ++i) {
                temp.fileList.add(new File(TransactionLogEntry.readFileName(buffer)));
            }
        } else if (temp.operationType == 10 || temp.operationType == 19 || temp.operationType == 20) {
            int numEvents = buffer.getInt();
            temp.eventList = new ArrayList(numEvents);
            for (int i = 0; i < numEvents; ++i) {
                temp.eventList.add(TransactionLogEntry.readEvent(buffer));
            }
        } else if (temp.operationType == 21) {
            temp.checkPointPosition = buffer.getInt();
        } else if (temp.operationType == 22 || temp.operationType == 23) {
            temp.remoteActivation = TransactionLogEntry.readRemoteEndPointActivation(buffer);
        }
        buffer.position(position);
        return temp;
    }

    private static String readFileName(ByteBuffer buffer) {
        int fileNameLength = buffer.getInt();
        byte[] fileName = new byte[fileNameLength];
        buffer.get(fileName);
        return TransactionLogEntry.getUTF8AssumedString(fileName);
    }

    private static byte[] getBytesFromEvent(FileSystemStateChangeEvent event) {
        byte[] fileNameBytes = TransactionLogEntry.getUTF8Bytes(event.getFile().getAbsolutePath());
        ByteBuffer buffer = ByteBuffer.allocate(fileNameBytes.length + 200);
        buffer.put(TransactionLogEntry.serializeXid(event.getEnqueuingTransaction()));
        buffer.put(event.getEventType().getByteValue());
        buffer.putInt(fileNameBytes.length);
        buffer.put(fileNameBytes);
        buffer.put((byte)(event.isDirectory() ? 1 : 0));
        buffer.flip();
        byte[] temp = new byte[buffer.limit()];
        buffer.get(temp);
        return temp;
    }

    private static FileSystemStateChangeEvent readEvent(ByteBuffer buffer) {
        XidImpl enqueuingTransaction = TransactionLogEntry.deSerializeXid(buffer);
        byte eventType = buffer.get();
        int fileNameLength = buffer.getInt();
        byte[] fileNameBytes = new byte[fileNameLength];
        buffer.get(fileNameBytes);
        String fileName = TransactionLogEntry.getUTF8AssumedString(fileNameBytes);
        File file = new File(fileName);
        boolean isDirectory = buffer.get() == 1;
        return new FileSystemStateChangeEvent(file, isDirectory, FileSystemStateChangeEvent.FileSystemEventType.getFileSystemEventType(eventType), enqueuingTransaction);
    }

    private static EndPointActivation readRemoteEndPointActivation(ByteBuffer buffer) {
        try {
            byte[] serverAddressBytes = new byte[buffer.getInt()];
            buffer.get(serverAddressBytes);
            String serverAddress = new String(serverAddressBytes, UTF8Charset);
            int serverPort = buffer.getInt();
            byte[] fileNamesAndEventInterestsBytes = new byte[buffer.getInt()];
            buffer.get(fileNamesAndEventInterestsBytes);
            String fileNamesAndEventInterests = new String(fileNamesAndEventInterestsBytes, UTF8Charset);
            int originalASpecObjectHashCode = buffer.getInt();
            byte[] xaDiskSystemIdBytes = new byte[buffer.getInt()];
            buffer.get(xaDiskSystemIdBytes);
            String xaDiskSystemId = new String(xaDiskSystemIdBytes, UTF8Charset);
            long remoteObjectId = buffer.getLong();
            RemoteXADiskActivationSpecImpl ras = new RemoteXADiskActivationSpecImpl();
            ras.setOriginalActivationSpecObjectsHashCode(originalASpecObjectHashCode);
            ras.setFileNamesAndEventInterests(fileNamesAndEventInterests);
            RemoteMessageEndpointFactory remoteMEPF = new RemoteMessageEndpointFactory(remoteObjectId, xaDiskSystemId, new RemoteMethodInvoker(serverAddress, serverPort));
            return new EndPointActivation(remoteMEPF, ras);
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    public byte getOperationType() {
        return this.operationType;
    }

    int getFileContentLength() {
        return this.fileContentLength;
    }

    String getFileName() {
        return this.fileName;
    }

    long getFilePosition() {
        return this.filePosition;
    }

    public XidImpl getXid() {
        return this.xid;
    }

    int getHeaderLength() {
        return this.headerLength;
    }

    String getDestFileName() {
        return this.destFileName;
    }

    long getNewLength() {
        return this.newLength;
    }

    public int getCheckPointPosition() {
        return this.checkPointPosition;
    }

    static byte[] serializeXid(XidImpl xid) {
        byte[] gid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        ByteBuffer temp = ByteBuffer.allocate(6 + gid.length + bqual.length);
        temp.put((byte)gid.length);
        temp.put((byte)bqual.length);
        temp.putInt(xid.getFormatId());
        temp.put(gid);
        temp.put(bqual);
        byte[] bytes = new byte[temp.capacity()];
        temp.flip();
        temp.get(bytes);
        return bytes;
    }

    static XidImpl deSerializeXid(ByteBuffer buffer) {
        return new XidImpl(buffer);
    }

    public static void updateContentLength(ByteBuffer buffer, int contentLength) {
        buffer.putInt(4, contentLength);
    }

    public static TransactionLogEntry getNextTransactionLogEntry(FileChannel logChannel, long position, boolean onlyCompletionEntry) throws IOException {
        ByteBuffer header = ByteBuffer.allocate(500);
        logChannel.position(position);
        FileIOUtility.readFromChannel(logChannel, header, 0, 4);
        int logEntryHeaderLength = header.getInt(0);
        if (logEntryHeaderLength > header.capacity()) {
            header = ByteBuffer.allocate(logEntryHeaderLength);
        }
        logChannel.position(position);
        header.clear();
        FileIOUtility.readFromChannel(logChannel, header, 0, logEntryHeaderLength);
        header.flip();
        if (onlyCompletionEntry) {
            TransactionLogEntry logEntry = new TransactionLogEntry();
            logEntry.headerLength = header.getInt();
            logEntry.fileContentLength = header.getInt();
            logEntry.xid = TransactionLogEntry.deSerializeXid(header);
            logEntry.operationType = header.get();
            logChannel.position(position + (long)logEntry.headerLength + (long)logEntry.fileContentLength);
            if (logEntry.operationType == 12 || logEntry.operationType == 15 || logEntry.operationType == 13 || logEntry.operationType == 14 || logEntry.operationType == 20) {
                return logEntry;
            }
            return null;
        }
        TransactionLogEntry logEntry = TransactionLogEntry.parseLogEntry(header);
        logChannel.position(position + (long)logEntry.headerLength + (long)logEntry.fileContentLength);
        return logEntry;
    }

    public HashSet<File> getFileList() {
        return this.fileList;
    }

    public ArrayList<FileSystemStateChangeEvent> getEventList() {
        return this.eventList;
    }

    public EndPointActivation getRemoteActivation(NativeXAFileSystem xaFileSystem) {
        this.remoteActivation.setLocalXAFileSystemForRemoteMEF(xaFileSystem);
        return this.remoteActivation;
    }

    public boolean isUndoLogEntry() {
        return this.operationType == 16 || this.operationType == 17;
    }

    public boolean isRedoLogEntry() {
        return this.operationType < 12;
    }
}

