/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.transaction.xa.Xid;
import org.xadisk.filesystem.NativeSession;
import org.xadisk.filesystem.ResourceDependencyGraph;

public class XidImpl
implements Xid,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final byte INTERRUPTED_DUE_TO_DEADLOCK = 1;
    public static final byte INTERRUPTED_DUE_TO_TIMEOUT = 2;
    private final byte[] gid;
    private final byte[] bqual;
    private final int formatId;
    private volatile transient ResourceDependencyGraph.Node nodeInResourceDependencyGraph = null;
    private volatile transient byte interruptCause = 0;
    public final Object interruptFlagLock = new ArrayList(0);
    private transient NativeSession owningSession;

    XidImpl(ByteBuffer buffer) {
        byte gidLength = buffer.get();
        byte bqualLength = buffer.get();
        this.formatId = buffer.getInt();
        this.gid = new byte[gidLength];
        this.bqual = new byte[bqualLength];
        buffer.get(this.gid);
        buffer.get(this.bqual);
    }

    public XidImpl(Xid xid) {
        this.gid = xid.getGlobalTransactionId();
        this.bqual = xid.getBranchQualifier();
        this.formatId = xid.getFormatId();
    }

    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    public int getFormatId() {
        return this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this.gid;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof XidImpl) {
            int i;
            XidImpl xid = (XidImpl)obj;
            if (xid.getFormatId() != this.formatId) {
                return false;
            }
            byte[] temp = xid.getGlobalTransactionId();
            for (i = 0; i < temp.length; ++i) {
                if (i < this.gid.length && temp[i] == this.gid[i]) continue;
                return false;
            }
            temp = xid.getBranchQualifier();
            for (i = 0; i < temp.length; ++i) {
                if (i < this.bqual.length && temp[i] == this.bqual[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.gid.length > 0) {
            hashCode += this.gid[0] + this.gid[this.gid.length / 2] + this.gid[this.gid.length - 1];
        }
        if (this.bqual.length > 0) {
            hashCode += this.bqual[0] + this.bqual[this.bqual.length / 2] + this.bqual[this.bqual.length - 1];
        }
        return hashCode;
    }

    public ResourceDependencyGraph.Node getNodeInResourceDependencyGraph() {
        return this.nodeInResourceDependencyGraph;
    }

    public void setNodeInResourceDependencyGraph(ResourceDependencyGraph.Node nodeInResourceDependencyGraph) {
        this.nodeInResourceDependencyGraph = nodeInResourceDependencyGraph;
    }

    public byte getInterruptCause() {
        return this.interruptCause;
    }

    public void setInterruptCause(byte interruptCause) {
        this.interruptCause = interruptCause;
    }

    public static XidImpl getXidInstanceForLocalTransaction(long localTransactionId) {
        ByteBuffer tidBuffer = ByteBuffer.allocate(20);
        tidBuffer.put((byte)8);
        tidBuffer.put((byte)0);
        tidBuffer.putInt(101);
        tidBuffer.putLong(localTransactionId);
        tidBuffer.flip();
        return new XidImpl(tidBuffer);
    }

    public NativeSession getOwningSession() {
        return this.owningSession;
    }

    public void setOwningSession(NativeSession owningSession) {
        this.owningSession = owningSession;
    }
}

