/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.utilities;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileIOUtility {
    public static void renameTo(File src, File dest) throws IOException {
        if (!src.renameTo(dest)) {
            if (FileIOUtility.renamePossible(src, dest)) {
                boolean interrupted = false;
                while (!src.renameTo(dest)) {
                    interrupted |= FileIOUtility.makeSpaceForGC();
                    if (src.renameTo(dest)) break;
                    if (src.isDirectory()) continue;
                    FileChannel srcFC = new FileInputStream(src).getChannel();
                    FileChannel destFC = new FileOutputStream(dest).getChannel();
                    long size = srcFC.size();
                    for (long num = 0L; num < size; num += destFC.transferFrom(srcFC, num, size - num)) {
                    }
                    srcFC.close();
                    destFC.close();
                    if (!src.delete()) continue;
                    break;
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            } else {
                throw new IOException("Rename not feasible from " + src + " to " + dest);
            }
        }
    }

    private static boolean renamePossible(File src, File dest) {
        return src.exists() && !dest.exists() && src.getParentFile().canWrite() && dest.getParentFile().canWrite();
    }

    public static void deleteFile(File f) throws IOException {
        if (f.delete()) {
            return;
        }
        if (!f.getParentFile().canWrite()) {
            throw new IOException("Parent directory not writable.");
        }
        if (!f.exists()) {
            throw new IOException("File does not exist.");
        }
        boolean interrupted = false;
        while (!f.delete()) {
            interrupted |= FileIOUtility.makeSpaceForGC();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private static void deleteEmptyDirectory(File dir) throws IOException {
        FileIOUtility.deleteFile(dir);
    }

    public static void deleteDirectoryRecursively(File dir) throws IOException {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FileIOUtility.deleteDirectoryRecursively(files[i]);
                continue;
            }
            FileIOUtility.deleteFile(files[i]);
        }
        FileIOUtility.deleteEmptyDirectory(dir);
    }

    public static void createFile(File f) throws IOException {
        if (f.createNewFile()) {
            return;
        }
        if (f.exists()) {
            throw new IOException("File already exists.");
        }
        if (!f.getParentFile().canWrite()) {
            throw new IOException("Parent directory not writable.");
        }
        boolean interrupted = false;
        while (!f.createNewFile()) {
            interrupted |= FileIOUtility.makeSpaceForGC();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static void createDirectory(File dir) throws IOException {
        if (dir.mkdir()) {
            return;
        }
        if (dir.exists()) {
            throw new IOException("File already exists.");
        }
        if (!dir.getParentFile().canWrite()) {
            throw new IOException("Parent directory not writable.");
        }
        boolean interrupted = false;
        while (!dir.mkdir()) {
            interrupted |= FileIOUtility.makeSpaceForGC();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static void createDirectoriesIfRequired(File dir) throws IOException {
        if (dir.isDirectory()) {
            return;
        }
        FileIOUtility.createDirectoriesIfRequired(dir.getParentFile());
        FileIOUtility.createDirectory(dir);
    }

    public static String[] listDirectoryContents(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException("The directory doesn't exist.");
        }
        if (!dir.canRead()) {
            throw new IOException("The directory is not readable.");
        }
        String[] children = dir.list();
        boolean interrupted = false;
        while (children == null) {
            interrupted |= FileIOUtility.makeSpaceForGC();
            children = dir.list();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return children;
    }

    private static boolean makeSpaceForGC() {
        System.gc();
        System.gc();
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            return true;
        }
        return false;
    }

    public static void readFromChannel(FileChannel fc, ByteBuffer buffer, int bufferOffset, int num) throws IOException, EOFException {
        buffer.position(bufferOffset);
        if (buffer.remaining() < num) {
            throw new BufferUnderflowException();
        }
        buffer.limit(bufferOffset + num);
        int t = 0;
        for (int numRead = 0; numRead < num; numRead += t) {
            t = fc.read(buffer);
            if (t != -1) continue;
            throw new EOFException();
        }
    }

    public static void copyFile(File src, File dest, boolean append) throws IOException {
        FileChannel srcChannel = new FileInputStream(src).getChannel();
        FileChannel destChannel = new FileOutputStream(dest, append).getChannel();
        long contentLength = srcChannel.size();
        for (long num = 0L; num < contentLength; num += srcChannel.transferTo(num, contentLength - num, destChannel)) {
        }
        destChannel.force(false);
        srcChannel.close();
        destChannel.close();
    }

    public static void copyFile(InputStream srcStream, File dest, boolean append) throws IOException {
        FileOutputStream destStream = new FileOutputStream(dest, append);
        byte[] b = new byte[1000];
        int numRead = 0;
        while ((numRead = srcStream.read(b)) != -1) {
            destStream.write(b, 0, numRead);
        }
        destStream.flush();
        destStream.close();
        srcStream.close();
    }
}

