/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.virtual;

import java.io.File;
import java.util.HashMap;
import java.util.Set;
import org.xadisk.filesystem.DurableDiskSession;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.exceptions.FileAlreadyExistsException;
import org.xadisk.filesystem.exceptions.FileNotExistsException;
import org.xadisk.filesystem.virtual.TransactionVirtualView;
import org.xadisk.filesystem.virtual.VirtualViewFile;

class VirtualViewDirectory {
    private final HashMap<String, File> allFiles = new HashMap(20);
    private final HashMap<String, File> allDirs = new HashMap(20);
    private final File pointsToPhysicalDirectory;
    private final HashMap<String, VirtualViewFile> virtualViewFiles = new HashMap(20);
    private final TransactionVirtualView owningView;
    private File virtualDirName;
    private boolean haveReadDirContents = false;
    private final NativeXAFileSystem xaFileSystem;
    private final DurableDiskSession diskSession;

    VirtualViewDirectory(File virtualDirName, File pointsToPhysicalDirectory, TransactionVirtualView owningView, NativeXAFileSystem xaFileSystem, DurableDiskSession diskSession) {
        this.owningView = owningView;
        this.virtualDirName = virtualDirName;
        this.pointsToPhysicalDirectory = pointsToPhysicalDirectory;
        this.xaFileSystem = xaFileSystem;
        this.diskSession = diskSession;
    }

    private void readDirectoryContents() {
        if (this.haveReadDirContents || this.pointsToPhysicalDirectory == null) {
            return;
        }
        File[] allPhysicalFiles = this.pointsToPhysicalDirectory.listFiles();
        for (int i = 0; i < allPhysicalFiles.length; ++i) {
            if (allPhysicalFiles[i].isDirectory()) {
                this.allDirs.put(allPhysicalFiles[i].getName(), allPhysicalFiles[i]);
                continue;
            }
            this.allFiles.put(allPhysicalFiles[i].getName(), allPhysicalFiles[i]);
        }
        this.haveReadDirContents = true;
    }

    void createFile(String fileName, boolean isDirectory) throws FileAlreadyExistsException {
        this.readDirectoryContents();
        if (this.fileExists(fileName) || this.dirExists(fileName)) {
            throw new FileAlreadyExistsException(fileName);
        }
        if (!this.isWritable()) {
            // empty if block
        }
        if (isDirectory) {
            this.allDirs.put(fileName, null);
        } else {
            this.allFiles.put(fileName, null);
        }
    }

    void moveDirectoryInto(String dirName, File pointsToPhysicalDir) throws FileAlreadyExistsException {
        this.readDirectoryContents();
        if (this.fileExists(dirName) || this.dirExists(dirName)) {
            throw new FileAlreadyExistsException(dirName);
        }
        if (!this.isWritable()) {
            // empty if block
        }
        this.allDirs.put(dirName, pointsToPhysicalDir);
    }

    void moveFileInto(String fileName, File pointsToPhysicalFile) throws FileAlreadyExistsException {
        this.readDirectoryContents();
        if (this.fileExists(fileName) || this.dirExists(fileName)) {
            throw new FileAlreadyExistsException(fileName);
        }
        if (!this.isWritable()) {
            // empty if block
        }
        this.allFiles.put(fileName, pointsToPhysicalFile);
    }

    void deleteFile(String fileName) throws FileNotExistsException {
        this.readDirectoryContents();
        if (!this.fileExists(fileName)) {
            throw new FileNotExistsException(this.virtualDirName.getAbsolutePath() + File.separator + fileName);
        }
        if (!this.isWritable()) {
            // empty if block
        }
        this.allFiles.remove(fileName);
    }

    void deleteDir(String fileName) throws FileNotExistsException {
        this.readDirectoryContents();
        if (!this.dirExists(fileName)) {
            throw new FileNotExistsException(this.virtualDirName.getAbsolutePath() + File.separator + fileName);
        }
        if (!this.isWritable()) {
            // empty if block
        }
        this.allDirs.remove(fileName);
    }

    boolean fileExists(String file) {
        boolean exists = this.allFiles.containsKey(file);
        if (this.haveReadDirContents) {
            return exists;
        }
        if (exists) {
            return true;
        }
        if (this.pointsToPhysicalDirectory == null) {
            return false;
        }
        boolean physicallyExists = new File(this.pointsToPhysicalDirectory, file).isFile();
        if (physicallyExists) {
            this.allFiles.put(file, new File(this.pointsToPhysicalDirectory, file));
        }
        return physicallyExists;
    }

    boolean dirExists(String file) {
        boolean exists = this.allDirs.containsKey(file);
        if (this.haveReadDirContents) {
            return exists;
        }
        if (exists) {
            return true;
        }
        if (this.pointsToPhysicalDirectory == null) {
            return false;
        }
        boolean physicallyExists = new File(this.pointsToPhysicalDirectory, file).isDirectory();
        if (physicallyExists) {
            this.allDirs.put(file, new File(this.pointsToPhysicalDirectory, file));
        }
        return physicallyExists;
    }

    boolean isWritable() {
        if (this.pointsToPhysicalDirectory != null) {
            return this.pointsToPhysicalDirectory.canWrite();
        }
        return true;
    }

    File pointsToPhysicalFile(String file) throws FileNotExistsException {
        if (!this.fileExists(file)) {
            throw new FileNotExistsException(this.virtualDirName.getAbsolutePath() + File.separator + file);
        }
        return this.allFiles.get(file);
    }

    File pointsToPhysicalDirectory(String file) throws FileNotExistsException {
        if (!this.dirExists(file)) {
            throw new FileNotExistsException(this.virtualDirName.getAbsolutePath() + File.separator + file);
        }
        return this.allDirs.get(file);
    }

    String[] listFilesAndDirectories() {
        int i;
        this.readDirectoryContents();
        Set<String> allFilesKeys = this.allFiles.keySet();
        Set<String> allDirsKeys = this.allDirs.keySet();
        String[] files = allFilesKeys.toArray(new String[allFilesKeys.size()]);
        String[] dirs = allDirsKeys.toArray(new String[allDirsKeys.size()]);
        String[] all = new String[files.length + dirs.length];
        for (i = 0; i < files.length; ++i) {
            all[i] = files[i];
        }
        for (i = files.length; i < dirs.length + files.length; ++i) {
            all[i] = dirs[i - files.length];
        }
        return all;
    }

    boolean isFileWritable(String fileName) {
        if (!this.fileExists(fileName)) {
            return false;
        }
        File pointsToPhysical = this.allFiles.get(fileName);
        if (pointsToPhysical != null) {
            return pointsToPhysical.canWrite();
        }
        return true;
    }

    boolean isFileReadable(String fileName) {
        if (!this.fileExists(fileName)) {
            return false;
        }
        File pointsToPhysical = this.allFiles.get(fileName);
        if (pointsToPhysical != null) {
            return pointsToPhysical.canRead();
        }
        return true;
    }

    boolean isDirWritable(String fileName) {
        if (!this.dirExists(fileName)) {
            return false;
        }
        File pointsToPhysical = this.allDirs.get(fileName);
        if (pointsToPhysical != null) {
            return pointsToPhysical.canWrite();
        }
        return true;
    }

    boolean isDirReadable(String fileName) {
        if (!this.dirExists(fileName)) {
            return false;
        }
        File pointsToPhysical = this.allDirs.get(fileName);
        if (pointsToPhysical != null) {
            return pointsToPhysical.canRead();
        }
        return true;
    }

    File getPointsToPhysicalDirectory() {
        return this.pointsToPhysicalDirectory;
    }

    private boolean isVirtualFileBeingWritten(String fileName) {
        VirtualViewFile vvf = this.virtualViewFiles.get(fileName);
        if (vvf == null) {
            return false;
        }
        return vvf.isBeingWritten();
    }

    private boolean isVirtualFileBeingRead(String fileName) {
        VirtualViewFile vvf = this.virtualViewFiles.get(fileName);
        if (vvf == null) {
            return false;
        }
        return vvf.isBeingRead();
    }

    boolean isNormalFileBeingReadOrWritten(String fileName) {
        return this.isVirtualFileBeingRead(fileName) || this.isVirtualFileBeingWritten(fileName);
    }

    VirtualViewFile getVirtualViewFile(String fileName) throws FileNotExistsException {
        VirtualViewFile vvf = this.virtualViewFiles.get(fileName);
        if (vvf != null) {
            return vvf;
        }
        File pointingToPhysicalFile = this.pointsToPhysicalFile(fileName);
        File virtualFileName = new File(this.virtualDirName.getAbsolutePath(), fileName);
        if (pointingToPhysicalFile != null) {
            vvf = new VirtualViewFile(virtualFileName, pointingToPhysicalFile.length(), this.owningView, pointingToPhysicalFile, pointingToPhysicalFile.length(), this.xaFileSystem, this.diskSession);
            vvf.setMappedToThePhysicalFileTill(pointingToPhysicalFile.length());
            vvf.setMappedToPhysicalFile(pointingToPhysicalFile);
        } else {
            vvf = new VirtualViewFile(virtualFileName, 0L, this.owningView, this.xaFileSystem, this.diskSession);
            vvf.setMappedToThePhysicalFileTill(-1L);
        }
        this.virtualViewFiles.put(fileName, vvf);
        return vvf;
    }

    VirtualViewFile removeVirtualViewFile(String filename) {
        return this.virtualViewFiles.remove(filename);
    }

    void addVirtualViewFile(String filename, VirtualViewFile vvf) {
        this.virtualViewFiles.put(filename, vvf);
    }

    void propagateMoveCall(File targetPath) {
        this.virtualDirName = targetPath;
        for (String fileName : this.virtualViewFiles.keySet()) {
            VirtualViewFile vvf = this.virtualViewFiles.get(fileName);
            vvf.propagatedAncestorMoveCall(new File(targetPath.getAbsolutePath(), fileName));
        }
    }
}

