/*
 * Decompiled with CFR 0.152.
 */
package org.lsc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.naming.CommunicationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.lsc.AsynchronousRunner;
import org.lsc.InfoCounter;
import org.lsc.LscDatasetModification;
import org.lsc.LscDatasets;
import org.lsc.LscModificationType;
import org.lsc.LscModifications;
import org.lsc.SynchronizeTask;
import org.lsc.SynchronizeThreadPoolExecutor;
import org.lsc.Task;
import org.lsc.beans.IBean;
import org.lsc.beans.syncoptions.ISyncOptions;
import org.lsc.configuration.LscConfiguration;
import org.lsc.configuration.PivotTransformationType;
import org.lsc.exception.LscServiceException;
import org.lsc.service.IService;
import org.lsc.utils.LSCStructuralLogger;
import org.lsc.utils.ScriptingEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSynchronize {
    static final Logger LOGGER = LoggerFactory.getLogger(AbstractSynchronize.class);
    private static Options options = new Options();
    protected boolean nocreate = false;
    protected boolean noupdate = false;
    protected boolean nodelete = false;
    protected boolean nomodrdn = false;
    private int threads;
    private int timeLimit = 3600;
    private Map<String, Thread> asynchronousThreads = new HashMap<String, Thread>();
    private Map<String, AsynchronousRunner> mapSTasks = new HashMap<String, AsynchronousRunner>();

    protected AbstractSynchronize() {
    }

    protected final boolean clean2Ldap(Task task) {
        InfoCounter counter = new InfoCounter();
        Set<Map.Entry<String, LscDatasets>> ids = null;
        try {
            ids = task.getDestinationService().getListPivots().entrySet();
        }
        catch (LscServiceException e) {
            LOGGER.error("Error getting list of IDs in the destination for task {}", (Object)task.getName());
            LOGGER.debug(e.toString(), (Throwable)e);
            return false;
        }
        if (ids.isEmpty()) {
            LOGGER.error("Empty or non existant destination (no IDs found)");
            return false;
        }
        ISyncOptions syncOptions = task.getSyncOptions();
        LscModifications lm = null;
        HashMap<String, Object> conditionObjects = null;
        for (Map.Entry<String, LscDatasets> id : ids) {
            counter.incrementCountAll();
            try {
                IBean taskBean = this.getBean(task, task.getSourceService(), id.getKey(), id.getValue(), false, false);
                if (taskBean != null) continue;
                Boolean doDelete = null;
                String conditionString = syncOptions.getDeleteCondition();
                if (conditionString.matches("true")) {
                    doDelete = true;
                } else if (conditionString.matches("false")) {
                    doDelete = false;
                } else {
                    IBean dstBean = this.getBean(task, task.getDestinationService(), id.getKey(), id.getValue(), true, false);
                    if (dstBean == null) {
                        LOGGER.error("Could not retrieve the object {} from the directory!", (Object)id.getKey());
                        counter.incrementCountError();
                        continue;
                    }
                    conditionObjects = new HashMap<String, Object>();
                    conditionObjects.put("dstBean", dstBean);
                    conditionObjects.putAll(task.getScriptingVars());
                    doDelete = ScriptingEvaluator.evalToBoolean(task, conditionString, conditionObjects);
                }
                if (!doDelete.booleanValue()) continue;
                lm = new LscModifications(LscModificationType.DELETE_OBJECT, task.getName());
                lm.setMainIdentifer(id.getKey());
                ArrayList<LscDatasetModification> attrsMod = new ArrayList<LscDatasetModification>();
                for (Map.Entry<String, Object> attr : id.getValue().getDatasets().entrySet()) {
                    attrsMod.add(new LscDatasetModification(LscDatasetModification.LscDatasetModificationType.DELETE_VALUES, attr.getKey(), Collections.singletonList(attr.getValue())));
                }
                lm.setLscAttributeModifications(attrsMod);
                counter.incrementCountModifiable();
                if (this.nodelete) {
                    this.logShouldAction(lm, task.getName());
                    continue;
                }
                if (task.getDestinationService().apply(lm)) {
                    counter.incrementCountCompleted();
                    this.logAction(lm, id, task.getName());
                    continue;
                }
                counter.incrementCountError();
                this.logActionError(lm, id.getValue(), new Exception("Technical problem while applying modifications to destination service"));
            }
            catch (LscServiceException e) {
                counter.incrementCountError();
                this.logActionError(lm, id.getValue(), e);
                if (e.getCause().getClass().isAssignableFrom(CommunicationException.class)) {
                    LOGGER.error("Connection lost! Aborting.");
                    return false;
                }
                LOGGER.error("Unable to delete object {} ({})", (Object)id.getKey(), (Object)e.toString());
            }
        }
        this.logStatus(counter);
        return counter.getCountError() == 0;
    }

    protected final boolean synchronize2Ldap(Task task) {
        InfoCounter counter = new InfoCounter();
        Set<Map.Entry<String, LscDatasets>> ids = null;
        SynchronizeThreadPoolExecutor threadPool = null;
        try {
            ids = task.getSourceService().getListPivots().entrySet();
        }
        catch (Exception e) {
            LOGGER.error("Error getting list of IDs in the source for task {}", (Object)task.getName());
            LOGGER.debug(e.toString(), (Throwable)e);
            return false;
        }
        if (ids.isEmpty()) {
            LOGGER.error("Empty or non existant source (no IDs found)");
            return false;
        }
        threadPool = new SynchronizeThreadPoolExecutor(this.getThreads());
        int threadCount = 0;
        int threadPoolAwaitTerminationTimeOut = 900;
        for (Map.Entry<String, LscDatasets> id : ids) {
            threadPool.runTask(new SynchronizeTask(task, counter, this, id, true));
            if (++threadCount != 10000) continue;
            try {
                threadPool.shutdown();
                threadPool.awaitTermination(threadPoolAwaitTerminationTimeOut, TimeUnit.SECONDS);
                threadCount = 0;
                threadPool = null;
                threadPool = new SynchronizeThreadPoolExecutor(this.getThreads());
            }
            catch (InterruptedException e) {
                LOGGER.error("Error while shutting down the threadpool and re initializing it: " + e.toString(), (Throwable)e);
            }
        }
        try {
            threadPool.shutdown();
            threadPool.awaitTermination(this.timeLimit, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Tasks terminated according to time limit: " + e.toString(), (Throwable)e);
            LOGGER.info("If you want to avoid this message, increase the time limit by using dedicated parameter.");
        }
        this.logStatus(counter);
        return counter.getCountError() == 0;
    }

    public final synchronized void startAsynchronousSynchronize2Ldap(Task task) {
        AsynchronousRunner asyncRunner = new AsynchronousRunner(task, this);
        String taskName = task.getName();
        Thread thread = new Thread(asyncRunner);
        thread.setName(taskName);
        this.asynchronousThreads.put(taskName, thread);
        this.mapSTasks.put(taskName, asyncRunner);
        thread.start();
    }

    public final synchronized void shutdownAsynchronousSynchronize2Ldap(String syncName, boolean forceStop) {
        Thread asyncThread = this.asynchronousThreads.get(syncName);
        long startTime = System.currentTimeMillis();
        if (asyncThread == null) {
            LOGGER.info("Trying to stop a non running asynchronous task: " + syncName);
            return;
        }
        while (asyncThread.isAlive()) {
            try {
                asyncThread.join(1000L);
                if (System.currentTimeMillis() - startTime <= 5000L) continue;
                if (!forceStop) break;
                asyncThread.interrupt();
                asyncThread.join(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!asyncThread.isAlive()) {
            this.asynchronousThreads.remove(syncName);
            this.mapSTasks.remove(syncName);
        }
    }

    public final boolean isAsynchronousTaskRunning(String syncName) {
        Thread asyncThread = this.asynchronousThreads.get(syncName);
        if (asyncThread != null) {
            if (asyncThread.isAlive()) {
                return true;
            }
            this.asynchronousThreads.remove(syncName);
            this.mapSTasks.remove(syncName);
            return false;
        }
        return false;
    }

    public final String getTaskFullStatus(String syncName) {
        Thread asyncThread = this.asynchronousThreads.get(syncName);
        if (asyncThread != null && asyncThread.isAlive()) {
            AsynchronousRunner asyncRunner = this.mapSTasks.get(syncName);
            InfoCounter counter = asyncRunner.getCounter();
            return this.getLogStatus(counter);
        }
        return null;
    }

    public abstract boolean isAsynchronousTask(String var1);

    public abstract Task[] getTasks();

    public abstract Task getTask(String var1);

    protected final void logActionError(LscModifications lm, Object data, Exception except) {
        LOGGER.error("Error while synchronizing ID {}: {}", lm != null ? lm.getMainIdentifier() : data, (Object)except.toString());
        LOGGER.debug(except.toString(), (Throwable)except);
        if (lm != null) {
            LOGGER.error("", (Object)lm);
        }
    }

    protected final void logAction(LscModifications lm, Map.Entry<String, LscDatasets> id, String syncName) {
        switch (lm.getOperation()) {
            case CREATE_OBJECT: {
                LSCStructuralLogger.DESTINATION.info("# Adding new object {} for {}", (Object)lm.getMainIdentifier(), (Object)syncName);
                break;
            }
            case UPDATE_OBJECT: {
                LSCStructuralLogger.DESTINATION.info("# Updating object {} for {}", (Object)lm.getMainIdentifier(), (Object)syncName);
                break;
            }
            case CHANGE_ID: {
                LSCStructuralLogger.DESTINATION.info("# Renaming object {} for {}", (Object)lm.getMainIdentifier(), (Object)syncName);
                break;
            }
            case DELETE_OBJECT: {
                LSCStructuralLogger.DESTINATION.info("# Removing object {} for {}", (Object)lm.getMainIdentifier(), (Object)syncName);
                break;
            }
            default: {
                LSCStructuralLogger.DESTINATION.info("Error: unknown changetype ({} for {})", (Object)lm.getMainIdentifier(), (Object)syncName);
            }
        }
        LSCStructuralLogger.DESTINATION.info("", (Object)lm);
    }

    protected final void logShouldAction(LscModifications lm, String syncName) {
        switch (lm.getOperation()) {
            case CREATE_OBJECT: {
                LSCStructuralLogger.DESTINATION.debug("Create condition false. Should have added object {}", (Object)lm.getMainIdentifier());
                break;
            }
            case UPDATE_OBJECT: {
                LSCStructuralLogger.DESTINATION.debug("Update condition false. Should have modified object {}", (Object)lm.getMainIdentifier());
                break;
            }
            case CHANGE_ID: {
                LSCStructuralLogger.DESTINATION.debug("ModRDN condition false. Should have renamed object {}", (Object)lm.getMainIdentifier());
                break;
            }
            case DELETE_OBJECT: {
                LSCStructuralLogger.DESTINATION.debug("Delete condition false. Should have removed object {}", (Object)lm.getMainIdentifier());
                break;
            }
            default: {
                LSCStructuralLogger.DESTINATION.debug("Error: unknown changetype ({} for {})", (Object)lm.getMainIdentifier(), (Object)syncName);
            }
        }
        LSCStructuralLogger.DESTINATION.debug("", (Object)lm);
    }

    protected void logStatus(InfoCounter counter) {
        String totalsLogMessage = this.getLogStatus(counter);
        if (counter.getCountError() > 0) {
            LOGGER.error(totalsLogMessage);
        } else {
            LOGGER.info(totalsLogMessage);
        }
    }

    protected String getLogStatus(InfoCounter counter) {
        String totalsLogMessage = "All entries: " + counter.getCountAll() + ", to modify entries: " + counter.getCountModifiable() + ", successfully modified entries: " + counter.getCountCompleted() + ", errors: " + counter.getCountError();
        return totalsLogMessage;
    }

    protected IBean getBean(Task task, IService service, String pivotName, LscDatasets pivotAttributes, boolean fromSameService, boolean fromSource) throws LscServiceException {
        List<PivotTransformationType.Transformation> transformations = LscConfiguration.getPivotTransformation(task.getTaskType());
        if (!fromSameService && transformations != null) {
            LscDatasets newPivots = new LscDatasets(pivotAttributes.getDatasets());
            for (Map.Entry<String, Object> pivot : pivotAttributes.getDatasets().entrySet()) {
                for (PivotTransformationType.Transformation transformation : transformations) {
                    if (!pivot.getKey().equalsIgnoreCase(transformation.getFromAttribute()) || !LscConfiguration.pivotOriginMatchesFromSource(transformation.getPivotOrigin(), fromSource)) continue;
                    newPivots.put(transformation.getToAttribute(), this.transform(task, transformation, pivot.getValue()));
                }
            }
            return service.getBean(pivotName, newPivots, fromSameService);
        }
        return service.getBean(pivotName, pivotAttributes, fromSameService);
    }

    protected Object transform(Task task, PivotTransformationType.Transformation transformation, Object value) throws LscServiceException {
        HashMap<String, Object> javaScriptObjects = new HashMap<String, Object>();
        javaScriptObjects.put("value", value);
        if (task.getCustomLibraries() != null) {
            javaScriptObjects.put("custom", task.getCustomLibraries());
        }
        javaScriptObjects.putAll(task.getScriptingVars());
        if (LscConfiguration.isLdapBinaryAttribute(transformation.getToAttribute())) {
            return ScriptingEvaluator.evalToByteArray(task, transformation.getValue(), javaScriptObjects);
        }
        return ScriptingEvaluator.evalToString(task, transformation.getValue(), javaScriptObjects);
    }

    public final boolean parseOptions(CommandLine cmdLine) {
        if (cmdLine.hasOption("nc")) {
            this.nocreate = true;
        }
        if (cmdLine.hasOption("nu")) {
            this.noupdate = true;
        }
        if (cmdLine.hasOption("nd")) {
            this.nodelete = true;
        }
        if (cmdLine.hasOption("nr")) {
            this.nomodrdn = true;
        }
        if (cmdLine.hasOption("n")) {
            this.nocreate = true;
            this.noupdate = true;
            this.nodelete = true;
            this.nomodrdn = true;
        }
        return true;
    }

    public static final Options getOptions() {
        return options;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    static {
        options.addOption("nc", "nocreate", false, "Don't create any entry");
        options.addOption("nu", "noupdate", false, "Don't update");
        options.addOption("nd", "nodelete", false, "Don't delete");
        options.addOption("nr", "nomodrdn", false, "Don't rename (MODRDN)");
        options.addOption("n", "dryrun", false, "Don't update the directory at all");
    }
}

