/*
 * Decompiled with CFR 0.152.
 */
package org.lsc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsc.LscDatasetModification;
import org.lsc.LscModificationType;
import org.lsc.beans.IBean;
import org.lsc.utils.CaseIgnoreStringHashMap;

public class LscModifications {
    private String mainId;
    private String newMainId;
    private LscModificationType operation;
    private List<LscDatasetModification> attributesModifications;
    private String taskName;
    private IBean sourceBean;
    private IBean destinationBean;

    public LscModifications(LscModificationType operation) {
        this.operation = operation;
        this.attributesModifications = new ArrayList<LscDatasetModification>();
    }

    public LscModifications(LscModificationType operation, String taskName) {
        this.operation = operation;
        this.taskName = taskName;
        this.attributesModifications = new ArrayList<LscDatasetModification>();
    }

    public final List<LscDatasetModification> getLscAttributeModifications() {
        return this.attributesModifications;
    }

    public final void setLscAttributeModifications(List<LscDatasetModification> attrsMod) {
        this.attributesModifications = attrsMod;
    }

    public final LscModificationType getOperation() {
        return this.operation;
    }

    public final void setOperation(LscModificationType operation) {
        this.operation = operation;
    }

    public final String getMainIdentifier() {
        return this.mainId;
    }

    public final void setMainIdentifer(String mainId) {
        this.mainId = mainId;
    }

    public final String getNewMainIdentifier() {
        return this.newMainId;
    }

    public final void setNewMainIdentifier(String newMainId) {
        this.newMainId = newMainId;
    }

    public Map<String, List<Object>> getModificationsItemsByHash() {
        CaseIgnoreStringHashMap<List<Object>> result = new CaseIgnoreStringHashMap<List<Object>>();
        List<LscDatasetModification> mi = this.getLscAttributeModifications();
        if (mi != null) {
            for (LscDatasetModification attributeModification : mi) {
                ((HashMap)result).put(attributeModification.getAttributeName().toLowerCase(), attributeModification.getValues());
            }
        }
        return result;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("mainid: ").append(this.getMainIdentifier()).append("\n");
        if (this.getNewMainIdentifier() != null) {
            sb.append("newmainid: ").append(this.getNewMainIdentifier()).append("\n");
        }
        sb.append("operation: ").append(this.getOperation().toString()).append("\n");
        for (LscDatasetModification lam : this.getLscAttributeModifications()) {
            sb.append(lam.getAttributeName()).append(": ").append(lam.getOperation().toString()).append("\n");
            for (Object value : lam.getValues()) {
                sb.append(" - ").append(value).append("\n");
            }
        }
        return sb.append("\n").toString();
    }

    public IBean getSourceBean() {
        return this.sourceBean;
    }

    public void setSourceBean(IBean sourceBean) {
        this.sourceBean = sourceBean;
    }

    public IBean getDestinationBean() {
        return this.destinationBean;
    }

    public void setDestinationBean(IBean destinationBean) {
        this.destinationBean = destinationBean;
    }
}

