/*
 * Decompiled with CFR 0.152.
 */
package org.lsc;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.lsc.SynchronizeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizeThreadPoolExecutor
extends ThreadPoolExecutor {
    static long keepAliveTime = 60L;
    BlockingQueue<Runnable> queue;
    final Logger LOGGER = LoggerFactory.getLogger(SynchronizeThreadPoolExecutor.class);

    protected SynchronizeThreadPoolExecutor(int threads) {
        super(threads, Integer.MAX_VALUE, keepAliveTime, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100000));
        this.queue = this.getQueue();
    }

    protected void runTask(SynchronizeTask task) {
        this.execute(task);
        this.beforeExecute(new Thread(task.getSyncName() + "-" + task.getId().getKey()), task);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        if (r instanceof SynchronizeTask) {
            SynchronizeTask task = (SynchronizeTask)r;
            t.setName(task.getSyncName() + "-" + t.getId());
        }
    }
}

