/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.beans;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.SerializationUtils;
import org.lsc.LscDatasets;
import org.lsc.beans.IBean;
import org.lsc.utils.SetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LscBean
implements IBean,
Serializable {
    private static final long serialVersionUID = 5074469517356449901L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LscBean.class);
    private String mainIdentifier;
    private Map<String, Set<Object>> datasets = new HashMap<String, Set<Object>>();

    @Override
    public final Set<Object> getDatasetById(String id) {
        return this.datasets.get(id.toLowerCase());
    }

    @Override
    @Deprecated
    public final Attribute getAttributeById(String id) {
        LOGGER.warn("The method getAttributeById() is deprecated and will be removed in a future version of LSC. Please use getDatasetById() instead.");
        Set<Object> values = this.getDatasetById(id);
        return values != null ? new BasicAttribute(id, values) : null;
    }

    public final Set<Object> getDatasetAsSetById(String id) {
        return this.datasets.get(id.toLowerCase());
    }

    @Override
    @Deprecated
    public final Set<Object> getAttributeAsSetById(String id) {
        LOGGER.warn("The method getAttributeAsSetById() is deprecated and will be removed in a future version of LSC. Please use getDatasetAsSetById() instead.");
        return this.getDatasetAsSetById(id);
    }

    @Override
    public final String getDatasetFirstValueById(String id) throws NamingException {
        List<String> allValues = this.getDatasetValuesById(id);
        return allValues.size() >= 1 ? allValues.get(0) : "";
    }

    @Override
    @Deprecated
    public final String getAttributeFirstValueById(String id) throws NamingException {
        LOGGER.warn("The method getAttributeFirstValueById() is deprecated and will be removed in a future version of LSC. Please use getDatasetFirstValueById() instead.");
        return this.getDatasetFirstValueById(id);
    }

    public final List<String> getDatasetValuesById(String id) throws NamingException {
        ArrayList<String> resultsArray = new ArrayList<String>();
        Set<Object> attributeValues = this.datasets.get(id.toLowerCase());
        if (attributeValues != null) {
            for (Object value : attributeValues) {
                if (value == null) continue;
                String stringValue = value instanceof byte[] ? new String((byte[])value) : value.toString();
                resultsArray.add(stringValue);
            }
        }
        return resultsArray;
    }

    @Override
    public final List<String> getAttributeValuesById(String id) throws NamingException {
        return this.getDatasetValuesById(id);
    }

    public final Set<String> getDatasetsNames() {
        return this.datasets.keySet();
    }

    @Override
    public final Set<String> getAttributesNames() {
        return this.getDatasetsNames();
    }

    @Override
    public final void setAttribute(Attribute attr) {
        if (attr != null && attr.size() > 0) {
            try {
                this.setAttribute(attr.getID(), SetUtils.attributeToSet(attr));
            }
            catch (NamingException e) {
                LOGGER.error("Error storing the attribute {}: {}", (Object)attr.getID(), (Object)e.toString());
                LOGGER.debug(e.toString(), (Throwable)e);
            }
        }
    }

    @Override
    public final void setDataset(String name, Set<Object> values) {
        this.datasets.put(name.toLowerCase(), values);
    }

    @Override
    @Deprecated
    public final void setAttribute(String name, Set<Object> values) {
        this.setDataset(name, values);
    }

    @Override
    public final String getMainIdentifier() {
        return this.mainIdentifier;
    }

    @Override
    @Deprecated
    public final String getDistinguishedName() {
        return this.getMainIdentifier();
    }

    @Deprecated
    public final String getDN() {
        return this.getMainIdentifier();
    }

    @Deprecated
    public final String getFullDistinguishedName() {
        return this.getMainIdentifier();
    }

    @Override
    public final void setMainIdentifier(String id) {
        this.mainIdentifier = id;
    }

    @Override
    public final void setDistinguishName(String dn) {
        if (dn != null) {
            this.setMainIdentifier(dn);
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: ").append(this.mainIdentifier).append('\n');
        for (String key : this.datasets.keySet()) {
            Set<Object> values = this.datasets.get(key);
            if (values == null) continue;
            sb.append("=> " + key);
            for (Object value : values) {
                sb.append(" - ").append(value).append('\n');
            }
        }
        return sb.toString();
    }

    @Override
    public LscBean clone() throws CloneNotSupportedException {
        try {
            LscBean bean = (LscBean)this.getClass().newInstance();
            bean.setMainIdentifier(this.getMainIdentifier());
            for (String attributeName : this.getAttributesNames()) {
                bean.setAttribute(attributeName, this.getDatasetAsSetById(attributeName));
            }
            return bean;
        }
        catch (InstantiationException ex) {
            throw new CloneNotSupportedException(ex.getLocalizedMessage());
        }
        catch (IllegalAccessException ex) {
            throw new CloneNotSupportedException(ex.getLocalizedMessage());
        }
    }

    public static void setMetadata(ResultSetMetaData metaData) {
    }

    public static LscBean getInstance(SearchResult entry, String baseDn, Class<?> c) throws NamingException {
        try {
            if (entry != null) {
                LscBean ab = (LscBean)c.newInstance();
                String dn = entry.getName();
                if (dn.length() > 0 && dn.charAt(0) == '\"' && dn.charAt(dn.length() - 1) == '\"') {
                    dn = dn.substring(1, dn.length() - 1);
                }
                if (dn.startsWith("ldap://")) {
                    ab.setDistinguishName(entry.getNameInNamespace());
                } else if (baseDn != null && baseDn.length() > 0) {
                    if (dn.length() > 0) {
                        ab.setDistinguishName(dn + "," + baseDn);
                    } else {
                        ab.setDistinguishName(baseDn);
                    }
                } else {
                    ab.setDistinguishName(dn);
                }
                NamingEnumeration<? extends Attribute> ne = entry.getAttributes().getAll();
                while (ne.hasMore()) {
                    ab.setAttribute(ne.next());
                }
                return ab;
            }
            return null;
        }
        catch (InstantiationException ie) {
            LOGGER.error(ie.toString());
            LOGGER.debug(ie.toString(), (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            LOGGER.error(iae.toString());
            LOGGER.debug(iae.toString(), (Throwable)iae);
        }
        return null;
    }

    @Override
    public LscDatasets datasets() {
        return new LscDatasets(this.datasets);
    }

    @Override
    public void setDatasets(LscDatasets datasets) {
        HashMap<String, Set<Object>> tmp = new HashMap<String, Set<Object>>();
        for (String name : datasets.getAttributesNames()) {
            LinkedHashSet<Object> valuesAsSet;
            Object values = datasets.getDatasets().get(name);
            if (values instanceof Set) {
                tmp.put(name, (Set)values);
                continue;
            }
            if (values instanceof List) {
                valuesAsSet = new LinkedHashSet<Object>();
                valuesAsSet.addAll((List)values);
                tmp.put(name, valuesAsSet);
                continue;
            }
            if (values instanceof String) {
                valuesAsSet = new LinkedHashSet();
                valuesAsSet.add(values);
                tmp.put(name, valuesAsSet);
                continue;
            }
            if (values instanceof Boolean) {
                valuesAsSet = new LinkedHashSet();
                valuesAsSet.add(values.toString());
                tmp.put(name, valuesAsSet);
                continue;
            }
            if (values instanceof Integer) {
                valuesAsSet = new LinkedHashSet();
                valuesAsSet.add("" + values);
                tmp.put(name, valuesAsSet);
                continue;
            }
            LOGGER.warn("Appending unknown type inside lsc bean as Set: " + values);
            tmp.put(name, (Set)values);
        }
        this.datasets = tmp;
    }

    public byte[] getDatasetsBytes() {
        return SerializationUtils.serialize((Serializable)((Serializable)((Object)this.datasets)));
    }
}

