/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.configuration;

import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import org.lsc.Configuration;
import org.lsc.configuration.ConnectionType;
import org.lsc.configuration.ConnectionsType;
import org.lsc.configuration.DatabaseConnectionType;
import org.lsc.configuration.DatabaseSourceServiceType;
import org.lsc.configuration.EncryptionType;
import org.lsc.configuration.ForceSyncOptionsType;
import org.lsc.configuration.LdapAuthenticationType;
import org.lsc.configuration.LdapConnectionType;
import org.lsc.configuration.LdapDestinationServiceType;
import org.lsc.configuration.LdapSourceServiceType;
import org.lsc.configuration.Lsc;
import org.lsc.configuration.LscConfiguration;
import org.lsc.configuration.PropertiesBasedSyncOptionsType;
import org.lsc.configuration.SecurityType;
import org.lsc.configuration.ServiceType;
import org.lsc.configuration.TaskType;
import org.lsc.configuration.TasksType;
import org.lsc.configuration.ValuesType;
import org.lsc.exception.LscConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesConfigurationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesConfigurationHelper.class);
    public static final String LSC_PROPS_PREFIX = "lsc";
    public static final String TASKS_PROPS_PREFIX = "tasks";
    public static final String SYNCOPTIONS_PREFIX = "syncoptions";
    public static final String SRCSERVICE_PROPS_PREFIX = "srcService";
    public static final String DSTSERVICE_PROPS_PREFIX = "dstService";
    public static final String CUSTOMLIBRARY_PROPS_PREFIX = "customLibrary";
    public static final String OBJECT_PROPS_PREFIX = "object";
    public static final String BEAN_PROPS_PREFIX = "bean";
    public static final String ASYNCHRONOUS_PROPS = "async";
    public static final String POST_SYNC_HOOK_PROPS_PREFIX = "postSyncHook";
    public static final String POST_CLEAN_HOOK_PROPS_PREFIX = "postCleanHook";

    public static void loadConfigurationFrom(String filename) throws LscConfigurationException {
        Lsc lscInstance = new Lsc();
        Properties conf = Configuration.getAsProperties(filename, LSC_PROPS_PREFIX);
        String tasks = conf.getProperty(TASKS_PROPS_PREFIX);
        lscInstance.setConnections(new ConnectionsType());
        if (Configuration.getString("src.java.naming.provider.url") != null) {
            LdapConnectionType ldapConn = new LdapConnectionType();
            ldapConn.setName("src-ldap");
            ldapConn.setUsername(Configuration.getString("src.java.naming.security.principal"));
            ldapConn.setPassword(Configuration.getString("src.java.naming.security.credentials"));
            if (ldapConn.getUsername() != null) {
                ldapConn.setAuthentication(LdapAuthenticationType.SIMPLE);
            } else {
                ldapConn.setAuthentication(LdapAuthenticationType.NONE);
            }
            ldapConn.setUrl(Configuration.getString("src.java.naming.provider.url"));
            lscInstance.getConnections().getLdapConnectionOrDatabaseConnectionOrPluginConnection().add(ldapConn);
        }
        if (Configuration.getString("src.database.url") != null) {
            DatabaseConnectionType jdbcConn = new DatabaseConnectionType();
            jdbcConn.setName("src-jdbc");
            jdbcConn.setUsername(Configuration.getString("src.database.username"));
            jdbcConn.setPassword(Configuration.getString("src.database.password"));
            jdbcConn.setUrl(Configuration.getString("src.database.url"));
            jdbcConn.setDriver(Configuration.getString("src.database.driver"));
            lscInstance.getConnections().getLdapConnectionOrDatabaseConnectionOrPluginConnection().add(jdbcConn);
        }
        if (Configuration.getString("dst.java.naming.provider.url") != null) {
            LdapConnectionType dstConn = new LdapConnectionType();
            dstConn.setName("dst-ldap");
            dstConn.setUsername(Configuration.getString("dst.java.naming.security.principal"));
            dstConn.setPassword(Configuration.getString("dst.java.naming.security.credentials"));
            if (dstConn.getUsername() != null) {
                dstConn.setAuthentication(LdapAuthenticationType.SIMPLE);
            } else {
                dstConn.setAuthentication(LdapAuthenticationType.NONE);
            }
            dstConn.setUrl(Configuration.getString("dst.java.naming.provider.url"));
            lscInstance.getConnections().getLdapConnectionOrDatabaseConnectionOrPluginConnection().add(dstConn);
        }
        lscInstance.setTasks(new TasksType());
        if (tasks != null) {
            StringTokenizer tasksSt = new StringTokenizer(tasks, ",");
            while (tasksSt.hasMoreTokens()) {
                String taskName = tasksSt.nextToken();
                lscInstance.getTasks().getTask().add(PropertiesConfigurationHelper.newTask(taskName, conf));
            }
        }
        SecurityType sec = new SecurityType();
        sec.setEncryption(new EncryptionType());
        if (new File(Configuration.getConfigurationDirectory(), "lsc.key").exists()) {
            sec.getEncryption().setKeyfile(new File(Configuration.getConfigurationDirectory(), "lsc.key").getAbsolutePath());
        }
        lscInstance.setSecurity(sec);
        LscConfiguration.loadFromInstance(lscInstance);
    }

    private static TaskType newTask(String taskName, Properties lscProperties) throws LscConfigurationException {
        TaskType newTask = new TaskType();
        newTask.setName(taskName);
        String prefix = "tasks." + taskName + ".";
        PropertiesConfigurationHelper.checkTaskOldProperty(lscProperties, taskName, OBJECT_PROPS_PREFIX, "Please take a look at upgrade notes at http://lsc-project.org/wiki/documentation/upgrade/1.1-1.2");
        newTask.setBean(PropertiesConfigurationHelper.getTaskPropertyAndCheckNotNull(taskName, lscProperties, BEAN_PROPS_PREFIX));
        newTask.setCleanHook(lscProperties.getProperty(prefix + POST_CLEAN_HOOK_PROPS_PREFIX));
        newTask.setSyncHook(lscProperties.getProperty(prefix + POST_SYNC_HOOK_PROPS_PREFIX));
        ConnectionType sourceConn = null;
        ServiceType sourceService = null;
        LdapDestinationServiceType destinationService = new LdapDestinationServiceType();
        if (lscProperties.getProperty(prefix + SRCSERVICE_PROPS_PREFIX).equals("org.lsc.service.SimpleJdbcSrcService")) {
            sourceConn = LscConfiguration.getConnection("src-jdbc");
            sourceService = new DatabaseSourceServiceType();
        } else if (lscProperties.getProperty(prefix + SRCSERVICE_PROPS_PREFIX).equals("org.lsc.jndi.SimpleJndiSrcService") || lscProperties.getProperty(prefix + SRCSERVICE_PROPS_PREFIX).equals("org.lsc.jndi.PullableJndiSrcService")) {
            sourceConn = LscConfiguration.getConnection("src-ldap");
            sourceService = new LdapSourceServiceType();
        } else {
            throw new LscConfigurationException("Unknown connection type: " + lscProperties.getProperty(prefix + SRCSERVICE_PROPS_PREFIX));
        }
        ConnectionType destinationConn = LscConfiguration.getConnection("dst-ldap");
        String syncOptionsType = lscProperties.getProperty("syncoptions." + taskName, "org.lsc.beans.syncoptions.ForceSyncOptions");
        sourceService.setName(taskName + "-src");
        Properties srcProps = Configuration.getPropertiesSubset(lscProperties, prefix + SRCSERVICE_PROPS_PREFIX);
        for (Object object : srcProps.keySet()) {
            LOGGER.warn("Unhandled property to set up source service: " + object);
        }
        sourceService.setConnection(new ServiceType.Connection());
        sourceService.getConnection().setReference(sourceConn);
        destinationService.setName(taskName + "-dst");
        Properties dstProps = Configuration.getPropertiesSubset(lscProperties, prefix + DSTSERVICE_PROPS_PREFIX);
        for (Object dstProp : dstProps.keySet()) {
            LOGGER.warn("Unhandled property to set up destination service: " + dstProp);
        }
        destinationService.setConnection(new ServiceType.Connection());
        destinationService.getConnection().setReference(destinationConn);
        if (syncOptionsType == null || "org.lsc.beans.syncoptions.PropertiesBasedSyncOptions".equals(syncOptionsType)) {
            newTask.setPropertiesBasedSyncOptions(new PropertiesBasedSyncOptionsType());
        } else if ("org.lsc.beans.syncoptions.ForceSyncOptions".equals(syncOptionsType)) {
            newTask.setForceSyncOptions(new ForceSyncOptionsType());
        } else {
            throw new LscConfigurationException("Unknown sync options type: " + lscProperties.getProperty(prefix + SRCSERVICE_PROPS_PREFIX));
        }
        ValuesType valuesType = new ValuesType();
        if (lscProperties.getProperty(prefix + CUSTOMLIBRARY_PROPS_PREFIX) != null) {
            valuesType.getString().add(lscProperties.getProperty(prefix + CUSTOMLIBRARY_PROPS_PREFIX));
        }
        newTask.setCustomLibrary(valuesType);
        LscConfiguration.getSyncOptions(newTask).setMainIdentifier(lscProperties.getProperty(prefix + "dn"));
        LscConfiguration.loadSyncOptions(newTask, taskName, Configuration.getPropertiesSubset(lscProperties, "syncoptions." + taskName));
        return newTask;
    }

    private static void checkTaskOldProperty(Properties props, String taskName, String propertyName, String message) {
        if (props.getProperty("tasks." + taskName + "." + propertyName) != null) {
            String errorMessage = "Deprecated value specified in task " + taskName + " for " + propertyName + "! Please read upgrade notes ! (" + message + ")";
            LOGGER.error(errorMessage);
            throw new ExceptionInInitializerError(errorMessage);
        }
    }

    private static String getTaskPropertyAndCheckNotNull(String taskName, Properties props, String propertyName) {
        String value = props.getProperty("tasks." + taskName + "." + propertyName);
        if (value == null) {
            String errorMessage = "No value specified in task " + taskName + " for " + propertyName + "! Aborting.";
            LOGGER.error(errorMessage);
            throw new ExceptionInInitializerError(errorMessage);
        }
        return value;
    }
}

